/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.iotdb.db.queryengine.execution.operator.process;

import org.apache.iotdb.db.queryengine.execution.operator.Operator;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.process.fill.ILinearFill;

import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.read.common.block.TsBlock;

/** Used for linear fill. */
public class TreeLinearFillOperator extends AbstractLinearFillOperator {
  public TreeLinearFillOperator(
      OperatorContext operatorContext, ILinearFill[] fillArray, Operator child) {
    super(operatorContext, fillArray, child);
  }

  @Override
  Column getHelperColumn(TsBlock tsBlock) {
    return tsBlock.getTimeColumn();
  }

  @Override
  Integer getLastRowIndexForNonNullHelperColumn(TsBlock tsBlock) {
    return tsBlock.getPositionCount() - 1;
  }
}
