/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.table;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import org.apache.iotdb.commons.schema.table.TsTable;
import org.apache.iotdb.commons.schema.table.TsTableInternalRPCUtil;
import org.apache.iotdb.commons.utils.PathUtils;
import org.apache.iotdb.confignode.rpc.thrift.TFetchTableResp;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.queryengine.plan.execution.config.executor.ClusterConfigTaskExecutor;
import org.apache.iotdb.db.schemaengine.table.ITableCache;
import org.apache.iotdb.db.schemaengine.table.InformationSchemaUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataNodeTableCache
implements ITableCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataNodeTableCache.class);
    private final AtomicLong version = new AtomicLong(0L);
    private final Map<String, Map<String, TsTable>> databaseTableMap = new ConcurrentHashMap<String, Map<String, TsTable>>();
    private final Map<String, Map<String, Pair<TsTable, Long>>> preUpdateTableMap = new ConcurrentHashMap<String, Map<String, Pair<TsTable, Long>>>();
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Semaphore fetchTableSemaphore = new Semaphore(IoTDBDescriptor.getInstance().getConfig().getDataNodeTableCacheSemaphorePermitNum());

    private DataNodeTableCache() {
    }

    public static DataNodeTableCache getInstance() {
        return DataNodeTableCacheHolder.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(byte[] tableInitializationBytes) {
        this.readWriteLock.writeLock().lock();
        try {
            if (tableInitializationBytes == null) {
                return;
            }
            Pair tableInfo = TsTableInternalRPCUtil.deserializeTableInitializationInfo((byte[])tableInitializationBytes);
            Map usingMap = (Map)tableInfo.left;
            Map preCreateMap = (Map)tableInfo.right;
            usingMap.forEach((key, value) -> this.databaseTableMap.put(PathUtils.unQualifyDatabaseName((String)key), value.stream().collect(Collectors.toMap(TsTable::getTableName, Function.identity(), (v1, v2) -> v2, ConcurrentHashMap::new))));
            preCreateMap.forEach((key, value) -> this.preUpdateTableMap.put(PathUtils.unQualifyDatabaseName((String)key), value.stream().collect(Collectors.toMap(TsTable::getTableName, table -> new Pair(table, (Object)0L), (v1, v2) -> v2, ConcurrentHashMap::new))));
            LOGGER.info("Init DataNodeTableCache successfully");
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    @Override
    public void preUpdateTable(String database, TsTable table) {
        database = PathUtils.unQualifyDatabaseName((String)database);
        this.readWriteLock.writeLock().lock();
        try {
            this.preUpdateTableMap.computeIfAbsent(database, k -> new ConcurrentHashMap()).compute(table.getTableName(), (k, v) -> {
                if (Objects.isNull(v)) {
                    return new Pair((Object)table, (Object)0L);
                }
                v.setLeft((Object)table);
                v.setRight((Object)((Long)v.getRight() + 1L));
                return v;
            });
            LOGGER.info("Pre-update table {}.{} successfully", (Object)database, (Object)table.getTableName());
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    @Override
    public void rollbackUpdateTable(String database, String tableName) {
        database = PathUtils.unQualifyDatabaseName((String)database);
        this.readWriteLock.writeLock().lock();
        try {
            this.removeTableFromPreUpdateMap(database, tableName);
            LOGGER.info("Rollback-update table {}.{} successfully", (Object)database, (Object)tableName);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    private void removeTableFromPreUpdateMap(String database, String tableName) {
        this.preUpdateTableMap.compute(database, (k, v) -> {
            if (v == null) {
                throw new IllegalStateException();
            }
            ((Pair)v.get(tableName)).setLeft(null);
            return v;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commitUpdateTable(String database, String tableName) {
        database = PathUtils.unQualifyDatabaseName((String)database);
        this.readWriteLock.writeLock().lock();
        try {
            TsTable newTable = (TsTable)this.preUpdateTableMap.get(database).get(tableName).getLeft();
            TsTable oldTable = this.databaseTableMap.computeIfAbsent(database, k -> new ConcurrentHashMap()).put(tableName, newTable);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Commit-update table {}.{} successfully, {}", new Object[]{database, tableName, this.compareTable(oldTable, newTable)});
            } else if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Commit-update table {}.{} successfully.", (Object)database, (Object)tableName);
            }
            this.removeTableFromPreUpdateMap(database, tableName);
            this.version.incrementAndGet();
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    @Override
    public void invalid(String database) {
        database = PathUtils.unQualifyDatabaseName((String)database);
        this.readWriteLock.writeLock().lock();
        try {
            this.databaseTableMap.remove(database);
            this.preUpdateTableMap.remove(database);
            this.version.incrementAndGet();
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    @Override
    @GuardedBy(value="TableDeviceSchemaCache#writeLock")
    public void invalid(String database, String tableName) {
        database = PathUtils.unQualifyDatabaseName((String)database);
        this.readWriteLock.writeLock().lock();
        try {
            if (this.databaseTableMap.containsKey(database)) {
                this.databaseTableMap.get(database).remove(tableName);
            }
            if (this.preUpdateTableMap.containsKey(database)) {
                this.preUpdateTableMap.get(database).remove(tableName);
            }
            this.version.incrementAndGet();
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @GuardedBy(value="TableDeviceSchemaCache#writeLock")
    public void invalid(String database, String tableName, String columnName) {
        database = PathUtils.unQualifyDatabaseName((String)database);
        this.readWriteLock.writeLock().lock();
        try {
            if (this.databaseTableMap.containsKey(database) && this.databaseTableMap.get(database).containsKey(tableName)) {
                this.databaseTableMap.get(database).get(tableName).removeColumnSchema(columnName);
            }
            if (this.preUpdateTableMap.containsKey(database) && this.preUpdateTableMap.get(database).containsKey(tableName)) {
                Pair<TsTable, Long> tableVersionPair = this.preUpdateTableMap.get(database).get(tableName);
                if (Objects.nonNull(tableVersionPair.getLeft())) {
                    ((TsTable)tableVersionPair.getLeft()).removeColumnSchema(columnName);
                }
                tableVersionPair.setRight((Object)((Long)tableVersionPair.getRight() + 1L));
            }
            this.version.incrementAndGet();
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    public long getVersion() {
        return this.version.get();
    }

    public TsTable getTableInWrite(String database, String tableName) {
        TsTable result = this.getTableInCache(database, tableName);
        return Objects.nonNull(result) ? result : this.getTable(database, tableName);
    }

    public TsTable getTable(String database, String tableName) {
        Map<String, Map<String, Long>> preUpdateTables = this.mayGetTableInPreUpdateMap(database = PathUtils.unQualifyDatabaseName((String)database), tableName);
        if (Objects.nonNull(preUpdateTables) && !preUpdateTables.isEmpty()) {
            this.updateTable(this.getTablesInConfigNode(preUpdateTables), preUpdateTables);
        }
        return this.getTableInCache(database, tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Map<String, Long>> mayGetTableInPreUpdateMap(String database, String tableName) {
        this.readWriteLock.readLock().lock();
        try {
            Map<String, Map> map = this.preUpdateTableMap.containsKey(database) && this.preUpdateTableMap.get(database).containsKey(tableName) && Objects.nonNull(this.preUpdateTableMap.get(database).get(tableName).getLeft()) ? this.preUpdateTableMap.entrySet().stream().filter(entry -> {
                ((Map)entry.getValue()).entrySet().removeIf(tableEntry -> Objects.isNull(((Pair)tableEntry.getValue()).getLeft()));
                return !((Map)entry.getValue()).isEmpty();
            }).collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Map)entry.getValue()).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, innerEntry -> (Long)((Pair)innerEntry.getValue()).getRight())))) : null;
            return map;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    private Map<String, Map<String, TsTable>> getTablesInConfigNode(Map<String, Map<String, Long>> tableInput) {
        Map result = Collections.emptyMap();
        try {
            this.fetchTableSemaphore.acquire();
            TFetchTableResp resp = ClusterConfigTaskExecutor.getInstance().fetchTables(tableInput.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Map)entry.getValue()).keySet())));
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() == resp.getStatus().getCode()) {
                result = TsTableInternalRPCUtil.deserializeTsTableFetchResult((byte[])resp.getTableInfoMap());
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOGGER.warn("Interrupted when trying to acquire semaphore when trying to get tables from configNode, ignore.");
        }
        catch (Exception e) {
            this.fetchTableSemaphore.release();
            throw e;
        }
        this.fetchTableSemaphore.release();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTable(Map<String, Map<String, TsTable>> fetchedTables, Map<String, Map<String, Long>> previousVersions) {
        this.readWriteLock.writeLock().lock();
        try {
            AtomicBoolean isUpdated = new AtomicBoolean(false);
            fetchedTables.forEach((qualifiedDatabase, tableInfoMap) -> {
                String database = PathUtils.unQualifyDatabaseName((String)qualifiedDatabase);
                if (this.preUpdateTableMap.containsKey(database)) {
                    tableInfoMap.forEach((tableName, tsTable) -> {
                        Pair<TsTable, Long> existingPair = this.preUpdateTableMap.get(database).get(tableName);
                        if (Objects.isNull(existingPair) || Objects.isNull(existingPair.getLeft()) || !Objects.equals(existingPair.getRight(), ((Map)previousVersions.get(database)).get(tableName))) {
                            return;
                        }
                        isUpdated.set(true);
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("Update table {}.{} by table fetch, {}", new Object[]{database, tableName, this.compareTable((TsTable)existingPair.getLeft(), (TsTable)this.databaseTableMap.computeIfAbsent(database, k -> new ConcurrentHashMap()).get(tableName))});
                        } else if (LOGGER.isInfoEnabled()) {
                            LOGGER.info("Update table {}.{} by table fetch.", (Object)database, tableName);
                        }
                        existingPair.setLeft(null);
                        if (Objects.nonNull(tsTable)) {
                            this.databaseTableMap.computeIfAbsent(database, k -> new ConcurrentHashMap()).put(tableName, tsTable);
                        } else if (this.databaseTableMap.containsKey(database)) {
                            this.databaseTableMap.get(database).remove(tableName);
                        }
                    });
                }
            });
            if (isUpdated.get()) {
                this.version.incrementAndGet();
            }
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    private String compareTable(TsTable oldTable, TsTable newTable) {
        HashMap newProps;
        if (Objects.isNull(oldTable)) {
            return "Added table: " + newTable;
        }
        if (Objects.isNull(newTable)) {
            return "Removed table: " + oldTable;
        }
        boolean modified = false;
        StringBuilder builder = new StringBuilder("Table name: " + oldTable.getTableName());
        HashMap oldProps = Objects.nonNull(oldTable.getProps()) ? new HashMap(oldTable.getProps()) : Collections.emptyMap();
        HashMap hashMap = newProps = Objects.nonNull(newTable.getProps()) ? new HashMap(newTable.getProps()) : Collections.emptyMap();
        if (!Objects.equals(oldProps, newProps)) {
            oldProps.keySet().removeIf(key -> {
                if (Objects.equals(oldProps.get(key), newProps.get(key))) {
                    newProps.remove(key);
                    return true;
                }
                return false;
            });
            if (!oldProps.isEmpty()) {
                builder.append(" Removed props: ").append(oldProps);
            }
            if (!newProps.isEmpty()) {
                builder.append(" Added props: ").append(newProps);
            }
            modified = true;
        }
        List oldSchema = oldTable.getColumnList().stream().filter(columnSchema -> Objects.isNull(newTable.getColumnSchema(columnSchema.getColumnName())) || !Objects.equals(columnSchema.getColumnCategory(), newTable.getColumnSchema(columnSchema.getColumnName()).getColumnCategory()) || !Objects.equals(columnSchema.getProps(), newTable.getColumnSchema(columnSchema.getColumnName()).getProps())).collect(Collectors.toList());
        List newSchema = newTable.getColumnList().stream().filter(columnSchema -> Objects.isNull(oldTable.getColumnSchema(columnSchema.getColumnName())) || !Objects.equals(columnSchema.getColumnCategory(), oldTable.getColumnSchema(columnSchema.getColumnName()).getColumnCategory()) || !Objects.equals(columnSchema.getProps(), oldTable.getColumnSchema(columnSchema.getColumnName()).getProps())).collect(Collectors.toList());
        if (!oldSchema.isEmpty()) {
            builder.append(" Removed column(s): ").append(oldSchema);
            modified = true;
        }
        if (!newSchema.isEmpty()) {
            builder.append(" Added column(s): ").append(newSchema);
            modified = true;
        }
        return modified ? builder.toString() : " Not modified";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TsTable getTableInCache(String database, String tableName) {
        this.readWriteLock.readLock().lock();
        try {
            TsTable result = this.databaseTableMap.containsKey(database) ? this.databaseTableMap.get(database).get(tableName) : null;
            TsTable tsTable = Objects.nonNull(result) ? result : InformationSchemaUtils.mayGetTable(database, tableName);
            return tsTable;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public boolean isDatabaseExist(String database) {
        if (this.databaseTableMap.containsKey(database)) {
            return true;
        }
        if (this.getTablesInConfigNode(Collections.singletonMap(database, Collections.emptyMap())).containsKey(database)) {
            this.readWriteLock.readLock().lock();
            try {
                this.databaseTableMap.computeIfAbsent(database, k -> new ConcurrentHashMap());
                boolean bl = true;
                return bl;
            }
            finally {
                this.readWriteLock.readLock().unlock();
            }
        }
        return false;
    }

    public String tryGetInternColumnName(@Nonnull String database, @Nonnull String tableName, @Nonnull String columnName) {
        if (columnName.isEmpty()) {
            return columnName;
        }
        try {
            return this.databaseTableMap.get(database).get(tableName).getColumnSchema(columnName).getColumnName();
        }
        catch (Exception e) {
            return null;
        }
    }

    private static final class DataNodeTableCacheHolder {
        private static final DataNodeTableCache INSTANCE = new DataNodeTableCache();

        private DataNodeTableCacheHolder() {
        }
    }
}

