/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.schemaregion.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.commons.path.IFullPath;
import org.apache.iotdb.commons.path.NonAlignedFullPath;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.queryengine.execution.fragment.QueryContext;
import org.apache.iotdb.db.schemaengine.schemaregion.utils.ResourceByPathUtils;
import org.apache.iotdb.db.storageengine.dataregion.memtable.IMemTable;
import org.apache.iotdb.db.storageengine.dataregion.memtable.IWritableMemChunk;
import org.apache.iotdb.db.storageengine.dataregion.memtable.IWritableMemChunkGroup;
import org.apache.iotdb.db.storageengine.dataregion.memtable.ReadOnlyMemChunk;
import org.apache.iotdb.db.storageengine.dataregion.modification.ModEntry;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.utils.ModificationUtils;
import org.apache.iotdb.db.utils.datastructure.TVList;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.IChunkMetadata;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.file.metadata.ITimeSeriesMetadata;
import org.apache.tsfile.file.metadata.TimeseriesMetadata;
import org.apache.tsfile.file.metadata.statistics.Statistics;
import org.apache.tsfile.read.common.TimeRange;
import org.apache.tsfile.read.filter.basic.Filter;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.write.writer.RestorableTsFileIOWriter;

class MeasurementResourceByPathUtils
extends ResourceByPathUtils {
    NonAlignedFullPath fullPath;

    protected MeasurementResourceByPathUtils(IFullPath fullPath) {
        this.fullPath = (NonAlignedFullPath)fullPath;
    }

    @Override
    public ITimeSeriesMetadata generateTimeSeriesMetadata(List<ReadOnlyMemChunk> readOnlyMemChunk, List<IChunkMetadata> chunkMetadataList) {
        TimeseriesMetadata timeSeriesMetadata = new TimeseriesMetadata();
        timeSeriesMetadata.setMeasurementId(this.fullPath.getMeasurementSchema().getMeasurementName());
        timeSeriesMetadata.setTsDataType(this.fullPath.getMeasurementSchema().getType());
        timeSeriesMetadata.setDataSizeOfChunkMetaDataList(-1);
        Statistics seriesStatistics = Statistics.getStatsByType((TSDataType)timeSeriesMetadata.getTsDataType());
        boolean isModified = false;
        for (IChunkMetadata chunkMetadata : chunkMetadataList) {
            isModified = isModified || chunkMetadata.isModified();
            seriesStatistics.mergeStatistics(chunkMetadata.getStatistics());
        }
        for (ReadOnlyMemChunk memChunk : readOnlyMemChunk) {
            if (memChunk.isEmpty()) continue;
            memChunk.sortTvLists();
            memChunk.initChunkMetaFromTvLists();
            seriesStatistics.mergeStatistics(memChunk.getChunkMetaData().getStatistics());
        }
        timeSeriesMetadata.setStatistics(seriesStatistics);
        timeSeriesMetadata.setModified(isModified);
        return timeSeriesMetadata;
    }

    @Override
    public ReadOnlyMemChunk getReadOnlyMemChunkFromMemTable(QueryContext context, IMemTable memTable, List<Pair<ModEntry, IMemTable>> modsToMemtable, long timeLowerBound, Filter globalTimeFilter) throws QueryProcessException, IOException {
        IDeviceID deviceID;
        Map<IDeviceID, IWritableMemChunkGroup> memTableMap = memTable.getMemTableMap();
        if (!memTableMap.containsKey(deviceID = this.fullPath.getDeviceId()) || !memTableMap.get(deviceID).contains(this.fullPath.getMeasurement())) {
            return null;
        }
        IWritableMemChunk memChunk = memTableMap.get(deviceID).getMemChunkMap().get(this.fullPath.getMeasurement());
        Map<TVList, Integer> tvListQueryMap = this.prepareTvListMapForQuery(context, memChunk, modsToMemtable == null, globalTimeFilter);
        List<TimeRange> deletionList = null;
        if (modsToMemtable != null) {
            deletionList = ModificationUtils.constructDeletionList(this.fullPath.getDeviceId(), this.fullPath.getMeasurement(), memTable, modsToMemtable, timeLowerBound);
        }
        return new ReadOnlyMemChunk(context, this.fullPath.getMeasurement(), this.fullPath.getMeasurementSchema().getType(), this.fullPath.getMeasurementSchema().getEncodingType(), tvListQueryMap, this.fullPath.getMeasurementSchema().getProps(), deletionList);
    }

    @Override
    public List<IChunkMetadata> getVisibleMetadataListFromWriter(RestorableTsFileIOWriter writer, TsFileResource tsFileResource, QueryContext context, long timeLowerBound) {
        List<ModEntry> modifications = context.getPathModifications(tsFileResource, this.fullPath.getDeviceId(), this.fullPath.getMeasurement());
        ArrayList<IChunkMetadata> chunkMetadataList = new ArrayList<IChunkMetadata>(writer.getVisibleMetadataList(this.fullPath.getDeviceId(), this.fullPath.getMeasurement(), this.fullPath.getMeasurementSchema().getType()));
        ModificationUtils.modifyChunkMetaData(chunkMetadataList, modifications);
        chunkMetadataList.removeIf(x -> x.getEndTime() < timeLowerBound);
        return chunkMetadataList;
    }
}

