/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.column.binary;

import org.apache.iotdb.db.queryengine.transformation.dag.column.ColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.binary.BinaryColumnTransformer;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.read.common.type.Type;

public class IntMultiplicationFloatColumnTransformer
extends BinaryColumnTransformer {
    public IntMultiplicationFloatColumnTransformer(Type returnType, ColumnTransformer leftTransformer, ColumnTransformer rightTransformer) {
        super(returnType, leftTransformer, rightTransformer);
    }

    @Override
    protected void doTransform(Column leftColumn, Column rightColumn, ColumnBuilder builder, int positionCount) {
        for (int i = 0; i < positionCount; ++i) {
            if (!leftColumn.isNull(i) && !rightColumn.isNull(i)) {
                this.returnType.writeFloat(builder, IntMultiplicationFloatColumnTransformer.transform(this.leftTransformer.getType().getInt(leftColumn, i), this.rightTransformer.getType().getFloat(rightColumn, i)));
                continue;
            }
            builder.appendNull();
        }
    }

    @Override
    protected void doTransform(Column leftColumn, Column rightColumn, ColumnBuilder builder, int positionCount, boolean[] selection) {
        for (int i = 0; i < positionCount; ++i) {
            if (!leftColumn.isNull(i) && !rightColumn.isNull(i) && selection[i]) {
                this.returnType.writeFloat(builder, IntMultiplicationFloatColumnTransformer.transform(this.leftTransformer.getType().getInt(leftColumn, i), this.rightTransformer.getType().getFloat(rightColumn, i)));
                continue;
            }
            builder.appendNull();
        }
    }

    @Override
    protected void checkType() {
    }

    public static float transform(int left, float right) {
        return (float)left * right;
    }
}

