/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.AlignedFullPath;
import org.apache.iotdb.commons.path.IFullPath;
import org.apache.iotdb.commons.path.NonAlignedFullPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.schema.table.TsTable;
import org.apache.iotdb.commons.schema.table.column.TsTableColumnCategory;
import org.apache.iotdb.commons.schema.table.column.TsTableColumnSchema;
import org.apache.iotdb.commons.udf.builtin.relational.TableBuiltinAggregationFunction;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.queryengine.common.DataNodeEndPoints;
import org.apache.iotdb.db.queryengine.common.FragmentInstanceId;
import org.apache.iotdb.db.queryengine.execution.aggregation.timerangeiterator.ITableTimeRangeIterator;
import org.apache.iotdb.db.queryengine.execution.aggregation.timerangeiterator.TableDateBinTimeRangeIterator;
import org.apache.iotdb.db.queryengine.execution.aggregation.timerangeiterator.TableSingleTimeWindowIterator;
import org.apache.iotdb.db.queryengine.execution.driver.DataDriverContext;
import org.apache.iotdb.db.queryengine.execution.exchange.MPPDataExchangeManager;
import org.apache.iotdb.db.queryengine.execution.exchange.MPPDataExchangeService;
import org.apache.iotdb.db.queryengine.execution.exchange.sink.DownStreamChannelIndex;
import org.apache.iotdb.db.queryengine.execution.exchange.sink.ISinkHandle;
import org.apache.iotdb.db.queryengine.execution.exchange.sink.ShuffleSinkHandle;
import org.apache.iotdb.db.queryengine.execution.exchange.source.ISourceHandle;
import org.apache.iotdb.db.queryengine.execution.operator.ExplainAnalyzeOperator;
import org.apache.iotdb.db.queryengine.execution.operator.Operator;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.process.AssignUniqueIdOperator;
import org.apache.iotdb.db.queryengine.execution.operator.process.CollectOperator;
import org.apache.iotdb.db.queryengine.execution.operator.process.EnforceSingleRowOperator;
import org.apache.iotdb.db.queryengine.execution.operator.process.FilterAndProjectOperator;
import org.apache.iotdb.db.queryengine.execution.operator.process.LimitOperator;
import org.apache.iotdb.db.queryengine.execution.operator.process.OffsetOperator;
import org.apache.iotdb.db.queryengine.execution.operator.process.PreviousFillWithGroupOperator;
import org.apache.iotdb.db.queryengine.execution.operator.process.TableFillOperator;
import org.apache.iotdb.db.queryengine.execution.operator.process.TableLinearFillOperator;
import org.apache.iotdb.db.queryengine.execution.operator.process.TableLinearFillWithGroupOperator;
import org.apache.iotdb.db.queryengine.execution.operator.process.TableMergeSortOperator;
import org.apache.iotdb.db.queryengine.execution.operator.process.TableSortOperator;
import org.apache.iotdb.db.queryengine.execution.operator.process.TableStreamSortOperator;
import org.apache.iotdb.db.queryengine.execution.operator.process.TableTopKOperator;
import org.apache.iotdb.db.queryengine.execution.operator.process.fill.IFill;
import org.apache.iotdb.db.queryengine.execution.operator.process.fill.ILinearFill;
import org.apache.iotdb.db.queryengine.execution.operator.process.fill.constant.BinaryConstantFill;
import org.apache.iotdb.db.queryengine.execution.operator.process.fill.constant.BooleanConstantFill;
import org.apache.iotdb.db.queryengine.execution.operator.process.fill.constant.DoubleConstantFill;
import org.apache.iotdb.db.queryengine.execution.operator.process.fill.constant.FloatConstantFill;
import org.apache.iotdb.db.queryengine.execution.operator.process.fill.constant.IntConstantFill;
import org.apache.iotdb.db.queryengine.execution.operator.process.fill.constant.LongConstantFill;
import org.apache.iotdb.db.queryengine.execution.operator.process.function.TableFunctionLeafOperator;
import org.apache.iotdb.db.queryengine.execution.operator.process.function.TableFunctionOperator;
import org.apache.iotdb.db.queryengine.execution.operator.process.gapfill.GapFillWGroupWMoOperator;
import org.apache.iotdb.db.queryengine.execution.operator.process.gapfill.GapFillWGroupWoMoOperator;
import org.apache.iotdb.db.queryengine.execution.operator.process.gapfill.GapFillWoGroupWMoOperator;
import org.apache.iotdb.db.queryengine.execution.operator.process.gapfill.GapFillWoGroupWoMoOperator;
import org.apache.iotdb.db.queryengine.execution.operator.process.join.FullOuterTimeJoinOperator;
import org.apache.iotdb.db.queryengine.execution.operator.process.join.InnerTimeJoinOperator;
import org.apache.iotdb.db.queryengine.execution.operator.process.join.SimpleNestedLoopCrossJoinOperator;
import org.apache.iotdb.db.queryengine.execution.operator.process.join.TableLeftOuterTimeJoinOperator;
import org.apache.iotdb.db.queryengine.execution.operator.process.join.merge.AscTimeComparator;
import org.apache.iotdb.db.queryengine.execution.operator.process.join.merge.ColumnMerger;
import org.apache.iotdb.db.queryengine.execution.operator.process.join.merge.DescTimeComparator;
import org.apache.iotdb.db.queryengine.execution.operator.process.join.merge.MergeSortComparator;
import org.apache.iotdb.db.queryengine.execution.operator.process.join.merge.SingleColumnMerger;
import org.apache.iotdb.db.queryengine.execution.operator.process.join.merge.comparator.JoinKeyComparatorFactory;
import org.apache.iotdb.db.queryengine.execution.operator.process.last.LastQueryUtil;
import org.apache.iotdb.db.queryengine.execution.operator.schema.CountMergeOperator;
import org.apache.iotdb.db.queryengine.execution.operator.schema.SchemaCountOperator;
import org.apache.iotdb.db.queryengine.execution.operator.schema.SchemaQueryScanOperator;
import org.apache.iotdb.db.queryengine.execution.operator.schema.source.DevicePredicateFilter;
import org.apache.iotdb.db.queryengine.execution.operator.schema.source.SchemaSourceFactory;
import org.apache.iotdb.db.queryengine.execution.operator.sink.IdentitySinkOperator;
import org.apache.iotdb.db.queryengine.execution.operator.source.AbstractDataSourceOperator;
import org.apache.iotdb.db.queryengine.execution.operator.source.ExchangeOperator;
import org.apache.iotdb.db.queryengine.execution.operator.source.SeriesScanOperator;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.AbstractAggTableScanOperator;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.AbstractTableScanOperator;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.AsofMergeSortInnerJoinOperator;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.DefaultAggTableScanOperator;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.DeviceIteratorScanOperator;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.InformationSchemaContentSupplierFactory;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.InformationSchemaTableScanOperator;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.LastQueryAggTableScanOperator;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.MarkDistinctOperator;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.MergeSortFullOuterJoinOperator;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.MergeSortInnerJoinOperator;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.MergeSortLeftJoinOperator;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.MergeSortSemiJoinOperator;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.TableScanOperator;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.TreeAlignedDeviceViewAggregationScanOperator;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.TreeAlignedDeviceViewScanOperator;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.TreeToTableViewAdaptorOperator;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.AccumulatorFactory;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.AggregationOperator;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.LastByDescAccumulator;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.LastDescAccumulator;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.TableAccumulator;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.TableAggregator;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.GroupedAccumulator;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.GroupedAggregator;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.HashAggregationOperator;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.StreamingAggregationOperator;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.StreamingHashAggregationOperator;
import org.apache.iotdb.db.queryengine.execution.relational.ColumnTransformerBuilder;
import org.apache.iotdb.db.queryengine.plan.analyze.PredicateUtils;
import org.apache.iotdb.db.queryengine.plan.analyze.TypeProvider;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.DataNodeTTLCache;
import org.apache.iotdb.db.queryengine.plan.planner.LocalExecutionPlanContext;
import org.apache.iotdb.db.queryengine.plan.planner.OperatorTreeGenerator;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metadata.read.CountSchemaMergeNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.SingleChildProcessNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.sink.IdentitySinkNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.InputLocation;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.SeriesScanOptions;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.predicate.ConvertPredicateToTimeFilterVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.ColumnSchema;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.DeviceEntry;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.Metadata;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.fetcher.cache.TableDeviceLastCache;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.fetcher.cache.TableDeviceSchemaCache;
import org.apache.iotdb.db.queryengine.plan.relational.planner.CastToBlobLiteralVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.planner.CastToBooleanLiteralVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.planner.CastToDateLiteralVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.planner.CastToDoubleLiteralVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.planner.CastToFloatLiteralVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.planner.CastToInt32LiteralVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.planner.CastToInt64LiteralVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.planner.CastToStringLiteralVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.planner.CastToTimestampLiteralVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.planner.OrderingScheme;
import org.apache.iotdb.db.queryengine.plan.relational.planner.SortOrder;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;
import org.apache.iotdb.db.queryengine.plan.relational.planner.SymbolsExtractor;
import org.apache.iotdb.db.queryengine.plan.relational.planner.ir.GlobalTimePredicateExtractVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.planner.ir.IrUtils;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.AggregationNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.AggregationTableScanNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.AggregationTreeDeviceViewScanNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.AssignUniqueId;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.CollectNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.DeviceTableScanNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.EnforceSingleRowNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.ExchangeNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.ExplainAnalyzeNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.FilterNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.GapFillNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.GroupNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.InformationSchemaTableScanNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.JoinNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.LimitNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.LinearFillNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.MarkDistinctNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.MergeSortNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.OffsetNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.OutputNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.PreviousFillNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.ProjectNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.SemiJoinNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.SortNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.StreamSortNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.TableFunctionNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.TableFunctionProcessorNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.TopKNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.TreeAlignedDeviceViewScanNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.TreeNonAlignedDeviceViewScanNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.ValueFillNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.schema.TableDeviceFetchNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.schema.TableDeviceQueryCountNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.schema.TableDeviceQueryScanNode;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.BooleanLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ComparisonExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.FunctionCall;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Literal;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.LongLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.type.InternalTypeManager;
import org.apache.iotdb.db.queryengine.plan.statement.component.Ordering;
import org.apache.iotdb.db.queryengine.transformation.dag.column.ColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.leaf.LeafColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.unary.scalar.DateBinFunctionColumnTransformer;
import org.apache.iotdb.db.schemaengine.schemaregion.read.resp.info.IDeviceSchemaInfo;
import org.apache.iotdb.db.schemaengine.table.DataNodeTableCache;
import org.apache.iotdb.db.utils.datastructure.SortKey;
import org.apache.iotdb.udf.api.relational.TableFunction;
import org.apache.iotdb.udf.api.relational.table.TableFunctionProcessorProvider;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.common.conf.TSFileDescriptor;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.file.metadata.idcolumn.FourOrHigherLevelDBExtractor;
import org.apache.tsfile.file.metadata.idcolumn.ThreeLevelDBExtractor;
import org.apache.tsfile.file.metadata.idcolumn.TwoLevelDBExtractor;
import org.apache.tsfile.read.TimeValuePair;
import org.apache.tsfile.read.common.TimeRange;
import org.apache.tsfile.read.common.block.column.BinaryColumn;
import org.apache.tsfile.read.common.block.column.BooleanColumn;
import org.apache.tsfile.read.common.block.column.DoubleColumn;
import org.apache.tsfile.read.common.block.column.FloatColumn;
import org.apache.tsfile.read.common.block.column.IntColumn;
import org.apache.tsfile.read.common.block.column.LongColumn;
import org.apache.tsfile.read.common.type.BinaryType;
import org.apache.tsfile.read.common.type.BlobType;
import org.apache.tsfile.read.common.type.BooleanType;
import org.apache.tsfile.read.common.type.TimestampType;
import org.apache.tsfile.read.common.type.Type;
import org.apache.tsfile.read.filter.basic.Filter;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.utils.TsPrimitiveType;
import org.apache.tsfile.write.schema.IMeasurementSchema;
import org.apache.tsfile.write.schema.MeasurementSchema;

public class TableOperatorGenerator
extends PlanVisitor<Operator, LocalExecutionPlanContext> {
    private final Metadata metadata;
    private static final MPPDataExchangeManager MPP_DATA_EXCHANGE_MANAGER = MPPDataExchangeService.getInstance().getMPPDataExchangeManager();

    public TableOperatorGenerator(Metadata metadata) {
        this.metadata = metadata;
    }

    @Override
    public Operator visitPlan(PlanNode node, LocalExecutionPlanContext context) {
        throw new UnsupportedOperationException("should call the concrete visitXX() method");
    }

    @Override
    public Operator visitIdentitySink(IdentitySinkNode node, LocalExecutionPlanContext context) {
        context.addExchangeSumNum(1);
        OperatorContext operatorContext = context.getDriverContext().addOperatorContext(context.getNextOperatorId(), node.getPlanNodeId(), IdentitySinkOperator.class.getSimpleName());
        Preconditions.checkArgument((MPP_DATA_EXCHANGE_MANAGER != null ? 1 : 0) != 0, (Object)"MPP_DATA_EXCHANGE_MANAGER should not be null");
        FragmentInstanceId localInstanceId = context.getInstanceContext().getId();
        DownStreamChannelIndex downStreamChannelIndex = new DownStreamChannelIndex(0);
        ISinkHandle sinkHandle = MPP_DATA_EXCHANGE_MANAGER.createShuffleSinkHandle(node.getDownStreamChannelLocationList(), downStreamChannelIndex, ShuffleSinkHandle.ShuffleStrategyEnum.PLAIN, localInstanceId.toThrift(), node.getPlanNodeId().getId(), context.getInstanceContext());
        sinkHandle.setMaxBytesCanReserve(context.getMaxBytesOneHandleCanReserve());
        context.getDriverContext().setSink(sinkHandle);
        if (node.getChildren().size() == 1) {
            Operator child = node.getChildren().get(0).accept(this, context);
            ArrayList<Operator> children = new ArrayList<Operator>(1);
            children.add(child);
            return new IdentitySinkOperator(operatorContext, children, downStreamChannelIndex, sinkHandle);
        }
        throw new IllegalStateException("IdentitySinkNode should only have one child in table model.");
    }

    @Override
    public Operator visitTableExchange(ExchangeNode node, LocalExecutionPlanContext context) {
        ISourceHandle sourceHandle;
        OperatorContext operatorContext = context.getDriverContext().addOperatorContext(context.getNextOperatorId(), node.getPlanNodeId(), ExchangeOperator.class.getSimpleName());
        FragmentInstanceId localInstanceId = context.getInstanceContext().getId();
        FragmentInstanceId remoteInstanceId = node.getUpstreamInstanceId();
        TEndPoint upstreamEndPoint = node.getUpstreamEndpoint();
        boolean isSameNode = DataNodeEndPoints.isSameNode(upstreamEndPoint);
        ISourceHandle iSourceHandle = isSameNode ? MPP_DATA_EXCHANGE_MANAGER.createLocalSourceHandleForFragment(localInstanceId.toThrift(), node.getPlanNodeId().getId(), node.getUpstreamPlanNodeId().getId(), remoteInstanceId.toThrift(), node.getIndexOfUpstreamSinkHandle(), context.getInstanceContext()::failed) : (sourceHandle = MPP_DATA_EXCHANGE_MANAGER.createSourceHandle(localInstanceId.toThrift(), node.getPlanNodeId().getId(), node.getIndexOfUpstreamSinkHandle(), upstreamEndPoint, remoteInstanceId.toThrift(), context.getInstanceContext()::failed));
        if (!isSameNode) {
            context.addExchangeSumNum(1);
        }
        sourceHandle.setMaxBytesCanReserve(context.getMaxBytesOneHandleCanReserve());
        ExchangeOperator exchangeOperator = new ExchangeOperator(operatorContext, sourceHandle, node.getUpstreamPlanNodeId());
        context.addExchangeOperator(exchangeOperator);
        return exchangeOperator;
    }

    @Override
    public Operator visitTreeNonAlignedDeviceViewScan(TreeNonAlignedDeviceViewScanNode node, LocalExecutionPlanContext context) {
        DeviceIteratorScanOperator.TreeNonAlignedDeviceViewScanParameters parameter = this.constructTreeNonAlignedDeviceViewScanOperatorParameter(node, context, TreeNonAlignedDeviceViewScanNode.class.getSimpleName(), node.getMeasurementColumnNameMap());
        DeviceIteratorScanOperator treeNonAlignedDeviceIteratorScanOperator = new DeviceIteratorScanOperator(parameter.context, parameter.deviceEntries, parameter.generator);
        this.addSource(treeNonAlignedDeviceIteratorScanOperator, context, node, parameter.measurementColumnNames, parameter.measurementSchemas, parameter.allSensors, TreeNonAlignedDeviceViewScanNode.class.getSimpleName());
        if (!parameter.generator.keepOffsetAndLimitOperatorAfterDeviceIterator()) {
            return treeNonAlignedDeviceIteratorScanOperator;
        }
        Operator operator = treeNonAlignedDeviceIteratorScanOperator;
        if (node.getPushDownOffset() > 0L) {
            operator = new OffsetOperator(parameter.context, node.getPushDownOffset(), operator);
        }
        if (node.getPushDownLimit() > 0L) {
            operator = new LimitOperator(parameter.context, node.getPushDownLimit(), operator);
        }
        return operator;
    }

    private DeviceIteratorScanOperator.TreeNonAlignedDeviceViewScanParameters constructTreeNonAlignedDeviceViewScanOperatorParameter(final TreeNonAlignedDeviceViewScanNode node, final LocalExecutionPlanContext context, String className, Map<String, String> fieldColumnsRenameMap) {
        if (node.isPushLimitToEachDevice() && node.getPushDownOffset() > 0L) {
            throw new IllegalArgumentException("PushDownOffset should not be set when isPushLimitToEachDevice is true.");
        }
        final CommonTableScanOperatorParameters commonParameter = new CommonTableScanOperatorParameters(node, fieldColumnsRenameMap, true);
        final List<IMeasurementSchema> measurementSchemas = commonParameter.measurementSchemas;
        final List<String> measurementColumnNames = commonParameter.measurementColumnNames;
        final List<ColumnSchema> fullColumnSchemas = commonParameter.columnSchemas;
        final int[] columnsIndexArray = commonParameter.columnsIndexArray;
        final boolean isSingleColumn = measurementSchemas.size() == 1;
        final OperatorContext operatorContext = context.getDriverContext().addOperatorContext(context.getNextOperatorId(), node.getPlanNodeId(), className);
        HashSet<String> allSensors = new HashSet<String>(measurementColumnNames);
        DeviceIteratorScanOperator.DeviceChildOperatorTreeGenerator deviceChildOperatorTreeGenerator = new DeviceIteratorScanOperator.DeviceChildOperatorTreeGenerator(){
            private Operator operator;
            private List<SeriesScanOptions> seriesScanOptionsList;
            private List<Operator> seriesScanOperators;
            private FilterAndProjectOperator filterAndProjectOperator;
            private OffsetOperator reuseOffsetOperator;
            private LimitOperator reuseLimitOperator;
            private Operator startCloseInternalOperator;
            private List<Expression> cannotPushDownConjuncts;
            private boolean removeUpperOffsetAndLimitOperator;

            @Override
            public boolean keepOffsetAndLimitOperatorAfterDeviceIterator() {
                this.calculateSeriesScanOptionsList();
                return !this.removeUpperOffsetAndLimitOperator && !node.isPushLimitToEachDevice();
            }

            @Override
            public void generateCurrentDeviceOperatorTree(DeviceEntry deviceEntry) {
                this.calculateSeriesScanOptionsList();
                this.operator = this.constructTreeToTableViewAdaptorOperator(deviceEntry);
                if (isSingleColumn) {
                    return;
                }
                if (!this.cannotPushDownConjuncts.isEmpty() || node.getAssignments().size() != node.getOutputSymbols().size()) {
                    this.operator = this.getFilterAndProjectOperator(this.operator);
                }
                if (!node.isPushLimitToEachDevice() || this.removeUpperOffsetAndLimitOperator) {
                    return;
                }
                if (node.getPushDownLimit() > 0L) {
                    this.operator = new LimitOperator(operatorContext, node.getPushDownLimit(), this.operator);
                }
            }

            private void calculateSeriesScanOptionsList() {
                boolean canPushDownLimit;
                if (this.seriesScanOptionsList != null) {
                    return;
                }
                this.seriesScanOptionsList = new ArrayList<SeriesScanOptions>(measurementSchemas.size());
                this.cannotPushDownConjuncts = new ArrayList<Expression>();
                HashMap<String, List> pushDownConjunctsForEachMeasurement = new HashMap<String, List>();
                if (node.getPushDownPredicate() != null) {
                    List<Expression> conjuncts = IrUtils.extractConjuncts(node.getPushDownPredicate());
                    for (Expression conjunct : conjuncts) {
                        boolean containsMultiDataSource;
                        Set<Symbol> symbols = SymbolsExtractor.extractUnique(conjunct);
                        boolean bl = containsMultiDataSource = symbols.size() > 1;
                        if (containsMultiDataSource) {
                            this.cannotPushDownConjuncts.add(conjunct);
                            continue;
                        }
                        String symbolName = symbols.iterator().next().getName();
                        pushDownConjunctsForEachMeasurement.computeIfAbsent(symbolName, k -> new ArrayList()).add(conjunct);
                    }
                }
                boolean canPushDownLimitToAllSeriesScanOptions = (canPushDownLimit = this.cannotPushDownConjuncts.isEmpty()) && pushDownConjunctsForEachMeasurement.isEmpty();
                boolean pushDownLimitToLeftChildSeriesScanOperator = canPushDownLimit && pushDownConjunctsForEachMeasurement.size() == 1;
                boolean pushDownOffsetAndLimitAfterInnerJoinOperator = canPushDownLimit && pushDownConjunctsForEachMeasurement.size() > 1;
                this.removeUpperOffsetAndLimitOperator = pushDownLimitToLeftChildSeriesScanOperator || pushDownOffsetAndLimitAfterInnerJoinOperator || isSingleColumn;
                for (int i = 0; i < measurementSchemas.size(); ++i) {
                    IMeasurementSchema measurementSchema = (IMeasurementSchema)measurementSchemas.get(i);
                    List pushDownPredicatesForCurrentMeasurement = (List)pushDownConjunctsForEachMeasurement.get(measurementSchema.getMeasurementName());
                    Expression pushDownPredicateForCurrentMeasurement = isSingleColumn ? node.getPushDownPredicate() : (pushDownPredicatesForCurrentMeasurement == null ? null : IrUtils.combineConjuncts(pushDownPredicatesForCurrentMeasurement));
                    SeriesScanOptions.Builder builder = node.getTimePredicate().map(expression -> TableOperatorGenerator.this.getSeriesScanOptionsBuilder(context, expression)).orElseGet(SeriesScanOptions.Builder::new);
                    builder.withAllSensors(new HashSet<String>(measurementColumnNames));
                    if (pushDownPredicateForCurrentMeasurement != null) {
                        builder.withPushDownFilter(PredicateUtils.convertPredicateToFilter(pushDownPredicateForCurrentMeasurement, Collections.singletonMap(measurementSchema.getMeasurementName(), 0), commonParameter.columnSchemaMap, commonParameter.timeColumnName));
                    }
                    if (isSingleColumn || pushDownLimitToLeftChildSeriesScanOperator && pushDownPredicateForCurrentMeasurement != null) {
                        builder.withPushDownLimit(node.getPushDownLimit());
                        builder.withPushLimitToEachDevice(node.isPushLimitToEachDevice());
                    }
                    if (canPushDownLimitToAllSeriesScanOptions) {
                        builder.withPushDownLimit(node.getPushDownLimit() + node.getPushDownOffset());
                    }
                    if (isSingleColumn || pushDownLimitToLeftChildSeriesScanOperator && pushDownPredicateForCurrentMeasurement != null) {
                        builder.withPushDownOffset(node.isPushLimitToEachDevice() ? 0L : node.getPushDownOffset());
                    }
                    this.seriesScanOptionsList.add(builder.build());
                }
            }

            private Operator constructTreeToTableViewAdaptorOperator(DeviceEntry deviceEntry) {
                this.seriesScanOperators = new ArrayList<Operator>(measurementSchemas.size());
                this.operator = this.constructAndJoinScanOperators(deviceEntry);
                return new TreeToTableViewAdaptorOperator(operatorContext, deviceEntry, columnsIndexArray, fullColumnSchemas, this.operator, TableOperatorGenerator.createTreeDeviceIdColumnValueExtractor(node.getTreeDBName()));
            }

            private Operator constructAndJoinScanOperators(DeviceEntry deviceEntry) {
                ArrayList<Operator> childrenWithPushDownPredicate = new ArrayList<Operator>();
                ArrayList<TSDataType> innerJoinDataTypeList = new ArrayList<TSDataType>();
                ArrayList<Operator> childrenWithoutPushDownPredicate = new ArrayList<Operator>();
                ArrayList<TSDataType> fullOuterTimeJoinDataTypeList = new ArrayList<TSDataType>();
                HashMap<InputLocation, Integer> leftOuterJoinColumnIndexMap = new HashMap<InputLocation, Integer>();
                for (int i = 0; i < measurementSchemas.size(); ++i) {
                    IMeasurementSchema measurementSchema = (IMeasurementSchema)measurementSchemas.get(i);
                    NonAlignedFullPath path = new NonAlignedFullPath(deviceEntry.getDeviceID(), measurementSchema);
                    SeriesScanOptions seriesScanOptions = this.seriesScanOptionsList.get(i);
                    SeriesScanOperator seriesScanOperator = new SeriesScanOperator(operatorContext, node.getPlanNodeId(), (IFullPath)path, node.getScanOrder(), seriesScanOptions);
                    this.seriesScanOperators.add(seriesScanOperator);
                    if (seriesScanOptions.getPushDownFilter() != null) {
                        childrenWithPushDownPredicate.add(seriesScanOperator);
                        innerJoinDataTypeList.add(measurementSchema.getType());
                        leftOuterJoinColumnIndexMap.put(new InputLocation(0, childrenWithPushDownPredicate.size() - 1), i);
                        continue;
                    }
                    childrenWithoutPushDownPredicate.add(seriesScanOperator);
                    fullOuterTimeJoinDataTypeList.add(measurementSchema.getType());
                    leftOuterJoinColumnIndexMap.put(new InputLocation(1, childrenWithoutPushDownPredicate.size() - 1), i);
                }
                Operator leftChild = this.generateInnerTimeJoinOperator(childrenWithPushDownPredicate, innerJoinDataTypeList);
                Operator rightChild = this.generateFullOuterTimeJoinOperator(childrenWithoutPushDownPredicate, fullOuterTimeJoinDataTypeList);
                return this.generateLeftOuterTimeJoinOperator(leftChild, rightChild, childrenWithPushDownPredicate.size(), leftOuterJoinColumnIndexMap, IMeasurementSchema.getDataTypeList((List)measurementSchemas));
            }

            private Operator generateInnerTimeJoinOperator(List<Operator> operators, List<TSDataType> dataTypes) {
                boolean addOffsetAndLimitOperatorAfterLeftChild;
                if (operators.isEmpty()) {
                    return null;
                }
                if (operators.size() == 1) {
                    return operators.get(0);
                }
                HashMap<InputLocation, Integer> outputColumnMap = new HashMap<InputLocation, Integer>();
                for (int i = 0; i < operators.size(); ++i) {
                    outputColumnMap.put(new InputLocation(i, 0), i);
                }
                Operator currentOperator = new InnerTimeJoinOperator(operatorContext, operators, dataTypes, node.getScanOrder() == Ordering.ASC ? new AscTimeComparator() : new DescTimeComparator(), outputColumnMap);
                boolean bl = addOffsetAndLimitOperatorAfterLeftChild = operators.size() > 1 && this.cannotPushDownConjuncts.isEmpty();
                if (addOffsetAndLimitOperatorAfterLeftChild) {
                    if (node.getPushDownOffset() > 0L) {
                        currentOperator = this.getReuseOffsetOperator(currentOperator);
                    }
                    if (node.getPushDownLimit() > 0L) {
                        currentOperator = this.getReuseLimitOperator(currentOperator);
                    }
                }
                return currentOperator;
            }

            private Operator generateFullOuterTimeJoinOperator(List<Operator> operators, List<TSDataType> dataTypes) {
                if (operators.isEmpty()) {
                    return null;
                }
                if (operators.size() == 1) {
                    return operators.get(0);
                }
                ArrayList<ColumnMerger> columnMergers = new ArrayList<ColumnMerger>(operators.size());
                for (int i = 0; i < operators.size(); ++i) {
                    columnMergers.add(new SingleColumnMerger(new InputLocation(i, 0), node.getScanOrder() == Ordering.ASC ? new AscTimeComparator() : new DescTimeComparator()));
                }
                return new FullOuterTimeJoinOperator(operatorContext, operators, node.getScanOrder(), dataTypes, columnMergers, node.getScanOrder() == Ordering.ASC ? new AscTimeComparator() : new DescTimeComparator());
            }

            private Operator generateLeftOuterTimeJoinOperator(Operator left, Operator right, int leftColumnCount, Map<InputLocation, Integer> outputColumnMap, List<TSDataType> dataTypes) {
                if (left == null) {
                    return right;
                }
                if (right == null) {
                    return left;
                }
                return new TableLeftOuterTimeJoinOperator(operatorContext, left, right, leftColumnCount, outputColumnMap, dataTypes, node.getScanOrder() == Ordering.ASC ? new AscTimeComparator() : new DescTimeComparator());
            }

            private Operator getReuseOffsetOperator(Operator child) {
                this.reuseOffsetOperator = this.reuseOffsetOperator == null ? new OffsetOperator(operatorContext, node.getPushDownOffset(), child) : new OffsetOperator(this.reuseOffsetOperator, child);
                return this.reuseOffsetOperator;
            }

            private Operator getReuseLimitOperator(Operator child) {
                this.reuseLimitOperator = this.reuseLimitOperator == null ? new LimitOperator(operatorContext, node.getPushDownLimit(), child) : new LimitOperator(this.reuseLimitOperator, child);
                return this.reuseLimitOperator;
            }

            private Operator getFilterAndProjectOperator(Operator childOperator) {
                this.startCloseInternalOperator = childOperator;
                if (this.filterAndProjectOperator != null) {
                    return new FilterAndProjectOperator(this.filterAndProjectOperator, childOperator);
                }
                ArrayList<TSDataType> inputDataTypeList = new ArrayList<TSDataType>(fullColumnSchemas.size());
                HashMap<Symbol, List> symbolInputLocationMap = new HashMap<Symbol, List>(fullColumnSchemas.size());
                for (int i = 0; i < fullColumnSchemas.size(); ++i) {
                    ColumnSchema columnSchema = (ColumnSchema)fullColumnSchemas.get(i);
                    symbolInputLocationMap.computeIfAbsent(new Symbol(columnSchema.getName()), key -> new ArrayList()).add(new InputLocation(0, i));
                    inputDataTypeList.add(InternalTypeManager.getTSDataType(columnSchema.getType()));
                }
                Expression combinedCannotPushDownPredicates = this.cannotPushDownConjuncts.isEmpty() ? null : IrUtils.combineConjuncts(this.cannotPushDownConjuncts);
                this.filterAndProjectOperator = (FilterAndProjectOperator)TableOperatorGenerator.this.constructFilterAndProjectOperator(Optional.ofNullable(combinedCannotPushDownPredicates), childOperator, (Expression[])node.getOutputSymbols().stream().map(Symbol::toSymbolReference).toArray(Expression[]::new), inputDataTypeList, symbolInputLocationMap, node.getPlanNodeId(), context);
                return this.filterAndProjectOperator;
            }

            @Override
            public Operator getCurrentDeviceRootOperator() {
                return this.operator;
            }

            @Override
            public List<Operator> getCurrentDeviceDataSourceOperators() {
                return this.seriesScanOperators;
            }

            @Override
            public Operator getCurrentDeviceStartCloseOperator() {
                return this.startCloseInternalOperator == null ? this.operator : this.startCloseInternalOperator;
            }
        };
        return new DeviceIteratorScanOperator.TreeNonAlignedDeviceViewScanParameters(allSensors, operatorContext, node.getDeviceEntries(), measurementColumnNames, measurementSchemas, deviceChildOperatorTreeGenerator);
    }

    public static IDeviceID.TreeDeviceIdColumnValueExtractor createTreeDeviceIdColumnValueExtractor(String treeDBName) {
        try {
            PartialPath db = new PartialPath(treeDBName);
            int dbLevel = db.getNodes().length;
            if (dbLevel == 2) {
                return new TwoLevelDBExtractor(treeDBName.length());
            }
            if (dbLevel == 3) {
                return new ThreeLevelDBExtractor(treeDBName.length());
            }
            if (dbLevel >= 4) {
                return new FourOrHigherLevelDBExtractor(dbLevel);
            }
            throw new IllegalArgumentException("tree db name should at least be two level: " + treeDBName);
        }
        catch (IllegalPathException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public Operator visitTreeAlignedDeviceViewScan(TreeAlignedDeviceViewScanNode node, LocalExecutionPlanContext context) {
        IDeviceID.TreeDeviceIdColumnValueExtractor idColumnValueExtractor = TableOperatorGenerator.createTreeDeviceIdColumnValueExtractor(node.getTreeDBName());
        AbstractTableScanOperator.AbstractTableScanOperatorParameter parameter = this.constructAbstractTableScanOperatorParameter(node, context, TreeAlignedDeviceViewScanOperator.class.getSimpleName(), node.getMeasurementColumnNameMap());
        TreeAlignedDeviceViewScanOperator treeAlignedDeviceViewScanOperator = new TreeAlignedDeviceViewScanOperator(parameter, idColumnValueExtractor);
        this.addSource(treeAlignedDeviceViewScanOperator, context, node, parameter.measurementColumnNames, parameter.measurementSchemas, parameter.allSensors, TreeAlignedDeviceViewScanNode.class.getSimpleName());
        return treeAlignedDeviceViewScanOperator;
    }

    private void addSource(AbstractDataSourceOperator sourceOperator, LocalExecutionPlanContext context, DeviceTableScanNode node, List<String> measurementColumnNames, List<IMeasurementSchema> measurementSchemas, Set<String> allSensors, String planNodeName) {
        ((DataDriverContext)context.getDriverContext()).addSourceOperator(sourceOperator);
        int size = node.getDeviceEntries().size();
        for (int i = 0; i < size; ++i) {
            if (node.getDeviceEntries().get(i) == null) {
                throw new IllegalStateException("Device entries of index " + i + " in " + planNodeName + " is empty");
            }
            AlignedFullPath alignedPath = TableScanOperator.constructAlignedPath(node.getDeviceEntries().get(i), measurementColumnNames, measurementSchemas, allSensors);
            ((DataDriverContext)context.getDriverContext()).addPath((IFullPath)alignedPath);
        }
        context.getDriverContext().setInputDriver(true);
    }

    private AbstractTableScanOperator.AbstractTableScanOperatorParameter constructAbstractTableScanOperatorParameter(DeviceTableScanNode node, LocalExecutionPlanContext context, String className, Map<String, String> fieldColumnsRenameMap) {
        CommonTableScanOperatorParameters commonParameter = new CommonTableScanOperatorParameters(node, fieldColumnsRenameMap, false);
        List<IMeasurementSchema> measurementSchemas = commonParameter.measurementSchemas;
        List<String> measurementColumnNames = commonParameter.measurementColumnNames;
        List<ColumnSchema> columnSchemas = commonParameter.columnSchemas;
        int[] columnsIndexArray = commonParameter.columnsIndexArray;
        SeriesScanOptions seriesScanOptions = this.buildSeriesScanOptions(context, commonParameter.columnSchemaMap, measurementColumnNames, commonParameter.measurementColumnsIndexMap, commonParameter.timeColumnName, node.getTimePredicate(), node.getPushDownLimit(), node.getPushDownOffset(), node.isPushLimitToEachDevice(), node.getPushDownPredicate());
        OperatorContext operatorContext = context.getDriverContext().addOperatorContext(context.getNextOperatorId(), node.getPlanNodeId(), className);
        int maxTsBlockLineNum = TSFileDescriptor.getInstance().getConfig().getMaxTsBlockLineNumber();
        if (context.getTypeProvider().getTemplatedInfo() != null) {
            maxTsBlockLineNum = (int)Math.min(context.getTypeProvider().getTemplatedInfo().getLimitValue(), (long)maxTsBlockLineNum);
        }
        HashSet<String> allSensors = new HashSet<String>(measurementColumnNames);
        allSensors.add("");
        return new AbstractTableScanOperator.AbstractTableScanOperatorParameter(allSensors, operatorContext, node.getPlanNodeId(), columnSchemas, columnsIndexArray, node.getDeviceEntries(), node.getScanOrder(), seriesScanOptions, measurementColumnNames, measurementSchemas, maxTsBlockLineNum);
    }

    private AbstractTableScanOperator.AbstractTableScanOperatorParameter constructAbstractTableScanOperatorParameter(DeviceTableScanNode node, LocalExecutionPlanContext context) {
        return this.constructAbstractTableScanOperatorParameter(node, context, TableScanOperator.class.getSimpleName(), Collections.emptyMap());
    }

    @Override
    public Operator visitDeviceTableScan(DeviceTableScanNode node, LocalExecutionPlanContext context) {
        AbstractTableScanOperator.AbstractTableScanOperatorParameter parameter = this.constructAbstractTableScanOperatorParameter(node, context);
        TableScanOperator tableScanOperator = new TableScanOperator(parameter);
        this.addSource(tableScanOperator, context, node, parameter.measurementColumnNames, parameter.measurementSchemas, parameter.allSensors, DeviceTableScanNode.class.getSimpleName());
        return tableScanOperator;
    }

    public static Map<Symbol, List<InputLocation>> makeLayout(List<PlanNode> children) {
        LinkedHashMap<Symbol, List<InputLocation>> outputMappings = new LinkedHashMap<Symbol, List<InputLocation>>();
        int tsBlockIndex = 0;
        for (PlanNode childNode : children) {
            int valueColumnIndex = 0;
            for (Symbol columnName : childNode.getOutputSymbols()) {
                outputMappings.computeIfAbsent(columnName, key -> new ArrayList()).add(new InputLocation(tsBlockIndex, valueColumnIndex));
                ++valueColumnIndex;
            }
            ++tsBlockIndex;
        }
        return outputMappings;
    }

    private ImmutableMap<Symbol, Integer> makeLayoutFromOutputSymbols(List<Symbol> outputSymbols) {
        if (outputSymbols == null) {
            return ImmutableMap.of();
        }
        ImmutableMap.Builder outputMappings = ImmutableMap.builder();
        int channel = 0;
        for (Symbol symbol : outputSymbols) {
            outputMappings.put((Object)symbol, (Object)channel);
            ++channel;
        }
        return outputMappings.buildOrThrow();
    }

    private SeriesScanOptions.Builder getSeriesScanOptionsBuilder(LocalExecutionPlanContext context, @NotNull Expression timePredicate) {
        SeriesScanOptions.Builder scanOptionsBuilder = new SeriesScanOptions.Builder();
        Filter timeFilter = timePredicate.accept(new ConvertPredicateToTimeFilterVisitor(), null);
        context.getDriverContext().getFragmentInstanceContext().setTimeFilterForTableModel(timeFilter);
        scanOptionsBuilder.withGlobalTimeFilter(timeFilter.copy());
        return scanOptionsBuilder;
    }

    @Override
    public Operator visitInformationSchemaTableScan(InformationSchemaTableScanNode node, LocalExecutionPlanContext context) {
        OperatorContext operatorContext = context.getDriverContext().addOperatorContext(context.getNextOperatorId(), node.getPlanNodeId(), InformationSchemaTableScanOperator.class.getSimpleName());
        List<TSDataType> dataTypes = node.getOutputSymbols().stream().map(symbol -> InternalTypeManager.getTSDataType(context.getTypeProvider().getTableModelType((Symbol)symbol))).collect(Collectors.toList());
        return new InformationSchemaTableScanOperator(operatorContext, node.getPlanNodeId(), InformationSchemaContentSupplierFactory.getSupplier(node.getQualifiedObjectName().getObjectName(), dataTypes));
    }

    @Override
    public Operator visitFilter(FilterNode node, LocalExecutionPlanContext context) {
        TypeProvider typeProvider = context.getTypeProvider();
        Optional<Expression> predicate = Optional.of(node.getPredicate());
        Operator inputOperator = node.getChild().accept(this, context);
        List<TSDataType> inputDataTypes = this.getInputColumnTypes(node, typeProvider);
        Map<Symbol, List<InputLocation>> inputLocations = TableOperatorGenerator.makeLayout(node.getChildren());
        return this.constructFilterAndProjectOperator(predicate, inputOperator, (Expression[])node.getOutputSymbols().stream().map(Symbol::toSymbolReference).toArray(Expression[]::new), inputDataTypes, inputLocations, node.getPlanNodeId(), context);
    }

    private Operator constructFilterAndProjectOperator(Optional<Expression> predicate, Operator inputOperator, Expression[] projectExpressions, List<TSDataType> inputDataTypes, Map<Symbol, List<InputLocation>> inputLocations, PlanNodeId planNodeId, LocalExecutionPlanContext context) {
        ArrayList<TSDataType> filterOutputDataTypes = new ArrayList<TSDataType>(inputDataTypes);
        ArrayList<LeafColumnTransformer> filterLeafColumnTransformerList = new ArrayList<LeafColumnTransformer>();
        HashMap<Expression, ColumnTransformer> filterExpressionColumnTransformerMap = new HashMap<Expression, ColumnTransformer>();
        ColumnTransformerBuilder visitor = new ColumnTransformerBuilder();
        ColumnTransformer filterOutputTransformer = predicate.map(p -> {
            ColumnTransformerBuilder.Context filterColumnTransformerContext = new ColumnTransformerBuilder.Context(context.getDriverContext().getFragmentInstanceContext().getSessionInfo(), filterLeafColumnTransformerList, inputLocations, filterExpressionColumnTransformerMap, (Map<Expression, ColumnTransformer>)ImmutableMap.of(), (List<ColumnTransformer>)ImmutableList.of(), (List<TSDataType>)ImmutableList.of(), 0, context.getTypeProvider(), this.metadata);
            return (ColumnTransformer)visitor.process((Node)p, filterColumnTransformerContext);
        }).orElse(null);
        ArrayList<LeafColumnTransformer> projectLeafColumnTransformerList = new ArrayList<LeafColumnTransformer>();
        ArrayList<ColumnTransformer> projectOutputTransformerList = new ArrayList<ColumnTransformer>();
        HashMap<Expression, ColumnTransformer> projectExpressionColumnTransformerMap = new HashMap<Expression, ColumnTransformer>();
        ArrayList<ColumnTransformer> commonTransformerList = new ArrayList<ColumnTransformer>();
        ColumnTransformerBuilder.Context projectColumnTransformerContext = new ColumnTransformerBuilder.Context(context.getDriverContext().getFragmentInstanceContext().getSessionInfo(), projectLeafColumnTransformerList, inputLocations, projectExpressionColumnTransformerMap, filterExpressionColumnTransformerMap, commonTransformerList, filterOutputDataTypes, inputLocations.size(), context.getTypeProvider(), this.metadata);
        for (Expression expression : projectExpressions) {
            projectOutputTransformerList.add((ColumnTransformer)visitor.process(expression, projectColumnTransformerContext));
        }
        OperatorContext operatorContext = context.getDriverContext().addOperatorContext(context.getNextOperatorId(), planNodeId, FilterAndProjectOperator.class.getSimpleName());
        return new FilterAndProjectOperator(operatorContext, inputOperator, filterOutputDataTypes, filterLeafColumnTransformerList, filterOutputTransformer, commonTransformerList, projectLeafColumnTransformerList, projectOutputTransformerList, false, predicate.isPresent());
    }

    @Override
    public Operator visitProject(ProjectNode node, LocalExecutionPlanContext context) {
        Map<Symbol, List<InputLocation>> inputLocations;
        List<TSDataType> inputDataTypes;
        Operator inputOperator;
        Optional<Expression> predicate;
        TypeProvider typeProvider = context.getTypeProvider();
        if (node.getChild() instanceof FilterNode) {
            FilterNode filterNode = (FilterNode)node.getChild();
            predicate = Optional.of(filterNode.getPredicate());
            inputOperator = filterNode.getChild().accept(this, context);
            inputDataTypes = this.getInputColumnTypes(filterNode, typeProvider);
            inputLocations = TableOperatorGenerator.makeLayout(filterNode.getChildren());
        } else {
            predicate = Optional.empty();
            inputOperator = node.getChild().accept(this, context);
            inputDataTypes = this.getInputColumnTypes(node, typeProvider);
            inputLocations = TableOperatorGenerator.makeLayout(node.getChildren());
        }
        return this.constructFilterAndProjectOperator(predicate, inputOperator, node.getAssignments().getMap().values().toArray(new Expression[0]), inputDataTypes, inputLocations, node.getPlanNodeId(), context);
    }

    private List<TSDataType> getInputColumnTypes(PlanNode node, TypeProvider typeProvider) {
        return node.getChildren().stream().map(PlanNode::getOutputSymbols).flatMap(Collection::stream).map(s -> InternalTypeManager.getTSDataType(typeProvider.getTableModelType((Symbol)s))).collect(Collectors.toList());
    }

    @Override
    public Operator visitGapFill(GapFillNode node, LocalExecutionPlanContext context) {
        Operator child = node.getChild().accept(this, context);
        List<TSDataType> inputDataTypes = this.getOutputColumnTypes(node.getChild(), context.getTypeProvider());
        int timeColumnIndex = this.getColumnIndex(node.getGapFillColumn(), node.getChild());
        if (node.getGapFillGroupingKeys().isEmpty()) {
            if (node.getMonthDuration() == 0) {
                OperatorContext operatorContext = context.getDriverContext().addOperatorContext(context.getNextOperatorId(), node.getPlanNodeId(), GapFillWoGroupWoMoOperator.class.getSimpleName());
                return new GapFillWoGroupWoMoOperator(operatorContext, child, timeColumnIndex, node.getStartTime(), node.getEndTime(), inputDataTypes, node.getNonMonthDuration());
            }
            OperatorContext operatorContext = context.getDriverContext().addOperatorContext(context.getNextOperatorId(), node.getPlanNodeId(), GapFillWoGroupWMoOperator.class.getSimpleName());
            return new GapFillWoGroupWMoOperator(operatorContext, child, timeColumnIndex, node.getStartTime(), node.getEndTime(), inputDataTypes, node.getMonthDuration(), context.getZoneId());
        }
        HashSet<Integer> groupingKeysIndexSet = new HashSet<Integer>();
        Comparator<SortKey> groupKeyComparator = this.genFillGroupKeyComparator(node.getGapFillGroupingKeys(), node, inputDataTypes, groupingKeysIndexSet);
        if (node.getMonthDuration() == 0) {
            OperatorContext operatorContext = context.getDriverContext().addOperatorContext(context.getNextOperatorId(), node.getPlanNodeId(), GapFillWGroupWoMoOperator.class.getSimpleName());
            return new GapFillWGroupWoMoOperator(operatorContext, child, timeColumnIndex, node.getStartTime(), node.getEndTime(), groupKeyComparator, inputDataTypes, groupingKeysIndexSet, node.getNonMonthDuration());
        }
        OperatorContext operatorContext = context.getDriverContext().addOperatorContext(context.getNextOperatorId(), node.getPlanNodeId(), GapFillWGroupWMoOperator.class.getSimpleName());
        return new GapFillWGroupWMoOperator(operatorContext, child, timeColumnIndex, node.getStartTime(), node.getEndTime(), groupKeyComparator, inputDataTypes, groupingKeysIndexSet, node.getMonthDuration(), context.getZoneId());
    }

    @Override
    public Operator visitPreviousFill(PreviousFillNode node, LocalExecutionPlanContext context) {
        Operator child = node.getChild().accept(this, context);
        List<TSDataType> inputDataTypes = this.getOutputColumnTypes(node.getChild(), context.getTypeProvider());
        int inputColumnCount = inputDataTypes.size();
        int helperColumnIndex = -1;
        if (node.getHelperColumn().isPresent()) {
            helperColumnIndex = this.getColumnIndex(node.getHelperColumn().get(), node.getChild());
        }
        IFill[] fillArray = OperatorTreeGenerator.getPreviousFill(inputColumnCount, inputDataTypes, node.getTimeBound().orElse(null), context.getZoneId());
        if (node.getGroupingKeys().isPresent()) {
            OperatorContext operatorContext = context.getDriverContext().addOperatorContext(context.getNextOperatorId(), node.getPlanNodeId(), PreviousFillWithGroupOperator.class.getSimpleName());
            return new PreviousFillWithGroupOperator(operatorContext, fillArray, child, helperColumnIndex, this.genFillGroupKeyComparator(node.getGroupingKeys().get(), node, inputDataTypes, new HashSet<Integer>()), inputDataTypes);
        }
        OperatorContext operatorContext = context.getDriverContext().addOperatorContext(context.getNextOperatorId(), node.getPlanNodeId(), TableFillOperator.class.getSimpleName());
        return new TableFillOperator(operatorContext, fillArray, child, helperColumnIndex);
    }

    private Comparator<SortKey> genFillGroupKeyComparator(List<Symbol> groupingKeys, SingleChildProcessNode node, List<TSDataType> inputDataTypes, Set<Integer> groupKeysIndex) {
        int groupKeysCount = groupingKeys.size();
        ArrayList<SortOrder> sortOrderList = new ArrayList<SortOrder>(groupKeysCount);
        ArrayList<Integer> groupItemIndexList = new ArrayList<Integer>(groupKeysCount);
        ArrayList<TSDataType> groupItemDataTypeList = new ArrayList<TSDataType>(groupKeysCount);
        ImmutableMap<Symbol, Integer> columnIndex = this.makeLayoutFromOutputSymbols(node.getChild().getOutputSymbols());
        for (Symbol symbol : groupingKeys) {
            sortOrderList.add(SortOrder.ASC_NULLS_LAST);
            int index = (Integer)columnIndex.get(symbol);
            groupItemIndexList.add(index);
            groupItemDataTypeList.add(inputDataTypes.get(index));
        }
        groupKeysIndex.addAll(groupItemIndexList);
        return MergeSortComparator.getComparatorForTable(sortOrderList, groupItemIndexList, groupItemDataTypeList);
    }

    private int getColumnIndex(Symbol symbol, PlanNode node) {
        String name = symbol.getName();
        int channel = 0;
        for (Symbol columnName : node.getOutputSymbols()) {
            if (columnName.getName().equals(name)) {
                return channel;
            }
            ++channel;
        }
        throw new IllegalStateException(String.format("Found no column %s in %s", symbol, node.getOutputSymbols()));
    }

    @Override
    public Operator visitLinearFill(LinearFillNode node, LocalExecutionPlanContext context) {
        Operator child = node.getChild().accept(this, context);
        List<TSDataType> inputDataTypes = this.getOutputColumnTypes(node.getChild(), context.getTypeProvider());
        int inputColumnCount = inputDataTypes.size();
        int helperColumnIndex = this.getColumnIndex(node.getHelperColumn(), node.getChild());
        ILinearFill[] fillArray = OperatorTreeGenerator.getLinearFill(inputColumnCount, inputDataTypes);
        if (node.getGroupingKeys().isPresent()) {
            OperatorContext operatorContext = context.getDriverContext().addOperatorContext(context.getNextOperatorId(), node.getPlanNodeId(), TableLinearFillWithGroupOperator.class.getSimpleName());
            return new TableLinearFillWithGroupOperator(operatorContext, fillArray, child, helperColumnIndex, this.genFillGroupKeyComparator(node.getGroupingKeys().get(), node, inputDataTypes, new HashSet<Integer>()), inputDataTypes);
        }
        OperatorContext operatorContext = context.getDriverContext().addOperatorContext(context.getNextOperatorId(), node.getPlanNodeId(), TableLinearFillOperator.class.getSimpleName());
        return new TableLinearFillOperator(operatorContext, fillArray, child, helperColumnIndex);
    }

    @Override
    public Operator visitValueFill(ValueFillNode node, LocalExecutionPlanContext context) {
        Operator child = node.getChild().accept(this, context);
        OperatorContext operatorContext = context.getDriverContext().addOperatorContext(context.getNextOperatorId(), node.getPlanNodeId(), TableFillOperator.class.getSimpleName());
        List<TSDataType> inputDataTypes = this.getOutputColumnTypes(node.getChild(), context.getTypeProvider());
        int inputColumnCount = inputDataTypes.size();
        Literal filledValue = node.getFilledValue();
        return new TableFillOperator(operatorContext, this.getValueFill(inputColumnCount, inputDataTypes, filledValue, context), child, -1);
    }

    private IFill[] getValueFill(int inputColumnCount, List<TSDataType> inputDataTypes, Literal filledValue, LocalExecutionPlanContext context) {
        IFill[] constantFill = new IFill[inputColumnCount];
        block11: for (int i = 0; i < inputColumnCount; ++i) {
            switch (inputDataTypes.get(i)) {
                case BOOLEAN: {
                    Boolean bool = filledValue.accept(new CastToBooleanLiteralVisitor(), null);
                    if (bool == null) {
                        constantFill[i] = OperatorTreeGenerator.IDENTITY_FILL;
                        continue block11;
                    }
                    constantFill[i] = new BooleanConstantFill(bool);
                    continue block11;
                }
                case TEXT: 
                case STRING: {
                    Binary binary = filledValue.accept(new CastToStringLiteralVisitor(TSFileConfig.STRING_CHARSET), null);
                    if (binary == null) {
                        constantFill[i] = OperatorTreeGenerator.IDENTITY_FILL;
                        continue block11;
                    }
                    constantFill[i] = new BinaryConstantFill(binary);
                    continue block11;
                }
                case BLOB: {
                    Binary blob = filledValue.accept(new CastToBlobLiteralVisitor(), null);
                    if (blob == null) {
                        constantFill[i] = OperatorTreeGenerator.IDENTITY_FILL;
                        continue block11;
                    }
                    constantFill[i] = new BinaryConstantFill(blob);
                    continue block11;
                }
                case INT32: {
                    Integer intValue = filledValue.accept(new CastToInt32LiteralVisitor(), null);
                    if (intValue == null) {
                        constantFill[i] = OperatorTreeGenerator.IDENTITY_FILL;
                        continue block11;
                    }
                    constantFill[i] = new IntConstantFill(intValue);
                    continue block11;
                }
                case DATE: {
                    Integer dateValue = filledValue.accept(new CastToDateLiteralVisitor(), null);
                    if (dateValue == null) {
                        constantFill[i] = OperatorTreeGenerator.IDENTITY_FILL;
                        continue block11;
                    }
                    constantFill[i] = new IntConstantFill(dateValue);
                    continue block11;
                }
                case INT64: {
                    Long longValue = filledValue.accept(new CastToInt64LiteralVisitor(), null);
                    if (longValue == null) {
                        constantFill[i] = OperatorTreeGenerator.IDENTITY_FILL;
                        continue block11;
                    }
                    constantFill[i] = new LongConstantFill(longValue);
                    continue block11;
                }
                case TIMESTAMP: {
                    Long timestampValue = filledValue.accept(new CastToTimestampLiteralVisitor(context.getZoneId()), null);
                    if (timestampValue == null) {
                        constantFill[i] = OperatorTreeGenerator.IDENTITY_FILL;
                        continue block11;
                    }
                    constantFill[i] = new LongConstantFill(timestampValue);
                    continue block11;
                }
                case FLOAT: {
                    Float floatValue = filledValue.accept(new CastToFloatLiteralVisitor(), null);
                    if (floatValue == null) {
                        constantFill[i] = OperatorTreeGenerator.IDENTITY_FILL;
                        continue block11;
                    }
                    constantFill[i] = new FloatConstantFill(floatValue.floatValue());
                    continue block11;
                }
                case DOUBLE: {
                    Double doubleValue = filledValue.accept(new CastToDoubleLiteralVisitor(), null);
                    if (doubleValue == null) {
                        constantFill[i] = OperatorTreeGenerator.IDENTITY_FILL;
                        continue block11;
                    }
                    constantFill[i] = new DoubleConstantFill(doubleValue);
                    continue block11;
                }
                default: {
                    throw new IllegalArgumentException("Unknown data type: " + inputDataTypes.get(i));
                }
            }
        }
        return constantFill;
    }

    @Override
    public Operator visitLimit(LimitNode node, LocalExecutionPlanContext context) {
        Operator child = node.getChild().accept(this, context);
        OperatorContext operatorContext = context.getDriverContext().addOperatorContext(context.getNextOperatorId(), node.getPlanNodeId(), LimitOperator.class.getSimpleName());
        return new LimitOperator(operatorContext, node.getCount(), child);
    }

    @Override
    public Operator visitOffset(OffsetNode node, LocalExecutionPlanContext context) {
        Operator child = node.getChild().accept(this, context);
        OperatorContext operatorContext = context.getDriverContext().addOperatorContext(context.getNextOperatorId(), node.getPlanNodeId(), OffsetOperator.class.getSimpleName());
        return new OffsetOperator(operatorContext, node.getCount(), child);
    }

    @Override
    public Operator visitOutput(OutputNode node, LocalExecutionPlanContext context) {
        return node.getChild().accept(this, context);
    }

    @Override
    public Operator visitCollect(CollectNode node, LocalExecutionPlanContext context) {
        OperatorContext operatorContext = context.getDriverContext().addOperatorContext(context.getNextOperatorId(), node.getPlanNodeId(), CollectOperator.class.getSimpleName());
        ArrayList<Operator> children = new ArrayList<Operator>(node.getChildren().size());
        for (PlanNode child : node.getChildren()) {
            children.add((Operator)this.process(child, context));
        }
        return new CollectOperator(operatorContext, children);
    }

    @Override
    public Operator visitMergeSort(MergeSortNode node, LocalExecutionPlanContext context) {
        OperatorContext operatorContext = context.getDriverContext().addOperatorContext(context.getNextOperatorId(), node.getPlanNodeId(), TableMergeSortOperator.class.getSimpleName());
        ArrayList<Operator> children = new ArrayList<Operator>(node.getChildren().size());
        for (PlanNode child : node.getChildren()) {
            children.add((Operator)this.process(child, context));
        }
        List<TSDataType> dataTypes = this.getOutputColumnTypes(node, context.getTypeProvider());
        int sortItemsCount = node.getOrderingScheme().getOrderBy().size();
        ArrayList<Integer> sortItemIndexList = new ArrayList<Integer>(sortItemsCount);
        ArrayList<TSDataType> sortItemDataTypeList = new ArrayList<TSDataType>(sortItemsCount);
        this.genSortInformation(node.getOutputSymbols(), node.getOrderingScheme(), sortItemIndexList, sortItemDataTypeList, context.getTypeProvider());
        return new TableMergeSortOperator(operatorContext, children, dataTypes, MergeSortComparator.getComparatorForTable(node.getOrderingScheme().getOrderingList(), sortItemIndexList, sortItemDataTypeList));
    }

    @Override
    public Operator visitSort(SortNode node, LocalExecutionPlanContext context) {
        OperatorContext operatorContext = context.getDriverContext().addOperatorContext(context.getNextOperatorId(), node.getPlanNodeId(), TableSortOperator.class.getSimpleName());
        List<TSDataType> dataTypes = this.getOutputColumnTypes(node, context.getTypeProvider());
        int sortItemsCount = node.getOrderingScheme().getOrderBy().size();
        ArrayList<Integer> sortItemIndexList = new ArrayList<Integer>(sortItemsCount);
        ArrayList<TSDataType> sortItemDataTypeList = new ArrayList<TSDataType>(sortItemsCount);
        this.genSortInformation(node.getOutputSymbols(), node.getOrderingScheme(), sortItemIndexList, sortItemDataTypeList, context.getTypeProvider());
        String filePrefix = IoTDBDescriptor.getInstance().getConfig().getSortTmpDir() + File.separator + operatorContext.getDriverContext().getFragmentInstanceContext().getId().getFullId() + File.separator + operatorContext.getDriverContext().getPipelineId() + File.separator;
        context.getDriverContext().setHaveTmpFile(true);
        context.getDriverContext().getFragmentInstanceContext().setMayHaveTmpFile(true);
        Operator child = node.getChild().accept(this, context);
        return new TableSortOperator(operatorContext, child, dataTypes, filePrefix, MergeSortComparator.getComparatorForTable(node.getOrderingScheme().getOrderingList(), sortItemIndexList, sortItemDataTypeList));
    }

    @Override
    public Operator visitTopK(TopKNode node, LocalExecutionPlanContext context) {
        OperatorContext operatorContext = context.getDriverContext().addOperatorContext(context.getNextOperatorId(), node.getPlanNodeId(), TableTopKOperator.class.getSimpleName());
        ArrayList<Operator> children = new ArrayList<Operator>(node.getChildren().size());
        for (PlanNode child : node.getChildren()) {
            children.add((Operator)this.process(child, context));
        }
        List<TSDataType> dataTypes = this.getOutputColumnTypes(node, context.getTypeProvider());
        int sortItemsCount = node.getOrderingScheme().getOrderBy().size();
        ArrayList<Integer> sortItemIndexList = new ArrayList<Integer>(sortItemsCount);
        ArrayList<TSDataType> sortItemDataTypeList = new ArrayList<TSDataType>(sortItemsCount);
        this.genSortInformation(node.getOutputSymbols(), node.getOrderingScheme(), sortItemIndexList, sortItemDataTypeList, context.getTypeProvider());
        return new TableTopKOperator(operatorContext, children, dataTypes, MergeSortComparator.getComparatorForTable(node.getOrderingScheme().getOrderingList(), sortItemIndexList, sortItemDataTypeList), (int)node.getCount(), node.isChildrenDataInOrder());
    }

    private List<TSDataType> getOutputColumnTypes(PlanNode node, TypeProvider typeProvider) {
        return node.getOutputSymbols().stream().map(s -> InternalTypeManager.getTSDataType(typeProvider.getTableModelType((Symbol)s))).collect(Collectors.toList());
    }

    private void genSortInformation(List<Symbol> outputSymbols, OrderingScheme orderingScheme, List<Integer> sortItemIndexList, List<TSDataType> sortItemDataTypeList, TypeProvider typeProvider) {
        HashMap<Symbol, Integer> columnIndex = new HashMap<Symbol, Integer>();
        int index = 0;
        for (Symbol symbol : outputSymbols) {
            columnIndex.put(symbol, index++);
        }
        orderingScheme.getOrderBy().forEach(sortItem -> {
            Integer i = (Integer)columnIndex.get(sortItem);
            if (i == null) {
                throw new IllegalStateException(String.format("Sort Item %s is not included in children's output columns", sortItem));
            }
            sortItemIndexList.add(i);
            sortItemDataTypeList.add(InternalTypeManager.getTSDataType(typeProvider.getTableModelType((Symbol)sortItem)));
        });
    }

    @Override
    public Operator visitStreamSort(StreamSortNode node, LocalExecutionPlanContext context) {
        OperatorContext operatorContext = context.getDriverContext().addOperatorContext(context.getNextOperatorId(), node.getPlanNodeId(), TableStreamSortOperator.class.getSimpleName());
        List<TSDataType> dataTypes = this.getOutputColumnTypes(node, context.getTypeProvider());
        int sortItemsCount = node.getOrderingScheme().getOrderBy().size();
        ArrayList<Integer> sortItemIndexList = new ArrayList<Integer>(sortItemsCount);
        ArrayList<TSDataType> sortItemDataTypeList = new ArrayList<TSDataType>(sortItemsCount);
        this.genSortInformation(node.getOutputSymbols(), node.getOrderingScheme(), sortItemIndexList, sortItemDataTypeList, context.getTypeProvider());
        String filePrefix = IoTDBDescriptor.getInstance().getConfig().getSortTmpDir() + File.separator + operatorContext.getDriverContext().getFragmentInstanceContext().getId().getFullId() + File.separator + operatorContext.getDriverContext().getPipelineId() + File.separator;
        context.getDriverContext().setHaveTmpFile(true);
        context.getDriverContext().getFragmentInstanceContext().setMayHaveTmpFile(true);
        Operator child = node.getChild().accept(this, context);
        return new TableStreamSortOperator(operatorContext, child, dataTypes, filePrefix, MergeSortComparator.getComparatorForTable(node.getOrderingScheme().getOrderingList(), sortItemIndexList, sortItemDataTypeList), MergeSortComparator.getComparatorForTable(node.getOrderingScheme().getOrderingList().subList(0, node.getStreamCompareKeyEndIndex() + 1), sortItemIndexList.subList(0, node.getStreamCompareKeyEndIndex() + 1), sortItemDataTypeList.subList(0, node.getStreamCompareKeyEndIndex() + 1)), TSFileDescriptor.getInstance().getConfig().getMaxTsBlockLineNumber());
    }

    @Override
    public Operator visitGroup(GroupNode node, LocalExecutionPlanContext context) {
        StreamSortNode streamSortNode = new StreamSortNode(node.getPlanNodeId(), node.getChild(), node.getOrderingScheme(), false, false, node.getPartitionKeyCount() - 1);
        return this.visitStreamSort(streamSortNode, context);
    }

    @Override
    public Operator visitJoin(JoinNode node, LocalExecutionPlanContext context) {
        List<TSDataType> dataTypes = this.getOutputColumnTypes(node, context.getTypeProvider());
        Operator leftChild = node.getLeftChild().accept(this, context);
        Operator rightChild = node.getRightChild().accept(this, context);
        ImmutableMap<Symbol, Integer> leftColumnNamesMap = this.makeLayoutFromOutputSymbols(node.getLeftChild().getOutputSymbols());
        int[] leftOutputSymbolIdx = new int[node.getLeftOutputSymbols().size()];
        for (int i = 0; i < leftOutputSymbolIdx.length; ++i) {
            Integer index = (Integer)leftColumnNamesMap.get((Object)node.getLeftOutputSymbols().get(i));
            if (index == null) {
                throw new IllegalStateException("Left child of JoinNode doesn't contain LeftOutputSymbol " + node.getLeftOutputSymbols().get(i));
            }
            leftOutputSymbolIdx[i] = index;
        }
        ImmutableMap<Symbol, Integer> rightColumnNamesMap = this.makeLayoutFromOutputSymbols(node.getRightChild().getOutputSymbols());
        int[] rightOutputSymbolIdx = new int[node.getRightOutputSymbols().size()];
        for (int i = 0; i < rightOutputSymbolIdx.length; ++i) {
            Integer index = (Integer)rightColumnNamesMap.get((Object)node.getRightOutputSymbols().get(i));
            if (index == null) {
                throw new IllegalStateException("Right child of JoinNode doesn't contain RightOutputSymbol " + node.getLeftOutputSymbols().get(i));
            }
            rightOutputSymbolIdx[i] = index;
        }
        if (node.isCrossJoin()) {
            OperatorContext operatorContext = context.getDriverContext().addOperatorContext(context.getNextOperatorId(), node.getPlanNodeId(), SimpleNestedLoopCrossJoinOperator.class.getSimpleName());
            return new SimpleNestedLoopCrossJoinOperator(operatorContext, leftChild, rightChild, leftOutputSymbolIdx, rightOutputSymbolIdx, dataTypes);
        }
        this.semanticCheckForJoin(node);
        JoinNode.AsofJoinClause asofJoinClause = node.getAsofCriteria().orElse(null);
        int equiSize = node.getCriteria().size();
        int size = equiSize + (asofJoinClause == null ? 0 : 1);
        int[] leftJoinKeyPositions = new int[size];
        for (int i = 0; i < equiSize; ++i) {
            Integer leftJoinKeyPosition = (Integer)leftColumnNamesMap.get((Object)node.getCriteria().get(i).getLeft());
            if (leftJoinKeyPosition == null) {
                throw new IllegalStateException("Left child of JoinNode doesn't contain left join key.");
            }
            leftJoinKeyPositions[i] = leftJoinKeyPosition;
        }
        ArrayList<Type> joinKeyTypes = new ArrayList<Type>(size);
        int[] rightJoinKeyPositions = new int[size];
        for (int i = 0; i < equiSize; ++i) {
            Integer rightJoinKeyPosition = (Integer)rightColumnNamesMap.get((Object)node.getCriteria().get(i).getRight());
            if (rightJoinKeyPosition == null) {
                throw new IllegalStateException("Right child of JoinNode doesn't contain right join key.");
            }
            rightJoinKeyPositions[i] = rightJoinKeyPosition;
            Type leftJoinKeyType = context.getTypeProvider().getTableModelType(node.getCriteria().get(i).getLeft());
            this.checkIfJoinKeyTypeMatches(leftJoinKeyType, context.getTypeProvider().getTableModelType(node.getCriteria().get(i).getRight()));
            joinKeyTypes.add(leftJoinKeyType);
        }
        if (asofJoinClause != null) {
            Integer leftAsofJoinKeyPosition = (Integer)leftColumnNamesMap.get((Object)asofJoinClause.getLeft());
            if (leftAsofJoinKeyPosition == null) {
                throw new IllegalStateException("Left child of JoinNode doesn't contain left ASOF main join key.");
            }
            leftJoinKeyPositions[equiSize] = leftAsofJoinKeyPosition;
            Integer rightAsofJoinKeyPosition = (Integer)rightColumnNamesMap.get((Object)asofJoinClause.getRight());
            if (rightAsofJoinKeyPosition == null) {
                throw new IllegalStateException("Right child of JoinNode doesn't contain right ASOF main join key.");
            }
            rightJoinKeyPositions[equiSize] = rightAsofJoinKeyPosition;
            if (context.getTypeProvider().getTableModelType(asofJoinClause.getLeft()) != TimestampType.TIMESTAMP) {
                throw new IllegalStateException("Type of left ASOF Join key is not TIMESTAMP");
            }
            if (context.getTypeProvider().getTableModelType(asofJoinClause.getRight()) != TimestampType.TIMESTAMP) {
                throw new IllegalStateException("Type of right ASOF Join key is not TIMESTAMP");
            }
            ComparisonExpression.Operator asofOperator = asofJoinClause.getOperator();
            if (Objects.requireNonNull(node.getJoinType()) == JoinNode.JoinType.INNER) {
                OperatorContext operatorContext = context.getDriverContext().addOperatorContext(context.getNextOperatorId(), node.getPlanNodeId(), AsofMergeSortInnerJoinOperator.class.getSimpleName());
                return new AsofMergeSortInnerJoinOperator(operatorContext, leftChild, leftJoinKeyPositions, leftOutputSymbolIdx, rightChild, rightJoinKeyPositions, rightOutputSymbolIdx, JoinKeyComparatorFactory.getAsofComparators(joinKeyTypes, asofOperator == ComparisonExpression.Operator.LESS_THAN_OR_EQUAL || asofOperator == ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, !asofJoinClause.isOperatorContainsGreater()), dataTypes);
            }
            throw new IllegalStateException("Unsupported ASOF join type: " + (Object)((Object)node.getJoinType()));
        }
        if (Objects.requireNonNull(node.getJoinType()) == JoinNode.JoinType.INNER) {
            OperatorContext operatorContext = context.getDriverContext().addOperatorContext(context.getNextOperatorId(), node.getPlanNodeId(), MergeSortInnerJoinOperator.class.getSimpleName());
            return new MergeSortInnerJoinOperator(operatorContext, leftChild, leftJoinKeyPositions, leftOutputSymbolIdx, rightChild, rightJoinKeyPositions, rightOutputSymbolIdx, JoinKeyComparatorFactory.getComparators(joinKeyTypes, true), dataTypes);
        }
        if (Objects.requireNonNull(node.getJoinType()) == JoinNode.JoinType.FULL) {
            OperatorContext operatorContext = context.getDriverContext().addOperatorContext(context.getNextOperatorId(), node.getPlanNodeId(), MergeSortFullOuterJoinOperator.class.getSimpleName());
            return new MergeSortFullOuterJoinOperator(operatorContext, leftChild, leftJoinKeyPositions, leftOutputSymbolIdx, rightChild, rightJoinKeyPositions, rightOutputSymbolIdx, JoinKeyComparatorFactory.getComparators(joinKeyTypes, true), dataTypes, joinKeyTypes.stream().map(this::buildUpdateLastRowFunction).collect(Collectors.toList()));
        }
        if (Objects.requireNonNull(node.getJoinType()) == JoinNode.JoinType.LEFT) {
            OperatorContext operatorContext = context.getDriverContext().addOperatorContext(context.getNextOperatorId(), node.getPlanNodeId(), MergeSortLeftJoinOperator.class.getSimpleName());
            return new MergeSortLeftJoinOperator(operatorContext, leftChild, leftJoinKeyPositions, leftOutputSymbolIdx, rightChild, rightJoinKeyPositions, rightOutputSymbolIdx, JoinKeyComparatorFactory.getComparators(joinKeyTypes, true), dataTypes);
        }
        throw new IllegalStateException("Unsupported join type: " + (Object)((Object)node.getJoinType()));
    }

    private void semanticCheckForJoin(JoinNode node) {
        try {
            Preconditions.checkArgument((!node.getFilter().isPresent() || node.getFilter().get().equals(BooleanLiteral.TRUE_LITERAL) ? 1 : 0) != 0, (Object)String.format("Filter is not supported in %s. Filter is %s.", new Object[]{node.getJoinType(), node.getFilter().map(Expression::toString).orElse("null")}));
            Preconditions.checkArgument((!node.getCriteria().isEmpty() || node.getAsofCriteria().isPresent() ? 1 : 0) != 0, (Object)String.format("%s must have join keys.", new Object[]{node.getJoinType()}));
        }
        catch (IllegalArgumentException e) {
            throw new SemanticException(e.getMessage());
        }
    }

    private BiFunction<Column, Integer, Column> buildUpdateLastRowFunction(Type joinKeyType) {
        switch (joinKeyType.getTypeEnum()) {
            case INT32: 
            case DATE: {
                return (inputColumn, rowIndex) -> new IntColumn(1, Optional.empty(), new int[]{inputColumn.getInt(rowIndex.intValue())});
            }
            case INT64: 
            case TIMESTAMP: {
                return (inputColumn, rowIndex) -> new LongColumn(1, Optional.empty(), new long[]{inputColumn.getLong(rowIndex.intValue())});
            }
            case FLOAT: {
                return (inputColumn, rowIndex) -> new FloatColumn(1, Optional.empty(), new float[]{inputColumn.getFloat(rowIndex.intValue())});
            }
            case DOUBLE: {
                return (inputColumn, rowIndex) -> new DoubleColumn(1, Optional.empty(), new double[]{inputColumn.getDouble(rowIndex.intValue())});
            }
            case BOOLEAN: {
                return (inputColumn, rowIndex) -> new BooleanColumn(1, Optional.empty(), new boolean[]{inputColumn.getBoolean(rowIndex.intValue())});
            }
            case STRING: 
            case TEXT: 
            case BLOB: {
                return (inputColumn, rowIndex) -> new BinaryColumn(1, Optional.empty(), new Binary[]{inputColumn.getBinary(rowIndex.intValue())});
            }
        }
        throw new UnsupportedOperationException("Unsupported data type: " + joinKeyType);
    }

    @Override
    public Operator visitSemiJoin(SemiJoinNode node, LocalExecutionPlanContext context) {
        List<TSDataType> dataTypes = this.getOutputColumnTypes(node, context.getTypeProvider());
        Operator leftChild = node.getLeftChild().accept(this, context);
        Operator rightChild = node.getRightChild().accept(this, context);
        ImmutableMap<Symbol, Integer> sourceColumnNamesMap = this.makeLayoutFromOutputSymbols(node.getSource().getOutputSymbols());
        List<Symbol> sourceOutputSymbols = node.getSource().getOutputSymbols();
        int[] sourceOutputSymbolIdx = new int[node.getSource().getOutputSymbols().size()];
        for (int i = 0; i < sourceOutputSymbolIdx.length; ++i) {
            Integer index = (Integer)sourceColumnNamesMap.get((Object)sourceOutputSymbols.get(i));
            Preconditions.checkNotNull((Object)index, (Object)"Source of SemiJoinNode doesn't contain sourceOutputSymbol.");
            sourceOutputSymbolIdx[i] = index;
        }
        ImmutableMap<Symbol, Integer> filteringSourceColumnNamesMap = this.makeLayoutFromOutputSymbols(node.getRightChild().getOutputSymbols());
        Integer sourceJoinKeyPosition = (Integer)sourceColumnNamesMap.get((Object)node.getSourceJoinSymbol());
        Preconditions.checkNotNull((Object)sourceJoinKeyPosition, (Object)"Source of SemiJoinNode doesn't contain sourceJoinSymbol.");
        Integer filteringSourceJoinKeyPosition = (Integer)filteringSourceColumnNamesMap.get((Object)node.getFilteringSourceJoinSymbol());
        Preconditions.checkNotNull((Object)filteringSourceJoinKeyPosition, (Object)"FilteringSource of SemiJoinNode doesn't contain filteringSourceJoinSymbol.");
        Type sourceJoinKeyType = context.getTypeProvider().getTableModelType(node.getSourceJoinSymbol());
        this.checkIfJoinKeyTypeMatches(sourceJoinKeyType, context.getTypeProvider().getTableModelType(node.getFilteringSourceJoinSymbol()));
        OperatorContext operatorContext = context.getDriverContext().addOperatorContext(context.getNextOperatorId(), node.getPlanNodeId(), MergeSortSemiJoinOperator.class.getSimpleName());
        return new MergeSortSemiJoinOperator(operatorContext, leftChild, sourceJoinKeyPosition, sourceOutputSymbolIdx, rightChild, filteringSourceJoinKeyPosition, JoinKeyComparatorFactory.getComparator(sourceJoinKeyType, true), dataTypes);
    }

    private void checkIfJoinKeyTypeMatches(Type leftJoinKeyType, Type rightJoinKeyType) {
        if (leftJoinKeyType != rightJoinKeyType) {
            throw new SemanticException("Join key type mismatch. Left join key type: " + leftJoinKeyType + ", right join key type: " + rightJoinKeyType);
        }
    }

    @Override
    public Operator visitEnforceSingleRow(EnforceSingleRowNode node, LocalExecutionPlanContext context) {
        Operator child = node.getChild().accept(this, context);
        OperatorContext operatorContext = context.getDriverContext().addOperatorContext(context.getNextOperatorId(), node.getPlanNodeId(), EnforceSingleRowOperator.class.getSimpleName());
        return new EnforceSingleRowOperator(operatorContext, child);
    }

    @Override
    public Operator visitAssignUniqueId(AssignUniqueId node, LocalExecutionPlanContext context) {
        Operator child = node.getChild().accept(this, context);
        OperatorContext operatorContext = context.getDriverContext().addOperatorContext(context.getNextOperatorId(), node.getPlanNodeId(), EnforceSingleRowOperator.class.getSimpleName());
        return new AssignUniqueIdOperator(operatorContext, child);
    }

    @Override
    public Operator visitCountMerge(CountSchemaMergeNode node, LocalExecutionPlanContext context) {
        OperatorContext operatorContext = context.getDriverContext().addOperatorContext(context.getNextOperatorId(), node.getPlanNodeId(), CountMergeOperator.class.getSimpleName());
        ArrayList<Operator> children = new ArrayList<Operator>(node.getChildren().size());
        for (PlanNode child : node.getChildren()) {
            children.add((Operator)this.process(child, context));
        }
        return new CountMergeOperator(operatorContext, children);
    }

    @Override
    public Operator visitTableDeviceFetch(TableDeviceFetchNode node, LocalExecutionPlanContext context) {
        OperatorContext operatorContext = context.getDriverContext().addOperatorContext(context.getNextOperatorId(), node.getPlanNodeId(), SchemaQueryScanOperator.class.getSimpleName());
        return new SchemaQueryScanOperator<IDeviceSchemaInfo>(node.getPlanNodeId(), operatorContext, SchemaSourceFactory.getTableDeviceFetchSource(node.getDatabase(), node.getTableName(), node.getDeviceIdList(), node.getColumnHeaderList()));
    }

    @Override
    public Operator visitTableDeviceQueryScan(TableDeviceQueryScanNode node, LocalExecutionPlanContext context) {
        TsTable table = DataNodeTableCache.getInstance().getTable(node.getDatabase(), node.getTableName());
        SchemaQueryScanOperator<IDeviceSchemaInfo> operator = new SchemaQueryScanOperator<IDeviceSchemaInfo>(node.getPlanNodeId(), context.getDriverContext().addOperatorContext(context.getNextOperatorId(), node.getPlanNodeId(), SchemaQueryScanOperator.class.getSimpleName()), SchemaSourceFactory.getTableDeviceQuerySource(node.getDatabase(), node.getTableName(), node.getIdDeterminedFilterList(), node.getColumnHeaderList(), node.getColumnHeaderList().stream().map(columnHeader -> table.getColumnSchema(columnHeader.getColumnName())).collect(Collectors.toList()), null));
        operator.setLimit(node.getLimit());
        return operator;
    }

    @Override
    public Operator visitTableDeviceQueryCount(TableDeviceQueryCountNode node, LocalExecutionPlanContext context) {
        String database = node.getDatabase();
        TsTable table = DataNodeTableCache.getInstance().getTable(database, node.getTableName());
        List<TsTableColumnSchema> columnSchemaList = node.getColumnHeaderList().stream().map(columnHeader -> table.getColumnSchema(columnHeader.getColumnName())).collect(Collectors.toList());
        ArrayList<LeafColumnTransformer> filterLeafColumnTransformerList = new ArrayList<LeafColumnTransformer>();
        return new SchemaCountOperator<IDeviceSchemaInfo>(node.getPlanNodeId(), context.getDriverContext().addOperatorContext(context.getNextOperatorId(), node.getPlanNodeId(), SchemaCountOperator.class.getSimpleName()), SchemaSourceFactory.getTableDeviceQuerySource(database, node.getTableName(), node.getIdDeterminedFilterList(), node.getColumnHeaderList(), columnSchemaList, Objects.nonNull(node.getIdFuzzyPredicate()) ? new DevicePredicateFilter(filterLeafColumnTransformerList, (ColumnTransformer)new ColumnTransformerBuilder().process(node.getIdFuzzyPredicate(), new ColumnTransformerBuilder.Context(context.getDriverContext().getFragmentInstanceContext().getSessionInfo(), filterLeafColumnTransformerList, TableOperatorGenerator.makeLayout(Collections.singletonList(node)), new HashMap<Expression, ColumnTransformer>(), (Map<Expression, ColumnTransformer>)ImmutableMap.of(), (List<ColumnTransformer>)ImmutableList.of(), (List<TSDataType>)ImmutableList.of(), 0, context.getTypeProvider(), this.metadata)), columnSchemaList) : null));
    }

    @Override
    public Operator visitAggregation(AggregationNode node, LocalExecutionPlanContext context) {
        Operator child = node.getChild().accept(this, context);
        if (node.getGroupingKeys().isEmpty()) {
            return this.planGlobalAggregation(node, child, context.getTypeProvider(), context);
        }
        return this.planGroupByAggregation(node, child, context.getTypeProvider(), context);
    }

    private Operator planGlobalAggregation(AggregationNode node, Operator child, TypeProvider typeProvider, LocalExecutionPlanContext context) {
        OperatorContext operatorContext = context.getDriverContext().addOperatorContext(context.getNextOperatorId(), node.getPlanNodeId(), AggregationOperator.class.getSimpleName());
        Map<Symbol, AggregationNode.Aggregation> aggregationMap = node.getAggregations();
        ImmutableList.Builder aggregatorBuilder = new ImmutableList.Builder();
        ImmutableMap<Symbol, Integer> childLayout = this.makeLayoutFromOutputSymbols(node.getChild().getOutputSymbols());
        node.getOutputSymbols().forEach(symbol -> aggregatorBuilder.add((Object)this.buildAggregator((Map<Symbol, Integer>)childLayout, (Symbol)symbol, (AggregationNode.Aggregation)aggregationMap.get(symbol), node.getStep(), typeProvider, true, null)));
        return new AggregationOperator(operatorContext, child, (List<TableAggregator>)aggregatorBuilder.build());
    }

    private TableAggregator buildAggregator(Map<Symbol, Integer> childLayout, Symbol symbol, AggregationNode.Aggregation aggregation, AggregationNode.Step step, TypeProvider typeProvider, boolean scanAscending, String timeColumnName) {
        ArrayList<Integer> argumentChannels = new ArrayList<Integer>();
        for (Expression argument : aggregation.getArguments()) {
            Symbol argumentSymbol = Symbol.from(argument);
            argumentChannels.add(childLayout.get(argumentSymbol));
        }
        String functionName = aggregation.getResolvedFunction().getSignature().getName();
        List<TSDataType> originalArgumentTypes = aggregation.getResolvedFunction().getSignature().getArgumentTypes().stream().map(InternalTypeManager::getTSDataType).collect(Collectors.toList());
        TableAccumulator accumulator = AccumulatorFactory.createAccumulator(functionName, TableBuiltinAggregationFunction.getAggregationTypeByFuncName((String)functionName), originalArgumentTypes, aggregation.getArguments(), Collections.emptyMap(), scanAscending, timeColumnName, aggregation.isDistinct());
        OptionalInt maskChannel = OptionalInt.empty();
        if (aggregation.hasMask()) {
            maskChannel = OptionalInt.of(childLayout.get(aggregation.getMask().get()));
        }
        return new TableAggregator(accumulator, step, InternalTypeManager.getTSDataType(typeProvider.getTableModelType(symbol)), argumentChannels, maskChannel);
    }

    private Operator planGroupByAggregation(AggregationNode node, Operator child, TypeProvider typeProvider, LocalExecutionPlanContext context) {
        ImmutableMap<Symbol, Integer> childLayout = this.makeLayoutFromOutputSymbols(node.getChild().getOutputSymbols());
        List<Integer> groupByChannels = TableOperatorGenerator.getChannelsForSymbols(node.getGroupingKeys(), childLayout);
        List groupByTypes = (List)node.getGroupingKeys().stream().map(typeProvider::getTableModelType).collect(ImmutableList.toImmutableList());
        if (node.isStreamable()) {
            if (groupByTypes.size() == node.getPreGroupedSymbols().size()) {
                ImmutableList.Builder aggregatorBuilder = new ImmutableList.Builder();
                node.getAggregations().forEach((k, v) -> aggregatorBuilder.add((Object)this.buildAggregator((Map<Symbol, Integer>)childLayout, (Symbol)k, (AggregationNode.Aggregation)v, node.getStep(), typeProvider, true, null)));
                OperatorContext operatorContext = context.getDriverContext().addOperatorContext(context.getNextOperatorId(), node.getPlanNodeId(), StreamingAggregationOperator.class.getSimpleName());
                return new StreamingAggregationOperator(operatorContext, child, groupByTypes, groupByChannels, this.genGroupKeyComparator(groupByTypes, groupByChannels), (List<TableAggregator>)aggregatorBuilder.build(), Long.MAX_VALUE, false, Long.MAX_VALUE);
            }
            ImmutableList.Builder aggregatorBuilder = new ImmutableList.Builder();
            node.getAggregations().forEach((k, v) -> aggregatorBuilder.add((Object)this.buildGroupByAggregator((Map<Symbol, Integer>)childLayout, (Symbol)k, (AggregationNode.Aggregation)v, node.getStep(), typeProvider)));
            ImmutableSet preGroupedKeys = ImmutableSet.copyOf(node.getPreGroupedSymbols());
            List<Symbol> groupingKeys = node.getGroupingKeys();
            ImmutableList.Builder preGroupedTypesBuilder = new ImmutableList.Builder();
            ImmutableList.Builder preGroupedChannelsBuilder = new ImmutableList.Builder();
            ImmutableList.Builder preGroupedIndexInResultBuilder = new ImmutableList.Builder();
            ImmutableList.Builder unPreGroupedTypesBuilder = new ImmutableList.Builder();
            ImmutableList.Builder unPreGroupedChannelsBuilder = new ImmutableList.Builder();
            ImmutableList.Builder unPreGroupedIndexInResultBuilder = new ImmutableList.Builder();
            for (int i = 0; i < groupByTypes.size(); ++i) {
                if (preGroupedKeys.contains(groupingKeys.get(i))) {
                    preGroupedTypesBuilder.add((Object)((Type)groupByTypes.get(i)));
                    preGroupedChannelsBuilder.add((Object)groupByChannels.get(i));
                    preGroupedIndexInResultBuilder.add((Object)i);
                    continue;
                }
                unPreGroupedTypesBuilder.add((Object)((Type)groupByTypes.get(i)));
                unPreGroupedChannelsBuilder.add((Object)groupByChannels.get(i));
                unPreGroupedIndexInResultBuilder.add((Object)i);
            }
            ImmutableList preGroupedChannels = preGroupedChannelsBuilder.build();
            OperatorContext operatorContext = context.getDriverContext().addOperatorContext(context.getNextOperatorId(), node.getPlanNodeId(), StreamingHashAggregationOperator.class.getSimpleName());
            return new StreamingHashAggregationOperator(operatorContext, child, (List<Integer>)preGroupedChannels, (List<Integer>)preGroupedIndexInResultBuilder.build(), (List<Type>)unPreGroupedTypesBuilder.build(), (List<Integer>)unPreGroupedChannelsBuilder.build(), (List<Integer>)unPreGroupedIndexInResultBuilder.build(), this.genGroupKeyComparator((List<Type>)preGroupedTypesBuilder.build(), (List<Integer>)preGroupedChannels), (List<GroupedAggregator>)aggregatorBuilder.build(), node.getStep(), 64, Long.MAX_VALUE, false, Long.MAX_VALUE);
        }
        ImmutableList.Builder aggregatorBuilder = new ImmutableList.Builder();
        node.getAggregations().forEach((k, v) -> aggregatorBuilder.add((Object)this.buildGroupByAggregator((Map<Symbol, Integer>)childLayout, (Symbol)k, (AggregationNode.Aggregation)v, node.getStep(), typeProvider)));
        OperatorContext operatorContext = context.getDriverContext().addOperatorContext(context.getNextOperatorId(), node.getPlanNodeId(), HashAggregationOperator.class.getSimpleName());
        return new HashAggregationOperator(operatorContext, child, groupByTypes, groupByChannels, (List<GroupedAggregator>)aggregatorBuilder.build(), node.getStep(), 64, Long.MAX_VALUE, false, Long.MAX_VALUE);
    }

    private Comparator<SortKey> genGroupKeyComparator(List<Type> groupTypes, List<Integer> groupByChannels) {
        return MergeSortComparator.getComparatorForTable(groupTypes.stream().map(k -> SortOrder.ASC_NULLS_LAST).collect(Collectors.toList()), groupByChannels, groupTypes.stream().map(InternalTypeManager::getTSDataType).collect(Collectors.toList()));
    }

    private static List<Integer> getChannelsForSymbols(List<Symbol> symbols, Map<Symbol, Integer> layout) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Symbol symbol : symbols) {
            builder.add((Object)layout.get(symbol));
        }
        return builder.build();
    }

    private GroupedAggregator buildGroupByAggregator(Map<Symbol, Integer> childLayout, Symbol symbol, AggregationNode.Aggregation aggregation, AggregationNode.Step step, TypeProvider typeProvider) {
        ArrayList<Integer> argumentChannels = new ArrayList<Integer>();
        for (Expression argument : aggregation.getArguments()) {
            Symbol argumentSymbol = Symbol.from(argument);
            argumentChannels.add(childLayout.get(argumentSymbol));
        }
        String functionName = aggregation.getResolvedFunction().getSignature().getName();
        List<TSDataType> originalArgumentTypes = aggregation.getResolvedFunction().getSignature().getArgumentTypes().stream().map(InternalTypeManager::getTSDataType).collect(Collectors.toList());
        GroupedAccumulator accumulator = AccumulatorFactory.createGroupedAccumulator(functionName, TableBuiltinAggregationFunction.getAggregationTypeByFuncName((String)functionName), originalArgumentTypes, Collections.emptyList(), Collections.emptyMap(), true, aggregation.isDistinct());
        OptionalInt maskChannel = OptionalInt.empty();
        if (aggregation.hasMask()) {
            maskChannel = OptionalInt.of(childLayout.get(aggregation.getMask().get()));
        }
        return new GroupedAggregator(accumulator, step, InternalTypeManager.getTSDataType(typeProvider.getTableModelType(symbol)), argumentChannels, maskChannel);
    }

    @Override
    public Operator visitAggregationTreeDeviceViewScan(AggregationTreeDeviceViewScanNode node, LocalExecutionPlanContext context) {
        IDeviceID.TreeDeviceIdColumnValueExtractor idColumnValueExtractor = TableOperatorGenerator.createTreeDeviceIdColumnValueExtractor(node.getTreeDBName());
        AbstractAggTableScanOperator.AbstractAggTableScanOperatorParameter parameter = this.constructAbstractAggTableScanOperatorParameter(node, context, TreeAlignedDeviceViewAggregationScanOperator.class.getSimpleName(), node.getMeasurementColumnNameMap());
        TreeAlignedDeviceViewAggregationScanOperator treeAlignedDeviceViewAggregationScanOperator = new TreeAlignedDeviceViewAggregationScanOperator(parameter, idColumnValueExtractor);
        this.addSource(treeAlignedDeviceViewAggregationScanOperator, context, node, parameter.getMeasurementColumnNames(), parameter.getMeasurementSchemas(), parameter.getAllSensors(), AggregationTreeDeviceViewScanNode.class.getSimpleName());
        return treeAlignedDeviceViewAggregationScanOperator;
    }

    /*
     * WARNING - void declaration
     */
    private AbstractAggTableScanOperator.AbstractAggTableScanOperatorParameter constructAbstractAggTableScanOperatorParameter(AggregationTableScanNode node, LocalExecutionPlanContext context, String className, Map<String, String> fieldColumnsRenameMap) {
        void var20_31;
        void var21_37;
        void var20_27;
        ArrayList<String> measurementColumnNames = new ArrayList<String>();
        ArrayList<IMeasurementSchema> measurementSchemas = new ArrayList<IMeasurementSchema>();
        HashMap<String, Integer> measurementColumnsIndexMap = new HashMap<String, Integer>();
        ArrayList<TableAggregator> aggregators = new ArrayList<TableAggregator>(node.getAggregations().size());
        ArrayList<Integer> aggregatorInputChannels = new ArrayList<Integer>((int)node.getAggregations().values().stream().mapToLong(aggregation -> aggregation.getArguments().size()).sum());
        int aggDistinctArgumentCount = (int)node.getAggregations().values().stream().flatMap(aggregation -> aggregation.getArguments().stream()).map(Symbol::from).distinct().count();
        ArrayList<ColumnSchema> aggColumnSchemas = new ArrayList<ColumnSchema>(aggDistinctArgumentCount);
        HashMap<Symbol, Integer> aggColumnLayout = new HashMap<Symbol, Integer>(aggDistinctArgumentCount);
        int[] aggColumnsIndexArray = new int[aggDistinctArgumentCount];
        String timeColumnName = null;
        int channel = 0;
        int measurementColumnCount = 0;
        for (Map.Entry<Symbol, AggregationNode.Aggregation> entry : node.getAggregations().entrySet()) {
            for (Expression expression : entry.getValue().getArguments()) {
                Symbol symbol = Symbol.from(expression);
                ColumnSchema schema = Objects.requireNonNull(node.getAssignments().get(symbol), symbol + " is null");
                if (!aggColumnLayout.containsKey(symbol)) {
                    switch (schema.getColumnCategory()) {
                        case TAG: 
                        case ATTRIBUTE: {
                            aggColumnsIndexArray[channel] = Objects.requireNonNull(node.getIdAndAttributeIndexMap().get(symbol), symbol + " is null");
                            break;
                        }
                        case FIELD: {
                            aggColumnsIndexArray[channel] = measurementColumnCount++;
                            String realMeasurementName = fieldColumnsRenameMap.getOrDefault(schema.getName(), schema.getName());
                            measurementColumnNames.add(realMeasurementName);
                            measurementSchemas.add((IMeasurementSchema)new MeasurementSchema(realMeasurementName, InternalTypeManager.getTSDataType(schema.getType())));
                            measurementColumnsIndexMap.put(symbol.getName(), measurementColumnCount - 1);
                            break;
                        }
                        case TIME: {
                            aggColumnsIndexArray[channel] = -1;
                            timeColumnName = symbol.getName();
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unexpected column category: " + schema.getColumnCategory());
                        }
                    }
                    aggColumnSchemas.add(schema);
                    aggregatorInputChannels.add(channel);
                    aggColumnLayout.put(symbol, channel++);
                    continue;
                }
                aggregatorInputChannels.add((Integer)aggColumnLayout.get(symbol));
            }
        }
        for (Map.Entry<Symbol, Object> entry : node.getAssignments().entrySet()) {
            if (!aggColumnLayout.containsKey(entry.getKey()) && ((ColumnSchema)entry.getValue()).getColumnCategory() == TsTableColumnCategory.FIELD) {
                ++measurementColumnCount;
                String realMeasurementName = fieldColumnsRenameMap.getOrDefault(((ColumnSchema)entry.getValue()).getName(), ((ColumnSchema)entry.getValue()).getName());
                measurementColumnNames.add(realMeasurementName);
                measurementSchemas.add((IMeasurementSchema)new MeasurementSchema(realMeasurementName, InternalTypeManager.getTSDataType(((ColumnSchema)entry.getValue()).getType())));
                measurementColumnsIndexMap.put(entry.getKey().getName(), measurementColumnCount - 1);
                continue;
            }
            if (((ColumnSchema)entry.getValue()).getColumnCategory() != TsTableColumnCategory.TIME) continue;
            timeColumnName = entry.getKey().getName();
        }
        boolean[] ret = this.checkStatisticAndScanOrder(node, timeColumnName);
        boolean bl = ret[0];
        boolean scanAscending = ret[1];
        for (Map.Entry<Symbol, AggregationNode.Aggregation> entry : node.getAggregations().entrySet()) {
            aggregators.add(this.buildAggregator(aggColumnLayout, entry.getKey(), entry.getValue(), node.getStep(), context.getTypeProvider(), scanAscending, timeColumnName));
        }
        Object var20_26 = null;
        Object var21_35 = null;
        int[] groupingKeyIndex = null;
        if (!node.getGroupingKeys().isEmpty()) {
            ArrayList<ColumnSchema> arrayList = new ArrayList<ColumnSchema>(node.getGroupingKeys().size());
            groupingKeyIndex = new int[node.getGroupingKeys().size()];
            for (int i = 0; i < node.getGroupingKeys().size(); ++i) {
                Symbol groupingKey = node.getGroupingKeys().get(i);
                if (node.getIdAndAttributeIndexMap().containsKey(groupingKey)) {
                    arrayList.add(node.getAssignments().get(groupingKey));
                    groupingKeyIndex[i] = node.getIdAndAttributeIndexMap().get(groupingKey);
                    continue;
                }
                if (node.getProjection() != null && !node.getProjection().getMap().isEmpty() && node.getProjection().contains(groupingKey)) {
                    FunctionCall dateBinFunc = (FunctionCall)node.getProjection().get(groupingKey);
                    List<Expression> arguments = dateBinFunc.getArguments();
                    DateBinFunctionColumnTransformer dateBinTransformer = new DateBinFunctionColumnTransformer((Type)TimestampType.TIMESTAMP, ((LongLiteral)arguments.get(0)).getParsedValue(), ((LongLiteral)arguments.get(1)).getParsedValue(), null, ((LongLiteral)arguments.get(3)).getParsedValue(), context.getZoneId());
                    TableDateBinTimeRangeIterator tableDateBinTimeRangeIterator = new TableDateBinTimeRangeIterator(dateBinTransformer);
                    continue;
                }
                throw new IllegalStateException("grouping key must be ID or Attribute in AggregationTableScan");
            }
        }
        if (var20_27 == null) {
            if (node.getGroupingKeys().isEmpty()) {
                TableSingleTimeWindowIterator tableSingleTimeWindowIterator = new TableSingleTimeWindowIterator(new TimeRange(Long.MIN_VALUE, Long.MAX_VALUE));
            } else {
                TableSingleTimeWindowIterator tableSingleTimeWindowIterator = new TableSingleTimeWindowIterator();
            }
        }
        OperatorContext operatorContext = context.getDriverContext().addOperatorContext(context.getNextOperatorId(), node.getPlanNodeId(), className);
        SeriesScanOptions seriesScanOptions = this.buildSeriesScanOptions(context, node.getAssignments(), measurementColumnNames, measurementColumnsIndexMap, timeColumnName, node.getTimePredicate(), node.getPushDownLimit(), node.getPushDownOffset(), node.isPushLimitToEachDevice(), node.getPushDownPredicate());
        HashSet<String> allSensors = new HashSet<String>(measurementColumnNames);
        allSensors.add("");
        context.getDriverContext().setInputDriver(true);
        return new AbstractAggTableScanOperator.AbstractAggTableScanOperatorParameter(node.getPlanNodeId(), operatorContext, aggColumnSchemas, aggColumnsIndexArray, node.getDeviceEntries(), node.getDeviceEntries().size(), seriesScanOptions, measurementColumnNames, allSensors, measurementSchemas, aggregators, (List<ColumnSchema>)var21_37, groupingKeyIndex, (ITableTimeRangeIterator)var20_31, scanAscending, bl, aggregatorInputChannels, timeColumnName);
    }

    private AbstractAggTableScanOperator.AbstractAggTableScanOperatorParameter constructAbstractAggTableScanOperatorParameter(AggregationTableScanNode node, LocalExecutionPlanContext context) {
        return this.constructAbstractAggTableScanOperatorParameter(node, context, AbstractAggTableScanOperator.class.getSimpleName(), Collections.emptyMap());
    }

    @Override
    public Operator visitAggregationTableScan(AggregationTableScanNode node, LocalExecutionPlanContext context) {
        AbstractAggTableScanOperator.AbstractAggTableScanOperatorParameter parameter = this.constructAbstractAggTableScanOperatorParameter(node, context);
        if (this.canUseLastCacheOptimize(parameter.getTableAggregators(), node, parameter.getTimeColumnName())) {
            return this.constructLastQueryAggTableScanOperator(node, parameter, context);
        }
        DefaultAggTableScanOperator aggTableScanOperator = new DefaultAggTableScanOperator(parameter);
        this.addSource(aggTableScanOperator, context, node, parameter.getMeasurementColumnNames(), parameter.getMeasurementSchemas(), parameter.getAllSensors(), AggregationTableScanNode.class.getSimpleName());
        return aggTableScanOperator;
    }

    private LastQueryAggTableScanOperator constructLastQueryAggTableScanOperator(AggregationTableScanNode node, AbstractAggTableScanOperator.AbstractAggTableScanOperatorParameter parameter, LocalExecutionPlanContext context) {
        ArrayList<Integer> hitCachesIndexes = new ArrayList<Integer>();
        ArrayList<Pair<OptionalLong, TsPrimitiveType[]>> hitCachedResults = new ArrayList<Pair<OptionalLong, TsPrimitiveType[]>>();
        ArrayList<DeviceEntry> cachedDeviceEntries = new ArrayList<DeviceEntry>();
        ArrayList<DeviceEntry> unCachedDeviceEntries = new ArrayList<DeviceEntry>();
        long tableTTL = DataNodeTTLCache.getInstance().getTTLForTable(node.getQualifiedObjectName().getDatabaseName(), node.getQualifiedObjectName().getObjectName());
        Filter updateTimeFilter = SeriesScanOptions.updateFilterUsingTTL(parameter.getSeriesScanOptions().getGlobalTimeFilter(), tableTTL);
        for (int i = 0; i < node.getDeviceEntries().size(); ++i) {
            Optional<Pair<OptionalLong, TsPrimitiveType[]>> lastByResult = TableDeviceSchemaCache.getInstance().getLastRow(node.getQualifiedObjectName().getDatabaseName(), node.getDeviceEntries().get(i).getDeviceID(), "", parameter.getMeasurementColumnNames());
            boolean allHitCache = true;
            if (lastByResult.isPresent() && ((OptionalLong)lastByResult.get().getLeft()).isPresent()) {
                for (int j = 0; j < ((TsPrimitiveType[])lastByResult.get().getRight()).length; ++j) {
                    TsPrimitiveType tsPrimitiveType = ((TsPrimitiveType[])lastByResult.get().getRight())[j];
                    if (tsPrimitiveType != null && tsPrimitiveType != TableDeviceLastCache.EMPTY_PRIMITIVE_TYPE && (updateTimeFilter == null || LastQueryUtil.satisfyFilter(updateTimeFilter, new TimeValuePair(((OptionalLong)lastByResult.get().getLeft()).getAsLong(), tsPrimitiveType)))) continue;
                    allHitCache = false;
                    break;
                }
            } else {
                allHitCache = false;
            }
            if (!allHitCache) {
                DeviceEntry deviceEntry = node.getDeviceEntries().get(i);
                AlignedFullPath alignedPath = TableScanOperator.constructAlignedPath(deviceEntry, parameter.getMeasurementColumnNames(), parameter.getMeasurementSchemas(), parameter.getAllSensors());
                ((DataDriverContext)context.getDriverContext()).addPath((IFullPath)alignedPath);
                unCachedDeviceEntries.add(deviceEntry);
                String[] updateColumns = new String[parameter.getMeasurementColumnNames().size() + 1];
                updateColumns[0] = "";
                for (int j = 1; j < updateColumns.length; ++j) {
                    updateColumns[j] = parameter.getMeasurementColumnNames().get(j - 1);
                }
                TableDeviceSchemaCache.getInstance().initOrInvalidateLastCache(node.getQualifiedObjectName().getDatabaseName(), deviceEntry.getDeviceID(), updateColumns, false);
                continue;
            }
            hitCachesIndexes.add(i);
            hitCachedResults.add(lastByResult.get());
            cachedDeviceEntries.add(node.getDeviceEntries().get(i));
        }
        parameter.setDeviceEntries(unCachedDeviceEntries);
        LastQueryAggTableScanOperator lastQueryOperator = new LastQueryAggTableScanOperator(parameter, cachedDeviceEntries, node.getQualifiedObjectName(), hitCachesIndexes, hitCachedResults);
        ((DataDriverContext)context.getDriverContext()).addSourceOperator(lastQueryOperator);
        return lastQueryOperator;
    }

    private SeriesScanOptions buildSeriesScanOptions(LocalExecutionPlanContext context, Map<Symbol, ColumnSchema> columnSchemaMap, List<String> measurementColumnNames, Map<String, Integer> measurementColumnsIndexMap, String timeColumnName, Optional<Expression> timePredicate, long pushDownLimit, long pushDownOffset, boolean pushLimitToEachDevice, Expression pushDownPredicate) {
        SeriesScanOptions.Builder scanOptionsBuilder = timePredicate.map(expression -> this.getSeriesScanOptionsBuilder(context, (Expression)expression)).orElseGet(SeriesScanOptions.Builder::new);
        scanOptionsBuilder.withPushDownLimit(pushDownLimit);
        scanOptionsBuilder.withPushDownOffset(pushDownOffset);
        scanOptionsBuilder.withPushLimitToEachDevice(pushLimitToEachDevice);
        scanOptionsBuilder.withAllSensors(new HashSet<String>(measurementColumnNames));
        if (pushDownPredicate != null) {
            scanOptionsBuilder.withPushDownFilter(PredicateUtils.convertPredicateToFilter(pushDownPredicate, measurementColumnsIndexMap, columnSchemaMap, timeColumnName));
        }
        return scanOptionsBuilder.build();
    }

    @Override
    public Operator visitExplainAnalyze(ExplainAnalyzeNode node, LocalExecutionPlanContext context) {
        Operator operator = node.getChild().accept(this, context);
        OperatorContext operatorContext = context.getDriverContext().addOperatorContext(context.getNextOperatorId(), node.getPlanNodeId(), ExplainAnalyzeOperator.class.getSimpleName());
        return new ExplainAnalyzeOperator(operatorContext, operator, node.getQueryId(), node.isVerbose(), node.getTimeout());
    }

    @Override
    public Operator visitTableFunctionProcessor(TableFunctionProcessorNode node, LocalExecutionPlanContext context) {
        TableFunction tableFunction = this.metadata.getTableFunction(node.getName());
        TableFunctionProcessorProvider processorProvider = tableFunction.getProcessorProvider(node.getTableFunctionHandle());
        if (node.getChildren().isEmpty()) {
            List<TSDataType> outputDataTypes = node.getOutputSymbols().stream().map(context.getTypeProvider()::getTableModelType).map(InternalTypeManager::getTSDataType).collect(Collectors.toList());
            OperatorContext operatorContext = context.getDriverContext().addOperatorContext(context.getNextOperatorId(), node.getPlanNodeId(), TableFunctionLeafOperator.class.getSimpleName());
            return new TableFunctionLeafOperator(operatorContext, processorProvider, outputDataTypes);
        }
        Operator operator = node.getChild().accept(this, context);
        OperatorContext operatorContext = context.getDriverContext().addOperatorContext(context.getNextOperatorId(), node.getPlanNodeId(), TableFunctionOperator.class.getSimpleName());
        List<TSDataType> inputDataTypes = node.getChild().getOutputSymbols().stream().map(context.getTypeProvider()::getTableModelType).map(InternalTypeManager::getTSDataType).collect(Collectors.toList());
        List<TSDataType> outputDataTypes = node.getOutputSymbols().stream().map(context.getTypeProvider()::getTableModelType).map(InternalTypeManager::getTSDataType).collect(Collectors.toList());
        int properChannelCount = node.getProperOutputs().size();
        Optional<TableFunctionNode.PassThroughSpecification> passThroughSpecification = node.getPassThroughSpecification();
        ImmutableMap<Symbol, Integer> childLayout = this.makeLayoutFromOutputSymbols(node.getChild().getOutputSymbols());
        List<Integer> requiredChannels = TableOperatorGenerator.getChannelsForSymbols(node.getRequiredSymbols(), childLayout);
        List<Integer> passThroughChannels = passThroughSpecification.map(passThrough -> TableOperatorGenerator.getChannelsForSymbols(passThrough.getColumns().stream().map(TableFunctionNode.PassThroughColumn::getSymbol).collect(Collectors.toList()), childLayout)).orElse(Collections.emptyList());
        List<Integer> partitionChannels = node.getDataOrganizationSpecification().isPresent() ? TableOperatorGenerator.getChannelsForSymbols(node.getDataOrganizationSpecification().get().getPartitionBy(), childLayout) : Collections.emptyList();
        return new TableFunctionOperator(operatorContext, processorProvider, operator, inputDataTypes, outputDataTypes, properChannelCount, requiredChannels, passThroughChannels, passThroughSpecification.map(TableFunctionNode.PassThroughSpecification::isDeclaredAsPassThrough).orElse(false), partitionChannels, node.isRequireRecordSnapshot());
    }

    private boolean[] checkStatisticAndScanOrder(AggregationTableScanNode node, String timeColumnName) {
        boolean groupByDateBin;
        boolean canUseStatistic = true;
        int ascendingCount = 0;
        int descendingCount = 0;
        block17: for (Map.Entry<Symbol, AggregationNode.Aggregation> entry : node.getAggregations().entrySet()) {
            AggregationNode.Aggregation aggregation = entry.getValue();
            String funcName = aggregation.getResolvedFunction().getSignature().getName();
            Symbol argument = Symbol.from(aggregation.getArguments().get(0));
            Type argumentType = node.getAssignments().get(argument).getType();
            switch (funcName) {
                case "count": 
                case "avg": 
                case "sum": 
                case "extreme": {
                    continue block17;
                }
                case "max": 
                case "min": {
                    if (!BlobType.BLOB.equals(argumentType) && !BinaryType.TEXT.equals(argumentType) && !BooleanType.BOOLEAN.equals(argumentType)) continue block17;
                    canUseStatistic = false;
                    continue block17;
                }
                case "first": 
                case "last": 
                case "last_by": 
                case "first_by": {
                    if ("first".equals(funcName) || "first_by".equals(funcName)) {
                        ++ascendingCount;
                    } else {
                        ++descendingCount;
                    }
                    if (BlobType.BLOB.equals(argumentType)) {
                        canUseStatistic = false;
                        continue block17;
                    }
                    if (!"last_by".equals(funcName) && !"first_by".equals(funcName) || GlobalTimePredicateExtractVisitor.isTimeColumn(aggregation.getArguments().get(0), timeColumnName) || GlobalTimePredicateExtractVisitor.isTimeColumn(aggregation.getArguments().get(1), timeColumnName)) continue block17;
                    canUseStatistic = false;
                    continue block17;
                }
            }
            canUseStatistic = false;
        }
        boolean isAscending = node.getScanOrder().isAscending();
        boolean bl = groupByDateBin = node.getProjection() != null && !node.getProjection().isEmpty();
        if (!groupByDateBin) {
            if (ascendingCount >= descendingCount) {
                node.setScanOrder(Ordering.ASC);
                isAscending = true;
            } else {
                node.setScanOrder(Ordering.DESC);
                isAscending = false;
            }
        }
        return new boolean[]{canUseStatistic, isAscending};
    }

    private boolean canUseLastCacheOptimize(List<TableAggregator> aggregators, AggregationTableScanNode node, String timeColumnName) {
        if (!CommonDescriptor.getInstance().getConfig().isLastCacheEnable() || aggregators.isEmpty()) {
            return false;
        }
        if (node.getPushDownPredicate() != null) {
            return false;
        }
        if (!node.getGroupingKeys().isEmpty() && node.getProjection() != null && !node.getProjection().getMap().isEmpty()) {
            return false;
        }
        for (TableAggregator aggregator : aggregators) {
            if (aggregator.getAccumulator() instanceof LastDescAccumulator) {
                if (((LastDescAccumulator)aggregator.getAccumulator()).isTimeColumn()) continue;
                return false;
            }
            if (aggregator.getAccumulator() instanceof LastByDescAccumulator) {
                if (((LastByDescAccumulator)aggregator.getAccumulator()).yIsTimeColumn()) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    @Override
    public Operator visitMarkDistinct(MarkDistinctNode node, LocalExecutionPlanContext context) {
        Operator child = node.getChild().accept(this, context);
        OperatorContext operatorContext = context.getDriverContext().addOperatorContext(context.getNextOperatorId(), node.getPlanNodeId(), ExplainAnalyzeOperator.class.getSimpleName());
        TypeProvider typeProvider = context.getTypeProvider();
        ImmutableMap<Symbol, Integer> childLayout = this.makeLayoutFromOutputSymbols(node.getChild().getOutputSymbols());
        return new MarkDistinctOperator(operatorContext, child, node.getChild().getOutputSymbols().stream().map(typeProvider::getTableModelType).collect(Collectors.toList()), node.getDistinctSymbols().stream().map(arg_0 -> childLayout.get(arg_0)).collect(Collectors.toList()), Optional.empty());
    }

    private static class CommonTableScanOperatorParameters {
        List<Symbol> outputColumnNames;
        List<ColumnSchema> columnSchemas;
        int[] columnsIndexArray;
        Map<Symbol, ColumnSchema> columnSchemaMap;
        Map<Symbol, Integer> idAndAttributeColumnsIndexMap;
        List<String> measurementColumnNames;
        Map<String, Integer> measurementColumnsIndexMap;
        String timeColumnName;
        List<IMeasurementSchema> measurementSchemas;
        int measurementColumnCount;
        int idx;

        private CommonTableScanOperatorParameters(DeviceTableScanNode node, Map<String, String> fieldColumnsRenameMap, boolean keepNonOutputMeasurementColumns) {
            String realMeasurementName;
            this.outputColumnNames = node.getOutputSymbols();
            int outputColumnCount = keepNonOutputMeasurementColumns ? node.getAssignments().size() : this.outputColumnNames.size();
            this.columnSchemas = new ArrayList<ColumnSchema>(outputColumnCount);
            this.columnsIndexArray = new int[outputColumnCount];
            this.columnSchemaMap = node.getAssignments();
            this.idAndAttributeColumnsIndexMap = node.getIdAndAttributeIndexMap();
            this.measurementColumnNames = new ArrayList<String>();
            this.measurementColumnsIndexMap = new HashMap<String, Integer>();
            this.measurementSchemas = new ArrayList<IMeasurementSchema>();
            this.measurementColumnCount = 0;
            this.idx = 0;
            block5: for (Symbol columnName : this.outputColumnNames) {
                ColumnSchema schema = Objects.requireNonNull(this.columnSchemaMap.get(columnName), columnName + " is null");
                switch (schema.getColumnCategory()) {
                    case TAG: 
                    case ATTRIBUTE: {
                        this.columnsIndexArray[this.idx++] = Objects.requireNonNull(this.idAndAttributeColumnsIndexMap.get(columnName), columnName + " is null");
                        this.columnSchemas.add(schema);
                        continue block5;
                    }
                    case FIELD: {
                        this.columnsIndexArray[this.idx++] = this.measurementColumnCount++;
                        realMeasurementName = fieldColumnsRenameMap.getOrDefault(schema.getName(), schema.getName());
                        this.measurementColumnNames.add(realMeasurementName);
                        this.measurementSchemas.add((IMeasurementSchema)new MeasurementSchema(realMeasurementName, InternalTypeManager.getTSDataType(schema.getType())));
                        this.columnSchemas.add(schema);
                        this.measurementColumnsIndexMap.put(columnName.getName(), this.measurementColumnCount - 1);
                        continue block5;
                    }
                    case TIME: {
                        this.columnsIndexArray[this.idx++] = -1;
                        this.columnSchemas.add(schema);
                        this.timeColumnName = columnName.getName();
                        continue block5;
                    }
                }
                throw new IllegalArgumentException("Unexpected column category: " + schema.getColumnCategory());
            }
            HashSet<Symbol> outputSet = new HashSet<Symbol>(this.outputColumnNames);
            for (Map.Entry<Symbol, ColumnSchema> entry : node.getAssignments().entrySet()) {
                if (!outputSet.contains(entry.getKey()) && entry.getValue().getColumnCategory() == TsTableColumnCategory.FIELD) {
                    if (keepNonOutputMeasurementColumns) {
                        this.columnSchemas.add(entry.getValue());
                        this.columnsIndexArray[this.idx++] = this.measurementColumnCount;
                    }
                    ++this.measurementColumnCount;
                    realMeasurementName = fieldColumnsRenameMap.getOrDefault(entry.getValue().getName(), entry.getValue().getName());
                    this.measurementColumnNames.add(realMeasurementName);
                    this.measurementSchemas.add((IMeasurementSchema)new MeasurementSchema(realMeasurementName, InternalTypeManager.getTSDataType(entry.getValue().getType())));
                    this.measurementColumnsIndexMap.put(entry.getKey().getName(), this.measurementColumnCount - 1);
                    continue;
                }
                if (entry.getValue().getColumnCategory() != TsTableColumnCategory.TIME) continue;
                this.timeColumnName = entry.getKey().getName();
            }
        }
    }
}

