/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.extractor.schemaregion;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.consensus.SchemaRegionId;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.pipe.datastructure.options.PipeInclusionOptions;
import org.apache.iotdb.commons.pipe.datastructure.pattern.TablePattern;
import org.apache.iotdb.commons.pipe.datastructure.pattern.TreePattern;
import org.apache.iotdb.commons.utils.PathUtils;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.schema.CreateOrUpdateTableDeviceNode;
import org.apache.iotdb.db.schemaengine.SchemaEngine;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;

public class SchemaRegionListeningFilter {
    private static final Map<PartialPath, List<PlanNodeType>> OPTION_PLAN_MAP = new HashMap<PartialPath, List<PlanNodeType>>();

    static boolean shouldPlanBeListened(PlanNode node) {
        try {
            return node.getType() == PlanNodeType.PIPE_ENRICHED_WRITE || node.getType() == PlanNodeType.PIPE_ENRICHED_NON_WRITE || OPTION_PLAN_MAP.values().stream().anyMatch(types -> types.contains((Object)node.getType())) && (node.getType() != PlanNodeType.CREATE_OR_UPDATE_TABLE_DEVICE || !((CreateOrUpdateTableDeviceNode)node).getAttributeNameList().isEmpty());
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean shouldSchemaRegionBeListened(int consensusGroupId, PipeParameters parameters) throws IllegalPathException {
        boolean isTableModel = PathUtils.isTableModelDatabase((String)SchemaEngine.getInstance().getSchemaRegion(new SchemaRegionId(consensusGroupId)).getDatabaseFullPath());
        return (TreePattern.isTreeModelDataAllowToBeCaptured((PipeParameters)parameters) && !isTableModel || TablePattern.isTableModelDataAllowToBeCaptured((PipeParameters)parameters) && isTableModel) && !SchemaRegionListeningFilter.parseListeningPlanTypeSet(parameters).isEmpty();
    }

    public static Set<PlanNodeType> parseListeningPlanTypeSet(PipeParameters parameters) throws IllegalPathException {
        HashSet<PlanNodeType> planTypes = new HashSet<PlanNodeType>();
        Set inclusionOptions = PipeInclusionOptions.parseOptions((String)PipeInclusionOptions.getInclusionString((PipeParameters)parameters));
        Set exclusionOptions = PipeInclusionOptions.parseOptions((String)PipeInclusionOptions.getExclusionString((PipeParameters)parameters));
        inclusionOptions.forEach(inclusion -> planTypes.addAll(SchemaRegionListeningFilter.getOptionsByPrefix(inclusion)));
        exclusionOptions.forEach(exclusion -> planTypes.removeAll(SchemaRegionListeningFilter.getOptionsByPrefix(exclusion)));
        if (!TreePattern.isTreeModelDataAllowToBeCaptured((PipeParameters)parameters)) {
            PipeInclusionOptions.treeOnlySyncPrefixes.forEach(prefix -> planTypes.removeAll(SchemaRegionListeningFilter.getOptionsByPrefix(prefix)));
        }
        if (!TablePattern.isTableModelDataAllowToBeCaptured((PipeParameters)parameters)) {
            PipeInclusionOptions.tableOnlySyncPrefixes.forEach(prefix -> planTypes.removeAll(SchemaRegionListeningFilter.getOptionsByPrefix(prefix)));
        }
        return planTypes;
    }

    private static Set<PlanNodeType> getOptionsByPrefix(PartialPath prefix) {
        return OPTION_PLAN_MAP.keySet().stream().filter(path -> path.overlapWithFullPathPrefix(prefix)).map(OPTION_PLAN_MAP::get).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private SchemaRegionListeningFilter() {
    }

    static {
        try {
            OPTION_PLAN_MAP.put(new PartialPath("schema.timeseries.view.create"), Collections.singletonList(PlanNodeType.CREATE_LOGICAL_VIEW));
            OPTION_PLAN_MAP.put(new PartialPath("schema.timeseries.view.alter"), Collections.singletonList(PlanNodeType.ALTER_LOGICAL_VIEW));
            OPTION_PLAN_MAP.put(new PartialPath("schema.timeseries.ordinary.create"), Collections.unmodifiableList(Arrays.asList(PlanNodeType.CREATE_TIME_SERIES, PlanNodeType.CREATE_ALIGNED_TIME_SERIES, PlanNodeType.CREATE_MULTI_TIME_SERIES, PlanNodeType.INTERNAL_CREATE_MULTI_TIMESERIES, PlanNodeType.INTERNAL_CREATE_TIME_SERIES)));
            OPTION_PLAN_MAP.put(new PartialPath("schema.timeseries.ordinary.alter"), Collections.singletonList(PlanNodeType.ALTER_TIME_SERIES));
            OPTION_PLAN_MAP.put(new PartialPath("schema.timeseries.template.activate"), Collections.unmodifiableList(Arrays.asList(PlanNodeType.ACTIVATE_TEMPLATE, PlanNodeType.BATCH_ACTIVATE_TEMPLATE, PlanNodeType.INTERNAL_BATCH_ACTIVATE_TEMPLATE)));
            OPTION_PLAN_MAP.put(new PartialPath("schema.table.alter"), Collections.unmodifiableList(Arrays.asList(PlanNodeType.CREATE_OR_UPDATE_TABLE_DEVICE, PlanNodeType.TABLE_DEVICE_ATTRIBUTE_UPDATE)));
        }
        catch (IllegalPathException illegalPathException) {
            // empty catch block
        }
    }
}

