/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.connector.util.builder;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.DiskSpaceInsufficientException;
import org.apache.iotdb.db.storageengine.rescon.disk.FolderManager;
import org.apache.iotdb.db.storageengine.rescon.disk.strategy.DirectoryStrategyType;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.tsfile.exception.write.WriteProcessException;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.write.TsFileWriter;
import org.apache.tsfile.write.record.Tablet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PipeTsFileBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeTsFileBuilder.class);
    private static final AtomicReference<FolderManager> FOLDER_MANAGER = new AtomicReference();
    protected final AtomicLong currentBatchId;
    private final File batchFileBaseDir;
    private static final String TS_FILE_PREFIX = "tb";
    private final AtomicLong tsFileIdGenerator;
    protected volatile TsFileWriter fileWriter;

    public PipeTsFileBuilder(AtomicLong currentBatchId, AtomicLong tsFileIdGenerator) {
        this.currentBatchId = currentBatchId;
        this.tsFileIdGenerator = tsFileIdGenerator;
        try {
            this.batchFileBaseDir = this.getNextBaseDir();
        }
        catch (Exception e) {
            throw new PipeException(String.format("Failed to create file dir for batch: %s", e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getNextBaseDir() throws DiskSpaceInsufficientException {
        File baseDir;
        if (FOLDER_MANAGER.get() == null) {
            AtomicReference<FolderManager> atomicReference = FOLDER_MANAGER;
            synchronized (atomicReference) {
                if (FOLDER_MANAGER.get() == null) {
                    FOLDER_MANAGER.set(new FolderManager(Arrays.stream(IoTDBDescriptor.getInstance().getConfig().getPipeReceiverFileDirs()).map(fileDir -> fileDir + File.separator + ".batch").collect(Collectors.toList()), DirectoryStrategyType.SEQUENCE_STRATEGY));
                }
            }
        }
        if ((baseDir = new File(FOLDER_MANAGER.get().getNextFolder(), Long.toString(this.currentBatchId.get()))).exists()) {
            FileUtils.deleteQuietly((File)baseDir);
        }
        if (!baseDir.exists() && !baseDir.mkdirs()) {
            LOGGER.warn("Batch id = {}: Failed to create batch file dir {}.", (Object)this.currentBatchId.get(), (Object)baseDir.getPath());
            throw new PipeException(String.format("Failed to create batch file dir %s. (Batch id = %s)", baseDir.getPath(), this.currentBatchId.get()));
        }
        LOGGER.info("Batch id = {}: Create batch dir successfully, batch file dir = {}.", (Object)this.currentBatchId.get(), (Object)baseDir.getPath());
        return baseDir;
    }

    public abstract void bufferTableModelTablet(String var1, Tablet var2);

    public abstract void bufferTreeModelTablet(Tablet var1, Boolean var2);

    public abstract List<Pair<String, File>> convertTabletToTsFileWithDBInfo() throws IOException, WriteProcessException;

    public abstract boolean isEmpty();

    public synchronized void onSuccess() {
        this.fileWriter = null;
    }

    public synchronized void close() {
        if (Objects.nonNull(this.fileWriter)) {
            try {
                this.fileWriter.close();
            }
            catch (Exception e) {
                LOGGER.info("Batch id = {}: Failed to close the tsfile {} when trying to close batch, because {}", new Object[]{this.currentBatchId.get(), this.fileWriter.getIOWriter().getFile().getPath(), e.getMessage(), e});
            }
            try {
                FileUtils.delete((File)this.fileWriter.getIOWriter().getFile());
            }
            catch (Exception e) {
                LOGGER.info("Batch id = {}: Failed to delete the tsfile {} when trying to close batch, because {}", new Object[]{this.currentBatchId.get(), this.fileWriter.getIOWriter().getFile().getPath(), e.getMessage(), e});
            }
            this.fileWriter = null;
        }
    }

    protected File createFile() throws IOException {
        return new File(this.batchFileBaseDir, "tb_" + IoTDBDescriptor.getInstance().getConfig().getDataNodeId() + "_" + this.currentBatchId.get() + "_" + this.tsFileIdGenerator.getAndIncrement() + ".tsfile");
    }
}

