/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.connector.payload.evolvable.request;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import org.apache.iotdb.commons.pipe.connector.payload.thrift.request.IoTDBConnectorRequestVersion;
import org.apache.iotdb.commons.pipe.connector.payload.thrift.request.PipeRequestType;
import org.apache.iotdb.db.pipe.receiver.protocol.thrift.IoTDBDataNodeReceiver;
import org.apache.iotdb.db.queryengine.plan.planner.plan.PlanFragment;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertRowNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertRowsNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertTabletNode;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertBaseStatement;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferReq;
import org.apache.tsfile.utils.BytesUtils;
import org.apache.tsfile.utils.PublicBAOS;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class PipeTransferTabletInsertNodeReq
extends TPipeTransferReq {
    protected transient InsertNode insertNode;

    protected PipeTransferTabletInsertNodeReq() {
    }

    public InsertNode getInsertNode() {
        return this.insertNode;
    }

    public InsertBaseStatement constructStatement() {
        if (!(this.insertNode instanceof InsertRowNode || this.insertNode instanceof InsertTabletNode || this.insertNode instanceof InsertRowsNode)) {
            throw new UnsupportedOperationException(String.format("Unknown InsertNode type %s when constructing statement from insert node.", this.insertNode));
        }
        return (InsertBaseStatement)IoTDBDataNodeReceiver.PLAN_TO_STATEMENT_VISITOR.process(this.insertNode, null);
    }

    public static PipeTransferTabletInsertNodeReq toTPipeTransferRawReq(InsertNode insertNode) {
        PipeTransferTabletInsertNodeReq req = new PipeTransferTabletInsertNodeReq();
        req.insertNode = insertNode;
        req.version = IoTDBConnectorRequestVersion.VERSION_1.getVersion();
        req.type = PipeRequestType.TRANSFER_TABLET_INSERT_NODE.getType();
        return req;
    }

    public static PipeTransferTabletInsertNodeReq toTPipeTransferReq(InsertNode insertNode) {
        PipeTransferTabletInsertNodeReq req = new PipeTransferTabletInsertNodeReq();
        req.insertNode = insertNode;
        req.version = IoTDBConnectorRequestVersion.VERSION_1.getVersion();
        req.type = PipeRequestType.TRANSFER_TABLET_INSERT_NODE.getType();
        req.body = insertNode.serializeToByteBuffer();
        return req;
    }

    public static PipeTransferTabletInsertNodeReq fromTPipeTransferReq(TPipeTransferReq transferReq) {
        PipeTransferTabletInsertNodeReq insertNodeReq = new PipeTransferTabletInsertNodeReq();
        insertNodeReq.insertNode = (InsertNode)PlanFragment.deserializeHelper(transferReq.body, null);
        insertNodeReq.version = transferReq.version;
        insertNodeReq.type = transferReq.type;
        insertNodeReq.body = transferReq.body;
        return insertNodeReq;
    }

    public static byte[] toTPipeTransferBytes(InsertNode insertNode) throws IOException {
        try (PublicBAOS byteArrayOutputStream = new PublicBAOS();){
            byte[] byArray;
            try (DataOutputStream outputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);){
                ReadWriteIOUtils.write((byte)IoTDBConnectorRequestVersion.VERSION_1.getVersion(), (OutputStream)outputStream);
                ReadWriteIOUtils.write((short)PipeRequestType.TRANSFER_TABLET_INSERT_NODE.getType(), (OutputStream)outputStream);
                byArray = BytesUtils.concatByteArray((byte[])byteArrayOutputStream.toByteArray(), (byte[])insertNode.serializeToByteBuffer().array());
            }
            return byArray;
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        PipeTransferTabletInsertNodeReq that = (PipeTransferTabletInsertNodeReq)((Object)obj);
        return Objects.equals(this.insertNode, that.insertNode) && this.version == that.version && this.type == that.type && Objects.equals(this.body, that.body);
    }

    public int hashCode() {
        return Objects.hash(this.insertNode, this.version, this.type, this.body);
    }
}

