/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.selector.estimator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.storageengine.dataregion.compaction.io.CompactionTsFileReader;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.CompactionScheduleContext;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.constant.CompactionType;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.estimator.AbstractCompactionEstimator;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.estimator.CompactionEstimateUtils;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.estimator.CompactionTaskInfo;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.tsfile.read.TsFileSequenceReader;

public abstract class AbstractCrossSpaceEstimator
extends AbstractCompactionEstimator {
    @Override
    protected TsFileSequenceReader getReader(String filePath) throws IOException {
        return new CompactionTsFileReader(filePath, CompactionType.CROSS_COMPACTION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long estimateCrossCompactionMemory(List<TsFileResource> seqResources, List<TsFileResource> unseqResources) throws IOException {
        CompactionTaskInfo taskInfo;
        ArrayList<TsFileResource> resources = new ArrayList<TsFileResource>(seqResources.size() + unseqResources.size());
        resources.addAll(seqResources);
        resources.addAll(unseqResources);
        CompactionEstimateUtils.addReadLock(resources);
        long cost = 0L;
        try {
            taskInfo = this.calculatingCompactionTaskInfo(resources);
            cost += this.calculatingMetadataMemoryCost(taskInfo);
        }
        finally {
            CompactionEstimateUtils.releaseReadLock(resources);
        }
        return cost += this.calculatingDataMemoryCost(taskInfo);
    }

    public abstract long roughEstimateCrossCompactionMemory(CompactionScheduleContext var1, List<TsFileResource> var2, List<TsFileResource> var3) throws IOException;
}

