/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.schemaregion.attribute.update;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.client.exception.ClientManagerException;
import org.apache.iotdb.commons.client.request.AsyncRequestContext;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.concurrent.ThreadName;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.consensus.ConsensusGroupId;
import org.apache.iotdb.commons.consensus.SchemaRegionId;
import org.apache.iotdb.commons.exception.StartupException;
import org.apache.iotdb.commons.service.IService;
import org.apache.iotdb.commons.service.ServiceType;
import org.apache.iotdb.commons.utils.PathUtils;
import org.apache.iotdb.confignode.rpc.thrift.TShowClusterResp;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.protocol.client.ConfigNodeClient;
import org.apache.iotdb.db.protocol.client.ConfigNodeClientManager;
import org.apache.iotdb.db.protocol.client.ConfigNodeInfo;
import org.apache.iotdb.db.protocol.client.dn.DnToDnInternalServiceAsyncRequestManager;
import org.apache.iotdb.db.protocol.client.dn.DnToDnRequestType;
import org.apache.iotdb.db.queryengine.execution.executor.RegionWriteExecutor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.schema.TableDeviceAttributeCommitUpdateNode;
import org.apache.iotdb.db.schemaengine.schemaregion.ISchemaRegion;
import org.apache.iotdb.db.schemaengine.schemaregion.impl.SchemaRegionMemoryImpl;
import org.apache.iotdb.mpp.rpc.thrift.TAttributeUpdateReq;
import org.apache.iotdb.mpp.rpc.thrift.TSchemaRegionAttributeInfo;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.thrift.TException;
import org.apache.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneralRegionAttributeSecurityService
implements IService {
    private static final Logger LOGGER = LoggerFactory.getLogger(GeneralRegionAttributeSecurityService.class);
    private static final IoTDBConfig iotdbConfig = IoTDBDescriptor.getInstance().getConfig();
    private final ExecutorService securityServiceExecutor = IoTDBThreadPoolFactory.newSingleThreadExecutor((String)ThreadName.GENERAL_REGION_ATTRIBUTE_SECURITY_SERVICE.getName());
    private final Map<Integer, Pair<Long, Integer>> dataNodeId2FailureDurationAndTimesMap = new HashMap<Integer, Pair<Long, Integer>>();
    private final Set<ISchemaRegion> regionLeaders = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Map<SchemaRegionId, String> regionId2DatabaseMap = new ConcurrentHashMap<SchemaRegionId, String>();
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private volatile boolean skipNextSleep = false;
    private volatile boolean allowSubmitListen = false;

    public void startBroadcast(ISchemaRegion schemaRegion) {
        if (schemaRegion instanceof SchemaRegionMemoryImpl && PathUtils.isTableModelDatabase((String)schemaRegion.getDatabaseFullPath())) {
            this.regionId2DatabaseMap.put(schemaRegion.getSchemaRegionId(), schemaRegion.getDatabaseFullPath());
            this.regionLeaders.add(schemaRegion);
        }
    }

    public void stopBroadcast(ISchemaRegion schemaRegion) {
        this.regionLeaders.remove(schemaRegion);
    }

    public void notifyBroadCast() {
        if (this.lock.tryLock()) {
            try {
                this.condition.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        } else {
            this.skipNextSleep = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute() {
        this.lock.lock();
        try {
            ISchemaRegion regionLeader;
            Pair<Long, Map<TDataNodeLocation, byte[]>> currentResult;
            AtomicInteger limit = new AtomicInteger(CommonDescriptor.getInstance().getConfig().getPipeConnectorRequestSliceThresholdBytes());
            AtomicBoolean hasRemaining = new AtomicBoolean(false);
            HashMap<SchemaRegionId, Pair<Long, Map<TDataNodeLocation, byte[]>>> attributeUpdateCommitMap = new HashMap<SchemaRegionId, Pair<Long, Map<TDataNodeLocation, byte[]>>>();
            Iterator<ISchemaRegion> iterator = this.regionLeaders.iterator();
            while (iterator.hasNext() && !((Map)(currentResult = (regionLeader = iterator.next()).getAttributeUpdateInfo(limit, hasRemaining)).getRight()).isEmpty()) {
                attributeUpdateCommitMap.put(regionLeader.getSchemaRegionId(), currentResult);
            }
            if (hasRemaining.get()) {
                this.skipNextSleep = true;
            }
            if (!attributeUpdateCommitMap.isEmpty()) {
                Map<SchemaRegionId, Set<TDataNodeLocation>> shrinkMap = this.sendUpdateRequestAndMayShrink(attributeUpdateCommitMap);
                attributeUpdateCommitMap.forEach((schemaRegionId, pair) -> {
                    if (!new RegionWriteExecutor().execute((ConsensusGroupId)schemaRegionId, new TableDeviceAttributeCommitUpdateNode(new PlanNodeId(""), (Long)pair.getLeft(), (Map)pair.getRight(), shrinkMap.getOrDefault(schemaRegionId, Collections.emptySet()), new TDataNodeLocation(iotdbConfig.getDataNodeId(), null, new TEndPoint(iotdbConfig.getInternalAddress(), iotdbConfig.getInternalPort()), null, null, null))).isAccepted()) {
                        this.skipNextSleep = false;
                        LOGGER.warn("Failed to write attribute commit message to region {}.", schemaRegionId);
                    }
                });
            }
            if (!this.skipNextSleep) {
                this.condition.await(iotdbConfig.getGeneralRegionAttributeSecurityServiceIntervalSeconds(), TimeUnit.SECONDS);
            }
            this.skipNextSleep = false;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOGGER.warn("Interrupted when waiting for the next attribute broadcasting: {}", (Object)e.getMessage());
        }
        finally {
            this.lock.unlock();
            if (this.allowSubmitListen) {
                this.securityServiceExecutor.submit(this::execute);
            }
        }
    }

    @Nonnull
    private Map<SchemaRegionId, Set<TDataNodeLocation>> detectNodeShrinkage(Map<SchemaRegionId, Pair<Long, Map<TDataNodeLocation, byte[]>>> attributeUpdateCommitMap) {
        TShowClusterResp showClusterResp;
        try (ConfigNodeClient client = (ConfigNodeClient)ConfigNodeClientManager.getInstance().borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            showClusterResp = client.showCluster();
        }
        catch (ClientManagerException | TException e) {
            LOGGER.warn("Failed to fetch dataNodeLocations, will retry.");
            return Collections.emptyMap();
        }
        this.dataNodeId2FailureDurationAndTimesMap.clear();
        HashSet realDataNodeLocations = new HashSet();
        showClusterResp.getDataNodeList().forEach(location -> {
            location.setDataRegionConsensusEndPoint(null);
            location.setMPPDataExchangeEndPoint(null);
            location.setSchemaRegionConsensusEndPoint(null);
            location.setClientRpcEndPoint(null);
            realDataNodeLocations.add(location);
        });
        return attributeUpdateCommitMap.entrySet().stream().filter(entry -> {
            ((Map)((Pair)entry.getValue()).getRight()).keySet().removeIf(realDataNodeLocations::contains);
            return !((Map)((Pair)entry.getValue()).getRight()).isEmpty();
        }).collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Map)((Pair)entry.getValue()).getRight()).keySet()));
    }

    @Nonnull
    private Map<SchemaRegionId, Set<TDataNodeLocation>> sendUpdateRequestAndMayShrink(Map<SchemaRegionId, Pair<Long, Map<TDataNodeLocation, byte[]>>> attributeUpdateCommitMap) {
        AsyncRequestContext clientHandler = new AsyncRequestContext((Object)DnToDnRequestType.UPDATE_ATTRIBUTE);
        attributeUpdateCommitMap.forEach((id, pair) -> ((Map)pair.getRight()).forEach((location, bytes) -> {
            clientHandler.putNodeLocation(location.getDataNodeId(), location);
            clientHandler.putRequestIfAbsent(location.getDataNodeId(), (Object)new TAttributeUpdateReq(new HashMap()));
            ((TAttributeUpdateReq)clientHandler.getRequest(location.getDataNodeId())).getAttributeUpdateMap().put(id.getId(), new TSchemaRegionAttributeInfo(((Long)pair.getLeft()).longValue(), this.regionId2DatabaseMap.get(id), ByteBuffer.wrap(bytes)));
        }));
        DnToDnInternalServiceAsyncRequestManager.getInstance().sendAsyncRequestWithTimeoutInMs(clientHandler, IoTDBDescriptor.getInstance().getConfig().getGeneralRegionAttributeSecurityServiceTimeoutSeconds());
        AtomicBoolean needFetch = new AtomicBoolean(false);
        Set failedDataNodes = clientHandler.getResponseMap().entrySet().stream().filter(entry -> {
            boolean failed;
            boolean bl = failed = ((TSStatus)entry.getValue()).getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode();
            if (failed) {
                this.dataNodeId2FailureDurationAndTimesMap.compute((Integer)entry.getKey(), (k, v) -> {
                    if (Objects.isNull(v)) {
                        return new Pair((Object)System.currentTimeMillis(), (Object)1);
                    }
                    v.setRight((Object)((Integer)v.getRight() + 1));
                    if (System.currentTimeMillis() - (Long)v.getLeft() >= iotdbConfig.getGeneralRegionAttributeSecurityServiceFailureDurationSecondsToFetch() || (Integer)v.getRight() >= iotdbConfig.getGeneralRegionAttributeSecurityServiceFailureTimesToFetch()) {
                        needFetch.set(true);
                    }
                    return v;
                });
            } else {
                this.dataNodeId2FailureDurationAndTimesMap.remove(entry.getKey());
            }
            return failed;
        }).map(Map.Entry::getKey).collect(Collectors.toSet());
        Map<SchemaRegionId, Set<TDataNodeLocation>> result = needFetch.get() ? this.detectNodeShrinkage(attributeUpdateCommitMap) : Collections.emptyMap();
        Iterator<Map.Entry<SchemaRegionId, Pair<Long, Map<TDataNodeLocation, byte[]>>>> it = attributeUpdateCommitMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<SchemaRegionId, Pair<Long, Map<TDataNodeLocation, byte[]>>> currentEntry = it.next();
            Map dataNodeLocationMap = (Map)currentEntry.getValue().getRight();
            dataNodeLocationMap.entrySet().removeIf(locationEntry -> failedDataNodes.contains(((TDataNodeLocation)locationEntry.getKey()).getDataNodeId()));
            if (!dataNodeLocationMap.isEmpty() || result.containsKey(currentEntry.getKey())) continue;
            it.remove();
        }
        return result;
    }

    public void start() throws StartupException {
        this.allowSubmitListen = true;
        this.securityServiceExecutor.submit(this::execute);
        LOGGER.info("General region attribute security service is started successfully.");
    }

    public void stop() {
        this.allowSubmitListen = false;
        this.securityServiceExecutor.shutdown();
        LOGGER.info("General region attribute security service is stopped successfully.");
    }

    public ServiceType getID() {
        return ServiceType.GENERAL_REGION_ATTRIBUTE_SECURITY_SERVICE;
    }

    private GeneralRegionAttributeSecurityService() {
    }

    public static GeneralRegionAttributeSecurityService getInstance() {
        return GeneralRegionAttributeSecurityServiceHolder.INSTANCE;
    }

    private static final class GeneralRegionAttributeSecurityServiceHolder {
        private static final GeneralRegionAttributeSecurityService INSTANCE = new GeneralRegionAttributeSecurityService();

        private GeneralRegionAttributeSecurityServiceHolder() {
        }
    }
}

