/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.statement.crud;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.auth.entity.PrivilegeType;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.schema.table.column.TsTableColumnCategory;
import org.apache.iotdb.commons.schema.view.LogicalViewSchema;
import org.apache.iotdb.db.auth.AuthorityChecker;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.metadata.DataTypeMismatchException;
import org.apache.iotdb.db.exception.metadata.DuplicateInsertException;
import org.apache.iotdb.db.exception.metadata.PathNotExistException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.pipe.resource.memory.InsertNodeMemoryEstimator;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.plan.analyze.schema.ISchemaValidation;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.ColumnSchema;
import org.apache.iotdb.db.queryengine.plan.relational.type.InternalTypeManager;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.db.schemaengine.schemaregion.attribute.update.UpdateDetailContainer;
import org.apache.iotdb.db.utils.CommonUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.annotations.TableModel;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.utils.Accountable;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.apache.tsfile.write.schema.MeasurementSchema;

public abstract class InsertBaseStatement
extends Statement
implements Accountable {
    protected PartialPath devicePath;
    protected boolean isAligned;
    protected MeasurementSchema[] measurementSchemas;
    protected String[] measurements;
    protected TSDataType[] dataTypes;
    protected Map<Integer, FailedMeasurementInfo> failedMeasurementIndex2Info;
    protected TsTableColumnCategory[] columnCategories;
    protected List<Integer> idColumnIndices;
    protected List<Integer> attrColumnIndices;
    protected boolean writeToTable = false;
    protected List<LogicalViewSchema> logicalViewSchemaList;
    protected List<Integer> indexOfSourcePathsOfLogicalViews;
    protected int recordedBeginOfLogicalViewSchemaList = 0;
    protected int recordedEndOfLogicalViewSchemaList = 0;
    @TableModel
    protected String databaseName;
    protected long ramBytesUsed = Long.MIN_VALUE;

    public PartialPath getDevicePath() {
        return this.devicePath;
    }

    public void setDevicePath(PartialPath devicePath) {
        this.devicePath = devicePath;
    }

    public String[] getMeasurements() {
        return this.measurements;
    }

    public void setMeasurements(String[] measurements) {
        this.measurements = measurements;
    }

    public MeasurementSchema[] getMeasurementSchemas() {
        return this.measurementSchemas;
    }

    public void setMeasurementSchemas(MeasurementSchema[] measurementSchemas) {
        this.measurementSchemas = measurementSchemas;
    }

    public void setMeasurementSchema(MeasurementSchema measurementSchema, int i) {
        if (this.measurementSchemas == null) {
            this.measurementSchemas = new MeasurementSchema[this.measurements.length];
        }
        this.measurementSchemas[i] = measurementSchema;
    }

    public boolean isAligned() {
        return this.isAligned;
    }

    public void setAligned(boolean aligned) {
        this.isAligned = aligned;
    }

    public TSDataType[] getDataTypes() {
        return this.dataTypes;
    }

    public TSDataType getDataType(int i) {
        if (this.dataTypes == null) {
            return null;
        }
        return this.dataTypes[i];
    }

    public void setDataTypes(TSDataType[] dataTypes) {
        this.dataTypes = dataTypes;
    }

    public void setDataType(TSDataType dataType, int i) {
        if (this.dataTypes == null) {
            this.dataTypes = new TSDataType[this.measurements.length];
        }
        this.dataTypes[i] = dataType;
    }

    public abstract boolean isEmpty();

    public List<PartialPath> getPaths() {
        return Collections.emptyList();
    }

    @Override
    public TSStatus checkPermissionBeforeProcess(String userName) {
        if (AuthorityChecker.SUPER_USER.equals(userName)) {
            return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        }
        List checkedPaths = this.getPaths().stream().distinct().collect(Collectors.toList());
        return AuthorityChecker.getTSStatus(AuthorityChecker.checkFullPathListPermission(userName, checkedPaths, PrivilegeType.WRITE_DATA), checkedPaths, PrivilegeType.WRITE_DATA);
    }

    public abstract ISchemaValidation getSchemaValidation();

    public abstract List<ISchemaValidation> getSchemaValidationList();

    public void updateAfterSchemaValidation(MPPQueryContext context) throws QueryProcessException {
    }

    public void selfCheckDataTypes(int index) throws DataTypeMismatchException, PathNotExistException {
        if (IoTDBDescriptor.getInstance().getConfig().isEnablePartialInsert()) {
            if (this.measurementSchemas[index] == null) {
                this.markFailedMeasurement(index, (Exception)((Object)new PathNotExistException(this.devicePath.concatNode(this.measurements[index]).getFullPath())));
            } else if (this.dataTypes[index] != this.measurementSchemas[index].getType() && !this.checkAndCastDataType(index, this.measurementSchemas[index].getType())) {
                this.markFailedMeasurement(index, (Exception)((Object)new DataTypeMismatchException(this.devicePath.getFullPath(), this.measurements[index], this.dataTypes[index], this.measurementSchemas[index].getType(), this.getMinTime(), this.getFirstValueOfIndex(index))));
            }
        } else {
            if (this.measurementSchemas[index] == null) {
                throw new PathNotExistException(this.devicePath.concatNode(this.measurements[index]).getFullPath());
            }
            if (this.dataTypes[index] != this.measurementSchemas[index].getType() && !this.checkAndCastDataType(index, this.measurementSchemas[index].getType())) {
                throw new DataTypeMismatchException(this.devicePath.getFullPath(), this.measurements[index], this.dataTypes[index], this.measurementSchemas[index].getType(), this.getMinTime(), this.getFirstValueOfIndex(index));
            }
        }
    }

    protected abstract boolean checkAndCastDataType(int var1, TSDataType var2);

    public abstract long getMinTime();

    public abstract Object getFirstValueOfIndex(int var1);

    public void semanticCheck() {
        HashSet<String> deduplicatedMeasurements = new HashSet<String>();
        for (String measurement : this.measurements) {
            if (measurement == null || measurement.isEmpty()) {
                throw new SemanticException("Measurement contains null or empty string: " + Arrays.toString(this.measurements));
            }
            if (deduplicatedMeasurements.contains(measurement)) {
                throw new SemanticException("Insertion contains duplicated measurement: " + measurement);
            }
            deduplicatedMeasurements.add(measurement);
        }
    }

    public void markFailedMeasurement(int index, Exception cause) {
        throw new UnsupportedOperationException();
    }

    public void removeAllFailedMeasurementMarks() {
        throw new UnsupportedOperationException();
    }

    public boolean hasValidMeasurements() {
        for (String o : this.measurements) {
            if (o == null) continue;
            return true;
        }
        return false;
    }

    public TsTableColumnCategory[] getColumnCategories() {
        return this.columnCategories;
    }

    public TsTableColumnCategory getColumnCategory(int i) {
        if (this.columnCategories == null) {
            return null;
        }
        return this.columnCategories[i];
    }

    public void setColumnCategories(TsTableColumnCategory[] columnCategories) {
        this.columnCategories = columnCategories;
    }

    public void setColumnCategory(TsTableColumnCategory columnCategory, int i) {
        if (this.columnCategories == null) {
            this.columnCategories = new TsTableColumnCategory[this.measurements.length];
        }
        this.columnCategories[i] = columnCategory;
        this.idColumnIndices = null;
    }

    public List<Integer> getIdColumnIndices() {
        if (this.idColumnIndices == null && this.columnCategories != null) {
            this.idColumnIndices = new ArrayList<Integer>();
            for (int i = 0; i < this.columnCategories.length; ++i) {
                if (!this.columnCategories[i].equals((Object)TsTableColumnCategory.TAG)) continue;
                this.idColumnIndices.add(i);
            }
        }
        return this.idColumnIndices;
    }

    public List<Integer> getAttrColumnIndices() {
        if (this.attrColumnIndices == null && this.columnCategories != null) {
            this.attrColumnIndices = new ArrayList<Integer>();
            for (int i = 0; i < this.columnCategories.length; ++i) {
                if (!this.columnCategories[i].equals((Object)TsTableColumnCategory.ATTRIBUTE)) continue;
                this.attrColumnIndices.add(i);
            }
        }
        return this.attrColumnIndices;
    }

    public boolean hasFailedMeasurements() {
        return this.failedMeasurementIndex2Info != null && !this.failedMeasurementIndex2Info.isEmpty();
    }

    public int getFailedMeasurementNumber() {
        return this.failedMeasurementIndex2Info == null ? 0 : this.failedMeasurementIndex2Info.size();
    }

    public List<String> getFailedMeasurements() {
        return this.failedMeasurementIndex2Info == null ? Collections.emptyList() : this.failedMeasurementIndex2Info.values().stream().map(info -> info.measurement).collect(Collectors.toList());
    }

    public Map<Integer, FailedMeasurementInfo> getFailedMeasurementInfoMap() {
        return this.failedMeasurementIndex2Info;
    }

    public List<Exception> getFailedExceptions() {
        return this.failedMeasurementIndex2Info == null ? Collections.emptyList() : this.failedMeasurementIndex2Info.values().stream().map(info -> info.cause).collect(Collectors.toList());
    }

    public List<String> getFailedMessages() {
        return this.failedMeasurementIndex2Info == null ? Collections.emptyList() : this.failedMeasurementIndex2Info.values().stream().map(info -> {
            Throwable cause = info.cause;
            while (cause.getCause() != null) {
                cause = cause.getCause();
            }
            return cause.getMessage();
        }).collect(Collectors.toList());
    }

    @TableModel
    public void removeAttributeColumns() {
        if (this.columnCategories == null) {
            return;
        }
        ArrayList<Integer> columnsToKeep = new ArrayList<Integer>();
        for (int i2 = 0; i2 < this.columnCategories.length; ++i2) {
            if (this.columnCategories[i2].equals((Object)TsTableColumnCategory.ATTRIBUTE)) continue;
            columnsToKeep.add(i2);
        }
        if (columnsToKeep.size() == this.columnCategories.length) {
            return;
        }
        if (this.failedMeasurementIndex2Info != null) {
            this.failedMeasurementIndex2Info = this.failedMeasurementIndex2Info.entrySet().stream().collect(Collectors.toMap(e -> columnsToKeep.indexOf(e.getKey()), Map.Entry::getValue));
        }
        if (this.measurementSchemas != null) {
            this.measurementSchemas = (MeasurementSchema[])columnsToKeep.stream().map(i -> this.measurementSchemas[i]).toArray(MeasurementSchema[]::new);
        }
        if (this.measurements != null) {
            this.measurements = (String[])columnsToKeep.stream().map(i -> this.measurements[i]).toArray(String[]::new);
        }
        if (this.dataTypes != null) {
            this.dataTypes = (TSDataType[])columnsToKeep.stream().map(i -> this.dataTypes[i]).toArray(TSDataType[]::new);
        }
        if (this.columnCategories != null) {
            this.columnCategories = (TsTableColumnCategory[])columnsToKeep.stream().map(i -> this.columnCategories[i]).toArray(TsTableColumnCategory[]::new);
        }
        this.subRemoveAttributeColumns(columnsToKeep);
        this.idColumnIndices = null;
        this.attrColumnIndices = null;
    }

    protected abstract void subRemoveAttributeColumns(List<Integer> var1);

    public abstract InsertBaseStatement removeLogicalView();

    public void setFailedMeasurementIndex2Info(Map<Integer, FailedMeasurementInfo> failedMeasurementIndex2Info) {
        this.failedMeasurementIndex2Info = failedMeasurementIndex2Info;
    }

    protected Map<PartialPath, List<Pair<String, Integer>>> getMapFromDeviceToMeasurementAndIndex() {
        boolean[] isLogicalView = new boolean[this.measurements.length];
        int[] indexMapToLogicalViewList = new int[this.measurements.length];
        Arrays.fill(isLogicalView, false);
        if (this.indexOfSourcePathsOfLogicalViews != null) {
            int i = 0;
            while (i < this.indexOfSourcePathsOfLogicalViews.size()) {
                int realIndex = this.indexOfSourcePathsOfLogicalViews.get(i);
                isLogicalView[realIndex] = true;
                indexMapToLogicalViewList[realIndex] = i++;
            }
        }
        HashMap<PartialPath, List<Pair<String, Integer>>> mapFromDeviceToMeasurementAndIndex = new HashMap<PartialPath, List<Pair<String, Integer>>>();
        int i = 0;
        while (i < this.measurements.length) {
            String measurementName;
            PartialPath targetDevicePath;
            if (isLogicalView[i]) {
                int viewIndex = indexMapToLogicalViewList[i];
                targetDevicePath = this.logicalViewSchemaList.get(viewIndex).getSourcePathIfWritable().getDevicePath();
                measurementName = this.logicalViewSchemaList.get(viewIndex).getSourcePathIfWritable().getMeasurement();
            } else {
                targetDevicePath = this.devicePath;
                measurementName = this.measurements[i];
            }
            int index = i++;
            String finalMeasurementName = measurementName;
            mapFromDeviceToMeasurementAndIndex.compute(targetDevicePath, (k, v) -> {
                if (v == null) {
                    ArrayList<Pair> valueList = new ArrayList<Pair>();
                    valueList.add(new Pair((Object)finalMeasurementName, (Object)index));
                    return valueList;
                }
                v.add(new Pair((Object)finalMeasurementName, (Object)index));
                return v;
            });
        }
        InsertBaseStatement.validateMapFromDeviceToMeasurement(mapFromDeviceToMeasurementAndIndex);
        return mapFromDeviceToMeasurementAndIndex;
    }

    protected static void validateMapFromDeviceToMeasurement(Map<PartialPath, List<Pair<String, Integer>>> map) {
        if (map == null) {
            return;
        }
        for (Map.Entry<PartialPath, List<Pair<String, Integer>>> entry : map.entrySet()) {
            List<Pair<String, Integer>> measurementList = entry.getValue();
            if (measurementList.size() <= 1) continue;
            HashSet<String> measurementSet = new HashSet<String>();
            for (Pair<String, Integer> thisPair : measurementList) {
                boolean measurementNotExists = measurementSet.add((String)thisPair.left);
                if (measurementNotExists) continue;
                PartialPath devicePath = entry.getKey();
                throw new SemanticException((Throwable)((Object)new DuplicateInsertException(devicePath.getFullPath(), (String)thisPair.left)));
            }
        }
    }

    public void insertColumn(int pos, ColumnSchema columnSchema) {
        if (pos < 0 || pos > this.measurements.length) {
            throw new ArrayIndexOutOfBoundsException(pos);
        }
        if (this.measurementSchemas != null) {
            MeasurementSchema[] tmp = new MeasurementSchema[this.measurementSchemas.length + 1];
            System.arraycopy(this.measurementSchemas, 0, tmp, 0, pos);
            tmp[pos] = new MeasurementSchema(columnSchema.getName(), InternalTypeManager.getTSDataType(columnSchema.getType()));
            System.arraycopy(this.measurementSchemas, pos, tmp, pos + 1, this.measurementSchemas.length - pos);
            this.measurementSchemas = tmp;
        }
        String[] tmpMeasurements = new String[this.measurements.length + 1];
        System.arraycopy(this.measurements, 0, tmpMeasurements, 0, pos);
        tmpMeasurements[pos] = columnSchema.getName();
        System.arraycopy(this.measurements, pos, tmpMeasurements, pos + 1, this.measurements.length - pos);
        this.measurements = tmpMeasurements;
        if (this.dataTypes == null) {
            this.dataTypes = new TSDataType[this.measurements.length + 1];
            this.dataTypes[pos] = InternalTypeManager.getTSDataType(columnSchema.getType());
        } else {
            TSDataType[] tmpTypes = new TSDataType[this.dataTypes.length + 1];
            System.arraycopy(this.dataTypes, 0, tmpTypes, 0, pos);
            tmpTypes[pos] = InternalTypeManager.getTSDataType(columnSchema.getType());
            System.arraycopy(this.dataTypes, pos, tmpTypes, pos + 1, this.dataTypes.length - pos);
            this.dataTypes = tmpTypes;
        }
        if (this.columnCategories == null) {
            this.columnCategories = new TsTableColumnCategory[this.measurements.length + 1];
            this.columnCategories[pos] = columnSchema.getColumnCategory();
        } else {
            TsTableColumnCategory[] tmpCategories = new TsTableColumnCategory[this.columnCategories.length + 1];
            System.arraycopy(this.columnCategories, 0, tmpCategories, 0, pos);
            tmpCategories[pos] = columnSchema.getColumnCategory();
            System.arraycopy(this.columnCategories, pos, tmpCategories, pos + 1, this.columnCategories.length - pos);
            this.columnCategories = tmpCategories;
            this.idColumnIndices = null;
        }
    }

    public void swapColumn(int src, int target) {
        if (src < 0 || src >= this.measurements.length || target < 0 || target >= this.measurements.length) {
            throw new ArrayIndexOutOfBoundsException(src + "/" + target);
        }
        if (this.measurementSchemas != null) {
            CommonUtils.swapArray(this.measurementSchemas, src, target);
        }
        CommonUtils.swapArray(this.measurements, src, target);
        if (this.dataTypes != null) {
            CommonUtils.swapArray(this.dataTypes, src, target);
        }
        if (this.columnCategories != null) {
            CommonUtils.swapArray(this.columnCategories, src, target);
        }
        this.idColumnIndices = null;
    }

    public boolean isWriteToTable() {
        return this.writeToTable;
    }

    public void setWriteToTable(boolean writeToTable) {
        this.writeToTable = writeToTable;
        if (writeToTable) {
            this.isAligned = true;
        }
    }

    @TableModel
    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    @TableModel
    public Optional<String> getDatabaseName() {
        return Optional.ofNullable(this.databaseName);
    }

    @TableModel
    public void toLowerCase() {
        this.devicePath.toLowerCase();
        if (this.measurements == null) {
            return;
        }
        for (int i = 0; i < this.measurements.length; ++i) {
            if (this.measurements[i] == null) continue;
            this.measurements[i] = this.measurements[i].toLowerCase();
        }
        if (this.measurementSchemas != null) {
            for (MeasurementSchema measurementSchema : this.measurementSchemas) {
                if (measurementSchema == null) continue;
                measurementSchema.setMeasurementName(measurementSchema.getMeasurementName().toLowerCase());
            }
        }
    }

    @TableModel
    public List<String> getAttributeColumnNameList() {
        ArrayList<String> attributeColumnNameList = new ArrayList<String>();
        for (int i = 0; i < this.getColumnCategories().length; ++i) {
            if (this.getColumnCategories()[i] != TsTableColumnCategory.ATTRIBUTE) continue;
            attributeColumnNameList.add(this.getMeasurements()[i]);
        }
        return attributeColumnNameList;
    }

    @TableModel
    public String getTableName() {
        return this.devicePath.getFullPath();
    }

    @TableModel
    public boolean isForceTypeConversion() {
        return false;
    }

    public long ramBytesUsed() {
        if (this.ramBytesUsed > 0L) {
            return this.ramBytesUsed;
        }
        this.ramBytesUsed = InsertNodeMemoryEstimator.sizeOfPartialPath(this.devicePath) + InsertNodeMemoryEstimator.sizeOfMeasurementSchemas(this.measurementSchemas) + InsertNodeMemoryEstimator.sizeOfStringArray(this.measurements) + RamUsageEstimator.shallowSizeOf((Object[])this.dataTypes) + RamUsageEstimator.shallowSizeOf((Object[])this.columnCategories) + this.shallowSizeOfList(this.idColumnIndices) + this.shallowSizeOfList(this.attrColumnIndices) + this.shallowSizeOfList(this.logicalViewSchemaList) + (Objects.nonNull(this.logicalViewSchemaList) ? this.logicalViewSchemaList.stream().mapToLong(LogicalViewSchema::ramBytesUsed).reduce(0L, Long::sum) : 0L) + this.shallowSizeOfList(this.indexOfSourcePathsOfLogicalViews) + RamUsageEstimator.sizeOf((String)this.databaseName) + this.calculateBytesUsed();
        return this.ramBytesUsed;
    }

    private long shallowSizeOfList(List<?> list) {
        return Objects.nonNull(list) ? UpdateDetailContainer.LIST_SIZE + RamUsageEstimator.alignObjectSize((long)((long)RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + (long)RamUsageEstimator.NUM_BYTES_OBJECT_REF * (long)list.size())) : 0L;
    }

    protected abstract long calculateBytesUsed();

    public static class FailedMeasurementInfo {
        protected String measurement;
        protected TSDataType dataType;
        protected Object value;
        protected Exception cause;

        public FailedMeasurementInfo(String measurement, TSDataType dataType, Object value, Exception cause) {
            this.measurement = measurement;
            this.dataType = dataType;
            this.value = value;
            this.cause = cause;
        }

        public String getMeasurement() {
            return this.measurement;
        }

        public TSDataType getDataType() {
            return this.dataType;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

