/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.metadata;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class FunctionNullability {
    private final boolean returnNullable;
    private final List<Boolean> argumentNullable;

    public FunctionNullability(boolean returnNullable, List<Boolean> argumentNullable) {
        this.returnNullable = returnNullable;
        this.argumentNullable = new ArrayList<Boolean>((Collection)Objects.requireNonNull(argumentNullable, "argumentNullable is null"));
    }

    public static FunctionNullability getAggregationFunctionNullability(int argumentsNumber) {
        return new FunctionNullability(false, Collections.nCopies(argumentsNumber, true));
    }

    public static FunctionNullability getScalarFunctionNullability(int argumentsNumber) {
        return new FunctionNullability(true, Collections.nCopies(argumentsNumber, true));
    }

    public boolean isReturnNullable() {
        return this.returnNullable;
    }

    public boolean isArgumentNullable(int index) {
        return this.argumentNullable.get(index);
    }

    public List<Boolean> getArgumentNullable() {
        return this.argumentNullable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FunctionNullability that = (FunctionNullability)o;
        return this.returnNullable == that.returnNullable && this.argumentNullable.equals(that.argumentNullable);
    }

    public int hashCode() {
        return Objects.hash(this.returnNullable, this.argumentNullable);
    }

    public String toString() {
        return this.argumentNullable.stream().map(Objects::toString).collect(Collectors.joining(", ", "(", ")")) + this.returnNullable;
    }

    public void serialize(ByteBuffer byteBuffer) {
        ReadWriteIOUtils.write((Boolean)this.returnNullable, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((int)this.argumentNullable.size(), (ByteBuffer)byteBuffer);
        for (boolean eachNullable : this.argumentNullable) {
            ReadWriteIOUtils.write((Boolean)eachNullable, (ByteBuffer)byteBuffer);
        }
    }

    public void serialize(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((Boolean)this.returnNullable, (OutputStream)stream);
        ReadWriteIOUtils.write((int)this.argumentNullable.size(), (OutputStream)stream);
        for (boolean eachNullable : this.argumentNullable) {
            ReadWriteIOUtils.write((Boolean)eachNullable, (OutputStream)stream);
        }
    }

    public static FunctionNullability deserialize(ByteBuffer byteBuffer) {
        boolean returnNullable = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
        int size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        ArrayList<Boolean> argumentNullable = new ArrayList<Boolean>(size);
        while (size-- > 0) {
            argumentNullable.add(ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer));
        }
        return new FunctionNullability(returnNullable, argumentNullable);
    }
}

