/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process.window.partition;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.iotdb.db.queryengine.execution.operator.process.window.function.WindowFunction;
import org.apache.iotdb.db.queryengine.execution.operator.process.window.partition.Partition;
import org.apache.iotdb.db.queryengine.execution.operator.process.window.partition.frame.Frame;
import org.apache.iotdb.db.queryengine.execution.operator.process.window.partition.frame.FrameInfo;
import org.apache.iotdb.db.queryengine.execution.operator.process.window.partition.frame.GroupsFrame;
import org.apache.iotdb.db.queryengine.execution.operator.process.window.partition.frame.RangeFrame;
import org.apache.iotdb.db.queryengine.execution.operator.process.window.partition.frame.RowsFrame;
import org.apache.iotdb.db.queryengine.execution.operator.process.window.utils.ColumnList;
import org.apache.iotdb.db.queryengine.execution.operator.process.window.utils.Range;
import org.apache.iotdb.db.queryengine.execution.operator.process.window.utils.RowComparator;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.common.block.TsBlockBuilder;

public final class PartitionExecutor {
    private final int partitionStart;
    private final int partitionEnd;
    private final Partition partition;
    private final List<WindowFunction> windowFunctions;
    private final List<ColumnList> sortedColumns;
    private final RowComparator peerGroupComparator;
    private int peerGroupStart;
    private int peerGroupEnd;
    private final List<Integer> outputChannels;
    private int currentGroupIndex = -1;
    private int currentPosition;
    private final List<Frame> frames;
    private final boolean needPeerGroup;

    public PartitionExecutor(List<TsBlock> tsBlocks, List<TSDataType> dataTypes, int startIndexInFirstBlock, int endIndexInLastBlock, List<Integer> outputChannels, List<WindowFunction> windowFunctions, List<FrameInfo> frameInfoList, List<Integer> sortChannels) {
        this.partition = new Partition(tsBlocks, startIndexInFirstBlock, endIndexInLastBlock);
        this.partitionStart = startIndexInFirstBlock;
        this.partitionEnd = startIndexInFirstBlock + this.partition.getPositionCount();
        this.windowFunctions = ImmutableList.copyOf(windowFunctions);
        this.frames = new ArrayList<Frame>();
        this.outputChannels = ImmutableList.copyOf(outputChannels);
        ArrayList<TSDataType> sortDataTypes = new ArrayList<TSDataType>();
        Iterator<Object> iterator = sortChannels.iterator();
        while (iterator.hasNext()) {
            int channel = iterator.next();
            TSDataType dataType = dataTypes.get(channel);
            sortDataTypes.add(dataType);
        }
        this.peerGroupComparator = new RowComparator(sortDataTypes);
        this.sortedColumns = this.partition.getSortedColumnList(sortChannels);
        for (WindowFunction windowFunction : windowFunctions) {
            windowFunction.reset();
        }
        this.currentPosition = this.partitionStart;
        boolean bl = this.needPeerGroup = windowFunctions.stream().anyMatch(WindowFunction::needPeerGroup) || frameInfoList.stream().anyMatch(frameInfo -> frameInfo.getFrameType() != FrameInfo.FrameType.ROWS);
        if (this.needPeerGroup) {
            this.updatePeerGroup();
        }
        for (int i = 0; i < frameInfoList.size(); ++i) {
            Frame frame = null;
            if (windowFunctions.get(i).needFrame()) {
                FrameInfo frameInfo2 = frameInfoList.get(i);
                switch (frameInfo2.getFrameType()) {
                    case RANGE: {
                        frame = new RangeFrame(this.partition, frameInfo2, this.sortedColumns, this.peerGroupComparator);
                        break;
                    }
                    case ROWS: {
                        frame = new RowsFrame(this.partition, frameInfo2, this.partitionStart, this.partitionEnd);
                        break;
                    }
                    case GROUPS: {
                        frame = new GroupsFrame(this.partition, frameInfo2, this.sortedColumns, this.peerGroupComparator, this.peerGroupEnd - this.partitionStart - 1);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unreachable!");
                    }
                }
            }
            this.frames.add(frame);
        }
    }

    public boolean hasNext() {
        return this.currentPosition < this.partitionEnd;
    }

    public void processNextRow(TsBlockBuilder builder) {
        int i;
        int index = this.currentPosition - this.partitionStart;
        Partition.PartitionIndex partitionIndex = this.partition.getPartitionIndex(index);
        int tsBlockIndex = partitionIndex.getTsBlockIndex();
        int offsetInTsBlock = partitionIndex.getOffsetInTsBlock();
        TsBlock tsBlock = this.partition.getTsBlock(tsBlockIndex);
        int channel = 0;
        for (i = 0; i < this.outputChannels.size(); ++i) {
            Column column = tsBlock.getColumn(this.outputChannels.get(i).intValue());
            ColumnBuilder columnBuilder = builder.getColumnBuilder(i);
            columnBuilder.write(column, offsetInTsBlock);
            ++channel;
        }
        if (this.needPeerGroup && this.currentPosition == this.peerGroupEnd) {
            this.updatePeerGroup();
        }
        for (i = 0; i < this.windowFunctions.size(); ++i) {
            Frame frame = this.frames.get(i);
            WindowFunction windowFunction = this.windowFunctions.get(i);
            Range frameRange = windowFunction.needFrame() ? frame.getRange(index, this.currentGroupIndex, this.peerGroupStart - this.partitionStart, this.peerGroupEnd - this.partitionStart) : new Range(-1, -1);
            windowFunction.transform(this.partition, builder.getColumnBuilder(channel), this.currentPosition - this.partitionStart, frameRange.getStart(), frameRange.getEnd(), this.peerGroupStart - this.partitionStart, this.peerGroupEnd - this.partitionStart - 1);
            ++channel;
        }
        ++this.currentPosition;
        builder.declarePosition();
    }

    private void updatePeerGroup() {
        ++this.currentGroupIndex;
        this.peerGroupStart = this.currentPosition;
        this.peerGroupEnd = this.peerGroupStart + 1;
        while (this.peerGroupEnd < this.partitionEnd && this.peerGroupComparator.equalColumnLists(this.sortedColumns, this.peerGroupStart - this.partitionStart, this.peerGroupEnd - this.partitionStart)) {
            ++this.peerGroupEnd;
        }
    }
}

