/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.fragment;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PatternTreeMap;
import org.apache.iotdb.db.queryengine.execution.fragment.QueryStatistics;
import org.apache.iotdb.db.storageengine.dataregion.modification.ModEntry;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileID;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.utils.ModificationUtils;
import org.apache.iotdb.db.utils.datastructure.PatternTreeMapFactory;
import org.apache.iotdb.db.utils.datastructure.TVList;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryContext.class);
    private QueryStatistics queryStatistics = new QueryStatistics();
    private final Map<String, PatternTreeMap<ModEntry, PatternTreeMapFactory.ModsSerializer>> fileModCache = new ConcurrentHashMap<String, PatternTreeMap<ModEntry, PatternTreeMapFactory.ModsSerializer>>();
    protected long queryId;
    private boolean debug;
    private long startTime;
    private long timeout;
    private volatile boolean isInterrupted = false;
    private boolean ignoreAllNullRows = true;
    private final Set<TsFileID> nonExistentModFiles = new CopyOnWriteArraySet<TsFileID>();
    protected final Set<TVList> tvListSet = new HashSet<TVList>();

    public QueryContext() {
    }

    public QueryContext(long queryId) {
        this(queryId, false, System.currentTimeMillis(), 0L);
    }

    public QueryContext(long queryId, boolean debug, long startTime, long timeout) {
        this.queryId = queryId;
        this.debug = debug;
        this.startTime = startTime;
        this.timeout = timeout;
    }

    private boolean checkIfModificationExists(TsFileResource tsFileResource) {
        if (this.nonExistentModFiles.contains(tsFileResource.getTsFileID())) {
            return false;
        }
        if (!tsFileResource.anyModFileExists()) {
            this.nonExistentModFiles.add(tsFileResource.getTsFileID());
            return false;
        }
        return true;
    }

    private PatternTreeMap<ModEntry, PatternTreeMapFactory.ModsSerializer> getAllModifications(TsFileResource resource) {
        return this.fileModCache.computeIfAbsent(resource.getTsFilePath(), k -> {
            PatternTreeMap<ModEntry, PatternTreeMapFactory.ModsSerializer> modifications = PatternTreeMapFactory.getModsPatternTreeMap();
            for (ModEntry modification : resource.getAllModEntries()) {
                modifications.append(modification.keyOfPatternTree(), (Object)modification);
            }
            return modifications;
        });
    }

    public List<ModEntry> getPathModifications(TsFileResource tsFileResource, IDeviceID deviceID, String measurement) {
        if (!this.checkIfModificationExists(tsFileResource)) {
            return Collections.emptyList();
        }
        List<ModEntry> modEntries = this.getAllModifications(tsFileResource).getOverlapped(deviceID, measurement);
        if (deviceID.isTableModel()) {
            modEntries = modEntries.stream().filter(mod -> mod.affects(deviceID) && mod.affects(measurement)).collect(Collectors.toList());
        }
        modEntries = ModificationUtils.sortAndMerge(modEntries);
        return modEntries;
    }

    public List<ModEntry> getPathModifications(TsFileResource tsFileResource, IDeviceID deviceID) throws IllegalPathException {
        if (!this.checkIfModificationExists(tsFileResource)) {
            return Collections.emptyList();
        }
        List<ModEntry> modEntries = this.getAllModifications(tsFileResource).getOverlapped(new PartialPath(deviceID));
        if (deviceID.isTableModel()) {
            modEntries = modEntries.stream().filter(mod -> mod.affects(deviceID)).collect(Collectors.toList());
        }
        modEntries = ModificationUtils.sortAndMerge(modEntries);
        return modEntries;
    }

    public List<List<ModEntry>> getPathModifications(TsFileResource tsFileResource, IDeviceID deviceID, List<String> measurementList) {
        int n = measurementList.size();
        ArrayList<List<ModEntry>> ans = new ArrayList<List<ModEntry>>(n);
        for (String s : measurementList) {
            ans.add(this.getPathModifications(tsFileResource, deviceID, s));
        }
        return ans;
    }

    public long getQueryId() {
        return this.queryId;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public QueryContext setStartTime(long startTime) {
        this.startTime = startTime;
        return this;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public QueryContext setTimeout(long timeout) {
        this.timeout = timeout;
        return this;
    }

    public boolean isInterrupted() {
        return this.isInterrupted;
    }

    public void setInterrupted(boolean interrupted) {
        this.isInterrupted = interrupted;
    }

    public QueryStatistics getQueryStatistics() {
        return this.queryStatistics;
    }

    public void setQueryStatistics(QueryStatistics queryStatistics) {
        this.queryStatistics = queryStatistics;
    }

    public boolean isIgnoreAllNullRows() {
        return this.ignoreAllNullRows;
    }

    public void setIgnoreAllNullRows(boolean ignoreAllNullRows) {
        this.ignoreAllNullRows = ignoreAllNullRows;
    }

    public void addTVListToSet(Map<TVList, Integer> tvListMap) {
        this.tvListSet.addAll(tvListMap.keySet());
    }
}

