/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.protocol.mqtt;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.protocol.mqtt.Message;
import org.apache.iotdb.db.protocol.mqtt.PayloadFormatter;
import org.apache.iotdb.db.protocol.mqtt.TreeMessage;

public class JSONPayloadFormatter
implements PayloadFormatter {
    private static final String JSON_KEY_DEVICE = "device";
    private static final String JSON_KEY_TIMESTAMP = "timestamp";
    private static final String JSON_KEY_TIMESTAMPS = "timestamps";
    private static final String JSON_KEY_MEASUREMENTS = "measurements";
    private static final String JSON_KEY_VALUES = "values";
    private static final Gson GSON = new GsonBuilder().create();

    @Override
    public List<Message> format(ByteBuf payload) {
        if (payload == null) {
            return new ArrayList<Message>();
        }
        String txt = payload.toString(StandardCharsets.UTF_8);
        JsonElement jsonElement = (JsonElement)GSON.fromJson(txt, JsonElement.class);
        if (jsonElement.isJsonObject()) {
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            if (jsonObject.get(JSON_KEY_TIMESTAMP) != null) {
                return this.formatJson(jsonObject);
            }
            if (jsonObject.get(JSON_KEY_TIMESTAMPS) != null) {
                return this.formatBatchJson(jsonObject);
            }
        } else if (jsonElement.isJsonArray()) {
            JsonArray jsonArray = jsonElement.getAsJsonArray();
            ArrayList<Message> messages = new ArrayList<Message>();
            for (JsonElement element : jsonArray) {
                JsonObject jsonObject = element.getAsJsonObject();
                if (jsonObject.get(JSON_KEY_TIMESTAMP) != null) {
                    messages.addAll(this.formatJson(jsonObject));
                }
                if (jsonObject.get(JSON_KEY_TIMESTAMPS) == null) continue;
                messages.addAll(this.formatBatchJson(jsonObject));
            }
            return messages;
        }
        throw new JsonParseException("payload is invalidate");
    }

    private List<Message> formatJson(JsonObject jsonObject) {
        TreeMessage message = new TreeMessage();
        message.setDevice(jsonObject.get(JSON_KEY_DEVICE).getAsString());
        message.setTimestamp(jsonObject.get(JSON_KEY_TIMESTAMP).getAsLong());
        message.setMeasurements((List)GSON.fromJson(jsonObject.get(JSON_KEY_MEASUREMENTS), new TypeToken<List<String>>(){}.getType()));
        message.setValues((List)GSON.fromJson(jsonObject.get(JSON_KEY_VALUES), new TypeToken<List<String>>(){}.getType()));
        return Lists.newArrayList((Object[])new Message[]{message});
    }

    private List<Message> formatBatchJson(JsonObject jsonObject) {
        String device = jsonObject.get(JSON_KEY_DEVICE).getAsString();
        List measurements = (List)GSON.fromJson((JsonElement)jsonObject.getAsJsonArray(JSON_KEY_MEASUREMENTS), new TypeToken<List<String>>(){}.getType());
        List timestamps = (List)GSON.fromJson(jsonObject.get(JSON_KEY_TIMESTAMPS), new TypeToken<List<Long>>(){}.getType());
        List values = (List)GSON.fromJson(jsonObject.get(JSON_KEY_VALUES), new TypeToken<List<List<String>>>(){}.getType());
        ArrayList<Message> ret = new ArrayList<Message>(timestamps.size());
        for (int i = 0; i < timestamps.size(); ++i) {
            TreeMessage message = new TreeMessage();
            message.setDevice(device);
            message.setTimestamp((Long)timestamps.get(i));
            message.setMeasurements(measurements);
            message.setValues((List)values.get(i));
            ret.add(message);
        }
        return ret;
    }

    @Override
    public String getName() {
        return "json";
    }

    @Override
    public String getType() {
        return "tree";
    }
}

