/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.subscription.meta.consumer;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.subscription.meta.consumer.ConsumerMeta;
import org.apache.iotdb.rpc.subscription.exception.SubscriptionException;
import org.apache.thrift.annotation.Nullable;
import org.apache.tsfile.utils.PublicBAOS;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerGroupMeta {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ConsumerGroupMeta.class);
    private String consumerGroupId;
    private long creationTime;
    private Map<String, Set<String>> topicNameToSubscribedConsumerIdSet = new ConcurrentHashMap<String, Set<String>>();
    private Map<String, ConsumerMeta> consumerIdToConsumerMeta = new ConcurrentHashMap<String, ConsumerMeta>();
    private Map<String, Long> topicNameToSubscriptionCreationTime = new ConcurrentHashMap<String, Long>();

    public ConsumerGroupMeta() {
    }

    public ConsumerGroupMeta(String consumerGroupId, long creationTime, ConsumerMeta firstConsumerMeta) {
        this();
        this.consumerGroupId = consumerGroupId;
        this.creationTime = -creationTime;
        this.consumerIdToConsumerMeta.put(firstConsumerMeta.getConsumerId(), firstConsumerMeta);
    }

    public ConsumerGroupMeta deepCopy() {
        ConsumerGroupMeta copied = new ConsumerGroupMeta();
        copied.consumerGroupId = this.consumerGroupId;
        copied.creationTime = this.creationTime;
        copied.topicNameToSubscribedConsumerIdSet = new ConcurrentHashMap<String, Set<String>>(this.topicNameToSubscribedConsumerIdSet);
        copied.consumerIdToConsumerMeta = new ConcurrentHashMap<String, ConsumerMeta>(this.consumerIdToConsumerMeta);
        copied.topicNameToSubscriptionCreationTime = new ConcurrentHashMap<String, Long>(this.topicNameToSubscriptionCreationTime);
        return copied;
    }

    public String getConsumerGroupId() {
        return this.consumerGroupId;
    }

    public long getCreationTime() {
        return Math.abs(this.creationTime);
    }

    private boolean shouldRecordSubscriptionCreationTime() {
        return this.creationTime < 0L;
    }

    public static Set<String> getTopicsUnsubByGroup(ConsumerGroupMeta currentMeta, ConsumerGroupMeta updatedMeta) {
        if (!Objects.equals(currentMeta.consumerGroupId, updatedMeta.consumerGroupId)) {
            return Collections.emptySet();
        }
        if (!Objects.equals(currentMeta.creationTime, updatedMeta.creationTime)) {
            return Collections.emptySet();
        }
        HashSet<String> unsubscribedTopicNames = new HashSet<String>();
        currentMeta.topicNameToSubscribedConsumerIdSet.keySet().forEach(topicName -> {
            if (!updatedMeta.topicNameToSubscribedConsumerIdSet.containsKey(topicName)) {
                unsubscribedTopicNames.add((String)topicName);
            }
        });
        return unsubscribedTopicNames;
    }

    public void checkAuthorityBeforeJoinConsumerGroup(ConsumerMeta consumerMeta) throws SubscriptionException {
        boolean match;
        if (this.isEmpty()) {
            return;
        }
        ConsumerMeta existedConsumerMeta = this.consumerIdToConsumerMeta.values().iterator().next();
        boolean bl = match = Objects.equals(existedConsumerMeta.getUsername(), consumerMeta.getUsername()) && Objects.equals(existedConsumerMeta.getPassword(), consumerMeta.getPassword());
        if (!match) {
            String exceptionMessage = String.format("Failed to create consumer %s because inconsistent username & password under the same consumer group, expected %s:%s, actual %s:%s", consumerMeta.getConsumerId(), existedConsumerMeta.getUsername(), existedConsumerMeta.getPassword(), consumerMeta.getUsername(), consumerMeta.getPassword());
            LOGGER.warn(exceptionMessage);
            throw new SubscriptionException(exceptionMessage);
        }
    }

    public void addConsumer(ConsumerMeta consumerMeta) {
        this.consumerIdToConsumerMeta.put(consumerMeta.getConsumerId(), consumerMeta);
    }

    public void removeConsumer(String consumerId) {
        this.consumerIdToConsumerMeta.remove(consumerId);
        for (Map.Entry<String, Set<String>> entry : this.topicNameToSubscribedConsumerIdSet.entrySet()) {
            entry.getValue().remove(consumerId);
            if (!entry.getValue().isEmpty()) continue;
            this.topicNameToSubscribedConsumerIdSet.remove(entry.getKey());
        }
    }

    public boolean containsConsumer(String consumerId) {
        return this.consumerIdToConsumerMeta.containsKey(consumerId);
    }

    public boolean isEmpty() {
        return this.consumerIdToConsumerMeta.isEmpty();
    }

    public ConsumerMeta getConsumerMeta(String consumerId) {
        return this.consumerIdToConsumerMeta.get(consumerId);
    }

    public Set<String> getConsumersSubscribingTopic(String topic) {
        return this.topicNameToSubscribedConsumerIdSet.getOrDefault(topic, Collections.emptySet());
    }

    public Optional<Long> getSubscriptionTime(String topic) {
        return this.shouldRecordSubscriptionCreationTime() ? Optional.ofNullable(this.topicNameToSubscriptionCreationTime.get(topic)) : Optional.empty();
    }

    public Set<String> getTopicsSubscribedByConsumer(String consumerId) {
        HashSet<String> topics = new HashSet<String>();
        for (Map.Entry<String, Set<String>> topicNameToSubscribedConsumerId : this.topicNameToSubscribedConsumerIdSet.entrySet()) {
            if (!topicNameToSubscribedConsumerId.getValue().contains(consumerId)) continue;
            topics.add(topicNameToSubscribedConsumerId.getKey());
        }
        return topics;
    }

    public boolean isTopicSubscribedByConsumerGroup(String topic) {
        Set<String> subscribedConsumerIdSet = this.topicNameToSubscribedConsumerIdSet.get(topic);
        if (Objects.isNull(subscribedConsumerIdSet)) {
            return false;
        }
        return !subscribedConsumerIdSet.isEmpty();
    }

    public boolean allowSubscribeTopicForConsumer(String topic, String consumerId) {
        if (!this.consumerIdToConsumerMeta.containsKey(consumerId)) {
            return false;
        }
        Set<String> subscribedConsumerIdSet = this.topicNameToSubscribedConsumerIdSet.get(topic);
        if (Objects.isNull(subscribedConsumerIdSet)) {
            return true;
        }
        if (subscribedConsumerIdSet.isEmpty()) {
            return true;
        }
        String subscribedConsumerId = subscribedConsumerIdSet.iterator().next();
        return Objects.equals(Objects.requireNonNull(this.consumerIdToConsumerMeta.get(subscribedConsumerId)).getUsername(), Objects.requireNonNull(this.consumerIdToConsumerMeta.get(consumerId)).getUsername());
    }

    public void addSubscription(String consumerId, Set<String> topics) {
        if (!this.consumerIdToConsumerMeta.containsKey(consumerId)) {
            throw new SubscriptionException(String.format("Failed to add subscription to consumer group meta: consumer %s does not exist in consumer group %s", consumerId, this.consumerGroupId));
        }
        for (String topic : topics) {
            this.topicNameToSubscribedConsumerIdSet.computeIfAbsent(topic, k -> {
                if (this.shouldRecordSubscriptionCreationTime()) {
                    this.topicNameToSubscriptionCreationTime.put(topic, System.currentTimeMillis());
                }
                return new HashSet();
            }).add(consumerId);
        }
    }

    public Set<String> removeSubscription(@Nullable String consumerId, Set<String> topics) {
        if (Objects.isNull(consumerId)) {
            return this.consumerIdToConsumerMeta.keySet().stream().map(id -> this.removeSubscriptionInternal((String)id, topics)).flatMap(Collection::stream).collect(Collectors.toSet());
        }
        return this.removeSubscriptionInternal(consumerId, topics);
    }

    private Set<String> removeSubscriptionInternal(@NonNull String consumerId, Set<String> topics) {
        if (!this.consumerIdToConsumerMeta.containsKey(consumerId)) {
            throw new SubscriptionException(String.format("Failed to remove subscription from consumer group meta: consumer %s does not exist in consumer group %s", consumerId, this.consumerGroupId));
        }
        HashSet<String> noSubscriptionTopicAfterRemoval = new HashSet<String>();
        for (String topic : topics) {
            if (!this.topicNameToSubscribedConsumerIdSet.containsKey(topic)) continue;
            this.topicNameToSubscribedConsumerIdSet.get(topic).remove(consumerId);
            if (!this.topicNameToSubscribedConsumerIdSet.get(topic).isEmpty()) continue;
            noSubscriptionTopicAfterRemoval.add(topic);
            this.topicNameToSubscribedConsumerIdSet.remove(topic);
            if (!this.shouldRecordSubscriptionCreationTime()) continue;
            this.topicNameToSubscriptionCreationTime.remove(topic);
        }
        return noSubscriptionTopicAfterRemoval;
    }

    public ByteBuffer serialize() throws IOException {
        PublicBAOS byteArrayOutputStream = new PublicBAOS();
        DataOutputStream outputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);
        this.serialize(outputStream);
        return ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size());
    }

    public void serialize(OutputStream outputStream) throws IOException {
        ReadWriteIOUtils.write((String)this.consumerGroupId, (OutputStream)outputStream);
        ReadWriteIOUtils.write((long)this.creationTime, (OutputStream)outputStream);
        ReadWriteIOUtils.write((int)this.topicNameToSubscribedConsumerIdSet.size(), (OutputStream)outputStream);
        for (Map.Entry<String, Set<String>> entry : this.topicNameToSubscribedConsumerIdSet.entrySet()) {
            ReadWriteIOUtils.write((String)entry.getKey(), (OutputStream)outputStream);
            ReadWriteIOUtils.write((int)entry.getValue().size(), (OutputStream)outputStream);
            for (String id : entry.getValue()) {
                ReadWriteIOUtils.write((String)id, (OutputStream)outputStream);
            }
        }
        ReadWriteIOUtils.write((int)this.consumerIdToConsumerMeta.size(), (OutputStream)outputStream);
        for (Map.Entry<String, Object> entry : this.consumerIdToConsumerMeta.entrySet()) {
            ReadWriteIOUtils.write((String)entry.getKey(), (OutputStream)outputStream);
            ((ConsumerMeta)entry.getValue()).serialize(outputStream);
        }
        if (this.shouldRecordSubscriptionCreationTime()) {
            ReadWriteIOUtils.write((int)this.topicNameToSubscriptionCreationTime.size(), (OutputStream)outputStream);
            for (Map.Entry<String, Object> entry : this.topicNameToSubscriptionCreationTime.entrySet()) {
                ReadWriteIOUtils.write((String)entry.getKey(), (OutputStream)outputStream);
                ReadWriteIOUtils.write((long)((Long)entry.getValue()), (OutputStream)outputStream);
            }
        }
    }

    public static ConsumerGroupMeta deserialize(InputStream inputStream) throws IOException {
        Object value;
        String key;
        int i;
        ConsumerGroupMeta consumerGroupMeta = new ConsumerGroupMeta();
        consumerGroupMeta.consumerGroupId = ReadWriteIOUtils.readString((InputStream)inputStream);
        consumerGroupMeta.creationTime = ReadWriteIOUtils.readLong((InputStream)inputStream);
        consumerGroupMeta.topicNameToSubscribedConsumerIdSet = new ConcurrentHashMap<String, Set<String>>();
        int size = ReadWriteIOUtils.readInt((InputStream)inputStream);
        for (i = 0; i < size; ++i) {
            key = ReadWriteIOUtils.readString((InputStream)inputStream);
            value = new HashSet<String>();
            int innerSize = ReadWriteIOUtils.readInt((InputStream)inputStream);
            for (int j = 0; j < innerSize; ++j) {
                value.add(ReadWriteIOUtils.readString((InputStream)inputStream));
            }
            consumerGroupMeta.topicNameToSubscribedConsumerIdSet.put(key, (Set<String>)value);
        }
        consumerGroupMeta.consumerIdToConsumerMeta = new ConcurrentHashMap<String, ConsumerMeta>();
        size = ReadWriteIOUtils.readInt((InputStream)inputStream);
        for (i = 0; i < size; ++i) {
            key = ReadWriteIOUtils.readString((InputStream)inputStream);
            value = ConsumerMeta.deserialize(inputStream);
            consumerGroupMeta.consumerIdToConsumerMeta.put(key, (ConsumerMeta)value);
        }
        consumerGroupMeta.topicNameToSubscriptionCreationTime = new ConcurrentHashMap<String, Long>();
        if (consumerGroupMeta.shouldRecordSubscriptionCreationTime()) {
            size = ReadWriteIOUtils.readInt((InputStream)inputStream);
            for (i = 0; i < size; ++i) {
                key = ReadWriteIOUtils.readString((InputStream)inputStream);
                long value2 = ReadWriteIOUtils.readLong((InputStream)inputStream);
                consumerGroupMeta.topicNameToSubscriptionCreationTime.put(key, value2);
            }
        }
        return consumerGroupMeta;
    }

    public static ConsumerGroupMeta deserialize(ByteBuffer byteBuffer) {
        Object value;
        String key;
        int i;
        ConsumerGroupMeta consumerGroupMeta = new ConsumerGroupMeta();
        consumerGroupMeta.consumerGroupId = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
        consumerGroupMeta.creationTime = ReadWriteIOUtils.readLong((ByteBuffer)byteBuffer);
        consumerGroupMeta.topicNameToSubscribedConsumerIdSet = new ConcurrentHashMap<String, Set<String>>();
        int size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        for (i = 0; i < size; ++i) {
            key = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
            value = new HashSet<String>();
            int innerSize = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
            for (int j = 0; j < innerSize; ++j) {
                value.add(ReadWriteIOUtils.readString((ByteBuffer)byteBuffer));
            }
            consumerGroupMeta.topicNameToSubscribedConsumerIdSet.put(key, (Set<String>)value);
        }
        consumerGroupMeta.consumerIdToConsumerMeta = new ConcurrentHashMap<String, ConsumerMeta>();
        size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        for (i = 0; i < size; ++i) {
            key = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
            value = ConsumerMeta.deserialize(byteBuffer);
            consumerGroupMeta.consumerIdToConsumerMeta.put(key, (ConsumerMeta)value);
        }
        consumerGroupMeta.topicNameToSubscriptionCreationTime = new ConcurrentHashMap<String, Long>();
        if (consumerGroupMeta.shouldRecordSubscriptionCreationTime()) {
            size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
            for (i = 0; i < size; ++i) {
                key = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
                long value2 = ReadWriteIOUtils.readLong((ByteBuffer)byteBuffer);
                consumerGroupMeta.topicNameToSubscriptionCreationTime.put(key, value2);
            }
        }
        return consumerGroupMeta;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ConsumerGroupMeta that = (ConsumerGroupMeta)obj;
        return Objects.equals(this.consumerGroupId, that.consumerGroupId) && this.creationTime == that.creationTime && Objects.equals(this.topicNameToSubscribedConsumerIdSet, that.topicNameToSubscribedConsumerIdSet) && Objects.equals(this.consumerIdToConsumerMeta, that.consumerIdToConsumerMeta) && Objects.equals(this.topicNameToSubscriptionCreationTime, that.topicNameToSubscriptionCreationTime);
    }

    public int hashCode() {
        return Objects.hash(this.consumerGroupId, this.creationTime, this.topicNameToSubscribedConsumerIdSet, this.consumerIdToConsumerMeta, this.topicNameToSubscriptionCreationTime);
    }

    public String toString() {
        return "ConsumerGroupMeta{consumerGroupId='" + this.consumerGroupId + "', creationTime=" + this.getCreationTime() + ", topicNameToSubscribedConsumerIdSet=" + this.topicNameToSubscribedConsumerIdSet + ", consumerIdToConsumerMeta=" + this.consumerIdToConsumerMeta + ", topicNameToSubscriptionCreationTime=" + this.topicNameToSubscriptionCreationTime + "}";
    }
}

