/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.schema.filter.impl;

import java.util.Objects;
import org.apache.iotdb.commons.schema.filter.SchemaFilter;
import org.apache.iotdb.commons.schema.filter.SchemaFilterVisitor;
import org.apache.iotdb.commons.schema.filter.impl.singlechild.AttributeFilter;
import org.apache.iotdb.commons.schema.filter.impl.singlechild.IdFilter;
import org.apache.iotdb.commons.schema.filter.impl.values.ComparisonFilter;
import org.apache.iotdb.commons.schema.filter.impl.values.InFilter;
import org.apache.iotdb.commons.schema.filter.impl.values.LikeFilter;
import org.apache.iotdb.commons.schema.filter.impl.values.PreciseFilter;
import org.apache.tsfile.common.conf.TSFileConfig;

public class StringValueFilterVisitor
extends SchemaFilterVisitor<String> {
    @Override
    protected Boolean visitNode(SchemaFilter filter, String context) {
        return true;
    }

    @Override
    public Boolean visitPreciseFilter(PreciseFilter filter, String context) {
        return Objects.equals(filter.getValue(), context);
    }

    @Override
    public Boolean visitComparisonFilter(ComparisonFilter filter, String context) {
        if (Objects.isNull(context)) {
            return null;
        }
        int result = context.compareTo(filter.getValue());
        switch (filter.getOperator()) {
            case NOT_EQUAL: {
                return result != 0;
            }
            case LESS_THAN: {
                return result < 0;
            }
            case LESS_THAN_OR_EQUAL: {
                return result <= 0;
            }
            case GREATER_THAN: {
                return result > 0;
            }
            case GREATER_THAN_OR_EQUAL: {
                return result >= 0;
            }
        }
        return false;
    }

    @Override
    public Boolean visitInFilter(InFilter filter, String context) {
        if (Objects.isNull(context)) {
            return null;
        }
        return filter.getValues().contains(context);
    }

    @Override
    public Boolean visitLikeFilter(LikeFilter filter, String context) {
        if (Objects.isNull(context)) {
            return null;
        }
        byte[] bytes = context.getBytes(TSFileConfig.STRING_CHARSET);
        return filter.getPattern().getMatcher().match(bytes, 0, bytes.length);
    }

    @Override
    public Boolean visitIdFilter(IdFilter filter, String context) {
        return filter.getChild().accept(this, context);
    }

    @Override
    public Boolean visitAttributeFilter(AttributeFilter filter, String context) {
        return filter.getChild().accept(this, context);
    }

    public static StringValueFilterVisitor getInstance() {
        return StringValueFilterVisitorContainer.instance;
    }

    private StringValueFilterVisitor() {
    }

    private static class StringValueFilterVisitorContainer {
        private static final StringValueFilterVisitor instance = new StringValueFilterVisitor();

        private StringValueFilterVisitorContainer() {
        }
    }
}

