/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.pipe.extractor;

import java.io.IOException;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.iotdb.commons.auth.entity.PrivilegeType;
import org.apache.iotdb.commons.auth.entity.PrivilegeUnion;
import org.apache.iotdb.commons.consensus.ConfigRegionId;
import org.apache.iotdb.commons.consensus.ConsensusGroupId;
import org.apache.iotdb.commons.exception.auth.AccessDeniedException;
import org.apache.iotdb.commons.pipe.agent.task.progress.PipeEventCommitManager;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.commons.pipe.datastructure.pattern.IoTDBTreePattern;
import org.apache.iotdb.commons.pipe.datastructure.pattern.TablePattern;
import org.apache.iotdb.commons.pipe.datastructure.queue.listening.AbstractPipeListeningQueue;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.commons.pipe.event.PipeSnapshotEvent;
import org.apache.iotdb.commons.pipe.event.PipeWritePlanEvent;
import org.apache.iotdb.commons.pipe.extractor.IoTDBNonDataRegionExtractor;
import org.apache.iotdb.commons.utils.PathUtils;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;
import org.apache.iotdb.confignode.consensus.request.write.database.DatabaseSchemaPlan;
import org.apache.iotdb.confignode.consensus.request.write.database.DeleteDatabasePlan;
import org.apache.iotdb.confignode.manager.PermissionManager;
import org.apache.iotdb.confignode.manager.pipe.agent.PipeConfigNodeAgent;
import org.apache.iotdb.confignode.manager.pipe.event.PipeConfigRegionSnapshotEvent;
import org.apache.iotdb.confignode.manager.pipe.event.PipeConfigRegionWritePlanEvent;
import org.apache.iotdb.confignode.manager.pipe.extractor.ConfigRegionListeningFilter;
import org.apache.iotdb.confignode.manager.pipe.extractor.PipeConfigPhysicalPlanTablePatternParseVisitor;
import org.apache.iotdb.confignode.manager.pipe.extractor.PipeConfigPhysicalPlanTablePrivilegeParseVisitor;
import org.apache.iotdb.confignode.manager.pipe.extractor.PipeConfigPhysicalPlanTableScopeParseVisitor;
import org.apache.iotdb.confignode.manager.pipe.extractor.PipeConfigPhysicalPlanTreePatternParseVisitor;
import org.apache.iotdb.confignode.manager.pipe.extractor.PipeConfigPhysicalPlanTreeScopeParseVisitor;
import org.apache.iotdb.confignode.manager.pipe.metric.overview.PipeConfigNodeRemainingTimeMetrics;
import org.apache.iotdb.confignode.manager.pipe.metric.source.PipeConfigRegionExtractorMetrics;
import org.apache.iotdb.confignode.persistence.schema.CNPhysicalPlanGenerator;
import org.apache.iotdb.confignode.persistence.schema.ConfigNodeSnapshotParser;
import org.apache.iotdb.confignode.service.ConfigNode;
import org.apache.iotdb.consensus.exception.ConsensusException;
import org.apache.iotdb.pipe.api.annotation.TableModel;
import org.apache.iotdb.pipe.api.annotation.TreeModel;
import org.apache.iotdb.pipe.api.customizer.configuration.PipeExtractorRuntimeConfiguration;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.iotdb.rpc.TSStatusCode;

@TreeModel
@TableModel
public class IoTDBConfigRegionExtractor
extends IoTDBNonDataRegionExtractor {
    public static final PipeConfigPhysicalPlanTreePatternParseVisitor TREE_PATTERN_PARSE_VISITOR = new PipeConfigPhysicalPlanTreePatternParseVisitor();
    public static final PipeConfigPhysicalPlanTablePatternParseVisitor TABLE_PATTERN_PARSE_VISITOR = new PipeConfigPhysicalPlanTablePatternParseVisitor();
    public static final PipeConfigPhysicalPlanTreeScopeParseVisitor TREE_SCOPE_PARSE_VISITOR = new PipeConfigPhysicalPlanTreeScopeParseVisitor();
    public static final PipeConfigPhysicalPlanTableScopeParseVisitor TABLE_SCOPE_PARSE_VISITOR = new PipeConfigPhysicalPlanTableScopeParseVisitor();
    public static final PipeConfigPhysicalPlanTablePrivilegeParseVisitor TABLE_PRIVILEGE_PARSE_VISITOR = new PipeConfigPhysicalPlanTablePrivilegeParseVisitor();
    private Set<ConfigPhysicalPlanType> listenedTypeSet = new HashSet<ConfigPhysicalPlanType>();
    private CNPhysicalPlanGenerator parser;

    public void customize(PipeParameters parameters, PipeExtractorRuntimeConfiguration configuration) throws Exception {
        if (ConfigNodeDescriptor.getInstance().getConf().getConfigNodeConsensusProtocolClass().equals("org.apache.iotdb.consensus.simple.SimpleConsensus")) {
            throw new PipeException("IoTDBConfigRegionExtractor does not transferring events under simple consensus");
        }
        super.customize(parameters, configuration);
        this.listenedTypeSet = ConfigRegionListeningFilter.parseListeningPlanTypeSet(parameters);
        PipeConfigRegionExtractorMetrics.getInstance().register(this);
        PipeConfigNodeRemainingTimeMetrics.getInstance().register(this);
    }

    protected AbstractPipeListeningQueue getListeningQueue() {
        return PipeConfigNodeAgent.runtime().listener();
    }

    protected boolean needTransferSnapshot() {
        return PipeConfigRegionSnapshotEvent.needTransferSnapshot(this.listenedTypeSet);
    }

    protected void triggerSnapshot() {
        try {
            ConfigNode.getInstance().getConfigManager().getConsensusManager().getConsensusImpl().triggerSnapshot((ConsensusGroupId)new ConfigRegionId(ConfigNodeDescriptor.getInstance().getConf().getConfigRegionId()), true);
        }
        catch (ConsensusException e) {
            throw new PipeException("Exception encountered when triggering schema region snapshot.", (Throwable)e);
        }
    }

    public synchronized EnrichedEvent supply() throws Exception {
        EnrichedEvent event = super.supply();
        PipeEventCommitManager.getInstance().enrichWithCommitterKeyAndCommitId(event, this.creationTime, this.regionId);
        return event;
    }

    protected long getMaxBlockingTimeMs() {
        return PipeConfig.getInstance().getPipeSubtaskExecutorPendingQueueMaxBlockingTimeMs();
    }

    protected boolean canSkipSnapshotPrivilegeCheck(PipeSnapshotEvent event) {
        PermissionManager permissionManager = ConfigNode.getInstance().getConfigManager().getPermissionManager();
        switch (((PipeConfigRegionSnapshotEvent)event).getFileType()) {
            case USER: {
                return !this.tablePattern.isTableModelDataAllowedToBeCaptured() || Objects.nonNull(this.userName) && permissionManager.checkUserPrivileges(this.userName, new PrivilegeUnion(PrivilegeType.MANAGE_USER)).getStatus().getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode();
            }
            case ROLE: {
                return !this.tablePattern.isTableModelDataAllowedToBeCaptured() || Objects.nonNull(this.userName) && permissionManager.checkUserPrivileges(this.userName, new PrivilegeUnion(PrivilegeType.MANAGE_ROLE)).getStatus().getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode();
            }
            case USER_ROLE: {
                return !this.tablePattern.isTableModelDataAllowedToBeCaptured() || Objects.nonNull(this.userName) && permissionManager.checkUserPrivileges(this.userName, new PrivilegeUnion(PrivilegeType.MANAGE_ROLE)).getStatus().getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() || Objects.nonNull(this.userName) && permissionManager.checkUserPrivileges(this.userName, new PrivilegeUnion(PrivilegeType.MANAGE_USER)).getStatus().getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode();
            }
            case SCHEMA: {
                return Objects.nonNull(((PipeConfigRegionSnapshotEvent)event).getTemplateFile()) || Objects.nonNull(this.userName) && permissionManager.checkUserPrivileges(this.userName, new PrivilegeUnion(null, false, true)).getStatus().getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode();
            }
        }
        return true;
    }

    protected void initSnapshotGenerator(PipeSnapshotEvent event) throws IOException {
        PipeConfigRegionSnapshotEvent snapshotEvent = (PipeConfigRegionSnapshotEvent)event;
        this.parser = ConfigNodeSnapshotParser.translate2PhysicalPlan(Paths.get(snapshotEvent.getSnapshotFile().getPath(), new String[0]), Objects.nonNull(snapshotEvent.getTemplateFile()) ? Paths.get(snapshotEvent.getTemplateFile().getPath(), new String[0]) : null, snapshotEvent.getFileType());
    }

    protected boolean hasNextEventInCurrentSnapshot() {
        return Objects.nonNull(this.parser) && this.parser.hasNext();
    }

    protected PipeWritePlanEvent getNextEventInCurrentSnapshot() {
        return new PipeConfigRegionWritePlanEvent(this.parser.next(), false);
    }

    protected Optional<PipeWritePlanEvent> trimRealtimeEventByPrivilege(PipeWritePlanEvent event) {
        ConfigPhysicalPlan plan = ((PipeConfigRegionWritePlanEvent)event).getConfigPhysicalPlan();
        Boolean isTableDatabasePlan = IoTDBConfigRegionExtractor.isTableDatabasePlan(plan);
        if (Boolean.FALSE.equals(isTableDatabasePlan)) {
            return Optional.of(event);
        }
        Optional result = (Optional)TABLE_PRIVILEGE_PARSE_VISITOR.process(plan, this.userName);
        if (result.isPresent()) {
            return Optional.of(new PipeConfigRegionWritePlanEvent((ConfigPhysicalPlan)result.get(), event.isGeneratedByPipe()));
        }
        if (this.skipIfNoPrivileges) {
            return Optional.empty();
        }
        throw new AccessDeniedException("Not has privilege to transfer plan: " + plan);
    }

    protected Optional<PipeWritePlanEvent> trimRealtimeEventByPipePattern(PipeWritePlanEvent event) {
        return IoTDBConfigRegionExtractor.parseConfigPlan(((PipeConfigRegionWritePlanEvent)event).getConfigPhysicalPlan(), this.treePattern, this.tablePattern).map(configPhysicalPlan -> new PipeConfigRegionWritePlanEvent((ConfigPhysicalPlan)configPhysicalPlan, event.isGeneratedByPipe()));
    }

    public static Optional<ConfigPhysicalPlan> parseConfigPlan(ConfigPhysicalPlan plan, IoTDBTreePattern treePattern, TablePattern tablePattern) {
        Optional result = Optional.of(plan);
        Boolean isTableDatabasePlan = IoTDBConfigRegionExtractor.isTableDatabasePlan(plan);
        if (!Boolean.TRUE.equals(isTableDatabasePlan) && !(result = (Optional)TREE_PATTERN_PARSE_VISITOR.process(plan, treePattern)).isPresent()) {
            return result;
        }
        if (!Boolean.FALSE.equals(isTableDatabasePlan) && !(result = (Optional)TABLE_PATTERN_PARSE_VISITOR.process((ConfigPhysicalPlan)result.get(), tablePattern)).isPresent()) {
            return result;
        }
        if (!treePattern.isTreeModelDataAllowedToBeCaptured() && !(result = (Optional)TREE_SCOPE_PARSE_VISITOR.process((ConfigPhysicalPlan)result.get(), null)).isPresent()) {
            return result;
        }
        if (!tablePattern.isTableModelDataAllowedToBeCaptured() && !(result = (Optional)TABLE_SCOPE_PARSE_VISITOR.process((ConfigPhysicalPlan)result.get(), null)).isPresent()) {
            return result;
        }
        return result;
    }

    protected boolean isTypeListened(PipeWritePlanEvent event) {
        return IoTDBConfigRegionExtractor.isTypeListened(((PipeConfigRegionWritePlanEvent)event).getConfigPhysicalPlan(), this.listenedTypeSet, this.treePattern, this.tablePattern);
    }

    public static boolean isTypeListened(ConfigPhysicalPlan plan, Set<ConfigPhysicalPlanType> listenedTypeSet, IoTDBTreePattern treePattern, TablePattern tablePattern) {
        Boolean isTableDatabasePlan = IoTDBConfigRegionExtractor.isTableDatabasePlan(plan);
        return listenedTypeSet.contains((Object)plan.getType()) && (Objects.isNull(isTableDatabasePlan) || Boolean.TRUE.equals(isTableDatabasePlan) && tablePattern.isTableModelDataAllowedToBeCaptured() || Boolean.FALSE.equals(isTableDatabasePlan) && treePattern.isTreeModelDataAllowedToBeCaptured());
    }

    private static Boolean isTableDatabasePlan(ConfigPhysicalPlan plan) {
        if (plan instanceof DatabaseSchemaPlan) {
            return ((DatabaseSchemaPlan)plan).getSchema().isIsTableModel() ? Boolean.TRUE : Boolean.FALSE;
        }
        if (plan instanceof DeleteDatabasePlan) {
            return PathUtils.isTableModelDatabase((String)((DeleteDatabasePlan)plan).getName()) ? Boolean.TRUE : Boolean.FALSE;
        }
        return null;
    }

    protected void confineHistoricalEventTransferTypes(PipeSnapshotEvent event) {
        ((PipeConfigRegionSnapshotEvent)event).confineTransferredTypes(this.listenedTypeSet);
    }

    public synchronized void close() throws Exception {
        if (this.hasBeenClosed.get()) {
            return;
        }
        this.hasBeenClosed.set(true);
        if (!this.hasBeenStarted.get()) {
            return;
        }
        super.close();
        if (Objects.nonNull(this.taskID)) {
            PipeConfigRegionExtractorMetrics.getInstance().deregister(this.taskID);
            PipeConfigNodeRemainingTimeMetrics.getInstance().deregister(this.pipeName + "_" + this.creationTime);
        }
    }
}

