/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request.write.table;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.iotdb.commons.schema.table.column.TsTableColumnSchema;
import org.apache.iotdb.commons.schema.table.column.TsTableColumnSchemaUtil;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;
import org.apache.iotdb.confignode.consensus.request.write.table.AbstractTablePlan;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class AddTableColumnPlan
extends AbstractTablePlan {
    private List<TsTableColumnSchema> columnSchemaList;
    private boolean isRollback;

    public AddTableColumnPlan() {
        super(ConfigPhysicalPlanType.AddTableColumn);
    }

    public AddTableColumnPlan(String database, String tableName, List<TsTableColumnSchema> columnSchemaList, boolean isRollback) {
        super(ConfigPhysicalPlanType.AddTableColumn, database, tableName);
        this.columnSchemaList = columnSchemaList;
        this.isRollback = isRollback;
    }

    public List<TsTableColumnSchema> getColumnSchemaList() {
        return this.columnSchemaList;
    }

    public boolean isRollback() {
        return this.isRollback;
    }

    @Override
    protected void serializeImpl(DataOutputStream stream) throws IOException {
        super.serializeImpl(stream);
        TsTableColumnSchemaUtil.serialize(this.columnSchemaList, (OutputStream)stream);
        ReadWriteIOUtils.write((Boolean)this.isRollback, (OutputStream)stream);
    }

    @Override
    protected void deserializeImpl(ByteBuffer buffer) throws IOException {
        super.deserializeImpl(buffer);
        this.columnSchemaList = TsTableColumnSchemaUtil.deserializeColumnSchemaList((ByteBuffer)buffer);
        this.isRollback = ReadWriteIOUtils.readBool((ByteBuffer)buffer);
    }
}

