/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.utils;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.tsfile.file.IMetadataIndexEntry;
import org.apache.tsfile.file.header.ChunkGroupHeader;
import org.apache.tsfile.file.header.PageHeader;
import org.apache.tsfile.file.metadata.ChunkGroupMetadata;
import org.apache.tsfile.file.metadata.ChunkMetadata;
import org.apache.tsfile.file.metadata.DeviceMetadataIndexEntry;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.file.metadata.MetadataIndexNode;
import org.apache.tsfile.file.metadata.TableSchema;
import org.apache.tsfile.file.metadata.TimeseriesMetadata;
import org.apache.tsfile.file.metadata.TsFileMetadata;
import org.apache.tsfile.file.metadata.enums.MetadataIndexNodeType;
import org.apache.tsfile.fileSystem.FSFactoryProducer;
import org.apache.tsfile.read.TsFileSequenceReader;
import org.apache.tsfile.read.common.Chunk;
import org.apache.tsfile.read.common.Path;
import org.apache.tsfile.utils.BloomFilter;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.utils.ReadWriteForEncodingUtils;
import org.apache.tsfile.write.schema.Schema;

public class TsFileSketchTool {
    private String filename;
    private PrintWriter pw;
    private TsFileSketchToolReader reader;
    private String splitStr;
    TsFileMetadata tsFileMetaData;
    List<ChunkGroupMetadata> allChunkGroupMetadata;

    public static void main(String[] args) throws IOException {
        Pair<String, String> fileNames = TsFileSketchTool.checkArgs(args);
        String filename = (String)fileNames.left;
        String outFile = (String)fileNames.right;
        System.out.println("TsFile path:" + filename);
        System.out.println("Sketch save path:" + outFile);
        new TsFileSketchTool(filename, outFile).run();
    }

    public TsFileSketchTool(String filename, String outFile) {
        try {
            this.filename = filename;
            this.pw = new PrintWriter(new FileWriter(outFile));
            this.reader = new TsFileSketchToolReader(filename);
            StringBuilder str1 = new StringBuilder();
            for (int i = 0; i < 21; ++i) {
                str1.append("|");
            }
            this.splitStr = str1.toString();
            this.tsFileMetaData = this.reader.readFileMetadata();
            this.allChunkGroupMetadata = new ArrayList<ChunkGroupMetadata>();
            if (this.reader.selfCheck(new Schema(), this.allChunkGroupMetadata, false) != 0L) {
                throw new IOException(String.format("Cannot load file %s because the file has crashed.", filename));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void run() throws IOException {
        Map.Entry value2;
        long length = FSFactoryProducer.getFSFactory().getFile(this.filename).length();
        this.printlnBoth(this.pw, "-------------------------------- TsFile Sketch --------------------------------");
        this.printlnBoth(this.pw, "file path: " + this.filename);
        this.printlnBoth(this.pw, "file length: " + length);
        this.printFileInfo();
        this.printChunk(this.allChunkGroupMetadata);
        if (this.tsFileMetaData.getTableMetadataIndexNodeMap().isEmpty()) {
            this.printlnBoth(this.pw, String.format("%20s", this.reader.getFileMetadataPos() - 1L) + "|\t[marker] 2");
        } else {
            this.printlnBoth(this.pw, String.format("%20s", this.reader.readFileMetadata().getMetaOffset()) + "|\t[marker] 2");
        }
        Map<Long, Pair<Path, TimeseriesMetadata>> timeseriesMetadataMap = this.reader.getAllTimeseriesMetadataWithOffset();
        TreeMap<Long, MetadataIndexNode> metadataIndexNodeMap = new TreeMap<Long, MetadataIndexNode>();
        ArrayList<String> treeOutputStringBuffer = new ArrayList<String>();
        for (Map.Entry<String, MetadataIndexNode> entry : this.tsFileMetaData.getTableMetadataIndexNodeMap().entrySet()) {
            treeOutputStringBuffer.add(entry.getKey());
            this.loadIndexTree(entry.getValue(), metadataIndexNodeMap, treeOutputStringBuffer, 0);
        }
        Iterator<Map.Entry<Long, Pair<Path, TimeseriesMetadata>>> ite1 = timeseriesMetadataMap.entrySet().iterator();
        Iterator ite2 = metadataIndexNodeMap.entrySet().iterator();
        Map.Entry<Long, Pair<Path, TimeseriesMetadata>> value1 = ite1.hasNext() ? ite1.next() : null;
        Map.Entry entry = value2 = ite2.hasNext() ? ite2.next() : null;
        while (value1 != null || value2 != null) {
            if (value2 == null || value1 != null && value1.getKey().compareTo((Long)value2.getKey()) <= 0) {
                this.printTimeseriesIndex(value1.getKey(), value1.getValue());
                value1 = ite1.hasNext() ? ite1.next() : null;
                continue;
            }
            this.printIndexOfTimerseriesIndex((Long)value2.getKey(), (MetadataIndexNode)value2.getValue());
            value2 = ite2.hasNext() ? ite2.next() : null;
        }
        this.printTsFileMetadata(this.tsFileMetaData);
        this.printlnBoth(this.pw, String.format("%20s", length) + "|\tEND of TsFile");
        this.printlnBoth(this.pw, "---------------------------- IndexOfTimerseriesIndex Tree -----------------------------");
        for (String str : treeOutputStringBuffer) {
            this.printlnBoth(this.pw, str);
        }
        this.printlnBoth(this.pw, "---------------------------------- TsFile Sketch End ----------------------------------");
        this.reader.close();
        this.pw.close();
    }

    public void close() throws IOException {
        this.reader.close();
        this.pw.close();
    }

    private void printTsFileMetadata(TsFileMetadata tsFileMetaData) {
        try {
            long pos = this.reader.getFileMetadataPos();
            this.printlnBoth(this.pw, this.splitStr + " [TsFileMetadata] begins");
            this.printlnBoth(this.pw, String.format("%20s", pos) + "|\tTableIndexRootCnt=" + tsFileMetaData.getTableMetadataIndexNodeMap().size());
            pos += 4L;
            for (Map.Entry<String, MetadataIndexNode> entry : tsFileMetaData.getTableMetadataIndexNodeMap().entrySet()) {
                this.printlnBoth(this.pw, String.format("%20s", pos) + "|\t[Table Name] " + entry.getKey() + ", size=" + ReadWriteForEncodingUtils.intStringSize(entry.getKey()));
                pos += (long)ReadWriteForEncodingUtils.intStringSize(entry.getKey());
                pos = this.printIndexOfTimerseriesIndex(pos, entry.getValue());
            }
            Map<String, TableSchema> tableSchemaMap = this.reader.getTableSchemaMap();
            this.printlnBoth(this.pw, String.format("%20s", pos) + "|\tTableSchemaCnt=" + tableSchemaMap.size());
            pos += 4L;
            for (Map.Entry<String, TableSchema> entry : tableSchemaMap.entrySet()) {
                String tableName = entry.getKey();
                TableSchema tableSchema = entry.getValue();
                int serializedSize = tableSchema.serializedSize();
                this.printlnBoth(this.pw, String.format("%20s", pos) + "|\t[TableSchema] " + tableSchema + ", size=" + serializedSize);
                pos += (long)(ReadWriteForEncodingUtils.intStringSize(tableName) + serializedSize);
            }
            this.printlnBoth(this.pw, String.format("%20s", pos) + "|\t[Meta Offset] " + tsFileMetaData.getMetaOffset());
            pos += 8L;
            BloomFilter bloomFilter = tsFileMetaData.getBloomFilter();
            if (bloomFilter != null) {
                int n = bloomFilter.serialize().length;
                this.printlnBoth(this.pw, String.format("%20s", pos) + "|\t[Bloom Filter Size] bit vector byte array length=" + n + bloomFilter.getHashFunctionSize());
                this.printlnBoth(this.pw, String.format("%20s", pos += 4L) + "|\t[Bloom Filter] , filterCapacity=" + bloomFilter.getSize() + ", hashFunctionSize=" + bloomFilter.getHashFunctionSize());
                pos += (long)n;
            }
            this.printlnBoth(this.pw, this.splitStr + " [TsFileMetadata] ends");
            this.printlnBoth(this.pw, String.format("%20s", this.reader.getFileMetadataPos() + (long)this.reader.getTsFileMetadataSize()) + "|\t[TsFileMetadataSize] " + this.reader.getTsFileMetadataSize());
            this.printlnBoth(this.pw, String.format("%20s", this.reader.getFileMetadataPos() + (long)this.reader.getTsFileMetadataSize() + 4L) + "|\t[magic tail] " + this.reader.readTailMagic());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private long printIndexOfTimerseriesIndex(long pos, MetadataIndexNode metadataIndexNode) {
        this.printlnBoth(this.pw, String.format("%20s", pos) + "|\t[MetadataIndexNode]");
        this.printlnBoth(this.pw, String.format("%20s", pos) + "|\t\t childrenCnt=" + metadataIndexNode.getChildren().size());
        pos += (long)ReadWriteForEncodingUtils.uVarIntSize(metadataIndexNode.getChildren().size());
        for (IMetadataIndexEntry metadataIndexEntry : metadataIndexNode.getChildren()) {
            this.printlnBoth(this.pw, String.format("%20s", pos) + "|\t\t<" + metadataIndexEntry.getCompareKey() + ", " + metadataIndexEntry.getOffset() + ">");
            pos += (long)metadataIndexEntry.serializedSize();
        }
        this.printlnBoth(this.pw, String.format("%20s", pos) + "|\t\tendOffset=" + metadataIndexNode.getEndOffset());
        this.printlnBoth(this.pw, String.format("%20s", pos += 8L) + "|\t\tnodeType=" + (Object)((Object)metadataIndexNode.getNodeType()));
        return ++pos;
    }

    private void printFileInfo() {
        try {
            this.printlnBoth(this.pw, "");
            this.printlnBoth(this.pw, String.format("%20s", "POSITION") + "|\tCONTENT");
            this.printlnBoth(this.pw, String.format("%20s", "--------") + " \t-------");
            this.printlnBoth(this.pw, String.format("%20d", 0) + "|\t[magic head] " + this.reader.readHeadMagic());
            this.printlnBoth(this.pw, String.format("%20d", "TsFile".getBytes().length) + "|\t[version number] " + this.reader.readVersionNumber());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void printChunk(List<ChunkGroupMetadata> allChunkGroupMetadata) {
        try {
            long nextChunkGroupHeaderPos = (long)"TsFile".getBytes().length + 1L;
            for (ChunkGroupMetadata chunkGroupMetadata : allChunkGroupMetadata) {
                this.printlnBoth(this.pw, this.splitStr + " [ChunkGroup] of " + chunkGroupMetadata.getDevice() + ", num of Chunks:" + chunkGroupMetadata.getChunkMetadataList().size());
                long offset = nextChunkGroupHeaderPos;
                this.printlnBoth(this.pw, String.format("%20s", offset) + "|\t[ChunkGroup Header]");
                ChunkGroupHeader chunkGroupHeader = this.reader.readChunkGroupHeader(nextChunkGroupHeaderPos, false);
                this.printlnBoth(this.pw, String.format("%20s", offset) + "|\t\t[marker] 0");
                this.printlnBoth(this.pw, String.format("%20s", offset + 1L) + "|\t\t[deviceID] " + chunkGroupHeader.getDeviceID() + " size=" + chunkGroupHeader.getDeviceID().serializedSize());
                for (ChunkMetadata chunkMetadata : chunkGroupMetadata.getChunkMetadataList()) {
                    PageHeader pageHeader;
                    offset = chunkMetadata.getOffsetOfChunkHeader();
                    Chunk chunk = this.reader.readMemChunk(chunkMetadata);
                    this.printlnBoth(this.pw, String.format("%20d", offset) + "|\t[Chunk] of " + new Path(chunkGroupHeader.getDeviceID(), chunkMetadata.getMeasurementUid(), false) + ", " + chunkMetadata.getStatistics());
                    this.printlnBoth(this.pw, String.format("%20s", offset) + "|\t\t[Chunk Header] marker=" + chunk.getHeader().getChunkType() + ", measurementID=" + chunk.getHeader().getMeasurementID() + ", dataSize=" + chunk.getHeader().getDataSize() + ", dataType=" + chunk.getHeader().getDataType() + ", compressionType=" + (Object)((Object)chunk.getHeader().getCompressionType()) + ", encodingType=" + (Object)((Object)chunk.getHeader().getEncodingType()) + ", size=" + chunk.getHeader().getSerializedSize());
                    offset += (long)chunk.getHeader().getSerializedSize();
                    if ((byte)(chunk.getHeader().getChunkType() & 0x3F) == 5) {
                        pageHeader = PageHeader.deserializeFrom(chunk.getData(), chunkMetadata.getStatistics());
                        this.printlnBoth(this.pw, String.format("%20s", offset) + "|\t\t\t[Page Header]  HeaderSize:" + (pageHeader.getSerializedSize() - pageHeader.getStatistics().getSerializedSize()) + ", UncompressedSize:" + pageHeader.getUncompressedSize() + ", CompressedSize:" + pageHeader.getCompressedSize());
                        this.printlnBoth(this.pw, String.format("%20s", offset += (long)(pageHeader.getSerializedSize() - pageHeader.getStatistics().getSerializedSize())) + "|\t\t\t[Page Data]  Size:" + pageHeader.getCompressedSize());
                    } else {
                        ByteBuffer chunkDataBuffer = chunk.getData();
                        int pageID = 0;
                        while (chunkDataBuffer.remaining() > 0) {
                            pageHeader = PageHeader.deserializeFrom(chunkDataBuffer, chunk.getHeader().getDataType());
                            chunkDataBuffer.position(chunkDataBuffer.position() + pageHeader.getCompressedSize());
                            this.printlnBoth(this.pw, String.format("%20s", offset) + String.format("|\t\t\t[PageHeader-%s] ", ++pageID) + " HeaderSize:" + pageHeader.getSerializedSize() + ", UncompressedSize:" + pageHeader.getUncompressedSize() + ", CompressedSize:" + pageHeader.getCompressedSize() + ", " + pageHeader.getStatistics());
                            this.printlnBoth(this.pw, String.format("%20s", offset += (long)pageHeader.getSerializedSize()) + String.format("|\t\t\t[Page-%s] ", pageID) + ", CompressedSize:" + pageHeader.getCompressedSize() + ", " + pageHeader.getStatistics());
                            offset += (long)pageHeader.getCompressedSize();
                        }
                    }
                    nextChunkGroupHeaderPos = chunkMetadata.getOffsetOfChunkHeader() + (long)chunk.getHeader().getSerializedSize() + (long)chunk.getHeader().getDataSize();
                }
                this.reader.position(nextChunkGroupHeaderPos);
                byte marker = this.reader.readMarker();
                switch (marker) {
                    case 0: {
                        break;
                    }
                    case 4: {
                        nextChunkGroupHeaderPos += 16L;
                    }
                }
                this.printlnBoth(this.pw, this.splitStr + " [ChunkGroup] of " + chunkGroupMetadata.getDevice() + " ends");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void printTimeseriesIndex(long pos, Pair<Path, TimeseriesMetadata> timeseriesMetadata) {
        try {
            this.printlnBoth(this.pw, String.format("%20s", pos) + "|\t[TimeseriesMetadata] of " + timeseriesMetadata.left + ", tsDataType:" + ((TimeseriesMetadata)timeseriesMetadata.right).getTsDataType() + ", sizeWithoutChunkMetadata:" + ((TimeseriesMetadata)timeseriesMetadata.right).serializedSizeWithoutMetadata() + ", " + ((TimeseriesMetadata)timeseriesMetadata.right).getStatistics());
            pos += (long)timeseriesMetadata.getRight().serializedSizeWithoutMetadata();
            List<ChunkMetadata> chunkMetadataList = this.reader.getChunkMetadataList((Path)timeseriesMetadata.left);
            for (int i = 0; i < chunkMetadataList.size(); ++i) {
                ChunkMetadata chunkMetadata = chunkMetadataList.get(i);
                int serializedSize = chunkMetadata.serializedSize(i != 0);
                this.printlnBoth(this.pw, String.format("%20s", pos) + "|\t\t[ChunkMetadata] offset=" + chunkMetadata.getOffsetOfChunkHeader() + ", size=" + serializedSize);
                pos += (long)serializedSize;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void loadIndexTree(MetadataIndexNode metadataIndexNode, TreeMap<Long, MetadataIndexNode> metadataIndexNodeMap, List<String> treeOutputStringBuffer, int deep) throws IOException {
        int i;
        StringBuilder tableWriter = new StringBuilder("\t");
        for (i = 0; i < deep; ++i) {
            tableWriter.append("\t\t");
        }
        treeOutputStringBuffer.add(tableWriter + "[MetadataIndex:" + (Object)((Object)metadataIndexNode.getNodeType()) + "]");
        for (i = 0; i < metadataIndexNode.getChildren().size(); ++i) {
            IMetadataIndexEntry metadataIndexEntry = metadataIndexNode.getChildren().get(i);
            treeOutputStringBuffer.add(tableWriter + "\u2514\u2500\u2500\u2500\u2500\u2500\u2500[" + metadataIndexEntry.getCompareKey() + "," + metadataIndexEntry.getOffset() + "]");
            if (metadataIndexNode.getNodeType().equals((Object)MetadataIndexNodeType.LEAF_MEASUREMENT)) continue;
            long endOffset = metadataIndexNode.getEndOffset();
            if (i != metadataIndexNode.getChildren().size() - 1) {
                endOffset = metadataIndexNode.getChildren().get(i + 1).getOffset();
            }
            boolean currentChildLevelIsDevice = MetadataIndexNodeType.INTERNAL_DEVICE.equals((Object)metadataIndexNode.getNodeType());
            MetadataIndexNode subNode = this.reader.readMetadataIndexNode(metadataIndexEntry.getOffset(), endOffset, currentChildLevelIsDevice);
            metadataIndexNodeMap.put(metadataIndexEntry.getOffset(), subNode);
            this.loadIndexTree(subNode, metadataIndexNodeMap, treeOutputStringBuffer, deep + 1);
        }
    }

    private void printlnBoth(PrintWriter pw, String str) {
        System.out.println(str);
        pw.println(str);
    }

    private static Pair<String, String> checkArgs(String[] args) {
        String filename = "test.tsfile";
        String outFile = "TsFile_sketch_view.txt";
        if (args.length == 1) {
            filename = args[0];
        } else if (args.length == 2) {
            filename = args[0];
            outFile = args[1];
        }
        return new Pair<String, String>(filename, outFile);
    }

    protected List<ChunkGroupMetadata> getAllChunkGroupMetadata() {
        return this.allChunkGroupMetadata;
    }

    private class TsFileSketchToolReader
    extends TsFileSequenceReader {
        public TsFileSketchToolReader(String file) throws IOException {
            super(file);
        }

        private void generateMetadataIndexWithOffset(long startOffset, IMetadataIndexEntry metadataIndex, ByteBuffer buffer, IDeviceID deviceId, MetadataIndexNodeType type, Map<Long, Pair<Path, TimeseriesMetadata>> timeseriesMetadataMap, boolean needChunkMetadata) throws IOException {
            if (type.equals((Object)MetadataIndexNodeType.LEAF_MEASUREMENT)) {
                while (buffer.hasRemaining()) {
                    long pos = startOffset + (long)buffer.position();
                    TimeseriesMetadata timeseriesMetadata = TimeseriesMetadata.deserializeFrom(buffer, needChunkMetadata);
                    timeseriesMetadataMap.put(pos, new Pair<Path, TimeseriesMetadata>(new Path(deviceId, timeseriesMetadata.getMeasurementId(), true), timeseriesMetadata));
                }
            } else {
                if (type.equals((Object)MetadataIndexNodeType.LEAF_DEVICE)) {
                    deviceId = ((DeviceMetadataIndexEntry)metadataIndex).getDeviceID();
                }
                boolean currentChildLevelIsDevice = MetadataIndexNodeType.INTERNAL_DEVICE.equals((Object)type);
                MetadataIndexNode metadataIndexNode = TsFileSketchTool.this.reader.getDeserializeContext().deserializeMetadataIndexNode(buffer, currentChildLevelIsDevice);
                int metadataIndexListSize = metadataIndexNode.getChildren().size();
                for (int i = 0; i < metadataIndexListSize; ++i) {
                    long endOffset = metadataIndexNode.getEndOffset();
                    if (i != metadataIndexListSize - 1) {
                        endOffset = metadataIndexNode.getChildren().get(i + 1).getOffset();
                    }
                    if (endOffset - metadataIndexNode.getChildren().get(i).getOffset() < Integer.MAX_VALUE) {
                        ByteBuffer nextBuffer = this.readData(metadataIndexNode.getChildren().get(i).getOffset(), endOffset);
                        this.generateMetadataIndexWithOffset(metadataIndexNode.getChildren().get(i).getOffset(), metadataIndexNode.getChildren().get(i), nextBuffer, deviceId, metadataIndexNode.getNodeType(), timeseriesMetadataMap, needChunkMetadata);
                        continue;
                    }
                    this.generateMetadataIndexWithOffsetUsingTsFileInput(metadataIndexNode.getChildren().get(i).getOffset(), endOffset, metadataIndexNode.getChildren().get(i), deviceId, metadataIndexNode.getNodeType(), timeseriesMetadataMap, needChunkMetadata);
                }
            }
        }

        private void generateMetadataIndexWithOffsetUsingTsFileInput(long start, long end, IMetadataIndexEntry metadataIndex, IDeviceID deviceId, MetadataIndexNodeType type, Map<Long, Pair<Path, TimeseriesMetadata>> timeseriesMetadataMap, boolean needChunkMetadata) throws IOException {
            this.tsFileInput.position(start);
            if (type.equals((Object)MetadataIndexNodeType.LEAF_MEASUREMENT)) {
                while (this.tsFileInput.position() < end) {
                    long pos = this.tsFileInput.position();
                    TimeseriesMetadata timeseriesMetadata = TimeseriesMetadata.deserializeFrom(this.tsFileInput, needChunkMetadata);
                    timeseriesMetadataMap.put(pos, new Pair<Path, TimeseriesMetadata>(new Path(deviceId, timeseriesMetadata.getMeasurementId(), true), timeseriesMetadata));
                }
            } else {
                if (type.equals((Object)MetadataIndexNodeType.LEAF_DEVICE)) {
                    deviceId = ((DeviceMetadataIndexEntry)metadataIndex).getDeviceID();
                }
                boolean isDeviceLevel = MetadataIndexNodeType.INTERNAL_DEVICE.equals((Object)type);
                MetadataIndexNode metadataIndexNode = TsFileSketchTool.this.reader.getDeserializeContext().deserializeMetadataIndexNode(this.tsFileInput.wrapAsInputStream(), isDeviceLevel);
                int metadataIndexListSize = metadataIndexNode.getChildren().size();
                for (int i = 0; i < metadataIndexListSize; ++i) {
                    long endOffset = metadataIndexNode.getEndOffset();
                    if (i != metadataIndexListSize - 1) {
                        endOffset = metadataIndexNode.getChildren().get(i + 1).getOffset();
                    }
                    this.generateMetadataIndexWithOffsetUsingTsFileInput(metadataIndexNode.getChildren().get(i).getOffset(), endOffset, metadataIndexNode.getChildren().get(i), deviceId, metadataIndexNode.getNodeType(), timeseriesMetadataMap, needChunkMetadata);
                }
            }
        }

        public Map<Long, Pair<Path, TimeseriesMetadata>> getAllTimeseriesMetadataWithOffset() throws IOException {
            if (this.tsFileMetaData == null) {
                this.readFileMetadata();
            }
            TreeMap<Long, Pair<Path, TimeseriesMetadata>> timeseriesMetadataMap = new TreeMap<Long, Pair<Path, TimeseriesMetadata>>();
            for (Map.Entry<String, MetadataIndexNode> entry : this.tsFileMetaData.getTableMetadataIndexNodeMap().entrySet()) {
                List<IMetadataIndexEntry> metadataIndexEntryList = entry.getValue().getChildren();
                for (int i = 0; i < metadataIndexEntryList.size(); ++i) {
                    IMetadataIndexEntry metadataIndexEntry = metadataIndexEntryList.get(i);
                    long endOffset = entry.getValue().getEndOffset();
                    if (i != metadataIndexEntryList.size() - 1) {
                        endOffset = metadataIndexEntryList.get(i + 1).getOffset();
                    }
                    ByteBuffer buffer = this.readData(metadataIndexEntry.getOffset(), endOffset);
                    this.generateMetadataIndexWithOffset(metadataIndexEntry.getOffset(), metadataIndexEntry, buffer, null, entry.getValue().getNodeType(), timeseriesMetadataMap, false);
                }
            }
            return timeseriesMetadataMap;
        }
    }
}

