/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.read.common.block.column;

import java.util.Arrays;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnEncoding;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.column.ColumnUtil;
import org.apache.tsfile.read.common.block.column.DictionaryColumn;
import org.apache.tsfile.read.common.block.column.DictionaryId;
import org.apache.tsfile.utils.RamUsageEstimator;

public class TimeColumn
implements Column {
    private static final int INSTANCE_SIZE = (int)RamUsageEstimator.shallowSizeOfInstance(TimeColumn.class);
    public static final int SIZE_IN_BYTES_PER_POSITION = 8;
    private final int arrayOffset;
    private int positionCount;
    private final long[] values;
    private final long retainedSizeInBytes;

    public TimeColumn(int initialCapacity) {
        this(0, 0, new long[initialCapacity]);
    }

    public TimeColumn(int positionCount, long[] values) {
        this(0, positionCount, values);
    }

    TimeColumn(int arrayOffset, int positionCount, long[] values) {
        if (arrayOffset < 0) {
            throw new IllegalArgumentException("arrayOffset is negative");
        }
        this.arrayOffset = arrayOffset;
        if (positionCount < 0) {
            throw new IllegalArgumentException("positionCount is negative");
        }
        this.positionCount = positionCount;
        if (values.length - arrayOffset < positionCount) {
            throw new IllegalArgumentException("values length is less than positionCount");
        }
        this.values = values;
        this.retainedSizeInBytes = (long)INSTANCE_SIZE + RamUsageEstimator.sizeOfLongArray((int)positionCount);
    }

    public TSDataType getDataType() {
        return TSDataType.INT64;
    }

    public ColumnEncoding getEncoding() {
        return ColumnEncoding.INT64_ARRAY;
    }

    public long getLong(int position) {
        return this.values[position + this.arrayOffset];
    }

    public Object getObject(int position) {
        return this.getLong(position);
    }

    public boolean mayHaveNull() {
        return false;
    }

    public boolean isNull(int position) {
        return false;
    }

    public boolean[] isNull() {
        throw new UnsupportedOperationException("isNull is not supported for TimeColumn");
    }

    public int getPositionCount() {
        return this.positionCount;
    }

    public long getRetainedSizeInBytes() {
        return this.retainedSizeInBytes;
    }

    public long getSizeInBytes() {
        return (long)this.positionCount * 8L;
    }

    public Column getRegion(int positionOffset, int length) {
        ColumnUtil.checkValidRegion(this.getPositionCount(), positionOffset, length);
        return new TimeColumn(positionOffset + this.arrayOffset, length, this.values);
    }

    public Column getRegionCopy(int positionOffset, int length) {
        ColumnUtil.checkValidRegion(this.getPositionCount(), positionOffset, length);
        int from = positionOffset + this.arrayOffset;
        int to = from + length;
        long[] valuesCopy = Arrays.copyOfRange(this.values, from, to);
        return new TimeColumn(0, length, valuesCopy);
    }

    public Column subColumn(int fromIndex) {
        if (fromIndex > this.positionCount) {
            throw new IllegalArgumentException("fromIndex is not valid");
        }
        return new TimeColumn(this.arrayOffset + fromIndex, this.positionCount - fromIndex, this.values);
    }

    public Column subColumnCopy(int fromIndex) {
        if (fromIndex > this.positionCount) {
            throw new IllegalArgumentException("fromIndex is not valid");
        }
        int from = this.arrayOffset + fromIndex;
        long[] valuesCopy = Arrays.copyOfRange(this.values, from, this.positionCount);
        int length = this.positionCount - fromIndex;
        return new TimeColumn(0, length, valuesCopy);
    }

    public void reverse() {
        int i = this.arrayOffset;
        for (int j = this.arrayOffset + this.positionCount - 1; i < j; ++i, --j) {
            long time = this.values[i];
            this.values[i] = this.values[j];
            this.values[j] = time;
        }
    }

    public Column getPositions(int[] positions, int offset, int length) {
        ColumnUtil.checkArrayRange(positions, offset, length);
        return DictionaryColumn.createInternal(offset, length, this, positions, DictionaryId.randomDictionaryId());
    }

    public Column copyPositions(int[] positions, int offset, int length) {
        ColumnUtil.checkArrayRange(positions, offset, length);
        long[] newValues = new long[length];
        for (int i = 0; i < length; ++i) {
            int position = positions[offset + i];
            ColumnUtil.checkReadablePosition(this, position);
            newValues[i] = this.values[position + this.arrayOffset];
        }
        return new TimeColumn(0, length, newValues);
    }

    public long getStartTime() {
        return this.values[this.arrayOffset];
    }

    public long getEndTime() {
        return this.values[this.getPositionCount() + this.arrayOffset - 1];
    }

    public long[] getTimes() {
        return this.values;
    }

    public long[] getLongs() {
        return this.getTimes();
    }

    public int getInstanceSize() {
        return INSTANCE_SIZE;
    }

    public void setPositionCount(int count) {
        this.positionCount = this.positionCount;
    }

    public void setNull(int start, int end) {
    }

    public void reset() {
        this.setPositionCount(0);
    }
}

