/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.read.common.block.column;

import java.util.Arrays;
import java.util.Optional;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnEncoding;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.column.ColumnUtil;
import org.apache.tsfile.read.common.block.column.DictionaryColumn;
import org.apache.tsfile.read.common.block.column.DictionaryId;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.apache.tsfile.utils.TsPrimitiveType;

public class IntColumn
implements Column {
    private static final int INSTANCE_SIZE = (int)RamUsageEstimator.shallowSizeOfInstance(IntColumn.class);
    public static final int SIZE_IN_BYTES_PER_POSITION = 5;
    private final int arrayOffset;
    private int positionCount;
    private boolean[] valueIsNull;
    private final int[] values;
    private final long retainedSizeInBytes;

    public IntColumn(int initialCapacity) {
        this(0, 0, null, new int[initialCapacity]);
    }

    public IntColumn(int positionCount, Optional<boolean[]> valueIsNull, int[] values) {
        this(0, positionCount, valueIsNull.orElse(null), values);
    }

    IntColumn(int arrayOffset, int positionCount, boolean[] valueIsNull, int[] values) {
        if (arrayOffset < 0) {
            throw new IllegalArgumentException("arrayOffset is negative");
        }
        this.arrayOffset = arrayOffset;
        if (positionCount < 0) {
            throw new IllegalArgumentException("positionCount is negative");
        }
        this.positionCount = positionCount;
        if (values.length - arrayOffset < positionCount) {
            throw new IllegalArgumentException("values length is less than positionCount");
        }
        this.values = values;
        if (valueIsNull != null && valueIsNull.length - arrayOffset < positionCount) {
            throw new IllegalArgumentException("isNull length is less than positionCount");
        }
        this.valueIsNull = valueIsNull;
        this.retainedSizeInBytes = (long)INSTANCE_SIZE + RamUsageEstimator.sizeOfIntArray((int)positionCount) + RamUsageEstimator.sizeOfBooleanArray((int)positionCount);
    }

    public TSDataType getDataType() {
        return TSDataType.INT32;
    }

    public ColumnEncoding getEncoding() {
        return ColumnEncoding.INT32_ARRAY;
    }

    public int getInt(int position) {
        return this.values[position + this.arrayOffset];
    }

    public long getLong(int position) {
        return this.values[position + this.arrayOffset];
    }

    public float getFloat(int position) {
        return this.values[position + this.arrayOffset];
    }

    public double getDouble(int position) {
        return this.values[position + this.arrayOffset];
    }

    public int[] getInts() {
        return this.values;
    }

    public float[] getFloats() {
        float[] result = new float[this.values.length];
        for (int i = 0; i < this.values.length; ++i) {
            result[i] = this.values[i];
        }
        return result;
    }

    public long[] getLongs() {
        long[] result = new long[this.values.length];
        for (int i = 0; i < this.values.length; ++i) {
            result[i] = this.values[i];
        }
        return result;
    }

    public double[] getDoubles() {
        double[] result = new double[this.values.length];
        for (int i = 0; i < this.values.length; ++i) {
            result[i] = this.values[i];
        }
        return result;
    }

    public Object getObject(int position) {
        return this.getInt(position);
    }

    public TsPrimitiveType getTsPrimitiveType(int position) {
        return new TsPrimitiveType.TsInt(this.getInt(position));
    }

    public boolean mayHaveNull() {
        return this.valueIsNull != null;
    }

    public boolean isNull(int position) {
        return this.valueIsNull != null && this.valueIsNull[position + this.arrayOffset];
    }

    public boolean[] isNull() {
        if (this.valueIsNull == null) {
            boolean[] res = new boolean[this.positionCount];
            Arrays.fill(res, false);
            return res;
        }
        return this.valueIsNull;
    }

    public int getPositionCount() {
        return this.positionCount;
    }

    public long getRetainedSizeInBytes() {
        return this.retainedSizeInBytes;
    }

    public long getSizeInBytes() {
        return (long)this.positionCount * 5L;
    }

    public Column getRegion(int positionOffset, int length) {
        ColumnUtil.checkValidRegion(this.getPositionCount(), positionOffset, length);
        return new IntColumn(positionOffset + this.arrayOffset, length, this.valueIsNull, this.values);
    }

    public Column getRegionCopy(int positionOffset, int length) {
        ColumnUtil.checkValidRegion(this.getPositionCount(), positionOffset, length);
        int from = positionOffset + this.arrayOffset;
        int to = from + length;
        boolean[] valueIsNullCopy = this.valueIsNull != null ? Arrays.copyOfRange(this.valueIsNull, from, to) : null;
        int[] valuesCopy = Arrays.copyOfRange(this.values, from, to);
        return new IntColumn(0, length, valueIsNullCopy, valuesCopy);
    }

    public Column subColumn(int fromIndex) {
        if (fromIndex > this.positionCount) {
            throw new IllegalArgumentException("fromIndex is not valid");
        }
        return new IntColumn(this.arrayOffset + fromIndex, this.positionCount - fromIndex, this.valueIsNull, this.values);
    }

    public Column subColumnCopy(int fromIndex) {
        if (fromIndex > this.positionCount) {
            throw new IllegalArgumentException("fromIndex is not valid");
        }
        int from = this.arrayOffset + fromIndex;
        boolean[] valueIsNullCopy = this.valueIsNull != null ? Arrays.copyOfRange(this.valueIsNull, from, this.positionCount) : null;
        int[] valuesCopy = Arrays.copyOfRange(this.values, from, this.positionCount);
        int length = this.positionCount - fromIndex;
        return new IntColumn(0, length, valueIsNullCopy, valuesCopy);
    }

    public void reverse() {
        int j;
        int i = this.arrayOffset;
        for (j = this.arrayOffset + this.positionCount - 1; i < j; ++i, --j) {
            int valueTmp = this.values[i];
            this.values[i] = this.values[j];
            this.values[j] = valueTmp;
        }
        if (this.valueIsNull != null) {
            i = this.arrayOffset;
            for (j = this.arrayOffset + this.positionCount - 1; i < j; ++i, --j) {
                boolean isNullTmp = this.valueIsNull[i];
                this.valueIsNull[i] = this.valueIsNull[j];
                this.valueIsNull[j] = isNullTmp;
            }
        }
    }

    public Column getPositions(int[] positions, int offset, int length) {
        ColumnUtil.checkArrayRange(positions, offset, length);
        return DictionaryColumn.createInternal(offset, length, this, positions, DictionaryId.randomDictionaryId());
    }

    public Column copyPositions(int[] positions, int offset, int length) {
        ColumnUtil.checkArrayRange(positions, offset, length);
        boolean[] newValueIsNull = null;
        if (this.valueIsNull != null) {
            newValueIsNull = new boolean[length];
        }
        int[] newValues = new int[length];
        for (int i = 0; i < length; ++i) {
            int position = positions[offset + i];
            ColumnUtil.checkReadablePosition(this, position);
            if (newValueIsNull != null) {
                newValueIsNull[i] = this.valueIsNull[position + this.arrayOffset];
            }
            newValues[i] = this.values[position + this.arrayOffset];
        }
        return new IntColumn(0, length, newValueIsNull, newValues);
    }

    public int getInstanceSize() {
        return INSTANCE_SIZE;
    }

    public void setPositionCount(int count) {
        this.positionCount = count;
    }

    public void setNull(int start, int end) {
        if (this.valueIsNull == null) {
            this.valueIsNull = new boolean[this.values.length];
        }
        Arrays.fill(this.valueIsNull, start, end, true);
    }
}

