/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.read.common.block.column;

import java.util.Arrays;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.block.column.ColumnBuilderStatus;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.column.ColumnUtil;
import org.apache.tsfile.read.common.block.column.DoubleColumn;
import org.apache.tsfile.read.common.block.column.RunLengthEncodedColumn;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.apache.tsfile.utils.TsPrimitiveType;
import org.apache.tsfile.write.UnSupportedDataTypeException;

public class DoubleColumnBuilder
implements ColumnBuilder {
    private static final int INSTANCE_SIZE = (int)RamUsageEstimator.shallowSizeOfInstance(DoubleColumnBuilder.class);
    public static final DoubleColumn NULL_VALUE_BLOCK = new DoubleColumn(0, 1, new boolean[]{true}, new double[1]);
    private final ColumnBuilderStatus columnBuilderStatus;
    private boolean initialized;
    private final int initialEntryCount;
    private int positionCount;
    private boolean hasNullValue;
    private boolean hasNonNullValue;
    private boolean[] valueIsNull = new boolean[0];
    private double[] values = new double[0];
    private long retainedSizeInBytes;

    public DoubleColumnBuilder(ColumnBuilderStatus columnBuilderStatus, int expectedEntries) {
        this.columnBuilderStatus = columnBuilderStatus;
        this.initialEntryCount = Math.max(expectedEntries, 1);
        this.updateDataSize();
    }

    public int getPositionCount() {
        return this.positionCount;
    }

    public ColumnBuilder writeLong(long value) {
        return this.writeDouble(value);
    }

    public ColumnBuilder writeFloat(float value) {
        return this.writeDouble(value);
    }

    public ColumnBuilder writeInt(int value) {
        return this.writeDouble(value);
    }

    public ColumnBuilder writeDouble(double value) {
        if (this.values.length <= this.positionCount) {
            this.growCapacity();
        }
        this.values[this.positionCount] = value;
        this.hasNonNullValue = true;
        ++this.positionCount;
        if (this.columnBuilderStatus != null) {
            this.columnBuilderStatus.addBytes(9);
        }
        return this;
    }

    public ColumnBuilder writeObject(Object value) {
        if (value instanceof Double) {
            this.writeDouble((Double)value);
            return this;
        }
        throw new UnSupportedDataTypeException("DoubleColumn only support Double data type");
    }

    public ColumnBuilder write(Column column, int index) {
        return this.writeDouble(column.getDouble(index));
    }

    public ColumnBuilder writeTsPrimitiveType(TsPrimitiveType value) {
        return this.writeDouble(value.getDouble());
    }

    public ColumnBuilder appendNull() {
        if (this.values.length <= this.positionCount) {
            this.growCapacity();
        }
        this.valueIsNull[this.positionCount] = true;
        this.hasNullValue = true;
        ++this.positionCount;
        if (this.columnBuilderStatus != null) {
            this.columnBuilderStatus.addBytes(9);
        }
        return this;
    }

    public Column build() {
        if (!this.hasNonNullValue) {
            return new RunLengthEncodedColumn(NULL_VALUE_BLOCK, this.positionCount);
        }
        return new DoubleColumn(0, this.positionCount, this.hasNullValue ? this.valueIsNull : null, this.values);
    }

    public TSDataType getDataType() {
        return TSDataType.DOUBLE;
    }

    public long getRetainedSizeInBytes() {
        return this.retainedSizeInBytes;
    }

    public ColumnBuilder newColumnBuilderLike(ColumnBuilderStatus columnBuilderStatus) {
        return new DoubleColumnBuilder(columnBuilderStatus, ColumnUtil.calculateBlockResetSize(this.positionCount));
    }

    private void growCapacity() {
        int newSize;
        if (this.initialized) {
            newSize = ColumnUtil.calculateNewArraySize(this.values.length);
        } else {
            newSize = this.initialEntryCount;
            this.initialized = true;
        }
        this.valueIsNull = Arrays.copyOf(this.valueIsNull, newSize);
        this.values = Arrays.copyOf(this.values, newSize);
        this.updateDataSize();
    }

    private void updateDataSize() {
        this.retainedSizeInBytes = (long)INSTANCE_SIZE + RamUsageEstimator.sizeOf((boolean[])this.valueIsNull) + RamUsageEstimator.sizeOf((double[])this.values);
        if (this.columnBuilderStatus != null) {
            this.retainedSizeInBytes += ColumnBuilderStatus.INSTANCE_SIZE;
        }
    }
}

