/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.persistence;

import io.moquette.broker.AbstractSessionMessageQueue;
import io.moquette.broker.SessionRegistry;
import io.moquette.persistence.EnqueuedMessageValueType;
import java.util.concurrent.atomic.AtomicLong;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.h2.mvstore.type.DataType;

class H2PersistentQueue
extends AbstractSessionMessageQueue<SessionRegistry.EnqueuedMessage> {
    private final MVMap<Long, SessionRegistry.EnqueuedMessage> queueMap;
    private final MVMap<String, Long> metadataMap;
    private final AtomicLong head;
    private final AtomicLong tail;
    private final MVStore store;
    private final String queueName;

    H2PersistentQueue(MVStore store, String queueName) {
        if (queueName == null || queueName.isEmpty()) {
            throw new IllegalArgumentException("queueName parameter can't be empty or null");
        }
        MVMap.Builder messageTypeBuilder = new MVMap.Builder().valueType((DataType)new EnqueuedMessageValueType());
        this.store = store;
        this.queueName = queueName;
        this.queueMap = this.store.openMap("queue_" + this.queueName, (MVMap.MapBuilder)messageTypeBuilder);
        this.metadataMap = store.openMap("queue_" + queueName + "_meta");
        long headIdx = 0L;
        if (this.metadataMap.containsKey((Object)"head")) {
            headIdx = (Long)this.metadataMap.get((Object)"head");
        } else {
            this.metadataMap.put((Object)"head", (Object)headIdx);
        }
        this.head = new AtomicLong(headIdx);
        long tailIdx = 0L;
        if (this.metadataMap.containsKey((Object)"tail")) {
            tailIdx = (Long)this.metadataMap.get((Object)"tail");
        } else {
            this.metadataMap.put((Object)"tail", (Object)tailIdx);
        }
        this.tail = new AtomicLong(tailIdx);
    }

    @Override
    public void enqueue(SessionRegistry.EnqueuedMessage t) {
        this.checkEnqueuePreconditions(t);
        long nextHead = this.head.getAndIncrement();
        this.queueMap.put((Object)nextHead, (Object)t);
        this.metadataMap.put((Object)"head", (Object)(nextHead + 1L));
    }

    @Override
    public SessionRegistry.EnqueuedMessage dequeue() {
        this.checkDequeuePreconditions();
        if (this.head.equals(this.tail)) {
            return null;
        }
        long nextTail = this.tail.getAndIncrement();
        SessionRegistry.EnqueuedMessage tail = (SessionRegistry.EnqueuedMessage)this.queueMap.get((Object)nextTail);
        this.queueMap.remove((Object)nextTail);
        this.metadataMap.put((Object)"tail", (Object)(nextTail + 1L));
        return tail;
    }

    @Override
    public boolean isEmpty() {
        this.checkIsEmptyPreconditions();
        return this.head.intValue() - this.tail.intValue() == 0;
    }

    @Override
    public void closeAndPurge() {
        this.closed = true;
        this.dropQueue(this.queueName);
    }

    private void dropQueue(String queueName) {
        this.store.removeMap(this.store.openMap("queue_" + queueName));
        this.store.removeMap(this.store.openMap("queue_" + queueName + "_meta"));
    }
}

