/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.raftlog.segmented;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.metrics.Timekeeper;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.RaftGroupMemberId;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.metrics.SegmentedRaftLogMetrics;
import org.apache.ratis.server.protocol.TermIndex;
import org.apache.ratis.server.raftlog.LogEntryHeader;
import org.apache.ratis.server.raftlog.LogProtoUtils;
import org.apache.ratis.server.raftlog.RaftLog;
import org.apache.ratis.server.raftlog.RaftLogBase;
import org.apache.ratis.server.raftlog.RaftLogIOException;
import org.apache.ratis.server.raftlog.segmented.LogSegment;
import org.apache.ratis.server.raftlog.segmented.LogSegmentPath;
import org.apache.ratis.server.raftlog.segmented.SegmentedRaftLogCache;
import org.apache.ratis.server.raftlog.segmented.SegmentedRaftLogWorker;
import org.apache.ratis.server.storage.RaftStorage;
import org.apache.ratis.server.storage.RaftStorageMetadata;
import org.apache.ratis.statemachine.StateMachine;
import org.apache.ratis.statemachine.TransactionContext;
import org.apache.ratis.statemachine.impl.TransactionContextImpl;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.util.AutoCloseableLock;
import org.apache.ratis.util.AwaitToRun;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.ReferenceCountedObject;
import org.apache.ratis.util.StringUtils;
import org.apache.ratis.util.UncheckedAutoCloseable;

public final class SegmentedRaftLog
extends RaftLogBase {
    private final ServerLogMethods server;
    private final RaftStorage storage;
    private final StateMachine stateMachine;
    private final SegmentedRaftLogCache cache;
    private final AwaitToRun cacheEviction;
    private final SegmentedRaftLogWorker fileLogWorker;
    private final long segmentMaxSize;
    private final boolean stateMachineCachingEnabled;
    private final SegmentedRaftLogMetrics metrics;

    private ServerLogMethods newServerLogMethods(final RaftServer.Division impl, final Consumer<RaftProtos.LogEntryProto> notifyTruncatedLogEntry, final BiFunction<RaftProtos.LogEntryProto, Boolean, TransactionContext> getTransactionContext) {
        if (impl == null) {
            return ServerLogMethods.DUMMY;
        }
        return new ServerLogMethods(){

            @Override
            public long[] getFollowerNextIndices() {
                return impl.getInfo().getFollowerNextIndices();
            }

            @Override
            public long getLastAppliedIndex() {
                return impl.getInfo().getLastAppliedIndex();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyTruncatedLogEntry(TermIndex ti) {
                ReferenceCountedObject<RaftProtos.LogEntryProto> ref = null;
                try {
                    ref = SegmentedRaftLog.this.retainLog(ti.getIndex());
                    RaftProtos.LogEntryProto entry = ref != null ? (RaftProtos.LogEntryProto)ref.get() : null;
                    notifyTruncatedLogEntry.accept(entry);
                }
                catch (RaftLogIOException e) {
                    RaftLog.LOG.error("{}: Failed to read log {}", new Object[]{SegmentedRaftLog.this.getName(), ti, e});
                }
                finally {
                    if (ref != null) {
                        ref.release();
                    }
                }
            }

            @Override
            public TransactionContext getTransactionContext(RaftProtos.LogEntryProto entry, boolean createNew) {
                return (TransactionContext)getTransactionContext.apply(entry, createNew);
            }
        };
    }

    private SegmentedRaftLog(Builder b) {
        super(b.memberId, b.snapshotIndexSupplier, b.properties);
        this.metrics = new SegmentedRaftLogMetrics(b.memberId);
        this.server = this.newServerLogMethods(b.server, b.notifyTruncatedLogEntry, b.getTransactionContext);
        this.storage = b.storage;
        this.stateMachine = b.stateMachine;
        this.segmentMaxSize = RaftServerConfigKeys.Log.segmentSizeMax((RaftProperties)b.properties).getSize();
        this.cache = new SegmentedRaftLogCache(b.memberId, this.storage, b.properties, this.getRaftLogMetrics());
        this.cacheEviction = new AwaitToRun((Object)(b.memberId + "-cacheEviction"), this::checkAndEvictCache).start();
        this.fileLogWorker = new SegmentedRaftLogWorker(b.memberId, this.stateMachine, b.submitUpdateCommitEvent, b.server, this.storage, b.properties, this.getRaftLogMetrics());
        this.stateMachineCachingEnabled = RaftServerConfigKeys.Log.StateMachineData.cachingEnabled((RaftProperties)b.properties);
    }

    public SegmentedRaftLogMetrics getRaftLogMetrics() {
        return this.metrics;
    }

    @Override
    protected void openImpl(long lastIndexInSnapshot, Consumer<RaftProtos.LogEntryProto> consumer) throws IOException {
        this.loadLogSegments(lastIndexInSnapshot, consumer);
        File openSegmentFile = Optional.ofNullable(this.cache.getOpenSegment()).map(LogSegment::getFile).orElse(null);
        this.fileLogWorker.start(Math.max(this.cache.getEndIndex(), lastIndexInSnapshot), Math.min(this.cache.getLastIndexInClosedSegments(), lastIndexInSnapshot), openSegmentFile);
    }

    public long getStartIndex() {
        return this.cache.getStartIndex();
    }

    private void loadLogSegments(long lastIndexInSnapshot, Consumer<RaftProtos.LogEntryProto> logConsumer) throws IOException {
        try (AutoCloseableLock writeLock = this.writeLock();){
            List<LogSegmentPath> paths = LogSegmentPath.getLogSegmentPaths(this.storage);
            int i = 0;
            for (LogSegmentPath pi : paths) {
                boolean keepEntryInCache = paths.size() - i++ <= this.cache.getMaxCachedSegments();
                UncheckedAutoCloseable ignored = this.getRaftLogMetrics().startLoadSegmentTimer();
                Throwable throwable = null;
                try {
                    this.cache.loadSegment(pi, keepEntryInCache, logConsumer);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (ignored == null) continue;
                    if (throwable != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ignored.close();
                }
            }
            if (!this.cache.isEmpty() && this.cache.getEndIndex() < lastIndexInSnapshot) {
                LOG.warn("End log index {} is smaller than last index in snapshot {}", (Object)this.cache.getEndIndex(), (Object)lastIndexInSnapshot);
                this.purgeImpl(lastIndexInSnapshot).whenComplete((purged, e) -> this.updatePurgeIndex((Long)purged));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RaftProtos.LogEntryProto get(long index) throws RaftLogIOException {
        ReferenceCountedObject<RaftProtos.LogEntryProto> ref = this.retainLog(index);
        if (ref == null) {
            return null;
        }
        try {
            RaftProtos.LogEntryProto logEntryProto = LogProtoUtils.copy((RaftProtos.LogEntryProto)ref.get());
            return logEntryProto;
        }
        finally {
            ref.release();
        }
    }

    public ReferenceCountedObject<RaftProtos.LogEntryProto> retainLog(long index) throws RaftLogIOException {
        this.checkLogState();
        LogSegment segment = this.cache.getSegment(index);
        if (segment == null) {
            return null;
        }
        LogSegment.LogRecord record = segment.getLogRecord(index);
        if (record == null) {
            return null;
        }
        TermIndex ti = record.getTermIndex();
        ReferenceCountedObject<RaftProtos.LogEntryProto> entry = segment.getEntryFromCache(ti);
        if (entry != null) {
            try {
                entry.retain();
                this.getRaftLogMetrics().onRaftLogCacheHit();
                return entry;
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        this.getRaftLogMetrics().onRaftLogCacheMiss();
        this.cacheEviction.signal();
        return segment.loadCache(ti);
    }

    public RaftLog.EntryWithData getEntryWithData(long index) throws RaftLogIOException {
        throw new UnsupportedOperationException("Use retainEntryWithData(" + index + ") instead.");
    }

    public ReferenceCountedObject<RaftLog.EntryWithData> retainEntryWithData(long index) throws RaftLogIOException {
        ReferenceCountedObject<RaftProtos.LogEntryProto> entryRef = this.retainLog(index);
        if (entryRef == null) {
            throw new RaftLogIOException("Log entry not found: index = " + index);
        }
        RaftProtos.LogEntryProto entry = (RaftProtos.LogEntryProto)entryRef.get();
        if (!LogProtoUtils.isStateMachineDataEmpty(entry)) {
            return this.newEntryWithData(entryRef);
        }
        try {
            CompletionStage future = null;
            if (this.stateMachine != null) {
                future = this.stateMachine.data().retainRead(entry, this.server.getTransactionContext(entry, false)).exceptionally(ex -> {
                    this.stateMachine.event().notifyLogFailed(ex, entry);
                    throw new CompletionException("Failed to read state machine data for log entry " + entry, (Throwable)ex);
                });
            }
            return future != null ? this.newEntryWithData(entryRef, (CompletableFuture<ReferenceCountedObject<ByteString>>)future) : this.newEntryWithData(entryRef);
        }
        catch (Exception e) {
            String err = this.getName() + ": Failed readStateMachineData for " + this.toLogEntryString(entry);
            LOG.error(err, (Throwable)e);
            entryRef.release();
            throw new RaftLogIOException(err, JavaUtils.unwrapCompletionException((Throwable)e));
        }
    }

    private void checkAndEvictCache() {
        if (this.cache.shouldEvict()) {
            try (AutoCloseableLock ignored = this.writeLock();){
                this.cache.evictCache(this.server.getFollowerNextIndices(), this.fileLogWorker.getSafeCacheEvictIndex(), this.server.getLastAppliedIndex());
            }
        }
    }

    public TermIndex getTermIndex(long index) {
        this.checkLogState();
        return this.cache.getTermIndex(index);
    }

    public LogEntryHeader[] getEntries(long startIndex, long endIndex) {
        this.checkLogState();
        return this.cache.getTermIndices(startIndex, endIndex);
    }

    public TermIndex getLastEntryTermIndex() {
        this.checkLogState();
        return this.cache.getLastTermIndex();
    }

    @Override
    protected CompletableFuture<Long> truncateImpl(long index) {
        this.checkLogState();
        try (AutoCloseableLock writeLock = this.writeLock();){
            SegmentedRaftLogCache.TruncationSegments ts = this.cache.truncate(index);
            if (ts != null) {
                Task task = this.fileLogWorker.truncate(ts, index);
                CompletableFuture<Long> completableFuture = task.getFuture();
                return completableFuture;
            }
        }
        return CompletableFuture.completedFuture(index);
    }

    @Override
    protected CompletableFuture<Long> purgeImpl(long index) {
        try (AutoCloseableLock writeLock = this.writeLock();){
            SegmentedRaftLogCache.TruncationSegments ts = this.cache.purge(index);
            this.updateSnapshotIndexFromStateMachine();
            if (ts != null) {
                LOG.info("{}: {}", (Object)this.getName(), (Object)ts);
                Task task = this.fileLogWorker.purge(ts);
                CompletableFuture<Long> completableFuture = task.getFuture();
                return completableFuture;
            }
        }
        LOG.debug("{}: purge({}) found nothing to purge.", (Object)this.getName(), (Object)index);
        return CompletableFuture.completedFuture(index);
    }

    /*
     * Exception decompiling
     */
    @Override
    protected CompletableFuture<Long> appendEntryImpl(ReferenceCountedObject<RaftProtos.LogEntryProto> entryRef, TransactionContext context) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean isSegmentFull(LogSegment segment, RaftProtos.LogEntryProto entry) {
        if (segment.getTotalFileSize() >= this.segmentMaxSize) {
            return true;
        }
        long entrySize = LogSegment.getEntrySize(entry, LogSegment.Op.CHECK_SEGMENT_FILE_FULL);
        return entrySize <= this.segmentMaxSize && segment.getTotalFileSize() + entrySize > this.segmentMaxSize;
    }

    /*
     * Loose catch block
     */
    @Override
    protected List<CompletableFuture<Long>> appendImpl(ReferenceCountedObject<List<RaftProtos.LogEntryProto>> entriesRef) {
        this.checkLogState();
        List entries = (List)entriesRef.retain();
        if (entries == null || entries.isEmpty()) {
            entriesRef.release();
            return Collections.emptyList();
        }
        try {
            try (AutoCloseableLock writeLock = this.writeLock();){
                ArrayList<CompletableFuture<Long>> futures;
                SegmentedRaftLogCache.TruncateIndices ti = this.cache.computeTruncateIndices(this.server::notifyTruncatedLogEntry, entries);
                long truncateIndex = ti.getTruncateIndex();
                int index = ti.getArrayIndex();
                LOG.debug("truncateIndex={}, arrayIndex={}", (Object)truncateIndex, (Object)index);
                if (truncateIndex != -1L) {
                    futures = new ArrayList(entries.size() - index + 1);
                    futures.add(this.truncate(truncateIndex));
                } else {
                    futures = new ArrayList<CompletableFuture<Long>>(entries.size() - index);
                }
                for (int i = index; i < entries.size(); ++i) {
                    RaftProtos.LogEntryProto entry = (RaftProtos.LogEntryProto)entries.get(i);
                    TransactionContextImpl transactionContext = (TransactionContextImpl)this.server.getTransactionContext(entry, true);
                    futures.add(this.appendEntry((ReferenceCountedObject<RaftProtos.LogEntryProto>)entriesRef.delegate((Object)entry), transactionContext));
                }
                ArrayList<CompletableFuture<Long>> arrayList = futures;
                return arrayList;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            entriesRef.release();
        }
    }

    public long getFlushIndex() {
        return this.fileLogWorker.getFlushIndex();
    }

    public void persistMetadata(RaftStorageMetadata metadata) throws IOException {
        this.storage.getMetadataFile().persist(metadata);
    }

    public RaftStorageMetadata loadMetadata() throws IOException {
        return this.storage.getMetadataFile().getMetadata();
    }

    public CompletableFuture<Long> onSnapshotInstalled(long lastSnapshotIndex) {
        this.updateSnapshotIndex(lastSnapshotIndex);
        this.fileLogWorker.syncWithSnapshot(lastSnapshotIndex);
        LogSegment openSegment = this.cache.getOpenSegment();
        if (openSegment != null && openSegment.hasEntries()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("syncWithSnapshot : Found open segment {}, with end index {}, snapshotIndex {}", new Object[]{openSegment, openSegment.getEndIndex(), lastSnapshotIndex});
            }
            if (openSegment.getEndIndex() <= lastSnapshotIndex) {
                this.fileLogWorker.closeLogSegment(openSegment);
                this.cache.rollOpenSegment(false);
                this.cacheEviction.signal();
            }
        }
        return this.purgeImpl(lastSnapshotIndex).whenComplete((purged, e) -> this.updatePurgeIndex((Long)purged));
    }

    @Override
    public void close() throws IOException {
        try (AutoCloseableLock writeLock = this.writeLock();){
            LOG.info("Start closing {}", (Object)this);
            super.close();
            this.cacheEviction.close();
            this.cache.close();
        }
        this.fileLogWorker.close();
        this.storage.close();
        this.getRaftLogMetrics().unregister();
        LOG.info("Successfully closed {}", (Object)this);
    }

    SegmentedRaftLogCache getRaftLogCache() {
        return this.cache;
    }

    @Override
    public String toLogEntryString(RaftProtos.LogEntryProto logEntry) {
        return LogProtoUtils.toLogEntryString(logEntry, this.stateMachine != null ? arg_0 -> ((StateMachine)this.stateMachine).toStateMachineLogEntryString(arg_0) : null);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    private static /* synthetic */ void lambda$appendEntryImpl$2(Timekeeper.Context appendEntryTimerContext, Long clientReply, Throwable exception) {
        appendEntryTimerContext.stop();
    }

    public static final class Builder {
        private RaftGroupMemberId memberId;
        private RaftServer.Division server;
        private StateMachine stateMachine;
        private Consumer<RaftProtos.LogEntryProto> notifyTruncatedLogEntry;
        private BiFunction<RaftProtos.LogEntryProto, Boolean, TransactionContext> getTransactionContext;
        private Runnable submitUpdateCommitEvent;
        private RaftStorage storage;
        private LongSupplier snapshotIndexSupplier = () -> -1L;
        private RaftProperties properties;

        private Builder() {
        }

        public Builder setMemberId(RaftGroupMemberId memberId) {
            this.memberId = memberId;
            return this;
        }

        public Builder setServer(RaftServer.Division server) {
            this.server = server;
            this.stateMachine = server.getStateMachine();
            return this;
        }

        public Builder setStateMachine(StateMachine stateMachine) {
            this.stateMachine = stateMachine;
            return this;
        }

        public Builder setNotifyTruncatedLogEntry(Consumer<RaftProtos.LogEntryProto> notifyTruncatedLogEntry) {
            this.notifyTruncatedLogEntry = notifyTruncatedLogEntry;
            return this;
        }

        public Builder setGetTransactionContext(BiFunction<RaftProtos.LogEntryProto, Boolean, TransactionContext> getTransactionContext) {
            this.getTransactionContext = getTransactionContext;
            return this;
        }

        public Builder setSubmitUpdateCommitEvent(Runnable submitUpdateCommitEvent) {
            this.submitUpdateCommitEvent = submitUpdateCommitEvent;
            return this;
        }

        public Builder setStorage(RaftStorage storage) {
            this.storage = storage;
            return this;
        }

        public Builder setSnapshotIndexSupplier(LongSupplier snapshotIndexSupplier) {
            this.snapshotIndexSupplier = snapshotIndexSupplier;
            return this;
        }

        public Builder setProperties(RaftProperties properties) {
            this.properties = properties;
            return this;
        }

        public SegmentedRaftLog build() {
            return new SegmentedRaftLog(this);
        }
    }

    static interface ServerLogMethods {
        public static final ServerLogMethods DUMMY = new ServerLogMethods(){};

        default public long[] getFollowerNextIndices() {
            return null;
        }

        default public long getLastAppliedIndex() {
            return -1L;
        }

        default public void notifyTruncatedLogEntry(TermIndex ti) {
        }

        default public TransactionContext getTransactionContext(RaftProtos.LogEntryProto entry, boolean createNew) {
            return null;
        }
    }

    static abstract class Task {
        private final CompletableFuture<Long> future = new CompletableFuture();
        private Timekeeper.Context queueTimerContext;

        Task() {
        }

        CompletableFuture<Long> getFuture() {
            return this.future;
        }

        void done() {
            this.completeFuture();
        }

        void discard() {
        }

        final void completeFuture() {
            boolean completed = this.future.complete(this.getEndIndex());
            Preconditions.assertTrue((boolean)completed, () -> this + " is already " + StringUtils.completableFuture2String(this.future, (boolean)false));
        }

        void failed(IOException e) {
            this.getFuture().completeExceptionally(e);
        }

        abstract void execute() throws IOException;

        abstract long getEndIndex();

        void startTimerOnEnqueue(Timekeeper queueTimer) {
            this.queueTimerContext = queueTimer.time();
        }

        void stopTimerOnDequeue() {
            if (this.queueTimerContext != null) {
                this.queueTimerContext.stop();
            }
        }

        int getSerializedSize() {
            return 0;
        }

        public String toString() {
            return JavaUtils.getClassSimpleName(this.getClass()) + ":" + this.getEndIndex();
        }
    }
}

