/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.session.subscription;

import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.iotdb.isession.SessionDataSet;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.rpc.subscription.exception.SubscriptionException;
import org.apache.iotdb.session.subscription.SubscriptionSessionConnection;
import org.apache.iotdb.session.subscription.SubscriptionSessionWrapper;
import org.apache.iotdb.session.subscription.model.Subscription;
import org.apache.iotdb.session.subscription.model.Topic;
import org.apache.iotdb.session.subscription.util.IdentifierUtils;
import org.apache.tsfile.read.common.Field;
import org.apache.tsfile.read.common.RowRecord;

abstract class AbstractSubscriptionSession {
    private final SubscriptionSessionWrapper session;

    protected AbstractSubscriptionSession(SubscriptionSessionWrapper session) {
        this.session = session;
    }

    public SubscriptionSessionConnection getSessionConnection() {
        return this.session.getSessionConnection();
    }

    public int getThriftMaxFrameSize() {
        return this.session.getThriftMaxFrameSize();
    }

    protected void open() throws IoTDBConnectionException {
        this.session.open();
    }

    protected void close() throws IoTDBConnectionException {
        this.session.close();
    }

    protected void createTopic(String topicName) throws IoTDBConnectionException, StatementExecutionException {
        IdentifierUtils.checkAndParseIdentifier(topicName);
        String sql = String.format("CREATE TOPIC %s", topicName);
        this.session.executeNonQueryStatement(sql);
    }

    protected void createTopicIfNotExists(String topicName) throws IoTDBConnectionException, StatementExecutionException {
        IdentifierUtils.checkAndParseIdentifier(topicName);
        String sql = String.format("CREATE TOPIC IF NOT EXISTS %s", topicName);
        this.session.executeNonQueryStatement(sql);
    }

    protected void createTopic(String topicName, Properties properties) throws IoTDBConnectionException, StatementExecutionException {
        IdentifierUtils.checkAndParseIdentifier(topicName);
        this.createTopic(topicName, properties, false);
    }

    protected void createTopicIfNotExists(String topicName, Properties properties) throws IoTDBConnectionException, StatementExecutionException {
        IdentifierUtils.checkAndParseIdentifier(topicName);
        this.createTopic(topicName, properties, true);
    }

    private void createTopic(String topicName, Properties properties, boolean isSetIfNotExistsCondition) throws IoTDBConnectionException, StatementExecutionException {
        if (Objects.isNull(properties) || properties.isEmpty()) {
            if (isSetIfNotExistsCondition) {
                this.createTopicIfNotExists(topicName);
            } else {
                this.createTopic(topicName);
            }
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> sb.append('\'').append(k).append('\'').append('=').append('\'').append(v).append('\'').append(',')));
        sb.deleteCharAt(sb.length() - 1);
        sb.append(')');
        String sql = isSetIfNotExistsCondition ? String.format("CREATE TOPIC IF NOT EXISTS %s WITH %s", topicName, sb) : String.format("CREATE TOPIC %s WITH %s", topicName, sb);
        this.session.executeNonQueryStatement(sql);
    }

    protected void dropTopic(String topicName) throws IoTDBConnectionException, StatementExecutionException {
        IdentifierUtils.checkAndParseIdentifier(topicName);
        String sql = String.format("DROP TOPIC %s", topicName);
        this.session.executeNonQueryStatement(sql);
    }

    protected void dropTopicIfExists(String topicName) throws IoTDBConnectionException, StatementExecutionException {
        IdentifierUtils.checkAndParseIdentifier(topicName);
        String sql = String.format("DROP TOPIC IF EXISTS %s", topicName);
        this.session.executeNonQueryStatement(sql);
    }

    protected Set<Topic> getTopics() throws IoTDBConnectionException, StatementExecutionException {
        String sql = "SHOW TOPICS";
        try (SessionDataSet dataSet = this.session.executeQueryStatement("SHOW TOPICS");){
            Set<Topic> set = this.convertDataSetToTopics(dataSet);
            return set;
        }
    }

    protected Optional<Topic> getTopic(String topicName) throws IoTDBConnectionException, StatementExecutionException {
        IdentifierUtils.checkAndParseIdentifier(topicName);
        String sql = String.format("SHOW TOPIC %s", topicName);
        try (SessionDataSet dataSet = this.session.executeQueryStatement(sql);){
            Set<Topic> topics = this.convertDataSetToTopics(dataSet);
            if (topics.isEmpty()) {
                Optional<Topic> optional = Optional.empty();
                return optional;
            }
            Optional<Topic> optional = Optional.of(topics.iterator().next());
            return optional;
        }
    }

    protected Set<Subscription> getSubscriptions() throws IoTDBConnectionException, StatementExecutionException {
        String sql = "SHOW SUBSCRIPTIONS";
        try (SessionDataSet dataSet = this.session.executeQueryStatement("SHOW SUBSCRIPTIONS");){
            Set<Subscription> set = this.convertDataSetToSubscriptions(dataSet);
            return set;
        }
    }

    protected Set<Subscription> getSubscriptions(String topicName) throws IoTDBConnectionException, StatementExecutionException {
        IdentifierUtils.checkAndParseIdentifier(topicName);
        String sql = String.format("SHOW SUBSCRIPTIONS ON %s", topicName);
        try (SessionDataSet dataSet = this.session.executeQueryStatement(sql);){
            Set<Subscription> set = this.convertDataSetToSubscriptions(dataSet);
            return set;
        }
    }

    protected void dropSubscription(String subscriptionId) throws IoTDBConnectionException, StatementExecutionException {
        IdentifierUtils.checkAndParseIdentifier(subscriptionId);
        String sql = String.format("DROP SUBSCRIPTION %s", subscriptionId);
        this.session.executeNonQueryStatement(sql);
    }

    protected void dropSubscriptionIfExists(String subscriptionId) throws IoTDBConnectionException, StatementExecutionException {
        IdentifierUtils.checkAndParseIdentifier(subscriptionId);
        String sql = String.format("DROP SUBSCRIPTION IF EXISTS %s", subscriptionId);
        this.session.executeNonQueryStatement(sql);
    }

    private Set<Topic> convertDataSetToTopics(SessionDataSet dataSet) throws IoTDBConnectionException, StatementExecutionException {
        HashSet<Topic> topics = new HashSet<Topic>();
        while (dataSet.hasNext()) {
            RowRecord record = dataSet.next();
            List fields = record.getFields();
            if (fields.size() != 2) {
                throw new SubscriptionException(String.format("Unexpected fields %s was obtained during SHOW TOPIC...", fields.stream().map(Object::toString).collect(Collectors.joining(", "))));
            }
            topics.add(new Topic(((Field)fields.get(0)).getStringValue(), ((Field)fields.get(1)).getStringValue()));
        }
        return topics;
    }

    private Set<Subscription> convertDataSetToSubscriptions(SessionDataSet dataSet) throws IoTDBConnectionException, StatementExecutionException {
        HashSet<Subscription> subscriptions = new HashSet<Subscription>();
        while (dataSet.hasNext()) {
            RowRecord record = dataSet.next();
            List fields = record.getFields();
            if (fields.size() != 4) {
                throw new SubscriptionException(String.format("Unexpected fields %s was obtained during SHOW SUBSCRIPTION...", fields.stream().map(Object::toString).collect(Collectors.joining(", "))));
            }
            subscriptions.add(new Subscription(((Field)fields.get(0)).getStringValue(), ((Field)fields.get(1)).getStringValue(), ((Field)fields.get(2)).getStringValue(), ((Field)fields.get(3)).getStringValue()));
        }
        return subscriptions;
    }
}

