/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ColumnDefinition;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Property;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.QualifiedName;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Statement;

public class CreateTable
extends Statement {
    private final QualifiedName name;
    private final List<ColumnDefinition> elements;
    private final boolean ifNotExists;
    @Nullable
    private final String charsetName;
    @Nullable
    private final String comment;
    private final List<Property> properties;

    public CreateTable(NodeLocation location, QualifiedName name, List<ColumnDefinition> elements, boolean ifNotExists, @Nullable String charsetName, @Nullable String comment, List<Property> properties) {
        super(Objects.requireNonNull(location, "location is null"));
        this.name = Objects.requireNonNull(name, "name is null");
        this.elements = ImmutableList.copyOf((Collection)Objects.requireNonNull(elements, "elements is null"));
        this.ifNotExists = ifNotExists;
        this.charsetName = charsetName;
        this.comment = comment;
        this.properties = Objects.requireNonNull(properties, "properties is null");
    }

    public QualifiedName getName() {
        return this.name;
    }

    public List<ColumnDefinition> getElements() {
        return this.elements;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public boolean isIfNotExists() {
        return this.ifNotExists;
    }

    public Optional<String> getCharsetName() {
        return Optional.ofNullable(this.charsetName);
    }

    @Nullable
    public String getComment() {
        return this.comment;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitCreateTable(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.builder().addAll(this.elements).addAll(this.properties).build();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateTable that = (CreateTable)o;
        return this.ifNotExists == that.ifNotExists && Objects.equals(this.name, that.name) && Objects.equals(this.elements, that.elements) && Objects.equals(this.charsetName, that.charsetName) && Objects.equals(this.properties, that.properties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.elements, this.ifNotExists, this.charsetName, this.properties);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("elements", this.elements).add("ifNotExists", this.ifNotExists).add("charsetName", (Object)this.charsetName).add("properties", this.properties).toString();
    }
}

