/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.metadata;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.AlignedDeviceEntry;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.NonAlignedAlignedDeviceEntry;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.file.metadata.StringArrayDeviceID;
import org.apache.tsfile.utils.Accountable;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public abstract class DeviceEntry
implements Accountable {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(DeviceEntry.class);
    protected final IDeviceID deviceID;
    protected final Binary[] attributeColumnValues;

    public DeviceEntry(IDeviceID deviceID, Binary[] attributeColumnValues) {
        this.deviceID = deviceID;
        this.attributeColumnValues = attributeColumnValues;
    }

    public IDeviceID getDeviceID() {
        return this.deviceID;
    }

    public Object getNthSegment(int segmentIndex) {
        return segmentIndex < this.deviceID.segmentNum() ? this.deviceID.segment(segmentIndex) : null;
    }

    public Binary[] getAttributeColumnValues() {
        return this.attributeColumnValues;
    }

    public void serialize(ByteBuffer byteBuffer) {
        this.deviceID.serialize(byteBuffer);
        ReadWriteIOUtils.write((int)this.attributeColumnValues.length, (ByteBuffer)byteBuffer);
        for (Binary value : this.attributeColumnValues) {
            DeviceEntry.serializeBinary(byteBuffer, value);
        }
        ReadWriteIOUtils.write((int)(this instanceof AlignedDeviceEntry ? DeviceEntryType.ALIGNED.ordinal() : DeviceEntryType.NON_ALIGNED.ordinal()), (ByteBuffer)byteBuffer);
    }

    public void serialize(DataOutputStream stream) throws IOException {
        this.deviceID.serialize((OutputStream)stream);
        ReadWriteIOUtils.write((int)this.attributeColumnValues.length, (OutputStream)stream);
        for (Binary value : this.attributeColumnValues) {
            DeviceEntry.serializeBinary(stream, value);
        }
        ReadWriteIOUtils.write((int)(this instanceof AlignedDeviceEntry ? DeviceEntryType.ALIGNED.ordinal() : DeviceEntryType.NON_ALIGNED.ordinal()), (OutputStream)stream);
    }

    public static DeviceEntry deserialize(ByteBuffer byteBuffer) {
        StringArrayDeviceID iDeviceID = StringArrayDeviceID.deserialize((ByteBuffer)byteBuffer);
        int size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        Binary[] attributeColumnValues = new Binary[size];
        while (size-- > 0) {
            attributeColumnValues[attributeColumnValues.length - size - 1] = DeviceEntry.deserializeBinary(byteBuffer);
        }
        return DeviceEntry.constructDeviceEntry((IDeviceID)iDeviceID, attributeColumnValues, ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer));
    }

    public static void serializeBinary(ByteBuffer byteBuffer, Binary binary) {
        if (binary == null) {
            ReadWriteIOUtils.write((int)-1, (ByteBuffer)byteBuffer);
            return;
        }
        ReadWriteIOUtils.write((Binary)binary, (ByteBuffer)byteBuffer);
    }

    public static void serializeBinary(DataOutputStream outputStream, Binary binary) throws IOException {
        if (binary == null) {
            ReadWriteIOUtils.write((int)-1, (OutputStream)outputStream);
            return;
        }
        ReadWriteIOUtils.write((Binary)binary, (OutputStream)outputStream);
    }

    public static Binary deserializeBinary(ByteBuffer byteBuffer) {
        int length = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        if (length <= 0) {
            return null;
        }
        byte[] bytes = ReadWriteIOUtils.readBytes((ByteBuffer)byteBuffer, (int)length);
        return new Binary(bytes);
    }

    private static DeviceEntry constructDeviceEntry(IDeviceID deviceID, Binary[] attributeColumnValues, int ordinal) {
        switch (DeviceEntryType.values()[ordinal]) {
            case ALIGNED: {
                return new AlignedDeviceEntry(deviceID, attributeColumnValues);
            }
            case NON_ALIGNED: {
                return new NonAlignedAlignedDeviceEntry(deviceID, attributeColumnValues);
            }
        }
        throw new UnsupportedOperationException("Unknown AlignedDeviceEntry Type: " + (Object)((Object)DeviceEntryType.values()[ordinal]));
    }

    public long ramBytesUsed() {
        return INSTANCE_SIZE + this.deviceID.ramBytesUsed() + RamUsageEstimator.sizeOf((Accountable[])this.attributeColumnValues);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DeviceEntry that = (DeviceEntry)obj;
        return Objects.equals(this.deviceID, that.deviceID) && Arrays.equals(this.attributeColumnValues, that.attributeColumnValues);
    }

    public int hashCode() {
        return Objects.hash(this.deviceID, Arrays.hashCode(this.attributeColumnValues));
    }

    public static enum DeviceEntryType {
        ALIGNED,
        NON_ALIGNED;

    }
}

