/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.plan.node.write;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.common.rpc.thrift.TTimePartitionSlot;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.utils.CommonDateTimeUtils;
import org.apache.iotdb.commons.utils.TestOnly;
import org.apache.iotdb.commons.utils.TimePartitionUtils;
import org.apache.iotdb.db.exception.query.OutOfTTLException;
import org.apache.iotdb.db.queryengine.plan.analyze.IAnalysis;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.WritePlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertMultiTabletsNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertNode;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.fetcher.cache.TreeDeviceSchemaCacheManager;
import org.apache.iotdb.db.storageengine.dataregion.memtable.DeviceIDFactory;
import org.apache.iotdb.db.storageengine.dataregion.wal.buffer.IWALByteBufferView;
import org.apache.iotdb.db.storageengine.dataregion.wal.buffer.WALEntryValue;
import org.apache.iotdb.db.storageengine.dataregion.wal.utils.WALWriteUtils;
import org.apache.iotdb.db.utils.CommonUtils;
import org.apache.iotdb.db.utils.DateTimeUtils;
import org.apache.iotdb.db.utils.QueryDataSetUtils;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.exception.NotImplementedException;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.read.TimeValuePair;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.BitMap;
import org.apache.tsfile.utils.BytesUtils;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.apache.tsfile.utils.TsPrimitiveType;
import org.apache.tsfile.write.UnSupportedDataTypeException;
import org.apache.tsfile.write.schema.IMeasurementSchema;
import org.apache.tsfile.write.schema.MeasurementSchema;

public class InsertTabletNode
extends InsertNode
implements WALEntryValue {
    private static final String DATATYPE_UNSUPPORTED = "Data type %s is not supported.";
    protected long[] times;
    protected BitMap[] bitMaps;
    protected Object[] columns;
    protected int rowCount = 0;
    protected List<Integer> range;

    public InsertTabletNode(PlanNodeId id) {
        super(id);
    }

    @Override
    public InsertNode mergeInsertNode(List<InsertNode> insertNodes) {
        ArrayList<Integer> index = new ArrayList<Integer>();
        ArrayList<InsertTabletNode> insertTabletNodes = new ArrayList<InsertTabletNode>();
        for (int i = 0; i < insertNodes.size(); ++i) {
            insertTabletNodes.add((InsertTabletNode)insertNodes.get(i));
            index.add(i);
        }
        return new InsertMultiTabletsNode(this.getPlanNodeId(), index, insertTabletNodes);
    }

    @TestOnly
    public InsertTabletNode(PlanNodeId id, PartialPath devicePath, boolean isAligned, String[] measurements, TSDataType[] dataTypes, long[] times, BitMap[] bitMaps, Object[] columns, int rowCount) {
        super(id, devicePath, isAligned, measurements, dataTypes);
        this.times = times;
        this.bitMaps = bitMaps;
        this.columns = columns;
        this.rowCount = rowCount;
    }

    public InsertTabletNode(PlanNodeId id, PartialPath devicePath, boolean isAligned, String[] measurements, TSDataType[] dataTypes, MeasurementSchema[] measurementSchemas, long[] times, BitMap[] bitMaps, Object[] columns, int rowCount) {
        super(id, devicePath, isAligned, measurements, dataTypes);
        this.measurementSchemas = measurementSchemas;
        this.times = times;
        this.bitMaps = bitMaps;
        this.columns = columns;
        this.rowCount = rowCount;
    }

    public long[] getTimes() {
        return this.times;
    }

    public void setTimes(long[] times) {
        this.times = times;
    }

    public BitMap[] getBitMaps() {
        return this.bitMaps;
    }

    public void setBitMaps(BitMap[] bitMaps) {
        this.bitMaps = bitMaps;
    }

    public Object[] getColumns() {
        return this.columns;
    }

    public void setColumns(Object[] columns) {
        this.columns = columns;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public void setRowCount(int rowCount) {
        this.rowCount = rowCount;
    }

    public List<Integer> getRange() {
        return this.range;
    }

    public void setRange(List<Integer> range) {
        this.range = range;
    }

    @Override
    public void addChild(PlanNode child) {
    }

    @Override
    public PlanNodeType getType() {
        return PlanNodeType.INSERT_TABLET;
    }

    @Override
    public PlanNode clone() {
        throw new NotImplementedException("clone of Insert is not implemented");
    }

    @Override
    public int allowedChildCount() {
        return 0;
    }

    @Override
    public List<String> getOutputColumnNames() {
        return null;
    }

    @Override
    public List<WritePlanNode> splitByPartition(IAnalysis analysis) {
        if (this.times.length == 0) {
            return Collections.emptyList();
        }
        Map<IDeviceID, PartitionSplitInfo> deviceIDSplitInfoMap = this.collectSplitRanges();
        Map<TRegionReplicaSet, List<Integer>> splitMap = this.splitByReplicaSet(deviceIDSplitInfoMap, analysis);
        return this.doSplit(splitMap);
    }

    private Map<IDeviceID, PartitionSplitInfo> collectSplitRanges() {
        long upperBoundOfTimePartition = TimePartitionUtils.getTimePartitionUpperBound((long)this.times[0]);
        TTimePartitionSlot timePartitionSlot = TimePartitionUtils.getTimePartitionSlot((long)this.times[0]);
        int startLoc = 0;
        IDeviceID currDeviceId = this.getDeviceID(0);
        LinkedHashMap<IDeviceID, PartitionSplitInfo> deviceIDSplitInfoMap = new LinkedHashMap<IDeviceID, PartitionSplitInfo>();
        for (int i = 1; i < this.times.length; ++i) {
            IDeviceID nextDeviceId = this.getDeviceID(i);
            if (this.times[i] < upperBoundOfTimePartition && currDeviceId.equals(nextDeviceId)) continue;
            PartitionSplitInfo splitInfo = deviceIDSplitInfoMap.computeIfAbsent(currDeviceId, deviceID1 -> new PartitionSplitInfo());
            splitInfo.ranges.add(startLoc);
            splitInfo.ranges.add(i);
            splitInfo.timePartitionSlots.add(timePartitionSlot);
            startLoc = i;
            upperBoundOfTimePartition = TimePartitionUtils.getTimePartitionUpperBound((long)this.times[i]);
            timePartitionSlot = TimePartitionUtils.getTimePartitionSlot((long)this.times[i]);
            currDeviceId = nextDeviceId;
        }
        PartitionSplitInfo splitInfo = deviceIDSplitInfoMap.computeIfAbsent(currDeviceId, deviceID1 -> new PartitionSplitInfo());
        splitInfo.ranges.add(startLoc);
        splitInfo.ranges.add(this.times.length);
        splitInfo.timePartitionSlots.add(timePartitionSlot);
        return deviceIDSplitInfoMap;
    }

    protected Map<TRegionReplicaSet, List<Integer>> splitByReplicaSet(Map<IDeviceID, PartitionSplitInfo> deviceIDSplitInfoMap, IAnalysis analysis) {
        HashMap<TRegionReplicaSet, List<Integer>> splitMap = new HashMap<TRegionReplicaSet, List<Integer>>();
        for (Map.Entry<IDeviceID, PartitionSplitInfo> entry : deviceIDSplitInfoMap.entrySet()) {
            List replicaSets;
            IDeviceID deviceID = entry.getKey();
            PartitionSplitInfo splitInfo = entry.getValue();
            splitInfo.replicaSets = replicaSets = analysis.getDataPartitionInfo().getDataRegionReplicaSetForWriting(deviceID, splitInfo.timePartitionSlots, analysis.getDatabaseName());
            analysis.addEndPointToRedirectNodeList(((TDataNodeLocation)((TRegionReplicaSet)replicaSets.get(replicaSets.size() - 1)).getDataNodeLocations().get(0)).getClientRpcEndPoint());
            for (int i = 0; i < replicaSets.size(); ++i) {
                List subRanges = splitMap.computeIfAbsent((TRegionReplicaSet)replicaSets.get(i), x -> new ArrayList());
                subRanges.add(splitInfo.ranges.get(2 * i));
                subRanges.add(splitInfo.ranges.get(2 * i + 1));
            }
        }
        return splitMap;
    }

    private List<WritePlanNode> doSplit(Map<TRegionReplicaSet, List<Integer>> splitMap) {
        Map.Entry<TRegionReplicaSet, List<Integer>> entry;
        ArrayList<WritePlanNode> result = new ArrayList<WritePlanNode>();
        if (splitMap.size() == 1 && (entry = splitMap.entrySet().iterator().next()).getValue().size() == 2) {
            this.setRange(entry.getValue());
            this.setDataRegionReplicaSet(entry.getKey());
            result.add(this);
            return result;
        }
        for (Map.Entry<TRegionReplicaSet, List<Integer>> entry2 : splitMap.entrySet()) {
            result.add(this.generateOneSplit(entry2));
        }
        return result;
    }

    protected InsertTabletNode getEmptySplit(int count) {
        long[] subTimes = new long[count];
        Object[] values = this.initTabletValues(this.dataTypes.length, count, this.dataTypes);
        BitMap[] newBitMaps = this.bitMaps == null ? null : this.initBitmaps(this.dataTypes.length, count);
        return new InsertTabletNode(this.getPlanNodeId(), this.targetPath, this.isAligned, this.measurements, this.dataTypes, this.measurementSchemas, subTimes, newBitMaps, values, subTimes.length);
    }

    private WritePlanNode generateOneSplit(Map.Entry<TRegionReplicaSet, List<Integer>> entry) {
        List<Integer> locs = entry.getValue();
        int count = 0;
        for (int i = 0; i < locs.size(); i += 2) {
            int start = locs.get(i);
            int end = locs.get(i + 1);
            count += end - start;
        }
        InsertTabletNode subNode = this.getEmptySplit(count);
        int destLoc = 0;
        for (int i = 0; i < locs.size(); i += 2) {
            int start = locs.get(i);
            int end = locs.get(i + 1);
            int length = end - start;
            System.arraycopy(this.times, start, subNode.times, destLoc, length);
            for (int k = 0; k < subNode.columns.length; ++k) {
                if (this.dataTypes[k] != null) {
                    System.arraycopy(this.columns[k], start, subNode.columns[k], destLoc, length);
                }
                if (subNode.bitMaps == null || this.bitMaps[k] == null) continue;
                BitMap.copyOfRange((BitMap)this.bitMaps[k], (int)start, (BitMap)subNode.bitMaps[k], (int)destLoc, (int)length);
            }
            destLoc += length;
        }
        subNode.setFailedMeasurementNumber(this.getFailedMeasurementNumber());
        subNode.setRange(locs);
        subNode.setDataRegionReplicaSet(entry.getKey());
        return subNode;
    }

    @TestOnly
    public List<TTimePartitionSlot> getTimePartitionSlots() {
        ArrayList<TTimePartitionSlot> result = new ArrayList<TTimePartitionSlot>();
        long upperBoundOfTimePartition = TimePartitionUtils.getTimePartitionUpperBound((long)this.times[0]);
        TTimePartitionSlot timePartitionSlot = TimePartitionUtils.getTimePartitionSlot((long)this.times[0]);
        for (int i = 1; i < this.times.length; ++i) {
            if (this.times[i] < upperBoundOfTimePartition) continue;
            result.add(timePartitionSlot);
            upperBoundOfTimePartition = TimePartitionUtils.getTimePartitionUpperBound((long)this.times[i]);
            timePartitionSlot = TimePartitionUtils.getTimePartitionSlot((long)this.times[i]);
        }
        result.add(timePartitionSlot);
        return result;
    }

    protected Object[] initTabletValues(int columnSize, int rowSize, TSDataType[] dataTypes) {
        Object[] values = new Object[columnSize];
        block8: for (int i = 0; i < values.length; ++i) {
            if (dataTypes[i] == null) continue;
            switch (dataTypes[i]) {
                case TEXT: 
                case BLOB: 
                case STRING: {
                    values[i] = new Binary[rowSize];
                    continue block8;
                }
                case FLOAT: {
                    values[i] = new float[rowSize];
                    continue block8;
                }
                case INT32: 
                case DATE: {
                    values[i] = new int[rowSize];
                    continue block8;
                }
                case TIMESTAMP: 
                case INT64: {
                    values[i] = new long[rowSize];
                    continue block8;
                }
                case DOUBLE: {
                    values[i] = new double[rowSize];
                    continue block8;
                }
                case BOOLEAN: {
                    values[i] = new boolean[rowSize];
                }
            }
        }
        return values;
    }

    protected BitMap[] initBitmaps(int columnSize, int rowSize) {
        BitMap[] bitMaps = new BitMap[columnSize];
        for (int i = 0; i < columnSize; ++i) {
            bitMaps[i] = new BitMap(rowSize);
        }
        return bitMaps;
    }

    @Override
    public void markFailedMeasurement(int index) {
        if (this.measurements[index] == null) {
            return;
        }
        this.measurements[index] = null;
        this.dataTypes[index] = null;
        this.columns[index] = null;
    }

    @Override
    public long getMinTime() {
        return this.times[0];
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        this.getType().serialize(byteBuffer);
        this.subSerialize(byteBuffer);
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        this.getType().serialize(stream);
        this.subSerialize(stream);
    }

    void subSerialize(ByteBuffer buffer) {
        ReadWriteIOUtils.write((String)this.targetPath.getFullPath(), (ByteBuffer)buffer);
        this.writeMeasurementsOrSchemas(buffer);
        this.writeDataTypes(buffer);
        this.writeTimes(buffer);
        this.writeBitMaps(buffer);
        this.writeValues(buffer);
        ReadWriteIOUtils.write((byte)((byte)(this.isAligned ? 1 : 0)), (ByteBuffer)buffer);
    }

    void subSerialize(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((String)this.targetPath.getFullPath(), (OutputStream)stream);
        this.writeMeasurementsOrSchemas(stream);
        this.writeDataTypes(stream);
        this.writeTimes(stream);
        this.writeBitMaps(stream);
        this.writeValues(stream);
        ReadWriteIOUtils.write((byte)((byte)(this.isAligned ? 1 : 0)), (OutputStream)stream);
    }

    private void writeMeasurementsOrSchemas(ByteBuffer buffer) {
        ReadWriteIOUtils.write((int)(this.measurements.length - this.getFailedMeasurementNumber()), (ByteBuffer)buffer);
        ReadWriteIOUtils.write((byte)((byte)(this.measurementSchemas != null ? 1 : 0)), (ByteBuffer)buffer);
        for (int i = 0; i < this.measurements.length; ++i) {
            if (this.measurements[i] == null) continue;
            if (this.measurementSchemas != null) {
                this.measurementSchemas[i].serializeTo(buffer);
                continue;
            }
            ReadWriteIOUtils.write((String)this.measurements[i], (ByteBuffer)buffer);
        }
    }

    private void writeMeasurementsOrSchemas(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((int)(this.measurements.length - this.getFailedMeasurementNumber()), (OutputStream)stream);
        ReadWriteIOUtils.write((byte)((byte)(this.measurementSchemas != null ? 1 : 0)), (OutputStream)stream);
        for (int i = 0; i < this.measurements.length; ++i) {
            if (this.measurements[i] == null) continue;
            if (this.measurementSchemas != null) {
                this.measurementSchemas[i].serializeTo((OutputStream)stream);
                continue;
            }
            ReadWriteIOUtils.write((String)this.measurements[i], (OutputStream)stream);
        }
    }

    private void writeDataTypes(ByteBuffer buffer) {
        for (int i = 0; i < this.dataTypes.length; ++i) {
            if (this.measurements[i] == null) continue;
            this.dataTypes[i].serializeTo(buffer);
        }
    }

    private void writeDataTypes(DataOutputStream stream) throws IOException {
        for (int i = 0; i < this.dataTypes.length; ++i) {
            if (this.measurements[i] == null) continue;
            this.dataTypes[i].serializeTo(stream);
        }
    }

    private void writeTimes(ByteBuffer buffer) {
        ReadWriteIOUtils.write((int)this.rowCount, (ByteBuffer)buffer);
        for (long time : this.times) {
            ReadWriteIOUtils.write((long)time, (ByteBuffer)buffer);
        }
    }

    private void writeTimes(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((int)this.rowCount, (OutputStream)stream);
        for (long time : this.times) {
            ReadWriteIOUtils.write((long)time, (OutputStream)stream);
        }
    }

    private void writeBitMaps(ByteBuffer buffer) {
        ReadWriteIOUtils.write((byte)BytesUtils.boolToByte((this.bitMaps != null ? 1 : 0) != 0), (ByteBuffer)buffer);
        if (this.bitMaps != null) {
            for (int i = 0; i < this.bitMaps.length; ++i) {
                if (this.measurements[i] == null) continue;
                if (this.bitMaps[i] == null) {
                    ReadWriteIOUtils.write((byte)BytesUtils.boolToByte((boolean)false), (ByteBuffer)buffer);
                    continue;
                }
                ReadWriteIOUtils.write((byte)BytesUtils.boolToByte((boolean)true), (ByteBuffer)buffer);
                buffer.put(this.bitMaps[i].getByteArray());
            }
        }
    }

    private void writeBitMaps(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((byte)BytesUtils.boolToByte((this.bitMaps != null ? 1 : 0) != 0), (OutputStream)stream);
        if (this.bitMaps != null) {
            for (int i = 0; i < this.bitMaps.length; ++i) {
                if (this.measurements[i] == null) continue;
                if (this.bitMaps[i] == null) {
                    ReadWriteIOUtils.write((byte)BytesUtils.boolToByte((boolean)false), (OutputStream)stream);
                    continue;
                }
                ReadWriteIOUtils.write((byte)BytesUtils.boolToByte((boolean)true), (OutputStream)stream);
                stream.write(this.bitMaps[i].getByteArray());
            }
        }
    }

    private void writeValues(ByteBuffer buffer) {
        for (int i = 0; i < this.columns.length; ++i) {
            if (this.measurements[i] == null) continue;
            this.serializeColumn(this.dataTypes[i], this.columns[i], buffer);
        }
    }

    private void writeValues(DataOutputStream stream) throws IOException {
        for (int i = 0; i < this.columns.length; ++i) {
            if (this.measurements[i] == null) continue;
            this.serializeColumn(this.dataTypes[i], this.columns[i], stream);
        }
    }

    private void serializeColumn(TSDataType dataType, Object column, ByteBuffer buffer) {
        switch (dataType) {
            case INT32: 
            case DATE: {
                int[] intValues = (int[])column;
                for (int j = 0; j < this.rowCount; ++j) {
                    ReadWriteIOUtils.write((int)intValues[j], (ByteBuffer)buffer);
                }
                break;
            }
            case TIMESTAMP: 
            case INT64: {
                long[] longValues = (long[])column;
                for (int j = 0; j < this.rowCount; ++j) {
                    ReadWriteIOUtils.write((long)longValues[j], (ByteBuffer)buffer);
                }
                break;
            }
            case FLOAT: {
                float[] floatValues = (float[])column;
                for (int j = 0; j < this.rowCount; ++j) {
                    ReadWriteIOUtils.write((float)floatValues[j], (ByteBuffer)buffer);
                }
                break;
            }
            case DOUBLE: {
                double[] doubleValues = (double[])column;
                for (int j = 0; j < this.rowCount; ++j) {
                    ReadWriteIOUtils.write((double)doubleValues[j], (ByteBuffer)buffer);
                }
                break;
            }
            case BOOLEAN: {
                boolean[] boolValues = (boolean[])column;
                for (int j = 0; j < this.rowCount; ++j) {
                    ReadWriteIOUtils.write((byte)BytesUtils.boolToByte((boolean)boolValues[j]), (ByteBuffer)buffer);
                }
                break;
            }
            case TEXT: 
            case BLOB: 
            case STRING: {
                Binary[] binaryValues = (Binary[])column;
                for (int j = 0; j < this.rowCount; ++j) {
                    if (binaryValues[j] != null) {
                        ReadWriteIOUtils.write((Binary)binaryValues[j], (ByteBuffer)buffer);
                        continue;
                    }
                    ReadWriteIOUtils.write((int)0, (ByteBuffer)buffer);
                }
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format(DATATYPE_UNSUPPORTED, dataType));
            }
        }
    }

    private void serializeColumn(TSDataType dataType, Object column, DataOutputStream stream) throws IOException {
        switch (dataType) {
            case INT32: 
            case DATE: {
                int[] intValues = (int[])column;
                for (int j = 0; j < this.rowCount; ++j) {
                    ReadWriteIOUtils.write((int)intValues[j], (OutputStream)stream);
                }
                break;
            }
            case TIMESTAMP: 
            case INT64: {
                long[] longValues = (long[])column;
                for (int j = 0; j < this.rowCount; ++j) {
                    ReadWriteIOUtils.write((long)longValues[j], (OutputStream)stream);
                }
                break;
            }
            case FLOAT: {
                float[] floatValues = (float[])column;
                for (int j = 0; j < this.rowCount; ++j) {
                    ReadWriteIOUtils.write((float)floatValues[j], (OutputStream)stream);
                }
                break;
            }
            case DOUBLE: {
                double[] doubleValues = (double[])column;
                for (int j = 0; j < this.rowCount; ++j) {
                    ReadWriteIOUtils.write((double)doubleValues[j], (OutputStream)stream);
                }
                break;
            }
            case BOOLEAN: {
                boolean[] boolValues = (boolean[])column;
                for (int j = 0; j < this.rowCount; ++j) {
                    ReadWriteIOUtils.write((byte)BytesUtils.boolToByte((boolean)boolValues[j]), (OutputStream)stream);
                }
                break;
            }
            case TEXT: 
            case BLOB: 
            case STRING: {
                Binary[] binaryValues = (Binary[])column;
                for (int j = 0; j < this.rowCount; ++j) {
                    if (binaryValues[j] != null) {
                        ReadWriteIOUtils.write((Binary)binaryValues[j], (OutputStream)stream);
                        continue;
                    }
                    ReadWriteIOUtils.write((int)0, (OutputStream)stream);
                }
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format(DATATYPE_UNSUPPORTED, dataType));
            }
        }
    }

    public static InsertTabletNode deserialize(ByteBuffer byteBuffer) {
        InsertTabletNode insertNode = new InsertTabletNode(new PlanNodeId(""));
        insertNode.subDeserialize(byteBuffer);
        insertNode.setPlanNodeId(PlanNodeId.deserialize(byteBuffer));
        return insertNode;
    }

    public void subDeserialize(ByteBuffer buffer) {
        int i;
        boolean hasSchema;
        try {
            this.targetPath = this.readTargetPath(buffer);
        }
        catch (IllegalPathException e) {
            throw new IllegalArgumentException("Cannot deserialize InsertTabletNode", e);
        }
        int measurementSize = buffer.getInt();
        this.measurements = new String[measurementSize];
        boolean bl = hasSchema = buffer.get() == 1;
        if (hasSchema) {
            this.measurementSchemas = new MeasurementSchema[measurementSize];
            for (i = 0; i < measurementSize; ++i) {
                this.measurementSchemas[i] = MeasurementSchema.deserializeFrom((ByteBuffer)buffer);
                this.measurements[i] = this.measurementSchemas[i].getMeasurementName();
            }
        } else {
            for (i = 0; i < measurementSize; ++i) {
                this.measurements[i] = ReadWriteIOUtils.readString((ByteBuffer)buffer);
            }
        }
        this.dataTypes = new TSDataType[measurementSize];
        for (i = 0; i < measurementSize; ++i) {
            this.dataTypes[i] = TSDataType.deserialize((byte)buffer.get());
        }
        this.rowCount = buffer.getInt();
        this.times = new long[this.rowCount];
        this.times = QueryDataSetUtils.readTimesFromBuffer(buffer, this.rowCount);
        boolean hasBitMaps = BytesUtils.byteToBool((byte)buffer.get());
        if (hasBitMaps) {
            this.bitMaps = QueryDataSetUtils.readBitMapsFromBuffer(buffer, measurementSize, this.rowCount).orElse(null);
        }
        this.columns = QueryDataSetUtils.readTabletValuesFromBuffer(buffer, this.dataTypes, measurementSize, this.rowCount);
        this.isAligned = buffer.get() == 1;
    }

    @Override
    public int serializedSize() {
        return this.serializedSize(0, this.rowCount);
    }

    public int serializedSize(int start, int end) {
        return 2 + this.subSerializeSize(start, end);
    }

    int subSerializeSize(int start, int end) {
        int i;
        int size = 0;
        size += 8;
        size += ReadWriteIOUtils.sizeToWrite((String)this.targetPath.getFullPath());
        size += 4;
        size += this.serializeMeasurementSchemasSize();
        size += 4;
        size += 8 * (end - start);
        ++size;
        if (this.bitMaps != null) {
            for (i = 0; i < this.bitMaps.length; ++i) {
                if (this.measurements[i] == null) continue;
                ++size;
                if (this.bitMaps[i] == null) continue;
                int len = end - start;
                BitMap partBitMap = new BitMap(len);
                BitMap.copyOfRange((BitMap)this.bitMaps[i], (int)start, (BitMap)partBitMap, (int)0, (int)len);
                size += partBitMap.getByteArray().length;
            }
        }
        for (i = 0; i < this.dataTypes.length; ++i) {
            if (this.columns[i] == null) continue;
            size += this.getColumnSize(this.dataTypes[i], this.columns[i], start, end);
        }
        return ++size;
    }

    private int getColumnSize(TSDataType dataType, Object column, int start, int end) {
        int size = 0;
        switch (dataType) {
            case INT32: 
            case DATE: {
                size += 4 * (end - start);
                break;
            }
            case TIMESTAMP: 
            case INT64: {
                size += 8 * (end - start);
                break;
            }
            case FLOAT: {
                size += 4 * (end - start);
                break;
            }
            case DOUBLE: {
                size += 8 * (end - start);
                break;
            }
            case BOOLEAN: {
                size += 1 * (end - start);
                break;
            }
            case TEXT: 
            case BLOB: 
            case STRING: {
                Binary[] binaryValues = (Binary[])column;
                for (int j = start; j < end; ++j) {
                    size += ReadWriteIOUtils.sizeToWrite((Binary)binaryValues[j]);
                }
                break;
            }
        }
        return size;
    }

    @Override
    public void serializeToWAL(IWALByteBufferView buffer) {
        this.serializeToWAL(buffer, Collections.singletonList(new int[]{0, this.rowCount}));
    }

    public void serializeToWAL(IWALByteBufferView buffer, List<int[]> rangeList) {
        buffer.putShort(this.getType().getNodeType());
        this.subSerialize(buffer, rangeList);
    }

    void subSerialize(IWALByteBufferView buffer, List<int[]> rangeList) {
        buffer.putLong(this.searchIndex);
        WALWriteUtils.write(this.targetPath.getFullPath(), buffer);
        this.writeMeasurementSchemas(buffer);
        int rowNumInRange = 0;
        for (int[] startEnd : rangeList) {
            rowNumInRange += startEnd[1] - startEnd[0];
        }
        this.writeTimes(buffer, rangeList, rowNumInRange);
        this.writeBitMaps(buffer, rangeList, rowNumInRange);
        this.writeValues(buffer, rangeList);
        buffer.put((byte)(this.isAligned ? 1 : 0));
    }

    protected void writeMeasurementSchemas(IWALByteBufferView buffer) {
        buffer.putInt(this.measurements.length - this.getFailedMeasurementNumber());
        this.serializeMeasurementSchemasToWAL(buffer);
    }

    protected void writeTimes(IWALByteBufferView buffer, List<int[]> rangeList, int rowNumInRange) {
        buffer.putInt(rowNumInRange);
        for (int[] startEnd : rangeList) {
            for (int i = startEnd[0]; i < startEnd[1]; ++i) {
                buffer.putLong(this.times[i]);
            }
        }
    }

    protected void writeBitMaps(IWALByteBufferView buffer, List<int[]> rangeList, int rowNumInRange) {
        buffer.put(BytesUtils.boolToByte((this.bitMaps != null ? 1 : 0) != 0));
        if (this.bitMaps != null) {
            for (int i = 0; i < this.bitMaps.length; ++i) {
                if (this.measurements[i] == null) continue;
                if (this.bitMaps[i] == null) {
                    buffer.put(BytesUtils.boolToByte((boolean)false));
                    continue;
                }
                buffer.put(BytesUtils.boolToByte((boolean)true));
                BitMap partBitMap = new BitMap(rowNumInRange);
                int copiedLength = 0;
                for (int[] startEnd : rangeList) {
                    int len = startEnd[1] - startEnd[0];
                    BitMap.copyOfRange((BitMap)this.bitMaps[i], (int)startEnd[0], (BitMap)partBitMap, (int)copiedLength, (int)len);
                    copiedLength += len;
                }
                buffer.put(partBitMap.getByteArray());
            }
        }
    }

    protected void writeValues(IWALByteBufferView buffer, List<int[]> rangeList) {
        for (int i = 0; i < this.columns.length; ++i) {
            if (this.measurements[i] == null) continue;
            for (int[] startEnd : rangeList) {
                this.serializeColumn(this.dataTypes[i], this.columns[i], buffer, startEnd[0], startEnd[1]);
            }
        }
    }

    private void serializeColumn(TSDataType dataType, Object column, IWALByteBufferView buffer, int start, int end) {
        switch (dataType) {
            case INT32: 
            case DATE: {
                int[] intValues = (int[])column;
                for (int j = start; j < end; ++j) {
                    buffer.putInt(intValues[j]);
                }
                break;
            }
            case TIMESTAMP: 
            case INT64: {
                long[] longValues = (long[])column;
                for (int j = start; j < end; ++j) {
                    buffer.putLong(longValues[j]);
                }
                break;
            }
            case FLOAT: {
                float[] floatValues = (float[])column;
                for (int j = start; j < end; ++j) {
                    buffer.putFloat(floatValues[j]);
                }
                break;
            }
            case DOUBLE: {
                double[] doubleValues = (double[])column;
                for (int j = start; j < end; ++j) {
                    buffer.putDouble(doubleValues[j]);
                }
                break;
            }
            case BOOLEAN: {
                boolean[] boolValues = (boolean[])column;
                for (int j = start; j < end; ++j) {
                    buffer.put(BytesUtils.boolToByte((boolean)boolValues[j]));
                }
                break;
            }
            case TEXT: 
            case BLOB: 
            case STRING: {
                Binary[] binaryValues = (Binary[])column;
                for (int j = start; j < end; ++j) {
                    if (binaryValues[j] != null) {
                        buffer.putInt(binaryValues[j].getLength());
                        buffer.put(binaryValues[j].getValues());
                        continue;
                    }
                    buffer.putInt(0);
                }
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format(DATATYPE_UNSUPPORTED, dataType));
            }
        }
    }

    public static InsertTabletNode deserializeFromWAL(DataInputStream stream) throws IOException {
        InsertTabletNode insertNode = new InsertTabletNode(new PlanNodeId(""));
        insertNode.subDeserializeFromWAL(stream);
        return insertNode;
    }

    protected void subDeserializeFromWAL(DataInputStream stream) throws IOException {
        this.searchIndex = stream.readLong();
        try {
            this.targetPath = this.readTargetPath(stream);
        }
        catch (IllegalPathException e) {
            throw new IllegalArgumentException("Cannot deserialize InsertTabletNode", e);
        }
        int measurementSize = stream.readInt();
        this.measurements = new String[measurementSize];
        this.measurementSchemas = new MeasurementSchema[measurementSize];
        this.dataTypes = new TSDataType[measurementSize];
        this.deserializeMeasurementSchemas(stream);
        this.rowCount = stream.readInt();
        this.times = new long[this.rowCount];
        this.times = QueryDataSetUtils.readTimesFromStream(stream, this.rowCount);
        boolean hasBitMaps = BytesUtils.byteToBool((byte)stream.readByte());
        if (hasBitMaps) {
            this.bitMaps = QueryDataSetUtils.readBitMapsFromStream(stream, measurementSize, this.rowCount).orElse(null);
        }
        this.columns = QueryDataSetUtils.readTabletValuesFromStream(stream, this.dataTypes, measurementSize, this.rowCount);
        this.isAligned = stream.readByte() == 1;
    }

    public static InsertTabletNode deserializeFromWAL(ByteBuffer buffer) {
        InsertTabletNode insertNode = new InsertTabletNode(new PlanNodeId(""));
        insertNode.subDeserializeFromWAL(buffer);
        return insertNode;
    }

    protected void subDeserializeFromWAL(ByteBuffer buffer) {
        this.searchIndex = buffer.getLong();
        try {
            this.targetPath = this.readTargetPath(buffer);
        }
        catch (IllegalPathException e) {
            throw new IllegalArgumentException("Cannot deserialize InsertTabletNode", e);
        }
        int measurementSize = buffer.getInt();
        this.measurements = new String[measurementSize];
        this.measurementSchemas = new MeasurementSchema[measurementSize];
        this.deserializeMeasurementSchemas(buffer);
        this.dataTypes = new TSDataType[measurementSize];
        for (int i = 0; i < measurementSize; ++i) {
            this.dataTypes[i] = this.measurementSchemas[i].getType();
        }
        this.rowCount = buffer.getInt();
        this.times = new long[this.rowCount];
        this.times = QueryDataSetUtils.readTimesFromBuffer(buffer, this.rowCount);
        boolean hasBitMaps = BytesUtils.byteToBool((byte)buffer.get());
        if (hasBitMaps) {
            this.bitMaps = QueryDataSetUtils.readBitMapsFromBuffer(buffer, measurementSize, this.rowCount).orElse(null);
        }
        this.columns = QueryDataSetUtils.readTabletValuesFromBuffer(buffer, this.dataTypes, measurementSize, this.rowCount);
        this.isAligned = buffer.get() == 1;
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(super.hashCode(), this.rowCount, this.range);
        result = 31 * result + Arrays.hashCode(this.times);
        result = 31 * result + Arrays.hashCode(this.bitMaps);
        result = 31 * result + Arrays.deepHashCode(this.columns);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InsertTabletNode that = (InsertTabletNode)o;
        return this.rowCount == that.rowCount && Arrays.equals(this.times, that.times) && Arrays.equals(this.bitMaps, that.bitMaps) && this.equals(that.columns) && Objects.equals(this.range, that.range);
    }

    private boolean equals(Object[] columns) {
        if (this.columns == columns) {
            return true;
        }
        if (columns == null || this.columns == null || columns.length != this.columns.length) {
            return false;
        }
        block8: for (int i = 0; i < columns.length; ++i) {
            if (this.dataTypes[i] != null) {
                switch (this.dataTypes[i]) {
                    case INT32: 
                    case DATE: {
                        if (Arrays.equals((int[])this.columns[i], (int[])columns[i])) continue block8;
                        return false;
                    }
                    case TIMESTAMP: 
                    case INT64: {
                        if (Arrays.equals((long[])this.columns[i], (long[])columns[i])) continue block8;
                        return false;
                    }
                    case FLOAT: {
                        if (Arrays.equals((float[])this.columns[i], (float[])columns[i])) continue block8;
                        return false;
                    }
                    case DOUBLE: {
                        if (Arrays.equals((double[])this.columns[i], (double[])columns[i])) continue block8;
                        return false;
                    }
                    case BOOLEAN: {
                        if (Arrays.equals((boolean[])this.columns[i], (boolean[])columns[i])) continue block8;
                        return false;
                    }
                    case TEXT: 
                    case BLOB: 
                    case STRING: {
                        if (Arrays.equals((Binary[])this.columns[i], (Binary[])columns[i])) continue block8;
                        return false;
                    }
                    default: {
                        throw new UnSupportedDataTypeException(String.format(DATATYPE_UNSUPPORTED, this.dataTypes[i]));
                    }
                }
            }
            if (columns[i].equals(columns)) continue;
            return false;
        }
        return true;
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitInsertTablet(this, context);
    }

    public TimeValuePair composeLastTimeValuePair(int measurementIndex, int startOffset, int endOffset) {
        TsPrimitiveType.TsInt value;
        int lastIdx;
        if (measurementIndex >= this.columns.length || Objects.isNull(this.dataTypes[measurementIndex])) {
            return null;
        }
        if (this.bitMaps != null && this.bitMaps[measurementIndex] != null) {
            BitMap bitMap = this.bitMaps[measurementIndex];
            for (lastIdx = Math.min(endOffset - 1, this.rowCount - 1); lastIdx >= startOffset && bitMap.isMarked(lastIdx); --lastIdx) {
            }
        }
        if (lastIdx < startOffset) {
            return null;
        }
        switch (this.dataTypes[measurementIndex]) {
            case INT32: 
            case DATE: {
                int[] intValues = (int[])this.columns[measurementIndex];
                value = new TsPrimitiveType.TsInt(intValues[lastIdx]);
                break;
            }
            case TIMESTAMP: 
            case INT64: {
                long[] longValues = (long[])this.columns[measurementIndex];
                value = new TsPrimitiveType.TsLong(longValues[lastIdx]);
                break;
            }
            case FLOAT: {
                float[] floatValues = (float[])this.columns[measurementIndex];
                value = new TsPrimitiveType.TsFloat(floatValues[lastIdx]);
                break;
            }
            case DOUBLE: {
                double[] doubleValues = (double[])this.columns[measurementIndex];
                value = new TsPrimitiveType.TsDouble(doubleValues[lastIdx]);
                break;
            }
            case BOOLEAN: {
                boolean[] boolValues = (boolean[])this.columns[measurementIndex];
                value = new TsPrimitiveType.TsBoolean(boolValues[lastIdx]);
                break;
            }
            case TEXT: 
            case BLOB: 
            case STRING: {
                Binary[] binaryValues = (Binary[])this.columns[measurementIndex];
                value = new TsPrimitiveType.TsBinary(binaryValues[lastIdx]);
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format(DATATYPE_UNSUPPORTED, this.dataTypes[measurementIndex]));
            }
        }
        return new TimeValuePair(this.times[lastIdx], (TsPrimitiveType)value);
    }

    public TimeValuePair composeLastTimeValuePair(int measurementIndex) {
        return this.composeLastTimeValuePair(measurementIndex, 0, this.rowCount);
    }

    public IDeviceID getDeviceID(int rowIdx) {
        if (this.deviceID != null) {
            return this.deviceID;
        }
        this.deviceID = DeviceIDFactory.getInstance().getDeviceID(this.targetPath);
        return this.deviceID;
    }

    public List<Pair<IDeviceID, Integer>> splitByDevice(int start, int end) {
        return Collections.singletonList(new Pair((Object)this.getDeviceID(), (Object)end));
    }

    public int checkTTL(TSStatus[] results, long ttl) throws OutOfTTLException {
        return this.checkTTLInternal(results, ttl, true);
    }

    protected int checkTTLInternal(TSStatus[] results, long ttl, boolean breakOnFirstAlive) throws OutOfTTLException {
        int firstAliveLoc = -1;
        for (int loc = 0; loc < this.getRowCount(); ++loc) {
            long currTime = this.getTimes()[loc];
            if (!CommonUtils.isAlive(currTime, ttl)) {
                results[loc] = RpcUtils.getStatus((TSStatusCode)TSStatusCode.OUT_OF_TTL, (String)String.format("Insertion time [%s] is less than ttl time bound [%s]", DateTimeUtils.convertLongToDate(currTime), DateTimeUtils.convertLongToDate(CommonDateTimeUtils.currentTime() - ttl)));
                continue;
            }
            if (firstAliveLoc == -1) {
                firstAliveLoc = loc;
            }
            if (breakOnFirstAlive) break;
        }
        if (firstAliveLoc == -1) {
            throw new OutOfTTLException(this.getTimes()[this.getTimes().length - 1], CommonDateTimeUtils.currentTime() - ttl);
        }
        return firstAliveLoc;
    }

    public void updateLastCache(String databaseName) {
        String[] rawMeasurements = this.getRawMeasurements();
        TimeValuePair[] timeValuePairs = new TimeValuePair[rawMeasurements.length];
        for (int i = 0; i < rawMeasurements.length; ++i) {
            timeValuePairs[i] = this.composeLastTimeValuePair(i);
        }
        TreeDeviceSchemaCacheManager.getInstance().updateLastCacheIfExists(databaseName, this.getDeviceID(), rawMeasurements, timeValuePairs, this.isAligned, (IMeasurementSchema[])this.measurementSchemas);
    }

    protected static class PartitionSplitInfo {
        List<Integer> ranges = new ArrayList<Integer>();
        List<TTimePartitionSlot> timePartitionSlots = new ArrayList<TTimePartitionSlot>();
        List<TRegionReplicaSet> replicaSets;

        protected PartitionSplitInfo() {
        }
    }
}

