/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation;

import com.google.common.base.Preconditions;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.iotdb.commons.exception.IoTDBRuntimeException;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class HyperLogLog {
    private final int[] registers;
    private final int m;
    private final int b;
    private final double alpha;
    private static final HashFunction hashFunction = Hashing.murmur3_128();
    public static final double DEFAULT_STANDARD_ERROR = 0.023;
    private static final double LOWEST_MAX_STANDARD_ERROR = 0.0040625;
    private static final double HIGHEST_MAX_STANDARD_ERROR = 0.26;
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(HyperLogLog.class);

    public HyperLogLog(double maxStandardError) {
        int precision;
        int buckets = HyperLogLog.standardErrorToBuckets(maxStandardError);
        this.b = precision = HyperLogLog.indexBitLength(buckets);
        this.m = buckets;
        this.registers = new int[this.m];
        this.alpha = HyperLogLog.getAlpha(precision, this.m);
    }

    public HyperLogLog(byte[] bytes) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        this.b = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        this.m = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        this.registers = new int[this.m];
        for (int i = 0; i < this.m; ++i) {
            this.registers[i] = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        }
        this.alpha = HyperLogLog.getAlpha(this.b, this.m);
    }

    private static double getAlpha(int precision, int m) {
        switch (precision) {
            case 4: {
                return 0.673;
            }
            case 5: {
                return 0.697;
            }
            case 6: {
                return 0.709;
            }
        }
        return 0.7213 / (1.0 + 1.079 / (double)m);
    }

    private static boolean isPowerOf2(long value) {
        Preconditions.checkArgument((value > 0L ? 1 : 0) != 0, (Object)"value must be positive");
        return (value & value - 1L) == 0L;
    }

    private static int indexBitLength(int numberOfBuckets) {
        Preconditions.checkArgument((boolean)HyperLogLog.isPowerOf2(numberOfBuckets), (String)"numberOfBuckets must be a power of 2, actual: %s", (int)numberOfBuckets);
        return Integer.numberOfTrailingZeros(numberOfBuckets);
    }

    private static int standardErrorToBuckets(double maxStandardError) {
        if (maxStandardError < 0.0040625 || maxStandardError > 0.26) {
            throw new IoTDBRuntimeException(String.format("Max Standard Error must be in [%s, %s]: %s", 0.0040625, 0.26, maxStandardError), TSStatusCode.NUMERIC_VALUE_OUT_OF_RANGE.getStatusCode(), true);
        }
        return HyperLogLog.log2Ceiling((int)Math.ceil(1.04 / (maxStandardError * maxStandardError)));
    }

    private static int log2Ceiling(int value) {
        return Integer.highestOneBit(value - 1) << 1;
    }

    public void add(boolean value) {
        this.offer(hashFunction.hashString((CharSequence)String.valueOf(value), StandardCharsets.UTF_8).asLong());
    }

    public void add(int value) {
        this.offer(hashFunction.hashInt(value).asLong());
    }

    public void add(long value) {
        this.offer(hashFunction.hashLong(value).asLong());
    }

    public void add(float value) {
        this.offer(hashFunction.hashString((CharSequence)String.valueOf(value), StandardCharsets.UTF_8).asLong());
    }

    public void add(double value) {
        this.offer(hashFunction.hashString((CharSequence)String.valueOf(value), StandardCharsets.UTF_8).asLong());
    }

    public void add(Binary value) {
        this.offer(hashFunction.hashBytes(value.getValues()).asLong());
    }

    public void offer(long hash) {
        int idx = (int)(hash & (long)(this.m - 1));
        int leadingZeros = Long.numberOfTrailingZeros(hash >>> this.b) + 1;
        this.registers[idx] = Math.max(this.registers[idx], leadingZeros);
    }

    public long cardinality() {
        double sum = 0.0;
        int zeros = 0;
        for (int i = 0; i < this.m; ++i) {
            sum += 1.0 / (double)(1 << this.registers[i]);
            if (this.registers[i] != 0) continue;
            ++zeros;
        }
        double estimate = this.alpha * (double)this.m * (double)this.m / sum;
        if (estimate <= 2.5 * (double)this.m && zeros > 0) {
            return Math.round((double)this.m * Math.log((double)this.m / (double)zeros));
        }
        double maxCardinality = 4.294967296E9;
        if (estimate > maxCardinality / 30.0) {
            return Math.round(-maxCardinality * Math.log(1.0 - estimate / maxCardinality));
        }
        return Math.round(estimate);
    }

    public void reset() {
        Arrays.fill(this.registers, 0);
    }

    public void merge(HyperLogLog other) {
        if (this.m != other.m) {
            throw new IllegalArgumentException("Cannot merge HyperLogLog instances with different precision");
        }
        for (int i = 0; i < this.m; ++i) {
            this.registers[i] = Math.max(this.registers[i], other.registers[i]);
        }
    }

    public byte[] serialize() {
        int totalBytes = 8 + this.registers.length * 4;
        ByteBuffer byteBuffer = ByteBuffer.allocate(totalBytes);
        ReadWriteIOUtils.write((int)this.b, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((int)this.m, (ByteBuffer)byteBuffer);
        for (int i = 0; i < this.m; ++i) {
            ReadWriteIOUtils.write((int)this.registers[i], (ByteBuffer)byteBuffer);
        }
        return byteBuffer.array();
    }

    public boolean equals(HyperLogLog hll) {
        return Arrays.equals(this.serialize(), hll.serialize());
    }

    public long getEstimatedSize() {
        return INSTANCE_SIZE + (long)Math.toIntExact(this.registers.length * 4);
    }
}

