/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.resource.tsfile;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.db.pipe.resource.PipeDataNodeResourceManager;
import org.apache.iotdb.db.pipe.resource.memory.PipeMemoryBlock;
import org.apache.iotdb.db.pipe.resource.memory.PipeMemoryWeightUtil;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.read.TsFileDeviceIterator;
import org.apache.tsfile.read.TsFileSequenceReader;
import org.apache.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeTsFileResource
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeTsFileResource.class);
    public static final long TSFILE_MIN_TIME_TO_LIVE_IN_MS = 20000L;
    public static final float MEMORY_SUFFICIENT_THRESHOLD = 0.7f;
    private final File hardlinkOrCopiedFile;
    private final boolean isTsFile;
    private final TsFileResource tsFileResource;
    private volatile long fileSize = -1L;
    private final AtomicInteger referenceCount;
    private final AtomicLong lastUnpinToZeroTime;
    private PipeMemoryBlock allocatedMemoryBlock;
    private Map<IDeviceID, List<String>> deviceMeasurementsMap = null;
    private Map<IDeviceID, Boolean> deviceIsAlignedMap = null;
    private Map<String, TSDataType> measurementDataTypeMap = null;

    public PipeTsFileResource(File hardlinkOrCopiedFile, boolean isTsFile, TsFileResource tsFileResource) {
        this.hardlinkOrCopiedFile = hardlinkOrCopiedFile;
        this.isTsFile = isTsFile;
        this.tsFileResource = tsFileResource;
        this.referenceCount = new AtomicInteger(1);
        this.lastUnpinToZeroTime = new AtomicLong(Long.MAX_VALUE);
    }

    public File getFile() {
        return this.hardlinkOrCopiedFile;
    }

    public boolean isOriginalTsFileDeleted() {
        return this.isTsFile && Objects.nonNull(this.tsFileResource) && this.tsFileResource.isDeleted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getFileSize() {
        if (this.fileSize == -1L) {
            PipeTsFileResource pipeTsFileResource = this;
            synchronized (pipeTsFileResource) {
                if (this.fileSize == -1L) {
                    this.fileSize = this.hardlinkOrCopiedFile.length();
                }
            }
        }
        return this.fileSize;
    }

    public long getTsFileResourceSize() {
        return Objects.nonNull(this.tsFileResource) ? this.tsFileResource.calculateRamSize() : 0L;
    }

    public int getReferenceCount() {
        return this.referenceCount.get();
    }

    public int increaseAndGetReference() {
        return this.referenceCount.addAndGet(1);
    }

    public int decreaseAndGetReference() {
        int finalReferenceCount = this.referenceCount.addAndGet(-1);
        if (finalReferenceCount == 0) {
            this.lastUnpinToZeroTime.set(System.currentTimeMillis());
        }
        if (finalReferenceCount < 0) {
            LOGGER.warn("PipeTsFileResource's reference count is decreased to below 0.");
        }
        return finalReferenceCount;
    }

    public synchronized boolean closeIfOutOfTimeToLive() {
        if (this.referenceCount.get() <= 0 && (this.deviceMeasurementsMap == null || System.currentTimeMillis() - this.lastUnpinToZeroTime.get() > 20000L)) {
            this.close();
            return true;
        }
        return false;
    }

    @Override
    public synchronized void close() {
        if (this.deviceMeasurementsMap != null) {
            this.deviceMeasurementsMap = null;
        }
        if (this.deviceIsAlignedMap != null) {
            this.deviceIsAlignedMap = null;
        }
        if (this.measurementDataTypeMap != null) {
            this.measurementDataTypeMap = null;
        }
        if (this.allocatedMemoryBlock != null) {
            this.allocatedMemoryBlock.close();
            this.allocatedMemoryBlock = null;
        }
        try {
            Files.deleteIfExists(this.hardlinkOrCopiedFile.toPath());
        }
        catch (Exception e) {
            LOGGER.error("PipeTsFileResource: Failed to delete tsfile {} when closing, because {}. Please MANUALLY delete it.", new Object[]{this.hardlinkOrCopiedFile, e.getMessage(), e});
        }
        LOGGER.info("PipeTsFileResource: Closed tsfile {} and cleaned up.", (Object)this.hardlinkOrCopiedFile);
    }

    public synchronized Map<IDeviceID, List<String>> tryGetDeviceMeasurementsMap() throws IOException {
        if (this.deviceMeasurementsMap == null && this.isTsFile) {
            this.cacheObjectsIfAbsent();
        }
        return this.deviceMeasurementsMap;
    }

    public synchronized Map<IDeviceID, Boolean> tryGetDeviceIsAlignedMap(boolean cacheOtherMetadata) throws IOException {
        if (this.deviceIsAlignedMap == null && this.isTsFile) {
            if (cacheOtherMetadata) {
                this.cacheObjectsIfAbsent();
            } else {
                this.cacheDeviceIsAlignedMapIfAbsent();
            }
        }
        return this.deviceIsAlignedMap;
    }

    public synchronized Map<String, TSDataType> tryGetMeasurementDataTypeMap() throws IOException {
        if (this.measurementDataTypeMap == null && this.isTsFile) {
            this.cacheObjectsIfAbsent();
        }
        return this.measurementDataTypeMap;
    }

    synchronized boolean cacheDeviceIsAlignedMapIfAbsent() throws IOException {
        if (!this.isTsFile) {
            return false;
        }
        if (this.allocatedMemoryBlock != null) {
            return true;
        }
        this.allocatedMemoryBlock = PipeDataNodeResourceManager.memory().forceAllocateIfSufficient(PipeConfig.getInstance().getPipeMemoryAllocateForTsFileSequenceReaderInBytes(), 0.7f);
        if (this.allocatedMemoryBlock == null) {
            LOGGER.info("Failed to cacheDeviceIsAlignedMapIfAbsent for tsfile {}, because memory usage is high", (Object)this.hardlinkOrCopiedFile.getPath());
            return false;
        }
        long memoryRequiredInBytes = 0L;
        try (TsFileSequenceReader sequenceReader = new TsFileSequenceReader(this.hardlinkOrCopiedFile.getPath(), true, false);){
            this.deviceIsAlignedMap = new HashMap<IDeviceID, Boolean>();
            TsFileDeviceIterator deviceIsAlignedIterator = sequenceReader.getAllDevicesIteratorWithIsAligned();
            while (deviceIsAlignedIterator.hasNext()) {
                Pair deviceIsAlignedPair = deviceIsAlignedIterator.next();
                this.deviceIsAlignedMap.put((IDeviceID)deviceIsAlignedPair.getLeft(), (Boolean)deviceIsAlignedPair.getRight());
            }
        }
        this.allocatedMemoryBlock.close();
        this.allocatedMemoryBlock = null;
        this.allocatedMemoryBlock = PipeDataNodeResourceManager.memory().forceAllocateIfSufficient(memoryRequiredInBytes += PipeMemoryWeightUtil.memoryOfIDeviceId2Bool(this.deviceIsAlignedMap), 0.7f);
        if (this.allocatedMemoryBlock == null) {
            LOGGER.info("PipeTsFileResource: Failed to cache objects for tsfile {} in cache, because memory usage is high", (Object)this.hardlinkOrCopiedFile.getPath());
            this.deviceIsAlignedMap = null;
            return false;
        }
        LOGGER.info("PipeTsFileResource: Cached deviceIsAlignedMap for tsfile {}.", (Object)this.hardlinkOrCopiedFile.getPath());
        return true;
    }

    synchronized boolean cacheObjectsIfAbsent() throws IOException {
        if (!this.isTsFile) {
            return false;
        }
        if (this.allocatedMemoryBlock != null) {
            if (this.deviceMeasurementsMap != null) {
                return true;
            }
            this.allocatedMemoryBlock.close();
            this.allocatedMemoryBlock = null;
        }
        this.allocatedMemoryBlock = PipeDataNodeResourceManager.memory().forceAllocateIfSufficient(PipeConfig.getInstance().getPipeMemoryAllocateForTsFileSequenceReaderInBytes(), 0.7f);
        if (this.allocatedMemoryBlock == null) {
            LOGGER.info("Failed to cacheObjectsIfAbsent for tsfile {}, because memory usage is high", (Object)this.hardlinkOrCopiedFile.getPath());
            return false;
        }
        long memoryRequiredInBytes = 0L;
        try (TsFileSequenceReader sequenceReader = new TsFileSequenceReader(this.hardlinkOrCopiedFile.getPath(), true, true);){
            this.deviceMeasurementsMap = sequenceReader.getDeviceMeasurementsMap();
            memoryRequiredInBytes += PipeMemoryWeightUtil.memoryOfIDeviceID2StrList(this.deviceMeasurementsMap);
            if (Objects.isNull(this.deviceIsAlignedMap)) {
                this.deviceIsAlignedMap = new HashMap<IDeviceID, Boolean>();
                TsFileDeviceIterator deviceIsAlignedIterator = sequenceReader.getAllDevicesIteratorWithIsAligned();
                while (deviceIsAlignedIterator.hasNext()) {
                    Pair deviceIsAlignedPair = deviceIsAlignedIterator.next();
                    this.deviceIsAlignedMap.put((IDeviceID)deviceIsAlignedPair.getLeft(), (Boolean)deviceIsAlignedPair.getRight());
                }
            }
            memoryRequiredInBytes += PipeMemoryWeightUtil.memoryOfIDeviceId2Bool(this.deviceIsAlignedMap);
            this.measurementDataTypeMap = sequenceReader.getFullPathDataTypeMap();
        }
        this.allocatedMemoryBlock.close();
        this.allocatedMemoryBlock = null;
        this.allocatedMemoryBlock = PipeDataNodeResourceManager.memory().forceAllocateIfSufficient(memoryRequiredInBytes += PipeMemoryWeightUtil.memoryOfStr2TSDataType(this.measurementDataTypeMap), 0.7f);
        if (this.allocatedMemoryBlock == null) {
            LOGGER.info("PipeTsFileResource: Failed to cache objects for tsfile {} in cache, because memory usage is high", (Object)this.hardlinkOrCopiedFile.getPath());
            this.deviceIsAlignedMap = null;
            this.deviceMeasurementsMap = null;
            this.measurementDataTypeMap = null;
            return false;
        }
        LOGGER.info("PipeTsFileResource: Cached objects for tsfile {}.", (Object)this.hardlinkOrCopiedFile.getPath());
        return true;
    }
}

