/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.extractor.dataregion.realtime.matcher;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.commons.pipe.datastructure.pattern.TablePattern;
import org.apache.iotdb.commons.pipe.datastructure.pattern.TreePattern;
import org.apache.iotdb.db.pipe.event.common.PipeInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.deletion.PipeDeleteDataNodeEvent;
import org.apache.iotdb.db.pipe.event.common.heartbeat.PipeHeartbeatEvent;
import org.apache.iotdb.db.pipe.event.realtime.PipeRealtimeEvent;
import org.apache.iotdb.db.pipe.extractor.dataregion.realtime.PipeRealtimeDataRegionExtractor;
import org.apache.iotdb.db.pipe.extractor.dataregion.realtime.matcher.PipeDataRegionMatcher;
import org.apache.iotdb.db.queryengine.plan.Coordinator;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.QualifiedObjectName;
import org.apache.iotdb.db.queryengine.plan.relational.security.AccessControl;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.file.metadata.PlainDeviceID;
import org.apache.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachedSchemaPatternMatcher
implements PipeDataRegionMatcher {
    protected static final Logger LOGGER = LoggerFactory.getLogger(CachedSchemaPatternMatcher.class);
    protected static final String TREE_MODEL_EVENT_TABLE_NAME_PREFIX = "root.";
    protected final ReentrantReadWriteLock lock;
    private final AccessControl accessControl = Coordinator.getInstance().getAccessControl();
    protected final Set<PipeRealtimeDataRegionExtractor> extractors;
    protected final Cache<IDeviceID, Set<PipeRealtimeDataRegionExtractor>> deviceToExtractorsCache;
    protected final Cache<Pair<String, IDeviceID>, Set<PipeRealtimeDataRegionExtractor>> databaseAndTableToExtractorsCache;

    public CachedSchemaPatternMatcher() {
        this.lock = new ReentrantReadWriteLock();
        this.extractors = new CopyOnWriteArraySet<PipeRealtimeDataRegionExtractor>();
        this.deviceToExtractorsCache = Caffeine.newBuilder().maximumSize((long)PipeConfig.getInstance().getPipeExtractorMatcherCacheSize()).build();
        this.databaseAndTableToExtractorsCache = Caffeine.newBuilder().maximumSize((long)PipeConfig.getInstance().getPipeExtractorMatcherCacheSize()).build();
    }

    @Override
    public void register(PipeRealtimeDataRegionExtractor extractor) {
        this.lock.writeLock().lock();
        try {
            this.extractors.add(extractor);
            this.deviceToExtractorsCache.invalidateAll();
            this.databaseAndTableToExtractorsCache.invalidateAll();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void deregister(PipeRealtimeDataRegionExtractor extractor) {
        this.lock.writeLock().lock();
        try {
            this.extractors.remove(extractor);
            this.deviceToExtractorsCache.invalidateAll();
            this.databaseAndTableToExtractorsCache.invalidateAll();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void invalidateCache() {
        this.lock.writeLock().lock();
        try {
            this.databaseAndTableToExtractorsCache.invalidateAll();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public int getRegisterCount() {
        this.lock.readLock().lock();
        try {
            int n = this.extractors.size();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<PipeRealtimeDataRegionExtractor> match(PipeRealtimeEvent event) {
        HashSet<PipeRealtimeDataRegionExtractor> matchedExtractors = new HashSet<PipeRealtimeDataRegionExtractor>();
        this.lock.readLock().lock();
        try {
            if (this.extractors.isEmpty()) {
                HashSet<PipeRealtimeDataRegionExtractor> hashSet = matchedExtractors;
                return hashSet;
            }
            if (event.getEvent() instanceof PipeHeartbeatEvent) {
                Set<PipeRealtimeDataRegionExtractor> set = this.extractors;
                return set;
            }
            if (event.getEvent() instanceof PipeDeleteDataNodeEvent) {
                Set<PipeRealtimeDataRegionExtractor> set = this.extractors.stream().filter(PipeRealtimeDataRegionExtractor::shouldExtractDeletion).collect(Collectors.toSet());
                return set;
            }
            for (Map.Entry<IDeviceID, String[]> entry : event.getSchemaInfo().entrySet()) {
                IDeviceID deviceID = entry.getKey();
                if (deviceID instanceof PlainDeviceID || deviceID.getTableName().startsWith(TREE_MODEL_EVENT_TABLE_NAME_PREFIX) || deviceID.getTableName().equals("root")) {
                    event.markAsTreeModelEvent();
                    this.matchTreeModelEvent(deviceID, entry.getValue(), matchedExtractors);
                } else {
                    event.markAsTableModelEvent();
                    this.matchTableModelEvent(event.getEvent() instanceof PipeInsertionEvent ? ((PipeInsertionEvent)event.getEvent()).getTableModelDatabaseName() : null, deviceID, matchedExtractors);
                }
                if (matchedExtractors.size() != this.extractors.size()) continue;
                break;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return matchedExtractors;
    }

    protected void matchTreeModelEvent(IDeviceID device, String[] measurements, Set<PipeRealtimeDataRegionExtractor> matchedExtractors) {
        Set extractorsFilteredByDevice = (Set)this.deviceToExtractorsCache.get((Object)device, this::filterExtractorsByDevice);
        if (extractorsFilteredByDevice == null) {
            LOGGER.warn("Extractors filtered by device is null when matching extractors for tree model event.", (Throwable)new Exception());
            return;
        }
        if (measurements.length == 0) {
            matchedExtractors.addAll(extractorsFilteredByDevice);
        } else {
            extractorsFilteredByDevice.forEach(extractor -> {
                if (matchedExtractors.size() == this.extractors.size()) {
                    return;
                }
                TreePattern pattern = extractor.getTreePattern();
                if (Objects.isNull(pattern) || pattern.isRoot() || pattern.coversDevice(device)) {
                    matchedExtractors.add((PipeRealtimeDataRegionExtractor)extractor);
                } else {
                    for (String measurement : measurements) {
                        if (measurement == null || !pattern.matchesMeasurement(device, measurement)) continue;
                        matchedExtractors.add((PipeRealtimeDataRegionExtractor)extractor);
                        break;
                    }
                }
            });
        }
    }

    protected Set<PipeRealtimeDataRegionExtractor> filterExtractorsByDevice(IDeviceID device) {
        HashSet<PipeRealtimeDataRegionExtractor> filteredExtractors = new HashSet<PipeRealtimeDataRegionExtractor>();
        for (PipeRealtimeDataRegionExtractor extractor : this.extractors) {
            TreePattern treePattern;
            if (!extractor.shouldExtractInsertion() || !Objects.isNull(treePattern = extractor.getTreePattern()) && (!treePattern.isTreeModelDataAllowedToBeCaptured() || !treePattern.mayOverlapWithDevice(device))) continue;
            filteredExtractors.add(extractor);
        }
        return filteredExtractors;
    }

    protected void matchTableModelEvent(String databaseName, IDeviceID tableName, Set<PipeRealtimeDataRegionExtractor> matchedExtractors) {
        if (databaseName == null) {
            LOGGER.warn("Database name is null when matching extractors for table model event.", (Throwable)new Exception());
            return;
        }
        Set extractorsFilteredByDatabaseAndTable = (Set)this.databaseAndTableToExtractorsCache.get((Object)new Pair((Object)databaseName, (Object)tableName), this::filterExtractorsByDatabaseAndTable);
        if (extractorsFilteredByDatabaseAndTable == null) {
            LOGGER.warn("Extractors filtered by database and table is null when matching extractors for table model event.", (Throwable)new Exception());
            return;
        }
        matchedExtractors.addAll(extractorsFilteredByDatabaseAndTable);
    }

    protected Set<PipeRealtimeDataRegionExtractor> filterExtractorsByDatabaseAndTable(Pair<String, IDeviceID> databaseNameAndTableName) {
        HashSet<PipeRealtimeDataRegionExtractor> filteredExtractors = new HashSet<PipeRealtimeDataRegionExtractor>();
        for (PipeRealtimeDataRegionExtractor extractor : this.extractors) {
            TablePattern tablePattern;
            if (!extractor.shouldExtractInsertion() || !this.matchesTablePattern(tablePattern = extractor.getTablePattern(), databaseNameAndTableName) || extractor.isSkipIfNoPrivileges() && !this.notFilteredByAccess(extractor.getUserName(), databaseNameAndTableName)) continue;
            filteredExtractors.add(extractor);
        }
        return filteredExtractors;
    }

    private boolean matchesTablePattern(TablePattern tablePattern, Pair<String, IDeviceID> databaseNameAndTableName) {
        return Objects.isNull(tablePattern) || tablePattern.isTableModelDataAllowedToBeCaptured() && tablePattern.matchesDatabase((String)databaseNameAndTableName.getLeft()) && tablePattern.matchesTable(((IDeviceID)databaseNameAndTableName.getRight()).getTableName());
    }

    private boolean notFilteredByAccess(String userName, Pair<String, IDeviceID> databaseNameAndTableName) {
        return this.accessControl.checkCanSelectFromTable4Pipe(userName, new QualifiedObjectName((String)databaseNameAndTableName.getLeft(), ((IDeviceID)databaseNameAndTableName.getRight()).getTableName()));
    }

    @Override
    public void clear() {
        this.lock.writeLock().lock();
        try {
            this.extractors.clear();
            this.deviceToExtractorsCache.invalidateAll();
            this.deviceToExtractorsCache.cleanUp();
            this.databaseAndTableToExtractorsCache.invalidateAll();
            this.databaseAndTableToExtractorsCache.cleanUp();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

