/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.write.chunk;

import java.io.IOException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.tsfile.common.conf.TSFileDescriptor;
import org.apache.tsfile.encoding.encoder.Encoder;
import org.apache.tsfile.encoding.encoder.TSEncodingBuilder;
import org.apache.tsfile.encrypt.EncryptParameter;
import org.apache.tsfile.encrypt.EncryptUtils;
import org.apache.tsfile.enums.ColumnCategory;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.exception.write.WriteProcessException;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.file.metadata.enums.CompressionType;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.DateUtils;
import org.apache.tsfile.write.UnSupportedDataTypeException;
import org.apache.tsfile.write.chunk.IChunkGroupWriter;
import org.apache.tsfile.write.chunk.TimeChunkWriter;
import org.apache.tsfile.write.chunk.ValueChunkWriter;
import org.apache.tsfile.write.record.Tablet;
import org.apache.tsfile.write.record.datapoint.DataPoint;
import org.apache.tsfile.write.schema.IMeasurementSchema;
import org.apache.tsfile.write.writer.TsFileIOWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlignedChunkGroupWriterImpl
implements IChunkGroupWriter {
    private static final Logger LOG = LoggerFactory.getLogger(AlignedChunkGroupWriterImpl.class);
    private final IDeviceID deviceId;
    private final Map<String, ValueChunkWriter> valueChunkWriterMap = new LinkedHashMap<String, ValueChunkWriter>();
    private final TimeChunkWriter timeChunkWriter;
    private final EncryptParameter encryprParam;
    private long lastTime = Long.MIN_VALUE;
    private boolean isInitLastTime = false;
    private boolean convertColumnNameToLowerCase = false;

    public AlignedChunkGroupWriterImpl(IDeviceID deviceId) {
        this.deviceId = deviceId;
        String timeMeasurementId = "";
        CompressionType compressionType = TSFileDescriptor.getInstance().getConfig().getCompressor();
        TSEncoding tsEncoding = TSEncoding.valueOf(TSFileDescriptor.getInstance().getConfig().getTimeEncoder());
        TSDataType timeType = TSFileDescriptor.getInstance().getConfig().getTimeSeriesDataType();
        Encoder encoder = TSEncodingBuilder.getEncodingBuilder(tsEncoding).getEncoder(timeType);
        this.encryprParam = EncryptUtils.getEncryptParameter();
        this.timeChunkWriter = new TimeChunkWriter(timeMeasurementId, compressionType, tsEncoding, encoder, this.encryprParam);
    }

    public AlignedChunkGroupWriterImpl(IDeviceID deviceId, EncryptParameter encryptParam) {
        this.deviceId = deviceId;
        String timeMeasurementId = "";
        CompressionType compressionType = TSFileDescriptor.getInstance().getConfig().getCompressor();
        TSEncoding tsEncoding = TSEncoding.valueOf(TSFileDescriptor.getInstance().getConfig().getTimeEncoder());
        TSDataType timeType = TSFileDescriptor.getInstance().getConfig().getTimeSeriesDataType();
        Encoder encoder = TSEncodingBuilder.getEncodingBuilder(tsEncoding).getEncoder(timeType);
        this.encryprParam = encryptParam;
        this.timeChunkWriter = new TimeChunkWriter(timeMeasurementId, compressionType, tsEncoding, encoder, this.encryprParam);
    }

    @Override
    public void tryToAddSeriesWriter(IMeasurementSchema measurementSchema) throws IOException {
        this.tryToAddSeriesWriterInternal(measurementSchema);
    }

    public ValueChunkWriter tryToAddSeriesWriterInternal(IMeasurementSchema measurementSchema) throws IOException {
        String measurementName = this.convertColumnNameToLowerCase ? measurementSchema.getMeasurementName().toLowerCase() : measurementSchema.getMeasurementName();
        ValueChunkWriter valueChunkWriter = this.valueChunkWriterMap.get(measurementName);
        if (valueChunkWriter == null) {
            valueChunkWriter = new ValueChunkWriter(measurementName, measurementSchema.getCompressor(), measurementSchema.getType(), measurementSchema.getEncodingType(), measurementSchema.getValueEncoder());
            this.valueChunkWriterMap.put(measurementName, valueChunkWriter);
            this.tryToAddEmptyPageAndData(valueChunkWriter);
        }
        return valueChunkWriter;
    }

    @Override
    public void tryToAddSeriesWriter(List<IMeasurementSchema> measurementSchemas) throws IOException {
        for (IMeasurementSchema schema : measurementSchemas) {
            String measurementName = this.convertColumnNameToLowerCase ? schema.getMeasurementName().toLowerCase() : schema.getMeasurementName();
            if (this.valueChunkWriterMap.containsKey(measurementName)) continue;
            ValueChunkWriter valueChunkWriter = new ValueChunkWriter(measurementName, schema.getCompressor(), schema.getType(), schema.getEncodingType(), schema.getValueEncoder());
            this.valueChunkWriterMap.put(measurementName, valueChunkWriter);
            this.tryToAddEmptyPageAndData(valueChunkWriter);
        }
    }

    @Override
    public int write(long time, List<DataPoint> data) throws WriteProcessException, IOException {
        this.checkIsHistoryData(time);
        ArrayList<ValueChunkWriter> emptyValueChunkWriters = new ArrayList<ValueChunkWriter>();
        Set existingMeasurements = data.stream().map(dataPoint -> this.convertColumnNameToLowerCase ? dataPoint.getMeasurementId().toLowerCase() : dataPoint.getMeasurementId()).collect(Collectors.toSet());
        for (Map.Entry<String, ValueChunkWriter> entry : this.valueChunkWriterMap.entrySet()) {
            if (existingMeasurements.contains(entry.getKey())) continue;
            emptyValueChunkWriters.add(entry.getValue());
        }
        block9: for (DataPoint point : data) {
            boolean isNull = point.getValue() == null;
            String measurementId = this.convertColumnNameToLowerCase ? point.getMeasurementId().toLowerCase() : point.getMeasurementId();
            ValueChunkWriter valueChunkWriter = this.valueChunkWriterMap.get(measurementId);
            switch (point.getType()) {
                case BOOLEAN: {
                    valueChunkWriter.write(time, (Boolean)point.getValue(), isNull);
                    continue block9;
                }
                case INT32: 
                case DATE: {
                    valueChunkWriter.write(time, isNull ? 0 : (Integer)point.getValue(), isNull);
                    continue block9;
                }
                case INT64: 
                case TIMESTAMP: {
                    valueChunkWriter.write(time, (Long)point.getValue(), isNull);
                    continue block9;
                }
                case FLOAT: {
                    valueChunkWriter.write(time, ((Float)point.getValue()).floatValue(), isNull);
                    continue block9;
                }
                case DOUBLE: {
                    valueChunkWriter.write(time, (Double)point.getValue(), isNull);
                    continue block9;
                }
                case TEXT: 
                case BLOB: 
                case STRING: {
                    valueChunkWriter.write(time, (Binary)point.getValue(), isNull);
                    continue block9;
                }
            }
            throw new UnSupportedDataTypeException(String.format("Data type %s is not supported.", point.getType()));
        }
        if (!emptyValueChunkWriters.isEmpty()) {
            this.writeEmptyDataInOneRow(emptyValueChunkWriters);
        }
        this.timeChunkWriter.write(time);
        this.lastTime = time;
        this.isInitLastTime = true;
        if (this.checkPageSizeAndMayOpenANewPage()) {
            this.writePageToPageBuffer();
        }
        return 1;
    }

    @Override
    public int write(Tablet tablet) throws IOException, WriteProcessException {
        return this.write(tablet, 0, tablet.getRowSize());
    }

    @Override
    public int write(Tablet tablet, int startRowIndex, int endRowIndex) throws WriteProcessException, IOException {
        int pointCount = 0;
        List<IMeasurementSchema> measurementSchemas = tablet.getSchemas();
        ArrayList<ValueChunkWriter> emptyValueChunkWriters = new ArrayList<ValueChunkWriter>();
        Set existingMeasurements = measurementSchemas.stream().map(schema -> this.convertColumnNameToLowerCase ? schema.getMeasurementName().toLowerCase() : schema.getMeasurementName()).collect(Collectors.toSet());
        for (Map.Entry<String, ValueChunkWriter> entry : this.valueChunkWriterMap.entrySet()) {
            if (existingMeasurements.contains(entry.getKey())) continue;
            emptyValueChunkWriters.add(entry.getValue());
        }
        for (int row = startRowIndex; row < endRowIndex; ++row) {
            long time = tablet.getTimestamps()[row];
            this.checkIsHistoryData(time);
            block11: for (int columnIndex = 0; columnIndex < tablet.getSchemas().size(); ++columnIndex) {
                if (tablet.getColumnTypes() != null && tablet.getColumnTypes().get(columnIndex) != ColumnCategory.FIELD) continue;
                boolean isNull = tablet.getBitMaps() != null && tablet.getBitMaps()[columnIndex] != null && tablet.getBitMaps()[columnIndex].isMarked(row);
                ValueChunkWriter valueChunkWriter = this.tryToAddSeriesWriterInternal(measurementSchemas.get(columnIndex));
                switch (measurementSchemas.get(columnIndex).getType()) {
                    case BOOLEAN: {
                        valueChunkWriter.write(time, ((boolean[])tablet.getValues()[columnIndex])[row], isNull);
                        continue block11;
                    }
                    case INT32: {
                        valueChunkWriter.write(time, ((int[])tablet.getValues()[columnIndex])[row], isNull);
                        continue block11;
                    }
                    case DATE: {
                        valueChunkWriter.write(time, isNull ? 0 : DateUtils.parseDateExpressionToInt(((LocalDate[])tablet.getValues()[columnIndex])[row]), isNull);
                        continue block11;
                    }
                    case INT64: 
                    case TIMESTAMP: {
                        valueChunkWriter.write(time, ((long[])tablet.getValues()[columnIndex])[row], isNull);
                        continue block11;
                    }
                    case FLOAT: {
                        valueChunkWriter.write(time, ((float[])tablet.getValues()[columnIndex])[row], isNull);
                        continue block11;
                    }
                    case DOUBLE: {
                        valueChunkWriter.write(time, ((double[])tablet.getValues()[columnIndex])[row], isNull);
                        continue block11;
                    }
                    case TEXT: 
                    case BLOB: 
                    case STRING: {
                        valueChunkWriter.write(time, ((Binary[])tablet.getValues()[columnIndex])[row], isNull);
                        continue block11;
                    }
                    default: {
                        throw new UnSupportedDataTypeException(String.format("Data type %s is not supported.", measurementSchemas.get(columnIndex).getType()));
                    }
                }
            }
            if (!emptyValueChunkWriters.isEmpty()) {
                this.writeEmptyDataInOneRow(emptyValueChunkWriters);
            }
            this.timeChunkWriter.write(time);
            this.lastTime = time;
            this.isInitLastTime = true;
            if (this.checkPageSizeAndMayOpenANewPage()) {
                this.writePageToPageBuffer();
            }
            ++pointCount;
        }
        return pointCount;
    }

    @Override
    public long flushToFileWriter(TsFileIOWriter tsfileWriter) throws IOException {
        LOG.debug("start flush device id:{}", (Object)this.deviceId);
        this.sealAllChunks();
        long currentChunkGroupSize = this.getCurrentChunkGroupSize();
        this.timeChunkWriter.writeToFileWriter(tsfileWriter);
        for (ValueChunkWriter valueChunkWriter : this.valueChunkWriterMap.values()) {
            valueChunkWriter.writeToFileWriter(tsfileWriter);
        }
        return currentChunkGroupSize;
    }

    @Override
    public long updateMaxGroupMemSize() {
        long bufferSize = this.timeChunkWriter.estimateMaxSeriesMemSize();
        for (ValueChunkWriter valueChunkWriter : this.valueChunkWriterMap.values()) {
            bufferSize += valueChunkWriter.estimateMaxSeriesMemSize();
        }
        return bufferSize;
    }

    @Override
    public long getCurrentChunkGroupSize() {
        long size = this.timeChunkWriter.getCurrentChunkSize();
        for (ValueChunkWriter valueChunkWriter : this.valueChunkWriterMap.values()) {
            size += valueChunkWriter.getCurrentChunkSize();
        }
        return size;
    }

    public void tryToAddEmptyPageAndData(ValueChunkWriter valueChunkWriter) throws IOException {
        for (int i = 0; i < this.timeChunkWriter.getNumOfPages(); ++i) {
            valueChunkWriter.writeEmptyPageToPageBuffer();
        }
        for (long i = 0L; i < (long)this.timeChunkWriter.getPageWriter().getStatistics().getCount(); ++i) {
            valueChunkWriter.write(0L, 0, true);
        }
    }

    private void writeEmptyDataInOneRow(List<ValueChunkWriter> valueChunkWriterList) {
        block8: for (ValueChunkWriter valueChunkWriter : valueChunkWriterList) {
            TSDataType dataType = valueChunkWriter.getDataType();
            switch (dataType) {
                case BOOLEAN: {
                    valueChunkWriter.write(-1L, false, true);
                    continue block8;
                }
                case INT32: 
                case DATE: {
                    valueChunkWriter.write(-1L, 0, true);
                    continue block8;
                }
                case INT64: 
                case TIMESTAMP: {
                    valueChunkWriter.write(-1L, 0L, true);
                    continue block8;
                }
                case FLOAT: {
                    valueChunkWriter.write(-1L, 0.0f, true);
                    continue block8;
                }
                case DOUBLE: {
                    valueChunkWriter.write(-1L, 0.0, true);
                    continue block8;
                }
                case TEXT: 
                case BLOB: 
                case STRING: {
                    valueChunkWriter.write(-1L, null, true);
                    continue block8;
                }
            }
            throw new UnSupportedDataTypeException(String.format("Data type %s is not supported.", dataType));
        }
    }

    private boolean checkPageSizeAndMayOpenANewPage() {
        if (this.timeChunkWriter.checkPageSizeAndMayOpenANewPage()) {
            return true;
        }
        for (ValueChunkWriter writer : this.valueChunkWriterMap.values()) {
            if (!writer.checkPageSizeAndMayOpenANewPage()) continue;
            return true;
        }
        return false;
    }

    private void writePageToPageBuffer() {
        this.timeChunkWriter.writePageToPageBuffer();
        for (ValueChunkWriter valueChunkWriter : this.valueChunkWriterMap.values()) {
            valueChunkWriter.writePageToPageBuffer();
        }
    }

    private void sealAllChunks() {
        this.timeChunkWriter.sealCurrentPage();
        for (ValueChunkWriter valueChunkWriter : this.valueChunkWriterMap.values()) {
            valueChunkWriter.sealCurrentPage();
        }
    }

    private void checkIsHistoryData(long time) throws WriteProcessException {
        if (this.isInitLastTime && time <= this.lastTime) {
            throw new WriteProcessException("Not allowed to write out-of-order data in timeseries " + this.deviceId + "." + ", time should later than " + this.lastTime);
        }
    }

    public List<String> getMeasurements() {
        return new ArrayList<String>(this.valueChunkWriterMap.keySet());
    }

    public Long getLastTime() {
        return this.lastTime;
    }

    public void setLastTime(Long lastTime) {
        if (lastTime != null) {
            this.lastTime = lastTime;
            this.isInitLastTime = true;
        }
    }

    public void setConvertColumnNameToLowerCase(boolean convertColumnNameToLowerCase) {
        this.convertColumnNameToLowerCase = convertColumnNameToLowerCase;
    }
}

