/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.path;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.rmi.UnexpectedException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.AlignedPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathDeserializeUtil;
import org.apache.iotdb.commons.path.PathType;
import org.apache.iotdb.commons.schema.view.LogicalViewSchema;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.apache.tsfile.write.schema.IMeasurementSchema;
import org.apache.tsfile.write.schema.MeasurementSchema;
import org.apache.tsfile.write.schema.MeasurementSchemaType;
import org.apache.tsfile.write.schema.VectorMeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MeasurementPath
extends PartialPath {
    private static final String NODES_LENGTH_ERROR = "nodes.length for MeasurementPath should always be greater than 1, current is: %s";
    private static final Logger logger = LoggerFactory.getLogger(MeasurementPath.class);
    private IMeasurementSchema measurementSchema;
    private Map<String, String> tagMap;
    private Boolean isUnderAlignedEntity = false;
    private String measurementAlias = "";

    public MeasurementPath() {
    }

    public MeasurementPath(String measurementPath) throws IllegalPathException {
        super(measurementPath);
        if (this.nodes.length < 2) {
            throw new IllegalArgumentException(String.format(NODES_LENGTH_ERROR, Arrays.toString(this.nodes)));
        }
    }

    public MeasurementPath(String measurementPath, TSDataType type) throws IllegalPathException {
        super(measurementPath);
        if (this.nodes.length < 2) {
            throw new IllegalArgumentException(String.format(NODES_LENGTH_ERROR, Arrays.toString(this.nodes)));
        }
        this.measurementSchema = new MeasurementSchema(this.getMeasurement(), type);
    }

    public MeasurementPath(PartialPath path, TSDataType type) {
        this(path, (IMeasurementSchema)new MeasurementSchema(path.getMeasurement(), type), false);
    }

    public MeasurementPath(PartialPath measurementPath, IMeasurementSchema measurementSchema) {
        this(measurementPath, measurementSchema, false);
    }

    public MeasurementPath(PartialPath measurementPath, IMeasurementSchema measurementSchema, Boolean isUnderAlignedEntity) {
        super(measurementPath.getNodes());
        if (this.nodes.length < 2) {
            throw new IllegalArgumentException(String.format(NODES_LENGTH_ERROR, Arrays.toString(this.nodes)));
        }
        this.measurementSchema = measurementSchema;
        this.isUnderAlignedEntity = isUnderAlignedEntity;
    }

    public MeasurementPath(IDeviceID device, String measurement) throws IllegalPathException {
        super(device, measurement);
    }

    public MeasurementPath(IDeviceID device, String measurement, IMeasurementSchema measurementSchema) throws IllegalPathException {
        super(device, measurement);
        this.measurementSchema = measurementSchema;
    }

    public MeasurementPath(String device, String measurement) throws IllegalPathException {
        super(device, measurement);
        if (this.nodes.length < 2) {
            throw new IllegalArgumentException(String.format(NODES_LENGTH_ERROR, Arrays.toString(this.nodes)));
        }
    }

    public MeasurementPath(String device, String measurement, IMeasurementSchema measurementSchema) throws IllegalPathException {
        super(device, measurement);
        if (this.nodes.length < 2) {
            throw new IllegalArgumentException(String.format(NODES_LENGTH_ERROR, Arrays.toString(this.nodes)));
        }
        this.measurementSchema = measurementSchema;
    }

    public MeasurementPath(String[] nodes, IMeasurementSchema schema) {
        super(nodes);
        if (nodes.length < 2) {
            throw new IllegalArgumentException(String.format(NODES_LENGTH_ERROR, Arrays.toString(nodes)));
        }
        this.measurementSchema = schema;
    }

    public MeasurementPath(String[] nodes) {
        super(nodes);
        if (nodes.length < 2) {
            throw new IllegalArgumentException("nodes.length for MeasurementPath should always be greater than 2, current is: " + Arrays.toString(nodes));
        }
    }

    @Override
    public IMeasurementSchema getMeasurementSchema() {
        return this.measurementSchema;
    }

    public Map<String, String> getTagMap() {
        return this.tagMap;
    }

    @Override
    public TSDataType getSeriesType() {
        if (this.measurementSchema == null) {
            return null;
        }
        return this.getMeasurementSchema().getType();
    }

    public byte getSeriesTypeInByte() {
        return this.getMeasurementSchema().getTypeInByte();
    }

    public void setMeasurementSchema(IMeasurementSchema measurementSchema) {
        this.measurementSchema = measurementSchema;
    }

    public void setTagMap(Map<String, String> tagMap) {
        this.tagMap = tagMap;
    }

    @Override
    public String getMeasurementAlias() {
        return this.measurementAlias;
    }

    @Override
    public void setMeasurementAlias(String measurementAlias) {
        if (measurementAlias != null) {
            this.measurementAlias = measurementAlias;
        }
    }

    public void removeMeasurementAlias() {
        this.measurementAlias = null;
    }

    @Override
    public boolean isMeasurementAliasExists() {
        return this.measurementAlias != null && !this.measurementAlias.isEmpty();
    }

    @Override
    public String getFullPathWithAlias() {
        if (this.getIDeviceID().isEmpty()) {
            return this.measurementAlias;
        }
        return this.getIDeviceID().toString() + '.' + this.measurementAlias;
    }

    public boolean isUnderAlignedEntity() {
        if (this.isUnderAlignedEntity == null) {
            return false;
        }
        return this.isUnderAlignedEntity;
    }

    public void setDevice(IDeviceID device) {
        this.device = device;
    }

    public void setUnderAlignedEntity(Boolean underAlignedEntity) {
        this.isUnderAlignedEntity = underAlignedEntity;
    }

    @Override
    public PartialPath copy() {
        MeasurementPath result = new MeasurementPath();
        result.nodes = this.nodes;
        result.fullPath = this.fullPath;
        result.device = this.device;
        result.measurementAlias = this.measurementAlias;
        result.measurementSchema = this.measurementSchema;
        if (this.tagMap != null) {
            result.tagMap = new HashMap<String, String>(this.tagMap);
        }
        result.isUnderAlignedEntity = this.isUnderAlignedEntity;
        return result;
    }

    public PartialPath transformToExactPath() {
        return this.isUnderAlignedEntity != false ? new AlignedPath(this) : this;
    }

    @Override
    public MeasurementPath clone() {
        MeasurementPath newMeasurementPath = null;
        try {
            newMeasurementPath = new MeasurementPath(this.getIDeviceID(), this.getMeasurement(), this.getMeasurementSchema());
            newMeasurementPath.setUnderAlignedEntity(this.isUnderAlignedEntity);
            newMeasurementPath.setMeasurementAlias(this.measurementAlias);
            if (this.tagMap != null) {
                newMeasurementPath.setTagMap(new HashMap<String, String>(this.tagMap));
            }
        }
        catch (IllegalPathException e) {
            logger.warn("path is illegal: {}", (Object)this.getFullPath(), (Object)e);
        }
        return newMeasurementPath;
    }

    @Override
    public void serialize(ByteBuffer byteBuffer) {
        PathType.Measurement.serialize(byteBuffer);
        super.serializeWithoutType(byteBuffer);
        if (this.measurementSchema == null) {
            ReadWriteIOUtils.write((byte)0, (ByteBuffer)byteBuffer);
        } else {
            ReadWriteIOUtils.write((byte)1, (ByteBuffer)byteBuffer);
            MeasurementSchemaType measurementSchemaType = this.measurementSchema.getSchemaType();
            ReadWriteIOUtils.write((byte)measurementSchemaType.getMeasurementSchemaTypeInByteEnum(), (ByteBuffer)byteBuffer);
            this.measurementSchema.serializeTo(byteBuffer);
        }
        if (this.tagMap == null) {
            ReadWriteIOUtils.write((byte)0, (ByteBuffer)byteBuffer);
        } else {
            ReadWriteIOUtils.write((byte)1, (ByteBuffer)byteBuffer);
            ReadWriteIOUtils.write(this.tagMap, (ByteBuffer)byteBuffer);
        }
        ReadWriteIOUtils.write((Boolean)this.isUnderAlignedEntity, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((String)this.measurementAlias, (ByteBuffer)byteBuffer);
    }

    @Override
    public void serialize(OutputStream stream) throws IOException {
        PathType.Measurement.serialize(stream);
        super.serializeWithoutType(stream);
        if (this.measurementSchema == null) {
            ReadWriteIOUtils.write((byte)0, (OutputStream)stream);
        } else {
            ReadWriteIOUtils.write((byte)1, (OutputStream)stream);
            MeasurementSchemaType measurementSchemaType = this.measurementSchema.getSchemaType();
            ReadWriteIOUtils.write((byte)measurementSchemaType.getMeasurementSchemaTypeInByteEnum(), (OutputStream)stream);
            this.measurementSchema.serializeTo(stream);
        }
        if (this.tagMap == null) {
            ReadWriteIOUtils.write((byte)0, (OutputStream)stream);
        } else {
            ReadWriteIOUtils.write((byte)1, (OutputStream)stream);
            ReadWriteIOUtils.write(this.tagMap, (OutputStream)stream);
        }
        ReadWriteIOUtils.write((Boolean)this.isUnderAlignedEntity, (OutputStream)stream);
        ReadWriteIOUtils.write((String)this.measurementAlias, (OutputStream)stream);
    }

    public static MeasurementPath deserialize(ByteBuffer byteBuffer) {
        PartialPath partialPath = PartialPath.deserialize(byteBuffer);
        MeasurementPath measurementPath = new MeasurementPath();
        byte isNull = ReadWriteIOUtils.readByte((ByteBuffer)byteBuffer);
        if (isNull == 1) {
            byte type = ReadWriteIOUtils.readByte((ByteBuffer)byteBuffer);
            if (type == MeasurementSchemaType.MEASUREMENT_SCHEMA.getMeasurementSchemaTypeInByteEnum()) {
                measurementPath.measurementSchema = MeasurementSchema.deserializeFrom((ByteBuffer)byteBuffer);
            } else if (type == MeasurementSchemaType.VECTOR_MEASUREMENT_SCHEMA.getMeasurementSchemaTypeInByteEnum()) {
                measurementPath.measurementSchema = VectorMeasurementSchema.deserializeFrom((ByteBuffer)byteBuffer);
            } else if (type == MeasurementSchemaType.LOGICAL_VIEW_SCHEMA.getMeasurementSchemaTypeInByteEnum()) {
                measurementPath.measurementSchema = LogicalViewSchema.deserializeFrom(byteBuffer);
            } else {
                throw new RuntimeException(new UnexpectedException("Type (" + type + ") of measurementSchema is unknown."));
            }
        }
        if ((isNull = ReadWriteIOUtils.readByte((ByteBuffer)byteBuffer)) == 1) {
            measurementPath.tagMap = ReadWriteIOUtils.readMap((ByteBuffer)byteBuffer);
        }
        measurementPath.isUnderAlignedEntity = ReadWriteIOUtils.readBoolObject((ByteBuffer)byteBuffer);
        measurementPath.measurementAlias = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
        measurementPath.nodes = partialPath.getNodes();
        measurementPath.device = measurementPath.getIDeviceID();
        measurementPath.fullPath = measurementPath.getFullPath();
        return measurementPath;
    }

    @Override
    public PartialPath transformToPartialPath() {
        return this.getDevicePath().concatNode(this.getTailNode());
    }

    public static String transformDataToString(MeasurementPath measurementPath) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            measurementPath.serialize(dataOutputStream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        byte[] bytes = byteArrayOutputStream.toByteArray();
        return new String(bytes, StandardCharsets.ISO_8859_1);
    }

    @Override
    protected IDeviceID toDeviceID(String[] nodes) {
        nodes = Arrays.copyOfRange(nodes, 0, nodes.length - 1);
        return super.toDeviceID(nodes);
    }

    public static MeasurementPath parseDataFromString(String measurementPathData) {
        return (MeasurementPath)PathDeserializeUtil.deserialize(ByteBuffer.wrap(measurementPathData.getBytes(StandardCharsets.ISO_8859_1)));
    }

    @Override
    protected PartialPath createPartialPath(String[] newPathNodes) {
        return new MeasurementPath(newPathNodes);
    }

    @Override
    public PartialPath getDevicePath() {
        return new PartialPath(Arrays.copyOf(this.nodes, this.nodes.length - 1));
    }

    @Override
    public List<PartialPath> getDevicePathPattern() {
        ArrayList<PartialPath> result = new ArrayList<PartialPath>();
        result.add(this.getDevicePath());
        if (this.nodes[this.nodes.length - 1].equals("**")) {
            result.add(new PartialPath(this.nodes));
        }
        return result;
    }
}

