/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.quarkus.config;

import jakarta.annotation.Priority;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Alternative;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.polaris.service.config.FeaturesConfiguration;
import org.apache.polaris.service.quarkus.config.QuarkusFeaturesConfiguration;

@ApplicationScoped
@Alternative
@Priority(value=1)
public class QuarkusResolvedFeaturesConfiguration
implements FeaturesConfiguration {
    private final Map<String, String> cleanedDefaults;
    private final Map<String, ? extends FeaturesConfiguration.RealmOverrides> realmOverrides;

    public QuarkusResolvedFeaturesConfiguration(QuarkusFeaturesConfiguration raw) {
        this.realmOverrides = raw.realmOverrides();
        this.cleanedDefaults = raw.defaults().entrySet().stream().filter(e -> ((String)e.getKey()).split("\\.").length == 1).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public Map<String, String> defaults() {
        return this.cleanedDefaults;
    }

    public Map<String, ? extends FeaturesConfiguration.RealmOverrides> realmOverrides() {
        return this.realmOverrides;
    }

    public QuarkusResolvedFeaturesConfiguration() {
    }
}

