/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import org.apache.iceberg.ContentScanTask;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.StructProjection;

public class PartitionUtil {
    private PartitionUtil() {
    }

    public static Map<Integer, ?> constantsMap(ContentScanTask<?> task) {
        return PartitionUtil.constantsMap(task, null, (type, constant) -> constant);
    }

    public static Map<Integer, ?> constantsMap(ContentScanTask<?> task, BiFunction<Type, Object, Object> convertConstant) {
        return PartitionUtil.constantsMap(task, null, convertConstant);
    }

    public static Map<Integer, ?> constantsMap(ContentScanTask<?> task, Types.StructType partitionType, BiFunction<Type, Object, Object> convertConstant) {
        PartitionSpec spec = task.spec();
        StructLike partitionData = task.file().partition();
        HashMap idToConstant = Maps.newHashMap();
        if (task.file().firstRowId() != null) {
            idToConstant.put(MetadataColumns.ROW_ID.fieldId(), convertConstant.apply((Type)Types.LongType.get(), task.file().firstRowId()));
        }
        idToConstant.put(MetadataColumns.LAST_UPDATED_SEQUENCE_NUMBER.fieldId(), convertConstant.apply((Type)Types.LongType.get(), task.file().fileSequenceNumber()));
        idToConstant.put(MetadataColumns.FILE_PATH.fieldId(), convertConstant.apply((Type)Types.StringType.get(), task.file().location()));
        idToConstant.put(MetadataColumns.SPEC_ID.fieldId(), convertConstant.apply((Type)Types.IntegerType.get(), task.file().specId()));
        if (partitionType != null) {
            if (!partitionType.fields().isEmpty()) {
                StructLike coercedPartition = PartitionUtil.coercePartition(partitionType, spec, partitionData);
                idToConstant.put(0x7FFFFFFA, convertConstant.apply((Type)partitionType, coercedPartition));
            } else {
                idToConstant.put(0x7FFFFFFA, null);
            }
        }
        List partitionFields = spec.partitionType().fields();
        List fields = spec.fields();
        for (int pos = 0; pos < fields.size(); ++pos) {
            PartitionField field = (PartitionField)fields.get(pos);
            if (!field.transform().isIdentity()) continue;
            Object converted = convertConstant.apply(((Types.NestedField)partitionFields.get(pos)).type(), partitionData.get(pos, Object.class));
            idToConstant.put(field.sourceId(), converted);
        }
        return idToConstant;
    }

    public static StructLike coercePartition(Types.StructType partitionType, PartitionSpec spec, StructLike partition) {
        StructProjection projection = StructProjection.createAllowMissing((Types.StructType)spec.partitionType(), (Types.StructType)partitionType);
        projection.wrap(partition);
        return projection;
    }

    public static Map<Integer, PartitionSpec> indexSpecs(List<PartitionSpec> specs) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (PartitionSpec spec : specs) {
            builder.put((Object)spec.specId(), (Object)spec);
        }
        return builder.build();
    }
}

