/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.task;

import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.polaris.core.context.CallContext;
import org.apache.polaris.core.entity.PolarisBaseEntity;
import org.apache.polaris.core.entity.PolarisEntityType;
import org.apache.polaris.core.entity.TaskEntity;
import org.apache.polaris.core.persistence.MetaStoreManagerFactory;
import org.apache.polaris.core.persistence.PolarisMetaStoreManager;
import org.apache.polaris.service.events.AfterTaskAttemptedEvent;
import org.apache.polaris.service.events.BeforeTaskAttemptedEvent;
import org.apache.polaris.service.events.PolarisEventListener;
import org.apache.polaris.service.task.BatchFileCleanupTaskHandler;
import org.apache.polaris.service.task.ManifestFileCleanupTaskHandler;
import org.apache.polaris.service.task.TableCleanupTaskHandler;
import org.apache.polaris.service.task.TaskExecutor;
import org.apache.polaris.service.task.TaskFileIOSupplier;
import org.apache.polaris.service.task.TaskHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskExecutorImpl
implements TaskExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskExecutorImpl.class);
    private static final long TASK_RETRY_DELAY = 1000L;
    private final Executor executor;
    private final MetaStoreManagerFactory metaStoreManagerFactory;
    private final TaskFileIOSupplier fileIOSupplier;
    private final List<TaskHandler> taskHandlers = new CopyOnWriteArrayList<TaskHandler>();
    private final PolarisEventListener polarisEventListener;

    public TaskExecutorImpl(Executor executor, MetaStoreManagerFactory metaStoreManagerFactory, TaskFileIOSupplier fileIOSupplier, PolarisEventListener polarisEventListener) {
        this.executor = executor;
        this.metaStoreManagerFactory = metaStoreManagerFactory;
        this.fileIOSupplier = fileIOSupplier;
        this.polarisEventListener = polarisEventListener;
    }

    public void init() {
        this.addTaskHandler(new TableCleanupTaskHandler(this, this.metaStoreManagerFactory, this.fileIOSupplier));
        this.addTaskHandler(new ManifestFileCleanupTaskHandler(this.fileIOSupplier, Executors.newVirtualThreadPerTaskExecutor()));
        this.addTaskHandler(new BatchFileCleanupTaskHandler(this.fileIOSupplier, Executors.newVirtualThreadPerTaskExecutor()));
    }

    public void addTaskHandler(TaskHandler taskHandler) {
        this.taskHandlers.add(taskHandler);
    }

    @Override
    public void addTaskHandlerContext(long taskEntityId, CallContext callContext) {
        CallContext clone = callContext.copy();
        this.tryHandleTask(taskEntityId, clone, null, 1);
    }

    @Nonnull
    private CompletableFuture<Void> tryHandleTask(long taskEntityId, CallContext callContext, Throwable e, int attempt) {
        if (attempt > 3) {
            return CompletableFuture.failedFuture(e);
        }
        return CompletableFuture.runAsync(() -> this.handleTask(taskEntityId, callContext, attempt), this.executor).exceptionallyComposeAsync(t -> {
            LOGGER.warn("Failed to handle task entity id {}", (Object)taskEntityId, t);
            return this.tryHandleTask(taskEntityId, callContext, (Throwable)t, attempt + 1);
        }, CompletableFuture.delayedExecutor(1000L * (long)attempt, TimeUnit.MILLISECONDS, this.executor));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleTask(long taskEntityId, CallContext ctx, int attempt) {
        this.polarisEventListener.onBeforeTaskAttempted(new BeforeTaskAttemptedEvent(taskEntityId, ctx, attempt));
        boolean success = false;
        try {
            CallContext.setCurrentContext((CallContext)ctx);
            LOGGER.info("Handling task entity id {}", (Object)taskEntityId);
            PolarisMetaStoreManager metaStoreManager = this.metaStoreManagerFactory.getOrCreateMetaStoreManager(ctx.getRealmContext());
            PolarisBaseEntity taskEntity = metaStoreManager.loadEntity(ctx.getPolarisCallContext(), 0L, taskEntityId, PolarisEntityType.TASK).getEntity();
            if (!PolarisEntityType.TASK.equals((Object)taskEntity.getType())) {
                throw new IllegalArgumentException("Provided taskId must be a task entity type");
            }
            TaskEntity task = TaskEntity.of((PolarisBaseEntity)taskEntity);
            Optional<TaskHandler> handlerOpt = this.taskHandlers.stream().filter(th -> th.canHandleTask(task)).findFirst();
            if (handlerOpt.isEmpty()) {
                LOGGER.atWarn().addKeyValue("taskEntityId", (Object)taskEntityId).addKeyValue("taskType", (Object)task.getTaskType()).log("Unable to find handler for task type");
                return;
            }
            TaskHandler handler = handlerOpt.get();
            success = handler.handleTask(task, ctx);
            if (success) {
                LOGGER.atInfo().addKeyValue("taskEntityId", (Object)taskEntityId).addKeyValue("handlerClass", handler.getClass()).log("Task successfully handled");
                metaStoreManager.dropEntityIfExists(ctx.getPolarisCallContext(), null, taskEntity, Map.of(), false);
            } else {
                LOGGER.atWarn().addKeyValue("taskEntityId", (Object)taskEntityId).addKeyValue("taskEntityName", (Object)taskEntity.getName()).log("Unable to execute async task");
            }
        }
        finally {
            this.polarisEventListener.onAfterTaskAttempted(new AfterTaskAttemptedEvent(taskEntityId, ctx, attempt, success));
        }
    }
}

