/*
 * Decompiled with CFR 0.152.
 */
package org.apache.livy.thriftserver.session;

import java.util.ArrayList;
import java.util.List;
import org.apache.livy.thriftserver.session.DataType;
import org.apache.livy.thriftserver.session.SparkCatalogJob;
import org.apache.livy.thriftserver.session.SparkUtils;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.GenericRow;
import org.apache.spark.sql.types.StructField;
import scala.collection.JavaConversions;
import scala.collection.Seq;

public class GetColumnsJob
extends SparkCatalogJob {
    private final String databasePattern;
    private final String tablePattern;
    private final String columnPattern;

    public GetColumnsJob(String databasePattern, String tablePattern, String columnPattern, String sessionId, String jobId, DataType[] resultTypes) {
        super(sessionId, jobId, resultTypes);
        this.databasePattern = this.convertSchemaPattern(databasePattern);
        this.tablePattern = this.convertIdentifierPattern(tablePattern, true);
        this.columnPattern = this.convertIdentifierPattern(columnPattern, false);
    }

    @Override
    protected List<Row> fetchCatalogObjects(SessionCatalog catalog) {
        ArrayList<Row> columnList = new ArrayList<Row>();
        List databases = JavaConversions.seqAsJavaList((Seq)catalog.listDatabases(this.databasePattern));
        for (String db : databases) {
            List tableIdentifiers = JavaConversions.seqAsJavaList((Seq)catalog.listTables(db, this.tablePattern));
            for (TableIdentifier tableIdentifier : tableIdentifiers) {
                CatalogTable table = catalog.getTempViewOrPermanentTableMetadata(tableIdentifier);
                List fields = JavaConversions.seqAsJavaList((Seq)table.schema());
                int position = 0;
                for (StructField field : fields) {
                    if (!field.name().matches(this.columnPattern)) continue;
                    columnList.add((Row)new GenericRow(new Object[]{"", table.database(), table.identifier().table(), field.name(), SparkUtils.toJavaSQLType(field.dataType()), field.dataType().typeName(), SparkUtils.getColumnSize(field.dataType()), null, SparkUtils.getDecimalDigits(field.dataType()), SparkUtils.getNumPrecRadix(field.dataType()), field.nullable() ? 1 : 0, field.getComment().isDefined() ? field.getComment().get() : "", null, null, null, null, position, field.nullable() ? "YES" : "NO", null, null, null, null, "NO"}));
                    ++position;
                }
            }
        }
        return columnList;
    }
}

