/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a;

import com.amazonaws.services.s3.internal.AmazonS3ExceptionBuilder;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.fs.s3a.FailureInjectionPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InconsistentS3Object
extends S3Object {
    public static final int MAX_READ_FAILURES = 100;
    private static int readFailureCounter = 0;
    private transient S3Object wrapped;
    private transient FailureInjectionPolicy policy;
    private static final transient Logger LOG = LoggerFactory.getLogger(InconsistentS3Object.class);

    public InconsistentS3Object(S3Object wrapped, FailureInjectionPolicy policy) {
        this.wrapped = wrapped;
        this.policy = policy;
    }

    @Override
    public S3ObjectInputStream getObjectContent() {
        return new InconsistentS3InputStream(this.wrapped.getObjectContent());
    }

    @Override
    public String toString() {
        return "InconsistentS3Object wrapping: " + this.wrapped.toString();
    }

    @Override
    public ObjectMetadata getObjectMetadata() {
        return this.wrapped.getObjectMetadata();
    }

    @Override
    public void setObjectMetadata(ObjectMetadata metadata) {
        this.wrapped.setObjectMetadata(metadata);
    }

    @Override
    public void setObjectContent(S3ObjectInputStream objectContent) {
        this.wrapped.setObjectContent(objectContent);
    }

    @Override
    public void setObjectContent(InputStream objectContent) {
        this.wrapped.setObjectContent(objectContent);
    }

    @Override
    public String getBucketName() {
        return this.wrapped.getBucketName();
    }

    @Override
    public void setBucketName(String bucketName) {
        this.wrapped.setBucketName(bucketName);
    }

    @Override
    public String getKey() {
        return this.wrapped.getKey();
    }

    @Override
    public void setKey(String key) {
        this.wrapped.setKey(key);
    }

    @Override
    public String getRedirectLocation() {
        return this.wrapped.getRedirectLocation();
    }

    @Override
    public void setRedirectLocation(String redirectLocation) {
        this.wrapped.setRedirectLocation(redirectLocation);
    }

    @Override
    public Integer getTaggingCount() {
        return this.wrapped.getTaggingCount();
    }

    @Override
    public void setTaggingCount(Integer taggingCount) {
        this.wrapped.setTaggingCount(taggingCount);
    }

    @Override
    public void close() throws IOException {
        this.wrapped.close();
    }

    @Override
    public boolean isRequesterCharged() {
        return this.wrapped.isRequesterCharged();
    }

    @Override
    public void setRequesterCharged(boolean isRequesterCharged) {
        this.wrapped.setRequesterCharged(isRequesterCharged);
    }

    private AmazonS3Exception mockException(String msg, int httpResponse) {
        AmazonS3ExceptionBuilder builder = new AmazonS3ExceptionBuilder();
        builder.setErrorMessage(msg);
        builder.setStatusCode(httpResponse);
        builder.setErrorCode(String.valueOf(httpResponse));
        return builder.build();
    }

    private void readFailpoint(int off, int len) throws IOException {
        if (this.shouldInjectFailure(this.getKey())) {
            String error = String.format("read(b, %d, %d) on key %s failed: injecting error %d/%d for test.", off, len, this.getKey(), readFailureCounter, 100);
            throw new FileNotFoundException(error);
        }
    }

    private void skipFailpoint(long len) throws IOException {
        if (this.shouldInjectFailure(this.getKey())) {
            String error = String.format("skip(%d) on key %s failed: injecting error %d/%d for test.", len, this.getKey(), readFailureCounter, 100);
            throw new FileNotFoundException(error);
        }
    }

    private boolean shouldInjectFailure(String key) {
        if (this.policy.shouldDelay(key) && readFailureCounter < 100) {
            ++readFailureCounter;
            return true;
        }
        return false;
    }

    protected class InconsistentS3InputStream
    extends S3ObjectInputStream {
        private S3ObjectInputStream wrapped;

        public InconsistentS3InputStream(S3ObjectInputStream wrapped) {
            super((InputStream)wrapped, wrapped.getHttpRequest());
            this.wrapped = wrapped;
        }

        @Override
        public void abort() {
            this.wrapped.abort();
        }

        @Override
        public int available() throws IOException {
            return this.wrapped.available();
        }

        @Override
        public void close() throws IOException {
            this.wrapped.close();
        }

        @Override
        public long skip(long n) throws IOException {
            InconsistentS3Object.this.skipFailpoint(n);
            return this.wrapped.skip(n);
        }

        @Override
        public int read() throws IOException {
            LOG.debug("read() for key {}", (Object)InconsistentS3Object.this.getKey());
            InconsistentS3Object.this.readFailpoint(0, 1);
            return this.wrapped.read();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            LOG.debug("read(b, {}, {}) for key {}", new Object[]{off, len, InconsistentS3Object.this.getKey()});
            InconsistentS3Object.this.readFailpoint(off, len);
            return this.wrapped.read(b, off, len);
        }
    }
}

