/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.utils;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.calcite.avatica.util.ByteString;
import org.apache.calcite.plan.RelOptPredicateList;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Calc;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.core.Values;
import org.apache.calcite.rel.logical.LogicalUnion;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexExecutor;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexPatternFieldRef;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexSimplify;
import org.apache.calcite.rex.RexUnknownAs;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.sql.SqlAsOperator;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlCastFunction;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.DateString;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.NlsString;
import org.apache.calcite.util.TimeString;
import org.apache.calcite.util.TimestampString;
import org.apache.calcite.util.Util;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.table.planner.calcite.FlinkContext;
import org.apache.flink.table.planner.functions.sql.SqlTryCastFunction;
import org.apache.flink.table.planner.plan.nodes.calcite.LegacySink;
import org.apache.flink.table.planner.plan.nodes.calcite.Sink;
import org.apache.flink.table.planner.plan.optimize.RelNodeBlock;
import org.apache.flink.table.planner.plan.utils.ExpressionDetail$;
import org.apache.flink.table.planner.plan.utils.ExpressionFormat$;
import org.apache.flink.table.planner.plan.utils.FlinkRelOptUtil$;
import org.apache.flink.table.planner.plan.utils.FlinkRexUtil;
import org.apache.flink.table.planner.plan.utils.InputRefVisitor;
import org.apache.flink.table.planner.plan.utils.RexNodeExtractor$;
import org.apache.flink.table.planner.plan.utils.RexNodeToExpressionConverter;
import org.apache.flink.table.planner.utils.ShortcutUtils;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

public final class FlinkRexUtil$ {
    public static FlinkRexUtil$ MODULE$;
    @Experimental
    private final ConfigOption<Integer> TABLE_OPTIMIZER_CNF_NODES_LIMIT;
    private final Set<SqlKind> BINARY_COMPARISON;

    static {
        new FlinkRexUtil$();
    }

    public ConfigOption<Integer> TABLE_OPTIMIZER_CNF_NODES_LIMIT() {
        return this.TABLE_OPTIMIZER_CNF_NODES_LIMIT;
    }

    public RexNode toCnf(RexBuilder rexBuilder, int maxCnfNodeCount, RexNode rex) {
        int maxCnfNodeCnt = maxCnfNodeCount < 0 ? this.org$apache$flink$table$planner$plan$utils$FlinkRexUtil$$getNumberOfRexCall(rex) * 2 : maxCnfNodeCount;
        return new FlinkRexUtil.CnfHelper(rexBuilder, maxCnfNodeCnt).toCnf(rex);
    }

    public boolean shouldSkipMiniBatch(Seq<RelNodeBlock> blocks) {
        Function1 & Serializable & scala.Serializable noMiniBatchRequired = (Function1 & Serializable & scala.Serializable)node -> BoxesRunTime.boxToBoolean((boolean)FlinkRexUtil$.$anonfun$shouldSkipMiniBatch$1(node));
        return ((IterableLike)blocks.map((Function1 & Serializable & scala.Serializable)b -> BoxesRunTime.boxToBoolean((boolean)FlinkRexUtil$.nodeTraverser$1(b.outputNode(), noMiniBatchRequired)), Seq$.MODULE$.canBuildFrom())).forall((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)r)));
    }

    public boolean containsExpectedInputRef(RexNode rex, ImmutableBitSet expectedInputRefs) {
        InputRefVisitor visitor = new InputRefVisitor();
        rex.accept(visitor);
        ImmutableBitSet inputRefs = ImmutableBitSet.of(visitor.getFields());
        return !inputRefs.intersect(expectedInputRefs).isEmpty();
    }

    public int org$apache$flink$table$planner$plan$utils$FlinkRexUtil$$getNumberOfRexCall(RexNode rex) {
        IntRef numberOfNodes = IntRef.create((int)0);
        rex.accept(new RexVisitorImpl<BoxedUnit>(numberOfNodes){
            private final IntRef numberOfNodes$1;

            public void visitCall(RexCall call) {
                ++this.numberOfNodes$1.elem;
                super.visitCall(call);
            }
            {
                this.numberOfNodes$1 = numberOfNodes$1;
                super(true);
            }
        });
        return numberOfNodes.elem;
    }

    public RexNode simplify(RexBuilder rexBuilder, RexNode expr, RexExecutor executor) {
        if (expr.isAlwaysTrue() || expr.isAlwaysFalse()) {
            return expr;
        }
        FlinkRexUtil.EquivalentExprShuttle exprShuttle = new FlinkRexUtil.EquivalentExprShuttle(rexBuilder);
        RexNode equiExpr = expr.accept(exprShuttle);
        FlinkRexUtil.SameExprMerger exprMerger = new FlinkRexUtil.SameExprMerger(rexBuilder);
        RexNode sameExprMerged = exprMerger.mergeSameExpr(equiExpr);
        RexNode binaryComparisonExprReduced = sameExprMerged.accept(new FlinkRexUtil.BinaryComparisonExprReducer(rexBuilder));
        RexSimplify rexSimplify = new RexSimplify(rexBuilder, RelOptPredicateList.EMPTY, executor);
        return rexSimplify.simplifyUnknownAs(binaryComparisonExprReduced, RexUnknownAs.falseIf(true));
    }

    public Set<SqlKind> BINARY_COMPARISON() {
        return this.BINARY_COMPARISON;
    }

    /*
     * WARNING - void declaration
     */
    public HashSet<RexInputRef> findAllInputRefs(RexNode node) {
        void var2_2;
        HashSet set = new HashSet();
        node.accept(new RexVisitorImpl<Void>(set){
            private final HashSet set$1;

            public Void visitInputRef(RexInputRef inputRef) {
                this.set$1.add(inputRef);
                return null;
            }
            {
                this.set$1 = set$1;
                super(true);
            }
        });
        return var2_2;
    }

    public RexNode adjustInputRef(RexNode expr, scala.collection.immutable.Map<Object, Object> fieldsOldToNewIndexMapping, RelDataType rowType) {
        return expr.accept(new RexShuttle(fieldsOldToNewIndexMapping, rowType){
            private final scala.collection.immutable.Map fieldsOldToNewIndexMapping$2;
            private final RelDataType rowType$1;

            /*
             * WARNING - void declaration
             */
            public RexNode visitInputRef(RexInputRef inputRef) {
                void var3_3;
                Predef$.MODULE$.require(JavaConversions$.MODULE$.deprecated$u0020mapAsJavaMap((Map)this.fieldsOldToNewIndexMapping$2).containsKey(BoxesRunTime.boxToInteger((int)inputRef.getIndex())));
                int newIndex = BoxesRunTime.unboxToInt((Object)this.fieldsOldToNewIndexMapping$2.apply((Object)BoxesRunTime.boxToInteger((int)inputRef.getIndex())));
                RexInputRef ref = RexInputRef.of(newIndex, this.rowType$1);
                return ref.getIndex() == inputRef.getIndex() && ref.getType() == inputRef.getType() ? inputRef : var3_3;
            }
            {
                this.fieldsOldToNewIndexMapping$2 = fieldsOldToNewIndexMapping$2;
                this.rowType$1 = rowType$1;
            }
        });
    }

    public Tuple2<Seq<RexNode>, Option<RexNode>> expandRexProgram(RexProgram program) {
        Buffer projection = (Buffer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(program.getProjectList()).map((Function1 & Serializable & scala.Serializable)x$1 -> program.expandLocalRef((RexLocalRef)x$1), Buffer$.MODULE$.canBuildFrom());
        None$ filter = program.getCondition() != null ? new Some((Object)program.expandLocalRef(program.getCondition())) : None$.MODULE$;
        return new Tuple2((Object)projection, (Object)filter);
    }

    public RexNode expandSearch(RexBuilder rexBuilder, RexNode rex) {
        return this.expandSearch(rexBuilder, rex, (Function1<RexCall, Object>)(Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)FlinkRexUtil$.$anonfun$expandSearch$1(x$1)));
    }

    public RexNode expandSearch(RexBuilder rexBuilder, RexNode rex, Function1<RexCall, Object> tester) {
        RexShuttle shuttle = new RexShuttle(rexBuilder, tester){
            private final RexBuilder rexBuilder$1;
            private final Function1 tester$1;

            public RexNode visitCall(RexCall call) {
                SqlKind sqlKind = call.getKind();
                SqlKind sqlKind2 = SqlKind.SEARCH;
                return !(sqlKind != null ? !((Object)((Object)sqlKind)).equals((Object)((Object)sqlKind2)) : sqlKind2 != null) && BoxesRunTime.unboxToBoolean((Object)this.tester$1.apply((Object)call)) ? RexUtil.expandSearch(this.rexBuilder$1, null, call) : super.visitCall(call);
            }
            {
                this.rexBuilder$1 = rexBuilder$1;
                this.tester$1 = tester$1;
            }
        };
        return rex.accept(shuttle);
    }

    public RexNode adjustInputRef(RexNode expr, scala.collection.immutable.Map<Object, Object> fieldsOldToNewIndexMapping) {
        return expr.accept(new RexShuttle(fieldsOldToNewIndexMapping){
            private final scala.collection.immutable.Map fieldsOldToNewIndexMapping$1;

            public RexNode visitInputRef(RexInputRef inputRef) {
                Predef$.MODULE$.require(JavaConversions$.MODULE$.deprecated$u0020mapAsJavaMap((Map)this.fieldsOldToNewIndexMapping$1).containsKey(BoxesRunTime.boxToInteger((int)inputRef.getIndex())));
                int newIndex = BoxesRunTime.unboxToInt((Object)this.fieldsOldToNewIndexMapping$1.apply((Object)BoxesRunTime.boxToInteger((int)inputRef.getIndex())));
                return new RexInputRef(newIndex, inputRef.getType());
            }
            {
                this.fieldsOldToNewIndexMapping$1 = fieldsOldToNewIndexMapping$1;
            }
        });
    }

    public String getExpressionString(RexNode expr, Seq<String> inFields) {
        return this.getExpressionString(expr, inFields, ExpressionDetail$.MODULE$.Digest());
    }

    public String getExpressionString(RexNode expr, Seq<String> inFields, Enumeration.Value expressionDetail) {
        return this.getExpressionString(expr, inFields, (Option<List<RexNode>>)Option$.MODULE$.empty(), ExpressionFormat$.MODULE$.Prefix(), expressionDetail);
    }

    public String getExpressionString(RexNode expr, Seq<String> inFields, Option<List<RexNode>> localExprsTable, Enumeration.Value expressionFormat, Enumeration.Value expressionDetail) {
        String string;
        block54: {
            RexNode rexNode;
            while (true) {
                RexNode lExpr;
                boolean bl = false;
                RexLocalRef rexLocalRef = null;
                rexNode = expr;
                if (rexNode instanceof RexPatternFieldRef) {
                    RexPatternFieldRef rexPatternFieldRef = (RexPatternFieldRef)rexNode;
                    String alpha = rexPatternFieldRef.getAlpha();
                    String field = (String)inFields.apply(rexPatternFieldRef.getIndex());
                    string = new StringBuilder(1).append(alpha).append(".").append(field).toString();
                    break block54;
                }
                if (rexNode instanceof RexInputRef) {
                    RexInputRef rexInputRef = (RexInputRef)rexNode;
                    string = (String)inFields.apply(rexInputRef.getIndex());
                    break block54;
                }
                if (rexNode instanceof RexLiteral) {
                    String string2;
                    RexLiteral rexLiteral = (RexLiteral)rexNode;
                    Enumeration.Value value = expressionDetail;
                    Enumeration.Value value2 = ExpressionDetail$.MODULE$.Digest();
                    Enumeration.Value value3 = value;
                    if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                        string2 = rexLiteral.toString();
                    } else {
                        Enumeration.Value value4 = ExpressionDetail$.MODULE$.Explain();
                        Enumeration.Value value5 = value;
                        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                            String string3;
                            Comparable value6 = rexLiteral.getValue();
                            if (value6 == null) {
                                string3 = new StringBuilder(5).append("null:").append(rexLiteral.getType()).toString();
                            } else {
                                String string4;
                                SqlTypeName sqlTypeName = rexLiteral.getTypeName();
                                if (((Object)((Object)SqlTypeName.DOUBLE)).equals((Object)sqlTypeName)) {
                                    string4 = Util.toScientificNotation((BigDecimal)value6);
                                } else if (((Object)((Object)SqlTypeName.BIGINT)).equals((Object)sqlTypeName)) {
                                    string4 = new StringBuilder(1).append(((BigDecimal)value6).longValue()).append("L").toString();
                                } else if (((Object)((Object)SqlTypeName.BINARY)).equals((Object)sqlTypeName)) {
                                    string4 = new StringBuilder(3).append("X'").append(((ByteString)value6).toString(16)).append("'").toString();
                                } else {
                                    boolean bl2 = ((Object)((Object)SqlTypeName.VARCHAR)).equals((Object)sqlTypeName) ? true : ((Object)((Object)SqlTypeName.CHAR)).equals((Object)sqlTypeName);
                                    if (bl2) {
                                        string4 = new StringBuilder(2).append("'").append(((NlsString)value6).getValue()).append("'").toString();
                                    } else {
                                        boolean bl3 = ((Object)((Object)SqlTypeName.TIME)).equals((Object)sqlTypeName) ? true : ((Object)((Object)SqlTypeName.TIME_WITH_LOCAL_TIME_ZONE)).equals((Object)sqlTypeName);
                                        if (bl3) {
                                            string4 = rexLiteral.getValueAs(TimeString.class).toString();
                                        } else if (((Object)((Object)SqlTypeName.DATE)).equals((Object)sqlTypeName)) {
                                            string4 = rexLiteral.getValueAs(DateString.class).toString();
                                        } else {
                                            boolean bl4 = ((Object)((Object)SqlTypeName.TIMESTAMP)).equals((Object)sqlTypeName) ? true : ((Object)((Object)SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE)).equals((Object)sqlTypeName);
                                            string4 = bl4 ? rexLiteral.getValueAs(TimestampString.class).toString() : (SqlTypeName.INTERVAL_TYPES.contains((Object)sqlTypeName) ? rexLiteral.toString() : value6.toString());
                                        }
                                    }
                                }
                                string3 = string4;
                            }
                            string2 = string3;
                        } else {
                            throw new MatchError((Object)value);
                        }
                    }
                    string = string2;
                    break block54;
                }
                if (rexNode instanceof RexLocalRef) {
                    bl = true;
                    rexLocalRef = (RexLocalRef)rexNode;
                    if (localExprsTable.isEmpty()) {
                        throw new IllegalArgumentException("Encountered RexLocalRef without local expression table");
                    }
                }
                if (!bl) break;
                expr = lExpr = (RexNode)((LinearSeqOptimized)localExprsTable.get()).apply(rexLocalRef.getIndex());
            }
            if (rexNode instanceof RexCall) {
                String string5;
                RexCall rexCall = (RexCall)rexNode;
                String op = rexCall.getOperator().toString();
                Buffer ops = (Buffer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(rexCall.getOperands()).map((Function1 & Serializable & scala.Serializable)x$2 -> MODULE$.getExpressionString((RexNode)x$2, inFields, localExprsTable, expressionFormat, expressionDetail), Buffer$.MODULE$.canBuildFrom());
                SqlOperator sqlOperator = rexCall.getOperator();
                if (sqlOperator instanceof SqlAsOperator) {
                    string5 = (String)ops.head();
                } else {
                    boolean bl = sqlOperator instanceof SqlCastFunction ? true : sqlOperator instanceof SqlTryCastFunction;
                    if (bl) {
                        String string6;
                        Enumeration.Value value = expressionDetail;
                        Enumeration.Value value7 = ExpressionDetail$.MODULE$.Digest();
                        Enumeration.Value value8 = value;
                        if (!(value7 != null ? !value7.equals(value8) : value8 != null)) {
                            string6 = rexCall.getType().getFullTypeString();
                        } else {
                            Enumeration.Value value9 = ExpressionDetail$.MODULE$.Explain();
                            Enumeration.Value value10 = value;
                            if (!(value9 != null ? !value9.equals(value10) : value10 != null)) {
                                string6 = ((Object)rexCall.getType()).toString();
                            } else {
                                throw new MatchError((Object)value);
                            }
                        }
                        String typeStr = string6;
                        string5 = new StringBuilder(6).append(op).append("(").append(ops.head()).append(" AS ").append(typeStr).append(")").toString();
                    } else {
                        String string7;
                        if (JavaConversions$.MODULE$.deprecated$u0020bufferAsJavaList(ops).size() == 1) {
                            String string8;
                            String operand = (String)ops.head();
                            Enumeration.Value value = expressionFormat;
                            Enumeration.Value value11 = ExpressionFormat$.MODULE$.Infix();
                            Enumeration.Value value12 = value;
                            if (!(value11 != null ? !value11.equals(value12) : value12 != null)) {
                                SqlKind sqlKind = rexCall.getKind();
                                boolean bl5 = ((Object)((Object)SqlKind.IS_FALSE)).equals((Object)sqlKind) ? true : (((Object)((Object)SqlKind.IS_NOT_FALSE)).equals((Object)sqlKind) ? true : (((Object)((Object)SqlKind.IS_TRUE)).equals((Object)sqlKind) ? true : (((Object)((Object)SqlKind.IS_NOT_TRUE)).equals((Object)sqlKind) ? true : (((Object)((Object)SqlKind.IS_UNKNOWN)).equals((Object)sqlKind) ? true : (((Object)((Object)SqlKind.IS_NULL)).equals((Object)sqlKind) ? true : ((Object)((Object)SqlKind.IS_NOT_NULL)).equals((Object)sqlKind))))));
                                String string9 = bl5 ? new StringBuilder(1).append(operand).append(" ").append(op).toString() : new StringBuilder(2).append(op).append("(").append(operand).append(")").toString();
                                string8 = string9;
                            } else {
                                Enumeration.Value value13 = ExpressionFormat$.MODULE$.PostFix();
                                Enumeration.Value value14 = value;
                                if (!(value13 != null ? !value13.equals(value14) : value14 != null)) {
                                    string8 = new StringBuilder(1).append(operand).append(" ").append(op).toString();
                                } else {
                                    Enumeration.Value value15 = ExpressionFormat$.MODULE$.Prefix();
                                    Enumeration.Value value16 = value;
                                    if (!(value15 != null ? !value15.equals(value16) : value16 != null)) {
                                        string8 = new StringBuilder(2).append(op).append("(").append(operand).append(")").toString();
                                    } else {
                                        throw new MatchError((Object)value);
                                    }
                                }
                            }
                            string7 = string8;
                        } else {
                            String string10;
                            SqlKind sqlKind = rexCall.getKind();
                            boolean bl6 = ((Object)((Object)SqlKind.TIMES)).equals((Object)sqlKind) ? true : (((Object)((Object)SqlKind.DIVIDE)).equals((Object)sqlKind) ? true : (((Object)((Object)SqlKind.PLUS)).equals((Object)sqlKind) ? true : (((Object)((Object)SqlKind.MINUS)).equals((Object)sqlKind) ? true : (((Object)((Object)SqlKind.LESS_THAN)).equals((Object)sqlKind) ? true : (((Object)((Object)SqlKind.LESS_THAN_OR_EQUAL)).equals((Object)sqlKind) ? true : (((Object)((Object)SqlKind.GREATER_THAN)).equals((Object)sqlKind) ? true : (((Object)((Object)SqlKind.GREATER_THAN_OR_EQUAL)).equals((Object)sqlKind) ? true : (((Object)((Object)SqlKind.EQUALS)).equals((Object)sqlKind) ? true : (((Object)((Object)SqlKind.NOT_EQUALS)).equals((Object)sqlKind) ? true : (((Object)((Object)SqlKind.OR)).equals((Object)sqlKind) ? true : ((Object)((Object)SqlKind.AND)).equals((Object)sqlKind)))))))))));
                            if (bl6) {
                                String string11;
                                Enumeration.Value value = expressionFormat;
                                Enumeration.Value value17 = ExpressionFormat$.MODULE$.Infix();
                                Enumeration.Value value18 = value;
                                if (!(value17 != null ? !value17.equals(value18) : value18 != null)) {
                                    string11 = new StringBuilder(2).append("(").append(ops.mkString(new StringBuilder(2).append(" ").append(op).append(" ").toString())).append(")").toString();
                                } else {
                                    Enumeration.Value value19 = ExpressionFormat$.MODULE$.PostFix();
                                    Enumeration.Value value20 = value;
                                    if (!(value19 != null ? !value19.equals(value20) : value20 != null)) {
                                        string11 = new StringBuilder(2).append("(").append(ops.mkString(", ")).append(")").append(op).toString();
                                    } else {
                                        Enumeration.Value value21 = ExpressionFormat$.MODULE$.Prefix();
                                        Enumeration.Value value22 = value;
                                        if (!(value21 != null ? !value21.equals(value22) : value22 != null)) {
                                            string11 = new StringBuilder(2).append(op).append("(").append(ops.mkString(", ")).append(")").toString();
                                        } else {
                                            throw new MatchError((Object)value);
                                        }
                                    }
                                }
                                string10 = string11;
                            } else {
                                string10 = new StringBuilder(2).append(op).append("(").append(ops.mkString(", ")).append(")").toString();
                            }
                            string7 = string10;
                        }
                        string5 = string7;
                    }
                }
                string = string5;
            } else if (rexNode instanceof RexFieldAccess) {
                RexFieldAccess rexFieldAccess = (RexFieldAccess)rexNode;
                String referenceExpr = this.getExpressionString(rexFieldAccess.getReferenceExpr(), inFields, localExprsTable, expressionFormat, expressionDetail);
                String field = rexFieldAccess.getField().getName();
                string = new StringBuilder(1).append(referenceExpr).append(".").append(field).toString();
            } else if (rexNode instanceof RexCorrelVariable) {
                RexCorrelVariable rexCorrelVariable = (RexCorrelVariable)rexNode;
                string = rexCorrelVariable.toString();
            } else {
                throw new IllegalArgumentException(new StringBuilder(28).append("Unknown expression type '").append(expr.getClass()).append("': ").append(expr).toString());
            }
        }
        return string;
    }

    public boolean hasOperatorCallMatching(RexNode expr, Predicate<SqlOperator> predicate) {
        try {
            RexVisitorImpl<Void> visitor = new RexVisitorImpl<Void>(predicate){
                private final Predicate predicate$1;

                public Void visitCall(RexCall call) {
                    if (this.predicate$1.test(call.getOperator())) {
                        throw new Util.FoundOne(call);
                    }
                    return (Void)super.visitCall(call);
                }
                {
                    this.predicate$1 = predicate$1;
                    super(true);
                }
            };
            expr.accept(visitor);
        }
        catch (Util.FoundOne e) {
            Util.swallow(e, null);
            return true;
        }
        return false;
    }

    public Optional<String> getNonDeterministicCallName(RexNode e) {
        Optional<String> optional;
        try {
            RexVisitorImpl<Void> visitor = new RexVisitorImpl<Void>(){

                public Void visitCall(RexCall call) {
                    if (!call.getOperator().isDeterministic()) {
                        throw new Util.FoundOne((Object)call.getOperator().getName());
                    }
                    return (Void)super.visitCall(call);
                }
            };
            e.accept(visitor);
            optional = Optional.empty();
        }
        catch (Util.FoundOne ex) {
            Util.swallow(ex, null);
            optional = Optional.ofNullable(ex.getNode().toString());
        }
        return optional;
    }

    public boolean isDeterministic(RexProgram rexProgram) {
        RexNode rexCondi;
        if (rexProgram.getCondition() != null && !RexUtil.isDeterministic(rexCondi = rexProgram.expandLocalRef(rexProgram.getCondition()))) {
            return false;
        }
        Buffer projects = (Buffer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(rexProgram.getProjectList()).map((Function1 & Serializable & scala.Serializable)x$1 -> rexProgram.expandLocalRef((RexLocalRef)x$1), Buffer$.MODULE$.canBuildFrom());
        return projects.forall((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)FlinkRexUtil$.$anonfun$isDeterministic$2(x$1)));
    }

    public Tuple2<RexNode[], RexNode[]> extractPredicates(String[] inputNames, RexNode filterExpression, RelNode rel, RexBuilder rexBuilder) {
        FlinkContext context = ShortcutUtils.unwrapContext(rel);
        int maxCnfNodeCount = FlinkRelOptUtil$.MODULE$.getMaxCnfNodeCount(rel);
        RexNodeToExpressionConverter converter = new RexNodeToExpressionConverter(rexBuilder, inputNames, context.getFunctionCatalog(), context.getCatalogManager(), (Option<RelDataType>)new Some((Object)rel.getRowType()));
        return RexNodeExtractor$.MODULE$.extractConjunctiveConditions(filterExpression, maxCnfNodeCount, rexBuilder, converter);
    }

    public static final /* synthetic */ boolean $anonfun$shouldSkipMiniBatch$1(RelNode node) {
        boolean bl;
        RelNode relNode = node;
        boolean bl2 = relNode instanceof Filter ? true : (relNode instanceof Project ? true : (relNode instanceof TableScan ? true : (relNode instanceof Calc ? true : (relNode instanceof Values ? true : (relNode instanceof Sink ? true : relNode instanceof LegacySink)))));
        if (bl2) {
            bl = true;
        } else if (relNode instanceof LogicalUnion) {
            LogicalUnion logicalUnion = (LogicalUnion)relNode;
            bl = logicalUnion.all;
        } else {
            bl = false;
        }
        return bl;
    }

    private static final boolean nodeTraverser$1(RelNode node, Function1 noMiniBatchRequired$1) {
        return BoxesRunTime.unboxToBoolean((Object)noMiniBatchRequired$1.apply((Object)node)) && ((IterableLike)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(node.getInputs()).map((Function1 & Serializable & scala.Serializable)n -> BoxesRunTime.boxToBoolean((boolean)FlinkRexUtil$.nodeTraverser$1(n, noMiniBatchRequired$1)), Buffer$.MODULE$.canBuildFrom())).forall((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)r)));
    }

    public static final /* synthetic */ boolean $anonfun$expandSearch$1(RexCall x$1) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$isDeterministic$2(RexNode x$1) {
        return RexUtil.isDeterministic(x$1);
    }

    private FlinkRexUtil$() {
        MODULE$ = this;
        this.TABLE_OPTIMIZER_CNF_NODES_LIMIT = ConfigOptions.key((String)"table.optimizer.cnf-nodes-limit").intType().defaultValue((Object)-1).withDescription("When converting to conjunctive normal form (CNF, like '(a AND b) OR c' will be converted to '(a OR c) AND (b OR c)'), fail if the expression  exceeds this threshold; (e.g. predicate in TPC-DS q41.sql will be converted to hundreds of thousands of CNF nodes.) the threshold is expressed in terms of number of nodes (only count RexCall node, including leaves and interior nodes). Negative number to use the default threshold: double of number of nodes.");
        this.BINARY_COMPARISON = EnumSet.of(SqlKind.EQUALS, (Enum[])new SqlKind[]{SqlKind.NOT_EQUALS, SqlKind.GREATER_THAN, SqlKind.GREATER_THAN_OR_EQUAL, SqlKind.LESS_THAN, SqlKind.LESS_THAN_OR_EQUAL});
    }
}

