/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.expressions.converter;

import java.util.Optional;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlOperator;
import org.apache.flink.table.expressions.CallExpression;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.FunctionIdentifier;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.functions.ScalarFunctionDefinition;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.functions.UserDefinedFunctionHelper;
import org.apache.flink.table.planner.expressions.converter.CallExpressionConvertRule;
import org.apache.flink.table.planner.expressions.converter.ExpressionConverter;
import org.apache.flink.table.planner.functions.utils.UserDefinedFunctionUtils;

public class LegacyScalarFunctionConvertRule
implements CallExpressionConvertRule {
    @Override
    public Optional<RexNode> convert(CallExpression call, CallExpressionConvertRule.ConvertContext context) {
        FunctionDefinition def = call.getFunctionDefinition();
        if (def instanceof ScalarFunctionDefinition) {
            ScalarFunction scalaFunc = ((ScalarFunctionDefinition)def).getScalarFunction();
            FunctionIdentifier identifier = call.getFunctionIdentifier().orElse(FunctionIdentifier.of((String)UserDefinedFunctionHelper.generateInlineFunctionName((UserDefinedFunction)scalaFunc)));
            SqlFunction sqlFunction = UserDefinedFunctionUtils.createScalarSqlFunction(identifier, scalaFunc.toString(), scalaFunc, context.getTypeFactory());
            return Optional.of(context.getRelBuilder().call((SqlOperator)sqlFunction, (Iterable<? extends RexNode>)ExpressionConverter.toRexNodes(context, call.getChildren())));
        }
        return Optional.empty();
    }
}

