/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.cdise.owb;

import java.lang.annotation.Annotation;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.ConversationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.SessionScoped;
import javax.inject.Singleton;
import org.apache.deltaspike.cdise.api.ContextControl;
import org.apache.deltaspike.cdise.owb.OwbHelper;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.spi.ContextsService;

@Dependent
public class OpenWebBeansContextControl
implements ContextControl {
    private static ThreadLocal<Object> mockSessions = new ThreadLocal();

    public void startContexts() {
        ContextsService contextsService = this.getContextsService();
        this.startSingletonScope();
        this.startApplicationScope();
        this.startSessionScope();
        this.startRequestScope();
        this.startConversationScope();
    }

    public void stopContexts() {
        this.stopSessionScope();
        this.stopConversationScope();
        this.stopRequestScope();
        this.stopApplicationScope();
        this.stopSingletonScope();
    }

    public void startContext(Class<? extends Annotation> scopeClass) {
        if (scopeClass.isAssignableFrom(ApplicationScoped.class)) {
            this.startApplicationScope();
        } else if (scopeClass.isAssignableFrom(SessionScoped.class)) {
            this.startSessionScope();
        } else if (scopeClass.isAssignableFrom(RequestScoped.class)) {
            this.startRequestScope();
        } else if (scopeClass.isAssignableFrom(ConversationScoped.class)) {
            this.startConversationScope();
        }
    }

    public void stopContext(Class<? extends Annotation> scopeClass) {
        if (scopeClass.isAssignableFrom(ApplicationScoped.class)) {
            this.stopApplicationScope();
        } else if (scopeClass.isAssignableFrom(SessionScoped.class)) {
            this.stopSessionScope();
        } else if (scopeClass.isAssignableFrom(RequestScoped.class)) {
            this.stopRequestScope();
        } else if (scopeClass.isAssignableFrom(ConversationScoped.class)) {
            this.stopConversationScope();
        }
    }

    static boolean isServletApiAvailable() {
        try {
            Class<?> servletClass = Class.forName("javax.servlet.http.HttpSession");
            return servletClass != null;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private void startSingletonScope() {
        ContextsService contextsService = this.getContextsService();
        Object mockServletContext = null;
        if (OpenWebBeansContextControl.isServletApiAvailable()) {
            mockServletContext = OwbHelper.getMockServletContext();
        }
        contextsService.startContext(Singleton.class, mockServletContext);
    }

    private void startApplicationScope() {
        ContextsService contextsService = this.getContextsService();
        Object mockServletContext = null;
        if (OpenWebBeansContextControl.isServletApiAvailable()) {
            mockServletContext = OwbHelper.getMockServletContext();
        }
        contextsService.startContext(ApplicationScoped.class, mockServletContext);
    }

    private void startSessionScope() {
        ContextsService contextsService = this.getContextsService();
        Object mockSession = null;
        if (OpenWebBeansContextControl.isServletApiAvailable() && (mockSession = mockSessions.get()) == null) {
            mockSession = OwbHelper.getMockSession(Thread.currentThread().getName());
            mockSessions.set(mockSession);
        }
        contextsService.startContext(SessionScoped.class, mockSession);
    }

    private void startRequestScope() {
        ContextsService contextsService = this.getContextsService();
        contextsService.startContext(RequestScoped.class, null);
    }

    private void startConversationScope() {
        ContextsService contextsService = this.getContextsService();
        contextsService.startContext(ConversationScoped.class, null);
    }

    private void stopSingletonScope() {
        ContextsService contextsService = this.getContextsService();
        Object mockServletContext = null;
        if (OpenWebBeansContextControl.isServletApiAvailable()) {
            mockServletContext = OwbHelper.getMockServletContext();
        }
        contextsService.endContext(Singleton.class, mockServletContext);
    }

    private void stopApplicationScope() {
        ContextsService contextsService = this.getContextsService();
        Object mockServletContext = null;
        if (OpenWebBeansContextControl.isServletApiAvailable()) {
            mockServletContext = OwbHelper.getMockServletContext();
        }
        contextsService.endContext(ApplicationScoped.class, mockServletContext);
    }

    private void stopSessionScope() {
        ContextsService contextsService = this.getContextsService();
        Object mockSession = null;
        if (OpenWebBeansContextControl.isServletApiAvailable()) {
            mockSession = mockSessions.get();
            mockSessions.set(null);
            mockSessions.remove();
        }
        contextsService.endContext(SessionScoped.class, mockSession);
    }

    private void stopRequestScope() {
        ContextsService contextsService = this.getContextsService();
        contextsService.endContext(RequestScoped.class, null);
    }

    private void stopConversationScope() {
        ContextsService contextsService = this.getContextsService();
        contextsService.endContext(ConversationScoped.class, null);
    }

    private ContextsService getContextsService() {
        WebBeansContext webBeansContext = WebBeansContext.currentInstance();
        return webBeansContext.getContextsService();
    }
}

