/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.util.function.Supplier;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemProperties;
import org.apache.commons.lang3.SystemUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.junitpioneer.jupiter.SetSystemProperty;

@SetSystemProperty.SetSystemProperties(value={@SetSystemProperty(key=" ", value="value1"), @SetSystemProperty(key="\t", value="value2")})
class SystemPropertiesTest {
    static final String KEY_SPACE_1 = " ";
    static final String KEY_TAB_1 = "\t";

    SystemPropertiesTest() {
    }

    private void basicKeyCheck(String key) {
        Assertions.assertNotNull((Object)key);
        Assertions.assertFalse((boolean)key.isEmpty());
        Assertions.assertDoesNotThrow(() -> System.getProperties().get(key));
        Assertions.assertDoesNotThrow(() -> System.getProperty(key));
        Assertions.assertDoesNotThrow(() -> System.getProperty(key, ""));
    }

    private boolean isJava11OrGreater() {
        return SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_11);
    }

    @Test
    void testActualKeys() {
        this.basicKeyCheck("apple.awt.enableTemplateImages");
        this.basicKeyCheck("awt.toolkit");
        this.basicKeyCheck("com.sun.jndi.ldap.object.trustSerialData");
        this.basicKeyCheck("com.sun.net.httpserver.HttpServerProvider");
        this.basicKeyCheck("file.encoding");
        this.basicKeyCheck("file.separator");
        this.basicKeyCheck("ftp.nonProxyHosts");
        this.basicKeyCheck("ftp.proxyHost");
        this.basicKeyCheck("ftp.proxyPort");
        this.basicKeyCheck("http.agent");
        this.basicKeyCheck("http.auth.digest.cnonceRepeat");
        this.basicKeyCheck("http.auth.digest.reEnabledAlgorithms");
        this.basicKeyCheck("http.auth.digest.validateProxy");
        this.basicKeyCheck("http.auth.digest.validateServer");
        this.basicKeyCheck("http.auth.ntlm.domain");
        this.basicKeyCheck("http.keepAlive");
        this.basicKeyCheck("http.keepAlive.time.proxy");
        this.basicKeyCheck("http.keepAlive.time.server");
        this.basicKeyCheck("http.maxConnections");
        this.basicKeyCheck("http.maxRedirects");
        this.basicKeyCheck("http.nonProxyHosts");
        this.basicKeyCheck("http.proxyHost");
        this.basicKeyCheck("http.proxyPort");
        this.basicKeyCheck("https.proxyHost");
        this.basicKeyCheck("https.proxyPort");
        this.basicKeyCheck("java.awt.fonts");
        this.basicKeyCheck("java.awt.graphicsenv");
        this.basicKeyCheck("java.awt.headless");
        this.basicKeyCheck("java.awt.printerjob");
        this.basicKeyCheck("java.class.path");
        this.basicKeyCheck("java.class.version");
        this.basicKeyCheck("java.compiler");
        this.basicKeyCheck("java.content.handler.pkgs");
        this.basicKeyCheck("java.endorsed.dirs");
        this.basicKeyCheck("java.ext.dirs");
        this.basicKeyCheck("java.home");
        this.basicKeyCheck("java.io.tmpdir");
        this.basicKeyCheck("java.library.path");
        this.basicKeyCheck("java.locale.providers");
        this.basicKeyCheck("java.locale.useOldISOCodes");
        this.basicKeyCheck("java.net.preferIPv4Stack");
        this.basicKeyCheck("java.net.preferIPv6Addresses");
        this.basicKeyCheck("java.net.socks.password");
        this.basicKeyCheck("java.net.socks.username");
        this.basicKeyCheck("java.net.useSystemProxies");
        this.basicKeyCheck("java.nio.channels.DefaultThreadPool.initialSize");
        this.basicKeyCheck("java.nio.channels.DefaultThreadPool.threadFactory");
        this.basicKeyCheck("java.nio.channels.spi.AsynchronousChannelProvider");
        this.basicKeyCheck("java.nio.channels.spi.SelectorProvider");
        this.basicKeyCheck("java.nio.file.spi.DefaultFileSystemProvider");
        this.basicKeyCheck("java.properties.date");
        this.basicKeyCheck("java.protocol.handler.pkgs");
        this.basicKeyCheck("java.rmi.server.codebase");
        this.basicKeyCheck("java.rmi.server.hostname");
        this.basicKeyCheck("java.rmi.server.randomIDs");
        this.basicKeyCheck("java.rmi.server.RMIClassLoaderSpi");
        this.basicKeyCheck("java.runtime.name");
        this.basicKeyCheck("java.runtime.version");
        this.basicKeyCheck("java.security.auth.login.config");
        this.basicKeyCheck("java.security.krb5.conf");
        this.basicKeyCheck("java.security.krb5.kdc");
        this.basicKeyCheck("java.security.krb5.realm");
        this.basicKeyCheck("java.security.debug");
        this.basicKeyCheck("java.security.manager");
        this.basicKeyCheck("java.specification.maintenance.version");
        this.basicKeyCheck("java.specification.name");
        this.basicKeyCheck("java.specification.vendor");
        this.basicKeyCheck("java.specification.version");
        this.basicKeyCheck("java.system.class.loader");
        this.basicKeyCheck("java.time.zone.DefaultZoneRulesProvider");
        this.basicKeyCheck("java.util.concurrent.ForkJoinPool.common.exceptionHandler");
        this.basicKeyCheck("java.util.concurrent.ForkJoinPool.common.maximumSpares");
        this.basicKeyCheck("java.util.concurrent.ForkJoinPool.common.parallelism");
        this.basicKeyCheck("java.util.concurrent.ForkJoinPool.common.threadFactory");
        this.basicKeyCheck("java.util.currency.data");
        this.basicKeyCheck("java.util.logging.config.class");
        this.basicKeyCheck("java.util.logging.config.file");
        this.basicKeyCheck("java.util.logging.simpleformatter.format");
        this.basicKeyCheck("java.util.prefs.PreferencesFactory");
        this.basicKeyCheck("java.util.PropertyResourceBundle.encoding");
        this.basicKeyCheck("java.vendor");
        this.basicKeyCheck("java.vendor.url");
        this.basicKeyCheck("java.vendor.version");
        this.basicKeyCheck("java.version");
        this.basicKeyCheck("java.version.date");
        this.basicKeyCheck("java.vm.info");
        this.basicKeyCheck("java.vm.name");
        this.basicKeyCheck("java.vm.specification.name");
        this.basicKeyCheck("java.vm.specification.vendor");
        this.basicKeyCheck("java.vm.specification.version");
        this.basicKeyCheck("java.vm.vendor");
        this.basicKeyCheck("java.vm.version");
        this.basicKeyCheck("java.xml.config.file");
        this.basicKeyCheck("javax.accessibility.assistive_technologies");
        this.basicKeyCheck("javax.net.ssl.sessionCacheSize");
        this.basicKeyCheck("javax.rmi.ssl.client.enabledCipherSuites");
        this.basicKeyCheck("javax.rmi.ssl.client.enabledProtocols");
        this.basicKeyCheck("javax.security.auth.useSubjectCredsOnly");
        this.basicKeyCheck("javax.smartcardio.TerminalFactory.DefaultType");
        this.basicKeyCheck("jdbc.drivers");
        this.basicKeyCheck("jdk.http.auth.proxying.disabledSchemes");
        this.basicKeyCheck("jdk.http.auth.tunneling.disabledSchemes");
        this.basicKeyCheck("jdk.httpclient.allowRestrictedHeaders");
        this.basicKeyCheck("jdk.httpclient.auth.retrylimit");
        this.basicKeyCheck("jdk.httpclient.bufsize");
        this.basicKeyCheck("jdk.httpclient.connectionPoolSize");
        this.basicKeyCheck("jdk.httpclient.connectionWindowSize");
        this.basicKeyCheck("jdk.httpclient.disableRetryConnect");
        this.basicKeyCheck("jdk.httpclient.enableAllMethodRetry");
        this.basicKeyCheck("jdk.httpclient.enablepush");
        this.basicKeyCheck("jdk.httpclient.hpack.maxheadertablesize");
        this.basicKeyCheck("jdk.httpclient.HttpClient.log");
        this.basicKeyCheck("jdk.httpclient.keepalive.timeout");
        this.basicKeyCheck("jdk.httpclient.keepalive.timeout.h2");
        this.basicKeyCheck("jdk.httpclient.maxframesize");
        this.basicKeyCheck("jdk.httpclient.maxstreams");
        this.basicKeyCheck("jdk.httpclient.receiveBufferSize");
        this.basicKeyCheck("jdk.httpclient.redirects.retrylimit");
        this.basicKeyCheck("jdk.httpclient.sendBufferSize");
        this.basicKeyCheck("jdk.httpclient.websocket.writeBufferSize");
        this.basicKeyCheck("jdk.httpclient.windowsize");
        this.basicKeyCheck("jdk.https.negotiate.cbt");
        this.basicKeyCheck("jdk.httpserver.maxConnections");
        this.basicKeyCheck("jdk.includeInExceptions");
        this.basicKeyCheck("jdk.internal.httpclient.disableHostnameVerification");
        this.basicKeyCheck("jdk.io.permissionsUseCanonicalPath");
        this.basicKeyCheck("jdk.jndi.ldap.object.factoriesFilter");
        this.basicKeyCheck("jdk.jndi.object.factoriesFilter");
        this.basicKeyCheck("jdk.jndi.rmi.object.factoriesFilter");
        this.basicKeyCheck("jdk.module.main");
        this.basicKeyCheck("jdk.module.main.class");
        this.basicKeyCheck("jdk.module.path");
        this.basicKeyCheck("jdk.module.upgrade.path");
        this.basicKeyCheck("jdk.net.unixdomain.tmpdir");
        this.basicKeyCheck("jdk.net.URLClassPath.showIgnoredClassPathEntries");
        this.basicKeyCheck("jdk.serialFilter");
        this.basicKeyCheck("jdk.serialFilterFactory");
        this.basicKeyCheck("jdk.tls.client.SignatureSchemes");
        this.basicKeyCheck("jdk.tls.namedGroups");
        this.basicKeyCheck("jdk.tls.server.SignatureSchemes");
        this.basicKeyCheck("jdk.virtualThreadScheduler.maxPoolSize");
        this.basicKeyCheck("jdk.virtualThreadScheduler.parallelism");
        this.basicKeyCheck("jdk.xml.cdataChunkSize");
        this.basicKeyCheck("jdk.xml.dtd.support");
        this.basicKeyCheck("jdk.xml.elementAttributeLimit");
        this.basicKeyCheck("jdk.xml.enableExtensionFunctions");
        this.basicKeyCheck("jdk.xml.entityExpansionLimit");
        this.basicKeyCheck("jdk.xml.entityReplacementLimi_t");
        this.basicKeyCheck("jdk.xml.isStandalone");
        this.basicKeyCheck("jdk.xml.jdkcatalog.resolve");
        this.basicKeyCheck("jdk.xml.maxElementDepth");
        this.basicKeyCheck("jdk.xml.maxGeneralEntitySizeLimit");
        this.basicKeyCheck("jdk.xml.maxOccurLimit");
        this.basicKeyCheck("jdk.xml.maxParameterEntitySizeLimit");
        this.basicKeyCheck("jdk.xml.maxXMLNameLimit");
        this.basicKeyCheck("jdk.xml.overrideDefaultParser");
        this.basicKeyCheck("jdk.xml.resetSymbolTable");
        this.basicKeyCheck("jdk.xml.totalEntitySizeLimit");
        this.basicKeyCheck("jdk.xml.xsltcIsStandalone");
        this.basicKeyCheck("line.separator");
        this.basicKeyCheck("native.encoding");
        this.basicKeyCheck("networkaddress.cache.negative.ttl");
        this.basicKeyCheck("networkaddress.cache.stale.ttl");
        this.basicKeyCheck("networkaddress.cache.ttl");
        this.basicKeyCheck("org.jcp.xml.dsig.securevalidation");
        this.basicKeyCheck("org.openjdk.java.util.stream.tripwire");
        this.basicKeyCheck("os.arch");
        this.basicKeyCheck("os.name");
        this.basicKeyCheck("os.version");
        this.basicKeyCheck("path.separator");
        this.basicKeyCheck("socksProxyHost");
        this.basicKeyCheck("socksProxyPort");
        this.basicKeyCheck("socksProxyVersion");
        this.basicKeyCheck("stderr.encoding");
        this.basicKeyCheck("stdout.encoding");
        this.basicKeyCheck("sun.net.httpserver.drainAmount");
        this.basicKeyCheck("sun.net.httpserver.idleInterval");
        this.basicKeyCheck("sun.net.httpserver.maxIdleConnections");
        this.basicKeyCheck("sun.net.httpserver.maxReqHeaders");
        this.basicKeyCheck("sun.net.httpserver.maxReqTime");
        this.basicKeyCheck("sun.net.httpserver.maxRspTime");
        this.basicKeyCheck("sun.net.httpserver.nodelay");
        this.basicKeyCheck("sun.security.krb5.principal");
        this.basicKeyCheck("user.country");
        this.basicKeyCheck("user.dir");
        this.basicKeyCheck("user.extensions");
        this.basicKeyCheck("user.home");
        this.basicKeyCheck("user.language");
        this.basicKeyCheck("user.name");
        this.basicKeyCheck("user.region");
        this.basicKeyCheck("user.script");
        this.basicKeyCheck("user.timezone");
        this.basicKeyCheck("user.variant");
    }

    @Test
    void testGetAwtToolkit() {
        Assertions.assertDoesNotThrow(SystemProperties::getAwtToolkit);
    }

    @Test
    void testGetBoolean() {
        String key = RandomStringUtils.random((int)10);
        String absentKey = RandomStringUtils.random((int)10);
        Assertions.assertNull((Object)System.getProperty(absentKey));
        try {
            System.setProperty(key, Boolean.toString(Boolean.TRUE));
            Assertions.assertEquals((Object)Boolean.TRUE, (Object)SystemProperties.getBoolean((String)key, () -> false));
            Assertions.assertEquals((Object)Boolean.TRUE, (Object)SystemProperties.getBoolean((String)absentKey, () -> Boolean.TRUE));
            Assertions.assertFalse((boolean)SystemProperties.getBoolean((String)absentKey, () -> false));
            Assertions.assertFalse((boolean)SystemProperties.getBoolean((String)absentKey, null));
        }
        finally {
            System.clearProperty(key);
        }
    }

    @Test
    void testGetDoesNotThrow() {
        Assertions.assertDoesNotThrow(SystemProperties::getAppleAwtEnableTemplateImages);
        Assertions.assertDoesNotThrow(SystemProperties::getAwtToolkit);
        Assertions.assertDoesNotThrow(SystemProperties::getComSunJndiLdapObjectTrustSerialData);
        Assertions.assertDoesNotThrow(SystemProperties::getComSunNetHttpServerHttpServerProvider);
        Assertions.assertDoesNotThrow(SystemProperties::getFileEncoding);
        Assertions.assertDoesNotThrow(SystemProperties::getFileSeparator);
        Assertions.assertDoesNotThrow(SystemProperties::getFtpNonProxyHost);
        Assertions.assertDoesNotThrow(SystemProperties::getFtpProxyHost);
        Assertions.assertDoesNotThrow(SystemProperties::getFtpProxyPort);
        Assertions.assertDoesNotThrow(SystemProperties::getHttpAgent);
        Assertions.assertDoesNotThrow(SystemProperties::getHttpAuthDigestCnonceRepeat);
        Assertions.assertDoesNotThrow(SystemProperties::getHttpAuthDigestReenabledAlgorithms);
        Assertions.assertDoesNotThrow(SystemProperties::getHttpAuthDigestValidateProxy);
        Assertions.assertDoesNotThrow(SystemProperties::getHttpAuthDigestValidateServer);
        Assertions.assertDoesNotThrow(SystemProperties::getHttpAuthNtlmDomain);
        Assertions.assertDoesNotThrow(SystemProperties::getHttpKeepAlive);
        Assertions.assertDoesNotThrow(SystemProperties::getHttpKeepAliveTimeProxy);
        Assertions.assertDoesNotThrow(SystemProperties::getHttpKeepAliveTimeServer);
        Assertions.assertDoesNotThrow(SystemProperties::getHttpMaxConnections);
        Assertions.assertDoesNotThrow(SystemProperties::getHttpMaxRedirects);
        Assertions.assertDoesNotThrow(SystemProperties::getHttpNonProxyHosts);
        Assertions.assertDoesNotThrow(SystemProperties::getHttpProxyHost);
        Assertions.assertDoesNotThrow(SystemProperties::getHttpProxyPort);
        Assertions.assertDoesNotThrow(SystemProperties::getHttpsProxyHost);
        Assertions.assertDoesNotThrow(SystemProperties::getHttpsProxyPort);
        Assertions.assertDoesNotThrow(SystemProperties::getJavaAwtFonts);
        Assertions.assertDoesNotThrow(SystemProperties::getJavaAwtGraphicsenv);
        Assertions.assertDoesNotThrow(SystemProperties::getJavaAwtHeadless);
        Assertions.assertDoesNotThrow(SystemProperties::getJavaAwtPrinterjob);
        Assertions.assertDoesNotThrow(SystemProperties::getJavaClassPath);
        Assertions.assertDoesNotThrow(SystemProperties::getJavaClassVersion);
        Assertions.assertDoesNotThrow(SystemProperties::getJavaCompiler);
        Assertions.assertDoesNotThrow(SystemProperties::getJavaContentHandlerPkgs);
        Assertions.assertDoesNotThrow(SystemProperties::getJavaEndorsedDirs);
        Assertions.assertDoesNotThrow(SystemProperties::getJavaExtDirs);
        Assertions.assertDoesNotThrow(SystemProperties::getJavaHome);
        Assertions.assertDoesNotThrow(SystemProperties::getJavaIoTmpdir);
        Assertions.assertDoesNotThrow(SystemProperties::getJavaLibraryPath);
        Assertions.assertDoesNotThrow(SystemProperties::getJavaLocaleProviders);
        Assertions.assertDoesNotThrow(SystemProperties::getJavaLocaleUseOldIsoCodes);
        Assertions.assertDoesNotThrow(SystemProperties::getJavaNetPreferIpv4Stack);
        Assertions.assertDoesNotThrow(SystemProperties::getJavaNetPreferIpv6Addresses);
        Assertions.assertDoesNotThrow(SystemProperties::getJavaNetSocksPassword);
        Assertions.assertDoesNotThrow(SystemProperties::getJavaNetSocksUserName);
        Assertions.assertDoesNotThrow(SystemProperties::getJavaNetUseSystemProxies);
        Assertions.assertDoesNotThrow(SystemProperties::getJavaNioChannelsDefaultThreadPoolInitialSize);
        Assertions.assertDoesNotThrow(SystemProperties::getJavaNioChannelsDefaultThreadPoolThreadFactory);
        Assertions.assertDoesNotThrow(SystemProperties::getJavaNioChannelsSpiAsynchronousChannelProvider);
        Assertions.assertDoesNotThrow(SystemProperties::getJavaNioChannelsSpiSelectorProvider);
        Assertions.assertDoesNotThrow(SystemProperties::getJavaNioFileSpiDefaultFileSystemProvider);
        Assertions.assertDoesNotThrow(SystemProperties::getJavaPropertiesDate);
        Assertions.assertDoesNotThrow(SystemProperties::getJavaProtocolHandlerPkgs);
        Assertions.assertDoesNotThrow(SystemProperties::getJavaRmiServerCodebase);
        Assertions.assertDoesNotThrow(SystemProperties::getJavaRmiServerHostName);
        Assertions.assertDoesNotThrow(SystemProperties::getJavaRmiServerRandomIds);
        Assertions.assertDoesNotThrow(SystemProperties::getJavaRmiServerRmiClassLoaderSpi);
        Assertions.assertDoesNotThrow(SystemProperties::getJavaRuntimeName);
        Assertions.assertDoesNotThrow(SystemProperties::getJavaRuntimeVersion);
        Assertions.assertDoesNotThrow(SystemProperties::getJavaSecurityAuthLoginConfig);
        Assertions.assertDoesNotThrow(SystemProperties::getJavaSecurityManager);
        Assertions.assertDoesNotThrow(SystemProperties::getJavaSpecificationMaintenanceVersion);
        Assertions.assertDoesNotThrow(SystemProperties::getJavaSpecificationName);
        Assertions.assertDoesNotThrow(SystemProperties::getJavaSpecificationVendor);
        Assertions.assertDoesNotThrow(SystemProperties::getJavaSpecificationVersion);
        Assertions.assertDoesNotThrow(SystemProperties::getJavaSystemClassLoader);
        Assertions.assertDoesNotThrow(SystemProperties::getJavaTimeZoneDefaultZoneRulesProvider);
        Assertions.assertDoesNotThrow(SystemProperties::getJavaUtilConcurrentForkJoinPoolCommonExceptionHandler);
        Assertions.assertDoesNotThrow(SystemProperties::getJavaUtilConcurrentForkJoinPoolCommonMaximumSpares);
        Assertions.assertDoesNotThrow(SystemProperties::getJavaUtilConcurrentForkJoinPoolCommonParallelism);
        Assertions.assertDoesNotThrow(SystemProperties::getJavaUtilConcurrentForkJoinPoolCommonThreadFactory);
        Assertions.assertDoesNotThrow(SystemProperties::getJavaUtilCurrencyData);
        Assertions.assertDoesNotThrow(SystemProperties::getJavaUtilLoggingConfigClass);
        Assertions.assertDoesNotThrow(SystemProperties::getJavaUtilLoggingConfigFile);
        Assertions.assertDoesNotThrow(SystemProperties::getJavaUtilLoggingSimpleFormatterFormat);
        Assertions.assertDoesNotThrow(SystemProperties::getJavaUtilPrefsPreferencesFactory);
        Assertions.assertDoesNotThrow(SystemProperties::getJavaUtilPropertyResourceBundleEncoding);
        Assertions.assertDoesNotThrow(SystemProperties::getJavaVendor);
        Assertions.assertDoesNotThrow(SystemProperties::getJavaVendorUrl);
        Assertions.assertDoesNotThrow(SystemProperties::getJavaVendorVersion);
        Assertions.assertDoesNotThrow(SystemProperties::getJavaVersion);
        Assertions.assertDoesNotThrow(SystemProperties::getJavaVersionDate);
        Assertions.assertDoesNotThrow(SystemProperties::getJavaVmInfo);
        Assertions.assertDoesNotThrow(SystemProperties::getJavaVmName);
        Assertions.assertDoesNotThrow(SystemProperties::getJavaVmSpecificationName);
        Assertions.assertDoesNotThrow(SystemProperties::getJavaVmSpecificationVendor);
        Assertions.assertDoesNotThrow(SystemProperties::getJavaVmSpecificationVersion);
        Assertions.assertDoesNotThrow(SystemProperties::getJavaVmVendor);
        Assertions.assertDoesNotThrow(SystemProperties::getJavaVmVersion);
        Assertions.assertDoesNotThrow(SystemProperties::getJavaxAccessibilityAssistiveTechnologies);
        Assertions.assertDoesNotThrow(SystemProperties::getJavaXmlConfigFile);
        Assertions.assertDoesNotThrow(SystemProperties::getJavaxNetSslSessionCacheSize);
        Assertions.assertDoesNotThrow(SystemProperties::getJavaxRmiSslClientEnabledCipherSuites);
        Assertions.assertDoesNotThrow(SystemProperties::getJavaxRmiSslClientEnabledProtocols);
        Assertions.assertDoesNotThrow(SystemProperties::getJavaxSecurityAuthUseSubjectCredsOnly);
        Assertions.assertDoesNotThrow(SystemProperties::getJavaxSmartCardIoTerminalFactoryDefaultType);
        Assertions.assertDoesNotThrow(SystemProperties::getJdbcDrivers);
        Assertions.assertDoesNotThrow(SystemProperties::getJdkHttpAuthProxyingDisabledSchemes);
        Assertions.assertDoesNotThrow(SystemProperties::getJdkHttpAuthTunnelingDisabledSchemes);
        Assertions.assertDoesNotThrow(SystemProperties::getJdkHttpClientAllowRestrictedHeaders);
        Assertions.assertDoesNotThrow(SystemProperties::getJdkHttpClientAuthRetryLimit);
        Assertions.assertDoesNotThrow(SystemProperties::getJdkHttpClientBufSize);
        Assertions.assertDoesNotThrow(SystemProperties::getJdkHttpClientConnectionPoolSize);
        Assertions.assertDoesNotThrow(SystemProperties::getJdkHttpClientConnectionWindowSize);
        Assertions.assertDoesNotThrow(SystemProperties::getJdkHttpClientDisableRetryConnect);
        Assertions.assertDoesNotThrow(SystemProperties::getJdkHttpClientEnableAllMethodRetry);
        Assertions.assertDoesNotThrow(SystemProperties::getJdkHttpClientEnablePush);
        Assertions.assertDoesNotThrow(SystemProperties::getJdkHttpClientHpackMaxHeaderTableSize);
        Assertions.assertDoesNotThrow(SystemProperties::getJdkHttpClientHttpClientLog);
        Assertions.assertDoesNotThrow(SystemProperties::getJdkHttpClientKeepAliveTimeout);
        Assertions.assertDoesNotThrow(SystemProperties::getJdkHttpClientKeepAliveTimeoutH2);
        Assertions.assertDoesNotThrow(SystemProperties::getJdkHttpClientMaxFrameSize);
        Assertions.assertDoesNotThrow(SystemProperties::getJdkHttpClientMaxStreams);
        Assertions.assertDoesNotThrow(SystemProperties::getJdkHttpClientReceiveBufferSize);
        Assertions.assertDoesNotThrow(SystemProperties::getJdkHttpClientRedirectsRetryLimit);
        Assertions.assertDoesNotThrow(SystemProperties::getJdkHttpClientSendBufferSize);
        Assertions.assertDoesNotThrow(SystemProperties::getJdkHttpClientWebSocketWriteBufferSize);
        Assertions.assertDoesNotThrow(SystemProperties::getJdkHttpClientWindowSize);
        Assertions.assertDoesNotThrow(SystemProperties::getJdkHttpServerMaxConnections);
        Assertions.assertDoesNotThrow(SystemProperties::getJdkHttpsNegotiateCbt);
        Assertions.assertDoesNotThrow(SystemProperties::getJdkIncludeInExceptions);
        Assertions.assertDoesNotThrow(SystemProperties::getJdkInternalHttpClientDisableHostNameVerification);
        Assertions.assertDoesNotThrow(SystemProperties::getJdkIoPermissionsUseCanonicalPath);
        Assertions.assertDoesNotThrow(SystemProperties::getJdkJndiLdapObjectFactoriesFilter);
        Assertions.assertDoesNotThrow(SystemProperties::getJdkJndiObjectFactoriesFilter);
        Assertions.assertDoesNotThrow(SystemProperties::getJdkJndiRmiObjectFactoriesFilter);
        Assertions.assertDoesNotThrow(SystemProperties::getJdkModuleMain);
        Assertions.assertDoesNotThrow(SystemProperties::getJdkModuleMainClass);
        Assertions.assertDoesNotThrow(SystemProperties::getJdkModulePath);
        Assertions.assertDoesNotThrow(SystemProperties::getJdkModuleUpgradePath);
        Assertions.assertDoesNotThrow(SystemProperties::getJdkNetUnixDomainTmpDir);
        Assertions.assertDoesNotThrow(SystemProperties::getJdkNetUrlClassPathShowIgnoredClassPathEntries);
        Assertions.assertDoesNotThrow(SystemProperties::getJdkSerialFilter);
        Assertions.assertDoesNotThrow(SystemProperties::getJdkSerialFilterFactory);
        Assertions.assertDoesNotThrow(SystemProperties::getJdkTlsClientSignatureSchemes);
        Assertions.assertDoesNotThrow(SystemProperties::getJdkTlsNamedGroups);
        Assertions.assertDoesNotThrow(SystemProperties::getJdkTlsServerSignatureSchemes);
        Assertions.assertDoesNotThrow(SystemProperties::getJdkVirtualThreadSchedulerMaxPoolSize);
        Assertions.assertDoesNotThrow(SystemProperties::getJdkVirtualThreadSchedulerParallelism);
        Assertions.assertDoesNotThrow(SystemProperties::getJdkXmlCdataChunkSize);
        Assertions.assertDoesNotThrow(SystemProperties::getJdkXmlDtdSupport);
        Assertions.assertDoesNotThrow(SystemProperties::getJdkXmlElementAttributeLimit);
        Assertions.assertDoesNotThrow(SystemProperties::getJdkXmlEnableExtensionFunctions);
        Assertions.assertDoesNotThrow(SystemProperties::getJdkXmlEntityExpansionLimit);
        Assertions.assertDoesNotThrow(SystemProperties::getJdkXmlEntityReplacementLimit);
        Assertions.assertDoesNotThrow(SystemProperties::getJdkXmlIsStandalone);
        Assertions.assertDoesNotThrow(SystemProperties::getJdkXmlJdkCatalogResolve);
        Assertions.assertDoesNotThrow(SystemProperties::getJdkXmlMaxElementDepth);
        Assertions.assertDoesNotThrow(SystemProperties::getJdkXmlMaxGeneralEntitySizeLimit);
        Assertions.assertDoesNotThrow(SystemProperties::getJdkXmlMaxOccurLimit);
        Assertions.assertDoesNotThrow(SystemProperties::getJdkXmlMaxParameterEntitySizeLimit);
        Assertions.assertDoesNotThrow(SystemProperties::getJdkXmlMaxXmlNameLimit);
        Assertions.assertDoesNotThrow(SystemProperties::getJdkXmlOverrideDefaultParser);
        Assertions.assertDoesNotThrow(SystemProperties::getJdkXmlResetSymbolTable);
        Assertions.assertDoesNotThrow(SystemProperties::getJdkXmlTotalEntitySizeLimit);
        Assertions.assertDoesNotThrow(SystemProperties::getJdkXmlXsltcIsStandalone);
        Assertions.assertDoesNotThrow(SystemProperties::getLineSeparator);
        Assertions.assertDoesNotThrow(SystemProperties::getNativeEncoding);
        Assertions.assertDoesNotThrow(SystemProperties::getNetworkAddressCacheNegativeTtl);
        Assertions.assertDoesNotThrow(SystemProperties::getNetworkAddressCacheStaleTtl);
        Assertions.assertDoesNotThrow(SystemProperties::getNetworkAddressCacheTtl);
        Assertions.assertDoesNotThrow(SystemProperties::getOrgJcpXmlDsigSecureValidation);
        Assertions.assertDoesNotThrow(SystemProperties::getOrgOpenJdkJavaUtilStreamTripwire);
        Assertions.assertDoesNotThrow(SystemProperties::getOsArch);
        Assertions.assertDoesNotThrow(SystemProperties::getOsName);
        Assertions.assertDoesNotThrow(SystemProperties::getOsVersion);
        Assertions.assertDoesNotThrow(SystemProperties::getPathSeparator);
        Assertions.assertDoesNotThrow(SystemProperties::getSocksProxyHost);
        Assertions.assertDoesNotThrow(SystemProperties::getSocksProxyPort);
        Assertions.assertDoesNotThrow(SystemProperties::getSocksProxyVersion);
        Assertions.assertDoesNotThrow(SystemProperties::getStdErrEncoding);
        Assertions.assertDoesNotThrow(SystemProperties::getStdOutEncoding);
        Assertions.assertDoesNotThrow(SystemProperties::getSunNetHttpServerDrainAmount);
        Assertions.assertDoesNotThrow(SystemProperties::getSunNetHttpServerIdleInterval);
        Assertions.assertDoesNotThrow(SystemProperties::getSunNetHttpServerMaxIdleConnections);
        Assertions.assertDoesNotThrow(SystemProperties::getSunNetHttpServerMaxReqHeaders);
        Assertions.assertDoesNotThrow(SystemProperties::getSunNetHttpServerMaxReqTime);
        Assertions.assertDoesNotThrow(SystemProperties::getSunNetHttpServerMaxRspTime);
        Assertions.assertDoesNotThrow(SystemProperties::getSunNetHttpServerNoDelay);
        Assertions.assertDoesNotThrow(SystemProperties::getSunSecurityKrb5Principal);
        Assertions.assertDoesNotThrow(SystemProperties::getUserCountry);
        Assertions.assertDoesNotThrow(SystemProperties::getUserDir);
        Assertions.assertDoesNotThrow(SystemProperties::getUserExtensions);
        Assertions.assertDoesNotThrow(SystemProperties::getUserHome);
        Assertions.assertDoesNotThrow(SystemProperties::getUserLanguage);
        Assertions.assertDoesNotThrow(SystemProperties::getUserName);
        Assertions.assertDoesNotThrow(SystemProperties::getUserRegion);
        Assertions.assertDoesNotThrow(SystemProperties::getUserScript);
        Assertions.assertDoesNotThrow(SystemProperties::getUserTimezone);
        Assertions.assertDoesNotThrow(SystemProperties::getUserVariant);
    }

    @Test
    void testGetFileEncoding() {
        this.basicKeyCheck(SystemProperties.getFileEncoding());
    }

    @Test
    void testGetFileSeparator() {
        Assertions.assertNotNull((Object)SystemProperties.getFileSeparator());
    }

    @Test
    void testGetInt() {
        String key = RandomStringUtils.random((int)10);
        String absentKey = RandomStringUtils.random((int)10);
        Assertions.assertNull((Object)System.getProperty(absentKey));
        try {
            System.setProperty(key, Integer.toString(Integer.MAX_VALUE));
            Assertions.assertEquals((int)Integer.MAX_VALUE, (int)SystemProperties.getInt((String)key, () -> 0));
            Assertions.assertEquals((int)Integer.MAX_VALUE, (int)SystemProperties.getInt((String)absentKey, () -> Integer.MAX_VALUE));
            Assertions.assertEquals((int)0, (int)SystemProperties.getInt((String)absentKey, () -> 0));
            Assertions.assertEquals((int)0, (int)SystemProperties.getInt((String)absentKey, null));
        }
        finally {
            System.clearProperty(key);
        }
    }

    @Test
    void testGetJavaAwtFonts() {
        Assertions.assertNull((Object)SystemProperties.getJavaAwtFonts());
    }

    @Test
    void testGetJavaAwtGraphicsenv() {
        Assertions.assertDoesNotThrow(SystemProperties::getJavaAwtGraphicsenv);
    }

    @Test
    void testGetJavaAwtHeadless() {
        Assertions.assertNull((Object)SystemProperties.getJavaAwtHeadless());
    }

    @Test
    void testGetJavaAwtPrinterjob() {
        Assertions.assertDoesNotThrow(SystemProperties::getJavaAwtPrinterjob);
    }

    @Test
    void testGetJavaClassPath() {
        Assertions.assertNotNull((Object)SystemProperties.getJavaClassPath());
    }

    @Test
    void testGetJavaClassVersion() {
        Assertions.assertNotNull((Object)SystemProperties.getJavaClassVersion());
    }

    @Test
    void testGetJavaCompiler() {
        if (SystemUtils.IS_JAVA_14) {
            Assertions.assertNotNull((Object)SystemProperties.getJavaCompiler());
        }
    }

    @Test
    void testGetJavaEndorsedDirs() {
        if (this.isJava11OrGreater()) {
            Assertions.assertNull((Object)SystemProperties.getJavaEndorsedDirs());
        } else {
            Assertions.assertNotNull((Object)SystemProperties.getJavaExtDirs());
        }
    }

    @Test
    void testGetJavaExtDirs() {
        if (this.isJava11OrGreater()) {
            Assertions.assertNull((Object)SystemProperties.getJavaExtDirs());
        } else {
            Assertions.assertNotNull((Object)SystemProperties.getJavaExtDirs());
        }
    }

    @Test
    void testGetJavaHome() {
        Assertions.assertNotNull((Object)SystemProperties.getJavaHome());
    }

    @Test
    void testGetJavaIoTmpdir() {
        Assertions.assertNotNull((Object)SystemProperties.getJavaIoTmpdir());
    }

    @Test
    void testGetJavaLibraryPath() {
        Assertions.assertNotNull((Object)SystemProperties.getJavaLibraryPath());
    }

    @Test
    void testGetJavaLocaleProviders() {
        Assumptions.assumeTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_9));
        Assertions.assertNull((Object)SystemProperties.getJavaLocaleProviders(), (String)SystemProperties.getJavaVersion());
    }

    @Test
    void testGetJavaRuntimeName() {
        Assertions.assertNotNull((Object)SystemProperties.getJavaRuntimeName());
    }

    @Test
    void testGetJavaRuntimeVersion() {
        Assertions.assertNotNull((Object)SystemProperties.getJavaRuntimeVersion());
    }

    @Test
    void testGetJavaSpecificationName() {
        Assertions.assertNotNull((Object)SystemProperties.getJavaSpecificationName());
    }

    @Test
    void testGetJavaSpecificationVendor() {
        Assertions.assertNotNull((Object)SystemProperties.getJavaSpecificationVendor());
    }

    @Test
    void testGetJavaSpecificationVersion() {
        Assertions.assertNotNull((Object)SystemProperties.getJavaSpecificationVersion());
    }

    @Test
    void testGetJavaSpecificationVersionSupplier() {
        Assertions.assertNotNull((Object)SystemProperties.getJavaSpecificationVersion((String)"99.0"));
    }

    @Test
    void testGetJavaUtilPrefsPreferencesFactory() {
        Assertions.assertNull((Object)SystemProperties.getJavaUtilPrefsPreferencesFactory());
    }

    @Test
    void testGetJavaVendor() {
        Assertions.assertNotNull((Object)SystemProperties.getJavaVendor());
    }

    @Test
    void testGetJavaVendorUrl() {
        Assertions.assertNotNull((Object)SystemProperties.getJavaVendorUrl());
    }

    @Test
    void testGetJavaVersion() {
        Assertions.assertNotNull((Object)SystemProperties.getJavaVersion());
    }

    @Test
    void testGetJavaVmInfo() {
        Assertions.assertNotNull((Object)SystemProperties.getJavaVmInfo());
    }

    @Test
    void testGetJavaVmName() {
        Assertions.assertNotNull((Object)SystemProperties.getJavaVmName());
    }

    @Test
    void testGetJavaVmSpecificationName() {
        Assertions.assertNotNull((Object)SystemProperties.getJavaVmSpecificationName());
    }

    @Test
    void testGetJavaVmSpecificationVendor() {
        Assertions.assertNotNull((Object)SystemProperties.getJavaVmSpecificationVendor());
    }

    @Test
    void testGetJavaVmSpecificationVersion() {
        Assertions.assertNotNull((Object)SystemProperties.getJavaVmSpecificationVersion());
    }

    @Test
    void testGetJavaVmVendor() {
        Assertions.assertNotNull((Object)SystemProperties.getJavaVmVendor());
    }

    @Test
    void testGetJavaVmVersion() {
        Assertions.assertNotNull((Object)SystemProperties.getJavaVmVersion());
    }

    @Test
    void testGetLineSeparator() {
        Assertions.assertNotNull((Object)SystemProperties.getLineSeparator());
        Assertions.assertNotNull((Object)SystemProperties.getLineSeparator(null));
        Assertions.assertNotNull((Object)SystemProperties.getLineSeparator(() -> ""));
        Assertions.assertNotNull((Object)SystemProperties.getLineSeparator(() -> "\n"));
        Assertions.assertNotNull((Object)SystemProperties.getLineSeparator(() -> null));
        Assertions.assertNotNull((Object)SystemProperties.getLineSeparator(null));
    }

    @Test
    void testGetLong() {
        String key = RandomStringUtils.random((int)10);
        String absentKey = RandomStringUtils.random((int)10);
        Assertions.assertNull((Object)System.getProperty(absentKey));
        try {
            System.setProperty(key, Long.toString(Long.MAX_VALUE));
            Assertions.assertEquals((long)Long.MAX_VALUE, (long)SystemProperties.getLong((String)key, () -> 0L));
            Assertions.assertEquals((long)Long.MAX_VALUE, (long)SystemProperties.getLong((String)absentKey, () -> Long.MAX_VALUE));
            Assertions.assertEquals((long)0L, (long)SystemProperties.getLong((String)absentKey, () -> 0L));
            Assertions.assertEquals((long)0L, (long)SystemProperties.getLong((String)absentKey, null));
        }
        finally {
            System.clearProperty(key);
        }
    }

    @Test
    void testGetOsArch() {
        Assertions.assertNotNull((Object)SystemProperties.getOsArch());
    }

    @Test
    void testGetOsName() {
        Assertions.assertNotNull((Object)SystemProperties.getOsName());
    }

    @Test
    void testGetOsVersion() {
        Assertions.assertNotNull((Object)SystemProperties.getOsVersion());
    }

    @Test
    void testGetPathSeparator() {
        Assertions.assertNotNull((Object)SystemProperties.getPathSeparator());
    }

    @Test
    void testGetProperty() {
        Assertions.assertNull((Object)SystemProperties.getProperty(null));
        Assertions.assertNull((Object)SystemProperties.getProperty((String)""));
        Assertions.assertEquals((Object)"value1", (Object)SystemProperties.getProperty((String)KEY_SPACE_1));
        Assertions.assertEquals((Object)"value2", (Object)SystemProperties.getProperty((String)KEY_TAB_1));
    }

    @Test
    void testGetPropertyStringString() {
        Assertions.assertNull((Object)SystemProperties.getProperty(null, (String)StringUtils.NULL));
        Assertions.assertNull((Object)SystemProperties.getProperty((String)"", (String)StringUtils.NULL));
        Assertions.assertEquals((Object)"value1", (Object)SystemProperties.getProperty((String)KEY_SPACE_1, (String)StringUtils.NULL));
        Assertions.assertEquals((Object)"value2", (Object)SystemProperties.getProperty((String)KEY_TAB_1, (String)StringUtils.NULL));
        Assertions.assertEquals((Object)"x", (Object)SystemProperties.getProperty(null, (String)"x"));
        Assertions.assertEquals((Object)"x", (Object)SystemProperties.getProperty((String)"", (String)"x"));
        Assertions.assertEquals((Object)"value1", (Object)SystemProperties.getProperty((String)KEY_SPACE_1, (String)"v"));
        Assertions.assertEquals((Object)"value2", (Object)SystemProperties.getProperty((String)KEY_TAB_1, (String)"v"));
    }

    @Test
    void testGetPropertyStringSupplier() {
        Assertions.assertNull((Object)SystemProperties.getProperty(null, (Supplier)null));
        Assertions.assertNull((Object)SystemProperties.getProperty((String)"", (Supplier)null));
        Assertions.assertEquals((Object)"value1", (Object)SystemProperties.getProperty((String)KEY_SPACE_1, (Supplier)null));
        Assertions.assertEquals((Object)"value2", (Object)SystemProperties.getProperty((String)KEY_TAB_1, (Supplier)null));
        Assertions.assertEquals((Object)"x", (Object)SystemProperties.getProperty(null, () -> "x"));
        Assertions.assertEquals((Object)"x", (Object)SystemProperties.getProperty((String)"", () -> "x"));
        Assertions.assertEquals((Object)"value1", (Object)SystemProperties.getProperty((String)KEY_SPACE_1, () -> "v"));
        Assertions.assertEquals((Object)"value2", (Object)SystemProperties.getProperty((String)KEY_TAB_1, () -> "v"));
    }

    @Test
    void testGetUserCountry() {
        Assertions.assertDoesNotThrow(SystemProperties::getUserCountry);
    }

    @Test
    void testGetUserDir() {
        Assertions.assertNotNull((Object)SystemProperties.getUserDir());
    }

    @Test
    void testGetUserHome() {
        Assertions.assertNotNull((Object)SystemProperties.getUserHome());
    }

    @Test
    void testGetUserLanguage() {
        Assertions.assertNotNull((Object)SystemProperties.getUserLanguage());
    }

    @Test
    void testGetUserName() {
        Assertions.assertNotNull((Object)SystemProperties.getUserName());
        Assertions.assertNotNull((Object)SystemProperties.getUserName((String)""));
        Assertions.assertNotNull((Object)SystemProperties.getUserName((String)"User"));
        Assertions.assertNotNull((Object)SystemProperties.getUserName(null));
    }

    @Test
    void testGetUserTimezone() {
        Assertions.assertDoesNotThrow(SystemProperties::getUserTimezone);
    }

    @ParameterizedTest
    @ValueSource(strings={" ", "\t"})
    void testIsPropertySet(String property) {
        Assertions.assertTrue((boolean)SystemProperties.isPropertySet((String)property));
    }

    @Test
    void testIsPropertySetEdges() {
        Assertions.assertFalse((boolean)SystemProperties.isPropertySet((String)StringUtils.NULL));
        Assertions.assertFalse((boolean)SystemProperties.isPropertySet((String)""));
    }
}

