/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.serialization;

import java.util.regex.Pattern;
import org.apache.commons.io.serialization.RegexpClassNameMatcher;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RegexpClassNameMatcherTest {
    @Test
    public void testNullPatternPattern() {
        Assertions.assertThrows(NullPointerException.class, () -> new RegexpClassNameMatcher((Pattern)null));
    }

    @Test
    public void testNullStringPattern() {
        Assertions.assertThrows(NullPointerException.class, () -> new RegexpClassNameMatcher((String)null));
    }

    @Test
    public void testOrPattern() {
        RegexpClassNameMatcher ca = new RegexpClassNameMatcher("foo.*|bar.*");
        Assertions.assertTrue((boolean)ca.matches("foo.should.match"));
        Assertions.assertTrue((boolean)ca.matches("bar.should.match"));
        Assertions.assertFalse((boolean)ca.matches("zoo.should.not.match"));
    }

    @Test
    public void testSimplePatternFromPattern() {
        RegexpClassNameMatcher ca = new RegexpClassNameMatcher(Pattern.compile("foo.*"));
        Assertions.assertTrue((boolean)ca.matches("foo.should.match"));
        Assertions.assertFalse((boolean)ca.matches("bar.should.not.match"));
    }

    @Test
    public void testSimplePatternFromString() {
        RegexpClassNameMatcher ca = new RegexpClassNameMatcher("foo.*");
        Assertions.assertTrue((boolean)ca.matches("foo.should.match"));
        Assertions.assertFalse((boolean)ca.matches("bar.should.not.match"));
    }
}

