/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.io.output.ProxyOutputStream;
import org.apache.commons.lang3.ArrayUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ProxyOutputStreamTest {
    private ByteArrayOutputStream original;
    private ProxyOutputStream proxied;
    private final AtomicBoolean hit = new AtomicBoolean();

    @BeforeEach
    public void setUp() {
        this.original = new ByteArrayOutputStream(){

            public void write(byte[] ba) {
                ProxyOutputStreamTest.this.hit.set(true);
                super.write(ba);
            }

            public synchronized void write(int ba) {
                ProxyOutputStreamTest.this.hit.set(true);
                super.write(ba);
            }
        };
        this.proxied = new ProxyOutputStream((OutputStream)this.original);
    }

    @Test
    public void testBuilder() throws Exception {
        Assertions.assertSame((Object)this.original, (Object)((ProxyOutputStream.Builder)new ProxyOutputStream.Builder().setOutputStream((OutputStream)this.original)).get().unwrap());
    }

    @Test
    public void testSetReference() throws Exception {
        Assertions.assertFalse((boolean)this.hit.get());
        this.proxied.setReference((OutputStream)new ByteArrayOutputStream());
        this.proxied.write(121);
        Assertions.assertFalse((boolean)this.hit.get());
        Assertions.assertEquals((int)0, (int)this.original.size());
        Assertions.assertArrayEquals((byte[])ArrayUtils.EMPTY_BYTE_ARRAY, (byte[])this.original.toByteArray());
    }

    @Test
    public void testWrite() throws Exception {
        Assertions.assertFalse((boolean)this.hit.get());
        this.proxied.write(121);
        Assertions.assertTrue((boolean)this.hit.get());
        Assertions.assertEquals((int)1, (int)this.original.size());
        Assertions.assertEquals((int)121, (int)this.original.toByteArray()[0]);
    }

    @Test
    public void testWriteNullArrayProxiesToUnderlying() throws Exception {
        Assertions.assertFalse((boolean)this.hit.get());
        byte[] ba = null;
        Assertions.assertThrows(NullPointerException.class, () -> this.original.write(ba));
        Assertions.assertTrue((boolean)this.hit.get());
        Assertions.assertThrows(NullPointerException.class, () -> this.proxied.write(ba));
        Assertions.assertTrue((boolean)this.hit.get());
    }
}

