/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.RandomUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public abstract class AbstractInputStreamTest {
    static final String ARRAY_LENGTHS_NAME = "org.apache.commons.io.input.AbstractInputStreamTest#getArrayLengths";
    static final int[] ARRAY_LENGTHS = new int[]{0, 1, 2, 4, 8, 16, 32, 64, 128};
    protected static byte[] ActualBytes;
    protected static byte[] ExpectedBytes;
    protected static Path InputPath;
    protected InputStream[] inputStreams;
    @TempDir
    static Path tempDir;

    static int[] getArrayLengths() {
        return ARRAY_LENGTHS;
    }

    @BeforeAll
    public static void setUp() throws IOException {
        ActualBytes = RandomUtils.insecure().randomBytes(0x200000);
        ExpectedBytes = (byte[])ActualBytes.clone();
        InputPath = tempDir.resolve(AbstractInputStreamTest.class.getSimpleName() + ".tmp");
        Files.write(InputPath, ActualBytes, new OpenOption[0]);
    }

    @AfterEach
    public void tearDown() throws IOException {
        IOUtils.close((Closeable[])this.inputStreams);
    }

    @Test
    public void testAvailableAfterClose() throws Exception {
        for (InputStream inputStream : this.inputStreams) {
            inputStream.close();
            Assertions.assertEquals((int)0, (int)inputStream.available());
        }
    }

    @Test
    public void testAvailableAfterOpen() throws Exception {
        for (InputStream inputStream : this.inputStreams) {
            Assertions.assertTrue((inputStream.available() >= 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testAvailableAfterRead() throws Exception {
        for (InputStream inputStream : this.inputStreams) {
            Assertions.assertNotEquals((int)-1, (int)inputStream.read());
            Assertions.assertTrue((inputStream.available() > 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testAvailableAtEnd() throws Exception {
        for (InputStream inputStream : this.inputStreams) {
            IOUtils.consume((InputStream)inputStream);
            Assertions.assertEquals((int)0, (int)inputStream.available());
        }
    }

    @Test
    public void testBytesSkipped() throws IOException {
        for (InputStream inputStream : this.inputStreams) {
            Assertions.assertEquals((long)1024L, (long)inputStream.skip(1024L));
            for (int i = 1024; i < ExpectedBytes.length; ++i) {
                Assertions.assertEquals((byte)ExpectedBytes[i], (byte)((byte)inputStream.read()));
            }
        }
    }

    @Test
    public void testBytesSkippedAfterEOF() throws IOException {
        for (InputStream inputStream : this.inputStreams) {
            Assertions.assertEquals((long)ExpectedBytes.length, (long)inputStream.skip(ActualBytes.length + 1));
            Assertions.assertEquals((int)-1, (int)inputStream.read());
        }
    }

    @Test
    public void testBytesSkippedAfterRead() throws IOException {
        for (InputStream inputStream : this.inputStreams) {
            int i;
            for (i = 0; i < 1024; ++i) {
                Assertions.assertEquals((byte)ExpectedBytes[i], (byte)((byte)inputStream.read()));
            }
            Assertions.assertEquals((long)1024L, (long)inputStream.skip(1024L));
            for (i = 2048; i < ExpectedBytes.length; ++i) {
                Assertions.assertEquals((byte)ExpectedBytes[i], (byte)((byte)inputStream.read()));
            }
        }
    }

    @Test
    public void testNegativeBytesSkippedAfterRead() throws IOException {
        for (InputStream inputStream : this.inputStreams) {
            int i;
            for (i = 0; i < 1024; ++i) {
                Assertions.assertEquals((byte)ExpectedBytes[i], (byte)((byte)inputStream.read()));
            }
            Assertions.assertEquals((long)0L, (long)inputStream.skip(-1L));
            Assertions.assertEquals((long)0L, (long)inputStream.skip(-1024L));
            Assertions.assertEquals((long)0L, (long)inputStream.skip(Long.MIN_VALUE));
            Assertions.assertEquals((long)1024L, (long)inputStream.skip(1024L));
            for (i = 2048; i < ExpectedBytes.length; ++i) {
                Assertions.assertEquals((byte)ExpectedBytes[i], (byte)((byte)inputStream.read()));
            }
        }
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.io.input.ReversedLinesFileReaderParamBlockSizeTest#blockSizes"})
    public void testReadMultipleBytes(int bufferSize) throws IOException {
        for (InputStream inputStream : this.inputStreams) {
            byte[] readBytes = new byte[bufferSize];
            int i = 0;
            while (i < ExpectedBytes.length) {
                int read = inputStream.read(readBytes, 0, readBytes.length);
                for (int j = 0; j < read; ++j) {
                    Assertions.assertEquals((byte)ExpectedBytes[i], (byte)readBytes[j]);
                    ++i;
                }
            }
        }
    }

    @Test
    public void testReadOneByOne() throws IOException {
        for (InputStream inputStream : this.inputStreams) {
            for (byte randomByte : ExpectedBytes) {
                Assertions.assertEquals((byte)randomByte, (byte)((byte)inputStream.read()));
            }
        }
    }

    @Test
    public void testReadOneByOneCheckAvailable() throws IOException {
        AtomicInteger refII = new AtomicInteger();
        for (int idxInputs = 0; idxInputs < this.inputStreams.length; ++idxInputs) {
            refII.set(idxInputs);
            AtomicInteger refIB = new AtomicInteger();
            InputStream inputStream = this.inputStreams[idxInputs];
            for (int idxBytes = 0; idxBytes < ExpectedBytes.length; ++idxBytes) {
                refIB.set(idxBytes);
                byte randomByte = ExpectedBytes[idxBytes];
                int available = inputStream.available();
                Supplier<String> messageSupplier = () -> String.format("idxInputs = %,d, idxBytes = %,d, available = %,d", refII.get(), refIB.get(), available);
                Assertions.assertTrue((available >= 0 ? 1 : 0) != 0, messageSupplier);
                Assertions.assertEquals((byte)randomByte, (byte)((byte)inputStream.read()));
            }
        }
    }

    @Test
    public void testReadPastEof() throws IOException {
        InputStream is = this.inputStreams[0];
        byte[] buf = new byte[1024];
        while (is.read(buf, 0, buf.length) != -1) {
        }
        int readAfterEOF = is.read(buf, 0, buf.length);
        Assertions.assertEquals((int)-1, (int)readAfterEOF);
    }

    @Test
    public void testSkipFromFileChannel() throws IOException {
        for (InputStream inputStream : this.inputStreams) {
            int i;
            Assertions.assertEquals((long)1024L, (long)inputStream.skip(1024L));
            for (i = 1024; i < 2048; ++i) {
                Assertions.assertEquals((byte)ExpectedBytes[i], (byte)((byte)inputStream.read()));
            }
            Assertions.assertEquals((long)256L, (long)inputStream.skip(256L));
            Assertions.assertEquals((long)256L, (long)inputStream.skip(256L));
            Assertions.assertEquals((long)512L, (long)inputStream.skip(512L));
            for (i = 3072; i < ExpectedBytes.length; ++i) {
                Assertions.assertEquals((byte)ExpectedBytes[i], (byte)((byte)inputStream.read()));
            }
        }
    }
}

