/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.channels;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.channels.FileChannelProxy;
import org.apache.commons.io.channels.FileChannels;
import org.apache.commons.io.channels.FixedReadSizeFileChannelProxy;
import org.apache.commons.io.channels.NonBlockingFileChannelProxy;
import org.apache.commons.io.file.AbstractTempDirTest;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.junitpioneer.jupiter.cartesian.CartesianTest;

public class FileChannelsTest
extends AbstractTempDirTest {
    private static final int LARGE_FILE_SIZE = Integer.getInteger(FileChannelsTest.class.getSimpleName(), 100000);
    private static final int SMALL_BUFFER_SIZE = 1024;
    private static final String CONTENT = StringUtils.repeat((String)"x", (int)1024);

    private static FileChannel getChannel(FileInputStream inNotEmpty, FileChannelType fileChannelType, int readSize) throws IOException {
        return FileChannelsTest.wrap(inNotEmpty.getChannel(), fileChannelType, readSize);
    }

    private static int half(int bufferSize) {
        return Math.max(1, bufferSize / 2);
    }

    private static boolean isEmpty(File empty) {
        return empty.length() == 0L;
    }

    private static FileChannel open(Path path, FileChannelType fileChannelType, int readSize) throws IOException {
        return FileChannelsTest.wrap(FileChannel.open(path, new OpenOption[0]), fileChannelType, readSize);
    }

    private static FileChannel reset(FileChannel fc) throws IOException {
        return fc.position(0L);
    }

    private static byte reverse(byte b) {
        return (byte)(~b & 0xFF);
    }

    private static FileChannel wrap(FileChannel fc, FileChannelType fileChannelType, int readSize) throws IOException {
        switch (fileChannelType.ordinal()) {
            case 2: {
                return new NonBlockingFileChannelProxy(fc);
            }
            case 0: {
                return fc;
            }
            case 1: {
                return new FileChannelProxy(fc);
            }
            case 3: {
                return new FixedReadSizeFileChannelProxy(fc, readSize);
            }
        }
        throw new UnsupportedOperationException("Unexpected FileChannelType " + (Object)((Object)fileChannelType));
    }

    private boolean contentEquals(InputStream in1, InputStream in2, int bufferCapacity) throws IOException {
        return FileChannels.contentEquals((ReadableByteChannel)Channels.newChannel(in1), (ReadableByteChannel)Channels.newChannel(in2), (int)bufferCapacity);
    }

    private void testContentEquals(String content1, String content2, int bufferSize, FileChannelType fileChannelType) throws IOException {
        FileChannel channel2;
        FileChannel channel1;
        FileInputStream in2;
        Assertions.assertTrue((boolean)FileChannels.contentEquals(null, null, (int)bufferSize));
        File file1 = new File(this.tempDirFile, "test1.txt");
        File file2 = new File(this.tempDirFile, "test2.txt");
        FileUtils.writeStringToFile((File)file1, (String)content1, (Charset)StandardCharsets.US_ASCII);
        FileUtils.writeStringToFile((File)file2, (String)content2, (Charset)StandardCharsets.US_ASCII);
        Assertions.assertNotEquals((long)FileUtils.checksumCRC32((File)file1), (long)FileUtils.checksumCRC32((File)file2));
        try (FileInputStream in1 = new FileInputStream(file1);){
            in2 = new FileInputStream(file2);
            try {
                channel1 = FileChannelsTest.getChannel(in1, fileChannelType, bufferSize);
                try {
                    channel2 = FileChannelsTest.getChannel(in2, fileChannelType, FileChannelsTest.half(bufferSize));
                    try {
                        Assertions.assertFalse((boolean)FileChannels.contentEquals((FileChannel)channel1, (FileChannel)channel2, (int)bufferSize));
                    }
                    finally {
                        if (channel2 != null) {
                            channel2.close();
                        }
                    }
                }
                finally {
                    if (channel1 != null) {
                        channel1.close();
                    }
                }
            }
            finally {
                in2.close();
            }
        }
        in1 = new FileInputStream(file1);
        try {
            in2 = new FileInputStream(file2);
            try {
                channel1 = FileChannelsTest.getChannel(in1, fileChannelType, bufferSize);
                try {
                    channel2 = FileChannelsTest.getChannel(in2, fileChannelType, FileChannelsTest.half(bufferSize));
                    try {
                        Assertions.assertTrue((boolean)FileChannels.contentEquals((FileChannel)channel1, (FileChannel)channel1, (int)bufferSize));
                        Assertions.assertTrue((boolean)FileChannels.contentEquals((FileChannel)channel2, (FileChannel)channel2, (int)bufferSize));
                    }
                    finally {
                        if (channel2 != null) {
                            channel2.close();
                        }
                    }
                }
                finally {
                    if (channel1 != null) {
                        channel1.close();
                    }
                }
            }
            finally {
                in2.close();
            }
        }
        finally {
            in1.close();
        }
    }

    @CartesianTest
    public void testContentEqualsDifferentPostfix(@CartesianTest.Values(ints={1, 2, 819, 8192, 81920}) int bufferSize, @CartesianTest.Enum FileChannelType fileChannelType) throws IOException {
        this.testContentEquals(CONTENT + "ABC", CONTENT + "XYZ", bufferSize, fileChannelType);
    }

    @CartesianTest
    public void testContentEqualsDifferentPrefix(@CartesianTest.Values(ints={1, 2, 819, 8192, 81920}) int bufferSize, @CartesianTest.Enum FileChannelType fileChannelType) throws IOException {
        this.testContentEquals("ABC" + CONTENT, "XYZ" + CONTENT, bufferSize, fileChannelType);
    }

    @CartesianTest
    public void testContentEqualsEmpty(@CartesianTest.Values(ints={1, 2, 819, 8192, 81920}) int bufferSize, @CartesianTest.Enum FileChannelType fileChannelType) throws IOException {
        Assertions.assertTrue((boolean)FileChannels.contentEquals(null, null, (int)bufferSize));
        File empty = new File(this.tempDirFile, "empty.txt");
        File notEmpty = new File(this.tempDirFile, "not-empty.txt");
        FileUtils.writeStringToFile((File)empty, (String)"", (Charset)StandardCharsets.US_ASCII);
        FileUtils.writeStringToFile((File)notEmpty, (String)"X", (Charset)StandardCharsets.US_ASCII);
        Assertions.assertTrue((boolean)FileChannelsTest.isEmpty(empty));
        Assertions.assertFalse((boolean)FileChannelsTest.isEmpty(notEmpty));
        Assertions.assertNotEquals((long)FileUtils.checksumCRC32((File)empty), (long)FileUtils.checksumCRC32((File)notEmpty));
        try (FileInputStream inEmpty = new FileInputStream(empty);
             FileInputStream inNotEmpty = new FileInputStream(notEmpty);
             FileChannel channelEmpty = FileChannelsTest.getChannel(inEmpty, fileChannelType, bufferSize);
             FileChannel channelNotEmpty = FileChannelsTest.getChannel(inNotEmpty, fileChannelType, FileChannelsTest.half(bufferSize));){
            Assertions.assertFalse((boolean)FileChannels.contentEquals((FileChannel)channelEmpty, (FileChannel)channelNotEmpty, (int)bufferSize));
            Assertions.assertFalse((boolean)FileChannels.contentEquals(null, (FileChannel)channelNotEmpty, (int)bufferSize));
            Assertions.assertFalse((boolean)FileChannels.contentEquals((FileChannel)channelNotEmpty, null, (int)bufferSize));
            Assertions.assertTrue((boolean)FileChannels.contentEquals((FileChannel)channelEmpty, (FileChannel)channelEmpty, (int)bufferSize));
            Assertions.assertTrue((boolean)FileChannels.contentEquals(null, (FileChannel)channelEmpty, (int)bufferSize));
            Assertions.assertTrue((boolean)FileChannels.contentEquals((FileChannel)channelEmpty, null, (int)bufferSize));
            Assertions.assertTrue((boolean)FileChannels.contentEquals((FileChannel)channelNotEmpty, (FileChannel)channelNotEmpty, (int)bufferSize));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CartesianTest
    public void testContentEqualsFileChannel(@CartesianTest.Values(ints={1, 2, 819, 8192, 81920}) int bufferSize) throws IOException {
        FileChannelType fileChannelType = FileChannelType.STOCK;
        Path bigFile1 = Files.createTempFile(this.getClass().getSimpleName(), "-1.bin", new FileAttribute[0]);
        Path bigFile2 = Files.createTempFile(this.getClass().getSimpleName(), "-2.bin", new FileAttribute[0]);
        Path bigFile3 = Files.createTempFile(this.getClass().getSimpleName(), "-3.bin", new FileAttribute[0]);
        try {
            FileChannel fc3;
            int newLength = LARGE_FILE_SIZE;
            byte[] bytes1 = new byte[newLength];
            byte[] bytes2 = new byte[newLength];
            ArrayUtils.shuffle((byte[])bytes1);
            bytes1[0] = 1;
            ArrayUtils.shuffle((byte[])bytes2);
            bytes2[0] = 2;
            Files.write(bigFile1, bytes1, new OpenOption[0]);
            Files.write(bigFile2, bytes2, new OpenOption[0]);
            try (FileChannel fc1 = FileChannelsTest.open(bigFile1, fileChannelType, bufferSize);
                 FileChannel fc2 = FileChannelsTest.open(bigFile2, fileChannelType, FileChannelsTest.half(bufferSize));){
                Assertions.assertFalse((boolean)FileChannels.contentEquals((FileChannel)fc1, (FileChannel)fc2, (int)bufferSize));
                Assertions.assertFalse((boolean)FileChannels.contentEquals((FileChannel)FileChannelsTest.reset(fc2), (FileChannel)FileChannelsTest.reset(fc1), (int)bufferSize));
                Assertions.assertTrue((boolean)FileChannels.contentEquals((FileChannel)FileChannelsTest.reset(fc1), (FileChannel)FileChannelsTest.reset(fc1), (int)bufferSize));
            }
            byte[] bytes3 = (byte[])bytes1.clone();
            int last = bytes3.length - 1;
            bytes3[last] = FileChannelsTest.reverse(bytes3[last]);
            Files.write(bigFile3, bytes3, new OpenOption[0]);
            try (FileChannel fc1 = FileChannelsTest.open(bigFile1, fileChannelType, bufferSize);){
                fc3 = FileChannelsTest.open(bigFile3, fileChannelType, FileChannelsTest.half(bufferSize));
                try {
                    Assertions.assertFalse((boolean)FileChannels.contentEquals((FileChannel)fc1, (FileChannel)fc3, (int)bufferSize));
                    Assertions.assertFalse((boolean)FileChannels.contentEquals((FileChannel)FileChannelsTest.reset(fc3), (FileChannel)FileChannelsTest.reset(fc1), (int)bufferSize));
                    fc1.position(last);
                    fc3.position(last);
                    Assertions.assertFalse((boolean)FileChannels.contentEquals((FileChannel)fc1, (FileChannel)fc3, (int)bufferSize));
                }
                finally {
                    if (fc3 != null) {
                        fc3.close();
                    }
                }
            }
            bytes3 = (byte[])bytes1.clone();
            Files.write(bigFile3, bytes3, new OpenOption[0]);
            fc1 = FileChannelsTest.open(bigFile1, fileChannelType, bufferSize);
            try {
                fc3 = FileChannelsTest.open(bigFile3, fileChannelType, FileChannelsTest.half(bufferSize));
                try {
                    fc1.position(last);
                    fc3.position(last);
                    Assertions.assertTrue((boolean)FileChannels.contentEquals((FileChannel)fc1, (FileChannel)fc3, (int)bufferSize));
                }
                finally {
                    if (fc3 != null) {
                        fc3.close();
                    }
                }
            }
            finally {
                if (fc1 != null) {
                    fc1.close();
                }
            }
            bytes3 = (byte[])bytes1.clone();
            int middle = bytes3.length / 2;
            bytes3[middle] = FileChannelsTest.reverse(bytes3[middle]);
            Files.write(bigFile3, bytes3, new OpenOption[0]);
            try (FileChannel fc1 = FileChannelsTest.open(bigFile1, fileChannelType, bufferSize);
                 FileChannel fc32 = FileChannelsTest.open(bigFile3, fileChannelType, FileChannelsTest.half(bufferSize));){
                Assertions.assertFalse((boolean)FileChannels.contentEquals((FileChannel)fc1, (FileChannel)fc32, (int)bufferSize));
                Assertions.assertFalse((boolean)FileChannels.contentEquals((FileChannel)FileChannelsTest.reset(fc32), (FileChannel)FileChannelsTest.reset(fc1), (int)bufferSize));
            }
        }
        finally {
            Files.deleteIfExists(bigFile1);
            Files.deleteIfExists(bigFile2);
            Files.deleteIfExists(bigFile3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CartesianTest
    public void testContentEqualsSeekableByteChannel(@CartesianTest.Values(ints={1, 2, 819, 8192, 81920}) int bufferSize, @CartesianTest.Enum FileChannelType fileChannelType1, @CartesianTest.Enum FileChannelType fileChannelType2) throws IOException {
        Path bigFile1 = Files.createTempFile(this.getClass().getSimpleName(), "-1.bin", new FileAttribute[0]);
        Path bigFile2 = Files.createTempFile(this.getClass().getSimpleName(), "-2.bin", new FileAttribute[0]);
        Path bigFile3 = Files.createTempFile(this.getClass().getSimpleName(), "-3.bin", new FileAttribute[0]);
        try {
            FileChannel fc3;
            int newLength = LARGE_FILE_SIZE;
            byte[] bytes1 = new byte[newLength];
            byte[] bytes2 = new byte[newLength];
            ArrayUtils.shuffle((byte[])bytes1);
            bytes1[0] = 1;
            ArrayUtils.shuffle((byte[])bytes2);
            bytes2[0] = 2;
            Files.write(bigFile1, bytes1, new OpenOption[0]);
            Files.write(bigFile2, bytes2, new OpenOption[0]);
            try (FileChannel fc1 = FileChannelsTest.open(bigFile1, fileChannelType1, bufferSize);
                 FileChannel fc2 = FileChannelsTest.open(bigFile2, fileChannelType2, FileChannelsTest.half(bufferSize));){
                Assertions.assertFalse((boolean)FileChannels.contentEquals((SeekableByteChannel)fc1, (SeekableByteChannel)fc2, (int)bufferSize));
                Assertions.assertFalse((boolean)FileChannels.contentEquals((SeekableByteChannel)FileChannelsTest.reset(fc2), (SeekableByteChannel)FileChannelsTest.reset(fc1), (int)bufferSize));
                Assertions.assertTrue((boolean)FileChannels.contentEquals((SeekableByteChannel)FileChannelsTest.reset(fc1), (SeekableByteChannel)FileChannelsTest.reset(fc1), (int)bufferSize));
            }
            byte[] bytes3 = (byte[])bytes1.clone();
            int last = bytes3.length - 1;
            bytes3[last] = FileChannelsTest.reverse(bytes3[last]);
            Files.write(bigFile3, bytes3, new OpenOption[0]);
            try (FileChannel fc1 = FileChannelsTest.open(bigFile1, fileChannelType1, bufferSize);){
                fc3 = FileChannelsTest.open(bigFile3, fileChannelType2, FileChannelsTest.half(bufferSize));
                try {
                    Assertions.assertFalse((boolean)FileChannels.contentEquals((SeekableByteChannel)fc1, (SeekableByteChannel)fc3, (int)bufferSize));
                    Assertions.assertFalse((boolean)FileChannels.contentEquals((SeekableByteChannel)FileChannelsTest.reset(fc3), (SeekableByteChannel)FileChannelsTest.reset(fc1), (int)bufferSize));
                    fc1.position(last);
                    fc3.position(last);
                    Assertions.assertFalse((boolean)FileChannels.contentEquals((SeekableByteChannel)fc1, (SeekableByteChannel)fc3, (int)bufferSize));
                }
                finally {
                    if (fc3 != null) {
                        fc3.close();
                    }
                }
            }
            bytes3 = (byte[])bytes1.clone();
            Files.write(bigFile3, bytes3, new OpenOption[0]);
            fc1 = FileChannelsTest.open(bigFile1, fileChannelType1, bufferSize);
            try {
                fc3 = FileChannelsTest.open(bigFile3, fileChannelType2, FileChannelsTest.half(bufferSize));
                try {
                    fc1.position(last);
                    fc3.position(last);
                    Assertions.assertTrue((boolean)FileChannels.contentEquals((SeekableByteChannel)fc1, (SeekableByteChannel)fc3, (int)bufferSize));
                }
                finally {
                    if (fc3 != null) {
                        fc3.close();
                    }
                }
            }
            finally {
                if (fc1 != null) {
                    fc1.close();
                }
            }
            bytes3 = (byte[])bytes1.clone();
            int middle = bytes3.length / 2;
            bytes3[middle] = FileChannelsTest.reverse(bytes3[middle]);
            Files.write(bigFile3, bytes3, new OpenOption[0]);
            try (FileChannel fc1 = FileChannelsTest.open(bigFile1, fileChannelType1, bufferSize);
                 FileChannel fc32 = FileChannelsTest.open(bigFile3, fileChannelType2, FileChannelsTest.half(bufferSize));){
                Assertions.assertFalse((boolean)FileChannels.contentEquals((SeekableByteChannel)fc1, (SeekableByteChannel)fc32, (int)bufferSize));
                Assertions.assertFalse((boolean)FileChannels.contentEquals((SeekableByteChannel)FileChannelsTest.reset(fc32), (SeekableByteChannel)FileChannelsTest.reset(fc1), (int)bufferSize));
            }
        }
        finally {
            Files.deleteIfExists(bigFile1);
            Files.deleteIfExists(bigFile2);
            Files.deleteIfExists(bigFile3);
        }
    }

    @ParameterizedTest
    @ValueSource(ints={1, 2, 4, 8, 16, 1024, 4096, 8192})
    public void testContentEqualsSequenceInputStream(int bufferCapacity) throws Exception {
        Assertions.assertFalse((boolean)this.contentEquals(new ByteArrayInputStream("ab".getBytes()), new SequenceInputStream(new ByteArrayInputStream("a".getBytes()), new ByteArrayInputStream("b-".getBytes())), bufferCapacity));
        Assertions.assertFalse((boolean)this.contentEquals(new ByteArrayInputStream("ab".getBytes()), new SequenceInputStream(new ByteArrayInputStream("a-".getBytes()), new ByteArrayInputStream("b".getBytes())), bufferCapacity));
        Assertions.assertFalse((boolean)this.contentEquals(new ByteArrayInputStream("ab-".getBytes()), new SequenceInputStream(new ByteArrayInputStream("a".getBytes()), new ByteArrayInputStream("b".getBytes())), bufferCapacity));
        Assertions.assertFalse((boolean)this.contentEquals(new ByteArrayInputStream("".getBytes()), new SequenceInputStream(new ByteArrayInputStream("a".getBytes()), new ByteArrayInputStream("b".getBytes())), bufferCapacity));
        Assertions.assertFalse((boolean)this.contentEquals(new ByteArrayInputStream("".getBytes()), new SequenceInputStream(new ByteArrayInputStream("".getBytes()), new ByteArrayInputStream("b".getBytes())), bufferCapacity));
        Assertions.assertFalse((boolean)this.contentEquals(new ByteArrayInputStream("ab".getBytes()), new SequenceInputStream(new ByteArrayInputStream("".getBytes()), new ByteArrayInputStream("".getBytes())), bufferCapacity));
        Assertions.assertTrue((boolean)this.contentEquals(new ByteArrayInputStream("".getBytes()), new SequenceInputStream(new ByteArrayInputStream("".getBytes()), new ByteArrayInputStream("".getBytes())), bufferCapacity));
        Assertions.assertTrue((boolean)this.contentEquals(new ByteArrayInputStream("ab".getBytes()), new SequenceInputStream(new ByteArrayInputStream("a".getBytes()), new ByteArrayInputStream("b".getBytes())), bufferCapacity));
        Assertions.assertTrue((boolean)this.contentEquals(new ByteArrayInputStream("ab".getBytes()), new SequenceInputStream(new ByteArrayInputStream("ab".getBytes()), new ByteArrayInputStream("".getBytes())), bufferCapacity));
        Assertions.assertTrue((boolean)this.contentEquals(new ByteArrayInputStream("ab".getBytes()), new SequenceInputStream(new ByteArrayInputStream("".getBytes()), new ByteArrayInputStream("ab".getBytes())), bufferCapacity));
    }

    static enum FileChannelType {
        STOCK,
        PROXY,
        NON_BLOCKING,
        FIXED_READ_SIZE;

    }
}

