/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.File;
import java.util.Locale;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FilenameUtilsWildcardTest {
    private static final boolean WINDOWS = File.separatorChar == '\\';

    private void assertMatch(String text, String wildcard, boolean expected) {
        Assertions.assertEquals((Object)expected, (Object)FilenameUtils.wildcardMatch((String)text, (String)wildcard), (String)(text + " " + wildcard));
    }

    @Test
    public void test_IO_246() {
        this.assertMatch("aaa", "aa*?", true);
        this.assertMatch("", "?*", false);
        this.assertMatch("a", "a?*", false);
        this.assertMatch("aa", "aa?*", false);
        this.assertMatch("a", "?*", true);
        this.assertMatch("aa", "?*", true);
        this.assertMatch("aaa", "?*", true);
        this.assertMatch("", "?", false);
        this.assertMatch("a", "a?", false);
        this.assertMatch("aa", "aa?", false);
        this.assertMatch("aab", "aa?", true);
        this.assertMatch("aaa", "*a", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLocaleIndependence() {
        Locale orig = Locale.getDefault();
        Locale[] locales = Locale.getAvailableLocales();
        String[][] data = new String[][]{{"I", "i"}, {"i", "I"}, {"i", "\u0130"}, {"i", "\u0131"}, {"\u03a3", "\u03c2"}, {"\u03a3", "\u03c3"}, {"\u03c2", "\u03c3"}};
        try {
            for (int i = 0; i < data.length; ++i) {
                for (Locale locale : locales) {
                    Locale.setDefault(locale);
                    Assertions.assertTrue((boolean)data[i][0].equalsIgnoreCase(data[i][1]), (String)("Test data corrupt: " + i));
                    boolean match = FilenameUtils.wildcardMatch((String)data[i][0], (String)data[i][1], (IOCase)IOCase.INSENSITIVE);
                    Assertions.assertTrue((boolean)match, (String)(Locale.getDefault().toString() + ": " + i));
                }
            }
        }
        finally {
            Locale.setDefault(orig);
        }
    }

    @Test
    public void testMatch() {
        Assertions.assertFalse((boolean)FilenameUtils.wildcardMatch(null, (String)"Foo"));
        Assertions.assertFalse((boolean)FilenameUtils.wildcardMatch((String)"Foo", null));
        Assertions.assertTrue((boolean)FilenameUtils.wildcardMatch(null, null));
        Assertions.assertTrue((boolean)FilenameUtils.wildcardMatch((String)"Foo", (String)"Foo"));
        Assertions.assertTrue((boolean)FilenameUtils.wildcardMatch((String)"", (String)""));
        Assertions.assertTrue((boolean)FilenameUtils.wildcardMatch((String)"", (String)"*"));
        Assertions.assertFalse((boolean)FilenameUtils.wildcardMatch((String)"", (String)"?"));
        Assertions.assertTrue((boolean)FilenameUtils.wildcardMatch((String)"Foo", (String)"Fo*"));
        Assertions.assertTrue((boolean)FilenameUtils.wildcardMatch((String)"Foo", (String)"Fo?"));
        Assertions.assertTrue((boolean)FilenameUtils.wildcardMatch((String)"Foo Bar and Catflap", (String)"Fo*"));
        Assertions.assertTrue((boolean)FilenameUtils.wildcardMatch((String)"New Bookmarks", (String)"N?w ?o?k??r?s"));
        Assertions.assertFalse((boolean)FilenameUtils.wildcardMatch((String)"Foo", (String)"Bar"));
        Assertions.assertTrue((boolean)FilenameUtils.wildcardMatch((String)"Foo Bar Foo", (String)"F*o Bar*"));
        Assertions.assertTrue((boolean)FilenameUtils.wildcardMatch((String)"Adobe Acrobat Installer", (String)"Ad*er"));
        Assertions.assertTrue((boolean)FilenameUtils.wildcardMatch((String)"Foo", (String)"*Foo"));
        Assertions.assertTrue((boolean)FilenameUtils.wildcardMatch((String)"BarFoo", (String)"*Foo"));
        Assertions.assertTrue((boolean)FilenameUtils.wildcardMatch((String)"Foo", (String)"Foo*"));
        Assertions.assertTrue((boolean)FilenameUtils.wildcardMatch((String)"FooBar", (String)"Foo*"));
        Assertions.assertFalse((boolean)FilenameUtils.wildcardMatch((String)"FOO", (String)"*Foo"));
        Assertions.assertFalse((boolean)FilenameUtils.wildcardMatch((String)"BARFOO", (String)"*Foo"));
        Assertions.assertFalse((boolean)FilenameUtils.wildcardMatch((String)"FOO", (String)"Foo*"));
        Assertions.assertFalse((boolean)FilenameUtils.wildcardMatch((String)"FOOBAR", (String)"Foo*"));
    }

    @Test
    public void testMatch2() {
        this.assertMatch("log.txt", "log.txt", true);
        this.assertMatch("log.txt1", "log.txt", false);
        this.assertMatch("log.txt", "log.txt*", true);
        this.assertMatch("log.txt", "log.txt*1", false);
        this.assertMatch("log.txt", "*log.txt*", true);
        this.assertMatch("log.txt", "*.txt", true);
        this.assertMatch("txt.log", "*.txt", false);
        this.assertMatch("config.ini", "*.ini", true);
        this.assertMatch("config.txt.bak", "con*.txt", false);
        this.assertMatch("log.txt9", "*.txt?", true);
        this.assertMatch("log.txt", "*.txt?", false);
        this.assertMatch("progtestcase.java~5~", "*test*.java~*~", true);
        this.assertMatch("progtestcase.java;5~", "*test*.java~*~", false);
        this.assertMatch("progtestcase.java~5", "*test*.java~*~", false);
        this.assertMatch("log.txt", "log.*", true);
        this.assertMatch("log.txt", "log?*", true);
        this.assertMatch("log.txt12", "log.txt??", true);
        this.assertMatch("log.log", "log**log", true);
        this.assertMatch("log.log", "log**", true);
        this.assertMatch("log.log", "log.**", true);
        this.assertMatch("log.log", "**.log", true);
        this.assertMatch("log.log", "**log", true);
        this.assertMatch("log.log", "log*log", true);
        this.assertMatch("log.log", "log*", true);
        this.assertMatch("log.log", "log.*", true);
        this.assertMatch("log.log", "*.log", true);
        this.assertMatch("log.log", "*log", true);
        this.assertMatch("log.log", "*log?", false);
        this.assertMatch("log.log", "*log?*", true);
        this.assertMatch("log.log.abc", "*log?abc", true);
        this.assertMatch("log.log.abc.log.abc", "*log?abc", true);
        this.assertMatch("log.log.abc.log.abc.d", "*log?abc?d", true);
    }

    @Test
    public void testMatchCaseSpecified() {
        Assertions.assertFalse((boolean)FilenameUtils.wildcardMatch(null, (String)"Foo", (IOCase)IOCase.SENSITIVE));
        Assertions.assertFalse((boolean)FilenameUtils.wildcardMatch((String)"Foo", null, (IOCase)IOCase.SENSITIVE));
        Assertions.assertTrue((boolean)FilenameUtils.wildcardMatch(null, null, (IOCase)IOCase.SENSITIVE));
        Assertions.assertTrue((boolean)FilenameUtils.wildcardMatch((String)"Foo", (String)"Foo", (IOCase)IOCase.SENSITIVE));
        Assertions.assertTrue((boolean)FilenameUtils.wildcardMatch((String)"", (String)"", (IOCase)IOCase.SENSITIVE));
        Assertions.assertTrue((boolean)FilenameUtils.wildcardMatch((String)"Foo", (String)"Fo*", (IOCase)IOCase.SENSITIVE));
        Assertions.assertTrue((boolean)FilenameUtils.wildcardMatch((String)"Foo", (String)"Fo?", (IOCase)IOCase.SENSITIVE));
        Assertions.assertTrue((boolean)FilenameUtils.wildcardMatch((String)"Foo Bar and Catflap", (String)"Fo*", (IOCase)IOCase.SENSITIVE));
        Assertions.assertTrue((boolean)FilenameUtils.wildcardMatch((String)"New Bookmarks", (String)"N?w ?o?k??r?s", (IOCase)IOCase.SENSITIVE));
        Assertions.assertFalse((boolean)FilenameUtils.wildcardMatch((String)"Foo", (String)"Bar", (IOCase)IOCase.SENSITIVE));
        Assertions.assertTrue((boolean)FilenameUtils.wildcardMatch((String)"Foo Bar Foo", (String)"F*o Bar*", (IOCase)IOCase.SENSITIVE));
        Assertions.assertTrue((boolean)FilenameUtils.wildcardMatch((String)"Adobe Acrobat Installer", (String)"Ad*er", (IOCase)IOCase.SENSITIVE));
        Assertions.assertTrue((boolean)FilenameUtils.wildcardMatch((String)"Foo", (String)"*Foo", (IOCase)IOCase.SENSITIVE));
        Assertions.assertTrue((boolean)FilenameUtils.wildcardMatch((String)"Foo", (String)"Foo*", (IOCase)IOCase.SENSITIVE));
        Assertions.assertTrue((boolean)FilenameUtils.wildcardMatch((String)"Foo", (String)"*Foo", (IOCase)IOCase.SENSITIVE));
        Assertions.assertTrue((boolean)FilenameUtils.wildcardMatch((String)"BarFoo", (String)"*Foo", (IOCase)IOCase.SENSITIVE));
        Assertions.assertTrue((boolean)FilenameUtils.wildcardMatch((String)"Foo", (String)"Foo*", (IOCase)IOCase.SENSITIVE));
        Assertions.assertTrue((boolean)FilenameUtils.wildcardMatch((String)"FooBar", (String)"Foo*", (IOCase)IOCase.SENSITIVE));
        Assertions.assertFalse((boolean)FilenameUtils.wildcardMatch((String)"FOO", (String)"*Foo", (IOCase)IOCase.SENSITIVE));
        Assertions.assertFalse((boolean)FilenameUtils.wildcardMatch((String)"BARFOO", (String)"*Foo", (IOCase)IOCase.SENSITIVE));
        Assertions.assertFalse((boolean)FilenameUtils.wildcardMatch((String)"FOO", (String)"Foo*", (IOCase)IOCase.SENSITIVE));
        Assertions.assertFalse((boolean)FilenameUtils.wildcardMatch((String)"FOOBAR", (String)"Foo*", (IOCase)IOCase.SENSITIVE));
        Assertions.assertTrue((boolean)FilenameUtils.wildcardMatch((String)"FOO", (String)"*Foo", (IOCase)IOCase.INSENSITIVE));
        Assertions.assertTrue((boolean)FilenameUtils.wildcardMatch((String)"BARFOO", (String)"*Foo", (IOCase)IOCase.INSENSITIVE));
        Assertions.assertTrue((boolean)FilenameUtils.wildcardMatch((String)"FOO", (String)"Foo*", (IOCase)IOCase.INSENSITIVE));
        Assertions.assertTrue((boolean)FilenameUtils.wildcardMatch((String)"FOOBAR", (String)"Foo*", (IOCase)IOCase.INSENSITIVE));
        Assertions.assertEquals((Object)WINDOWS, (Object)FilenameUtils.wildcardMatch((String)"FOO", (String)"*Foo", (IOCase)IOCase.SYSTEM));
        Assertions.assertEquals((Object)WINDOWS, (Object)FilenameUtils.wildcardMatch((String)"BARFOO", (String)"*Foo", (IOCase)IOCase.SYSTEM));
        Assertions.assertEquals((Object)WINDOWS, (Object)FilenameUtils.wildcardMatch((String)"FOO", (String)"Foo*", (IOCase)IOCase.SYSTEM));
        Assertions.assertEquals((Object)WINDOWS, (Object)FilenameUtils.wildcardMatch((String)"FOOBAR", (String)"Foo*", (IOCase)IOCase.SYSTEM));
    }

    @Test
    public void testMatchOnSystem() {
        Assertions.assertFalse((boolean)FilenameUtils.wildcardMatchOnSystem(null, (String)"Foo"));
        Assertions.assertFalse((boolean)FilenameUtils.wildcardMatchOnSystem((String)"Foo", null));
        Assertions.assertTrue((boolean)FilenameUtils.wildcardMatchOnSystem(null, null));
        Assertions.assertTrue((boolean)FilenameUtils.wildcardMatchOnSystem((String)"Foo", (String)"Foo"));
        Assertions.assertTrue((boolean)FilenameUtils.wildcardMatchOnSystem((String)"", (String)""));
        Assertions.assertTrue((boolean)FilenameUtils.wildcardMatchOnSystem((String)"Foo", (String)"Fo*"));
        Assertions.assertTrue((boolean)FilenameUtils.wildcardMatchOnSystem((String)"Foo", (String)"Fo?"));
        Assertions.assertTrue((boolean)FilenameUtils.wildcardMatchOnSystem((String)"Foo Bar and Catflap", (String)"Fo*"));
        Assertions.assertTrue((boolean)FilenameUtils.wildcardMatchOnSystem((String)"New Bookmarks", (String)"N?w ?o?k??r?s"));
        Assertions.assertFalse((boolean)FilenameUtils.wildcardMatchOnSystem((String)"Foo", (String)"Bar"));
        Assertions.assertTrue((boolean)FilenameUtils.wildcardMatchOnSystem((String)"Foo Bar Foo", (String)"F*o Bar*"));
        Assertions.assertTrue((boolean)FilenameUtils.wildcardMatchOnSystem((String)"Adobe Acrobat Installer", (String)"Ad*er"));
        Assertions.assertTrue((boolean)FilenameUtils.wildcardMatchOnSystem((String)"Foo", (String)"*Foo"));
        Assertions.assertTrue((boolean)FilenameUtils.wildcardMatchOnSystem((String)"BarFoo", (String)"*Foo"));
        Assertions.assertTrue((boolean)FilenameUtils.wildcardMatchOnSystem((String)"Foo", (String)"Foo*"));
        Assertions.assertTrue((boolean)FilenameUtils.wildcardMatchOnSystem((String)"FooBar", (String)"Foo*"));
        Assertions.assertEquals((Object)WINDOWS, (Object)FilenameUtils.wildcardMatchOnSystem((String)"FOO", (String)"*Foo"));
        Assertions.assertEquals((Object)WINDOWS, (Object)FilenameUtils.wildcardMatchOnSystem((String)"BARFOO", (String)"*Foo"));
        Assertions.assertEquals((Object)WINDOWS, (Object)FilenameUtils.wildcardMatchOnSystem((String)"FOO", (String)"Foo*"));
        Assertions.assertEquals((Object)WINDOWS, (Object)FilenameUtils.wildcardMatchOnSystem((String)"FOOBAR", (String)"Foo*"));
    }

    @Test
    public void testSplitOnTokens() {
        Assertions.assertArrayEquals((Object[])new String[]{"Ad", "*", "er"}, (Object[])FilenameUtils.splitOnTokens((String)"Ad*er"));
        Assertions.assertArrayEquals((Object[])new String[]{"Ad", "?", "er"}, (Object[])FilenameUtils.splitOnTokens((String)"Ad?er"));
        Assertions.assertArrayEquals((Object[])new String[]{"Test", "*", "?", "One"}, (Object[])FilenameUtils.splitOnTokens((String)"Test*?One"));
        Assertions.assertArrayEquals((Object[])new String[]{"Test", "?", "*", "One"}, (Object[])FilenameUtils.splitOnTokens((String)"Test?*One"));
        Assertions.assertArrayEquals((Object[])new String[]{"*"}, (Object[])FilenameUtils.splitOnTokens((String)"****"));
        Assertions.assertArrayEquals((Object[])new String[]{"*", "?", "?", "*"}, (Object[])FilenameUtils.splitOnTokens((String)"*??*"));
        Assertions.assertArrayEquals((Object[])new String[]{"*", "?", "*", "?", "*"}, (Object[])FilenameUtils.splitOnTokens((String)"*?**?*"));
        Assertions.assertArrayEquals((Object[])new String[]{"*", "?", "*", "?", "*"}, (Object[])FilenameUtils.splitOnTokens((String)"*?***?*"));
        Assertions.assertArrayEquals((Object[])new String[]{"h", "?", "?", "*"}, (Object[])FilenameUtils.splitOnTokens((String)"h??*"));
        Assertions.assertArrayEquals((Object[])new String[]{""}, (Object[])FilenameUtils.splitOnTokens((String)""));
    }
}

